#ifndef _IO_DLPI_ETHER_DLPI_EMB_H	/* wrapper symbol for kernel use */
#define _IO_DLPI_ETHER_DLPI_EMB_H	/* subject to change without notice */

#ident	"@(#)kit:eth/src/dlpi_727.h	1.00"
#ident  "$Header: $"

/*	Copyright (c) 1993  Cogent Data Technologies			*/
/*	All Rights Reserved						*/
/*									*/
/*									*/
/*      eMASTER+ ATS DLPI streams device driver				*/
/*									*/
/*      Initiate version:       1.0             			*/
/*      Date:                   Sept. 24, 1993   			*/
/*                                                                      */
/* -------------------------------------------------------------------- */
/*                                                                      */
/*      Modification log:                                               */
/*                                                                      */
/* -------------------------------------------------------------------- */

/*
 *  Device dependent symbol names.
 */

/*
 *  STREAMS structures
 */
#define	DL_NAME		"emB"
#define	DLdevflag	emBdevflag
#define	DLrminfo	emBrminfo
#define	DLwminfo	emBwminfo
#define	DLrinit		emBrinit
#define	DLwinit		emBwinit

/*
 *  Functions
 */
#define DLopen		emBopen
#define	DLclose		emBclose
#define DLrput		emBrput
#define	DLwput		emBwput
#define	DLioctl		emBioctl
#define	DLinfo		emBinfo
#define	DLloopback	emBloopback
#define	DLmk_ud_ind	emBmk_ud_ind
#define	DLxmit_packet	emBxmit_packet
#define	DLintr		emBintr
#define	DLinfo_req	emBinfo_req
#define	DLcmds		emBcmds
#define	DLprint_eaddr	emBprint_eaddr
#define	DLbind_req	emBbind_req
#define	DLrsrv		emBrsrv
#define	DLunbind_req	emBunbind_req
#define	DLunitdata_req	emBunitdata_req
#define	DLerror_ack	emBerror_ack
#define	DLuderror_ind	emBuderror_ind
#define	DLpromisc_off	emBpromisc_off
#define	DLpromisc_on	emBpromisc_on
#define	DLset_eaddr	emBset_eaddr
#define	DLadd_multicast	emBadd_multicast
#define	DLset_multicast	emBset_multicast
#define	DLdel_multicast	emBdel_multicast
#define	DLdisable	emBdisable
#define	DLenable	emBenable
#define	DLreset		emBreset
#define	DLis_multicast	emBis_multicast
#define	DLget_multicast	emBget_multicast
#define DLrecv		emBrecv
#define DLproc_llc	emBproc_llc
#define DLform_80223	emBform_80223
#define DLmk_test_con	emBmk_test_con
#define DLinsert_sap	emBinsert_sap
#define DLsubsbind_req	emBsubsbind_req
#define DLtest_req	emBtest_req
#define DLremove_sap	emBremove_sap
#define DLis_equalsnap	emBis_equalsnap
#define DLform_snap	emBform_snap
#define DLis_broadcast	emBis_broadcast
#define DLis_us		emBis_us
#define DLis_validsnap	emBis_validsnap

#define DLbdspecioctl	emBbdspecioctl
#define DLbdspecclose	emBbdspecclose

/*
 *  wrapper functions
 */
#define DLinit		emBinit
#define DLuninit	emBuninit
#define DL_attach_info	emB_attach_info
/*
 *  Implementation structures and variables
 */
#define DL_ifname	emB_ifname
#define DLprint_eaddr	emBprint_eaddr
#define DLboards	emBboards
#define DLconfig	emBconfig
#define DLsaps		emBsaps
#define DLstrlog	emBstrlog
#define DLifstats	emBifstats
#define	DLinetstats	emBinetstats
#define	DLid_string	emBid_string
#define	DLcopyright	emBcopyright
#define	DLbus_t_on	emBbus_t_on
#define	em_debug	emBdebug

/*
 *  Flow control defines
 */
#define DL_MIN_PACKET		0
#define DL_MAX_PACKET		1500
#define DL_MAX_PACKET_LLC	(DL_MAX_PACKET - 3)
#define DL_MAX_PACKET_SNAP	(DL_MAX_PACKET_LLC - 5)
#define	DL_HIWATER		(40 * DL_MAX_PACKET)
#define	DL_LOWATER		(20 * DL_MAX_PACKET)

#define	USER_MAX_SIZE		1500
#define	USER_MIN_SIZE		46

/* Inline asm routine for block moves */
#ifndef lint
#ifndef C_PIO

asm	void mybcopy(src, dest, count)
{
%mem	src, dest, count;lab	r_1;
	movl	count, %ecx
	movl	dest, %eax
	push	%edi
	push	%esi
	movl	%eax, %edi	/* %edi = destination */
	movl	src, %eax  	
	movl	%eax, %esi	/* %esi = source */
	testw	$1, %cx		/* bit 0 set? */
	jz	r_1
	movsb
	dec	%ecx
r_1:
	shrl	$1, %ecx	/* cx <- cx / 2 */
	rep		
	movsw
	pop	%esi
	pop	%edi
}

#endif	/* ifndef C_PIO */
#endif	/* ifndef lint */

#endif	/* _IO_DLPI_ETHER_DLPI_EMB_H */
