;TMA macro assembler
;Main file
; (c)1996-1998 Sven Klose

TMASEQ=62
; 
;_obj		 = 1		 ;Create object file
#if !_obj
_edit		= 1		;Include editor in project
lang_english	= 1		;Speak English
#endif
;_view		 = 1		 ;Output lines while assembling
;_screen	 = 1		 ;Buffer code in VGA memory 
;_labalign	 = 1		 ;Align records in label database
				;Doesn't seem to speed anything up.
;opt_movr0	 = 1		 ;Convert MOV r,0 to XOR r,r
_mdltiny	=1		;Assemble project for tiny memory model
; 
size_localclr	= 600h		;Size of local label clear buffer

#if !_mdltiny
	.model small		;Use small memory model if not tiny
	.stack 4k
dataseg group _text,data
#endif

enum	_com,_exe

	code segment
main:
#if !_mdltiny
	mov ax,data		;We'll have to initialize this in any memory
	mov ds,ax		;model...
#else
	mov ax,ds		;... except tiny.
#endif
	mov sr_data,ax
	mov es,ax
	mov ax,cs
	mov sr_code,ax
	;
	mov di,fdat		;Clear common data area of assembler and editor
	mov cx,fdate-fdat
	xor al,al
	rep stosb
	jmp start

; 

; 
	
	data segment
sr_code 	dw ?		;Code segment of assembler.
sr_data 	dw ?		;Data  "      "   "
fdat:
ptr_localclr:	dw ?		;Position in localclr reference table
segment_references:
asm_segs:
seg_input:	dw ?		;Input buffer.
seg_code:	dw ?		;Code buffer.
seg_data:	dw ?		;Data buffer.
seg_localclr:	dw ?		; and its segment.
seg_macro:	dw ?		;MACRO sources.
seg_struc:	dw ?		;STRUC definitions.
seg_internal:	dw ?		;Internal Variables.

seg_strucsizes: dw ?
seg_eaoverrides:dw ?

seg_global:	dw ?
seg_local:	dw ?
seg_labelmode:	dw ?

seg_reloc	dw ?	;Relocation table

;seg_tmp:	 dw ?		 ;new.inc debug

;seg_macrobuffer:dw ?
;seg_macroparms: dw ?
;seg_macroparmnames: dw ?
end_asm_segs:

;Editor segments
seg_text	dw ?		;The text we edit.
seg_buffer	dw ?		;Clipboard buffer
end_segment_references:
sourcename:	db 64 dup ?	;Name of the source someone wants to compile
flag_ed:	db ?

	include"global\global.inc"	;Global definitions
	include"asm\screenio.inc"	;Screen I/O(text)
	include"asm\memory.inc" 	;DOS/XMS memory allocation
	include"global\new.inc" 	;Memory handling
#if _edit
	include"ide\editor.asm" 	;The generic editor
#endif

	data segment
fdate:
datastart:

; 

	include"..\keys\share.mac"	;Fingerprint generation pattern
	include"..\lib\io\doserruk.inc" ;DOS error messages
	include"..\lib\io\doserrmn.inc"
	include"asm\opcodesc.inc"	;Deskriptors of assembly instructions
	include"asm\dirtable.inc"	;List of direktives
	include"asm\errors.inc" 	;Assembler error messages
	include"asm\string.inc" 	;String scanner
	include"asm\fileio.inc" 	;Filehandling and XMS cache
	include"asm\comfile.inc"	;COM file creation
	include"asm\exefile.inc"	;EXE file creation
	include"asm\direct.inc" 	;Procedures executing directives
	include"asm\labels.inc" 	;Label handler
	include"asm\constant.inc"	;Reads in constants
	include"asm\modrm.inc"		;ModRM-byte creation
	include"asm\parser.inc" 	;Parsing
	include"asm\generate.inc"	;Code generation

; 
	.code
start:	mov ax,sr_data
	mov ds,ax
	mov es,ax
	mov fs,ax	;FS ist used globally and contains the segment or
			;selector of the global data area.
			;DO NOT MODIFY IT!
	
	; Initialize memory handler
	xor ax,ax		;Allocate memory
	call allocmem
	xor eax,eax
	xor ebx,ebx
	mov ax,[dossegstart]
	mov seg_memtree,ax
	shl eax,4
	add eax,treemem
	mov memstart,eax
	mov bx,[doslen]
	shl ebx,4
	sub ebx,treemem
	mov memsize,ebx
	call InitMemory

cr_com:
	mov di,datastart ;Clear data area of assembler
	mov cx,dataend-datastart
	xor al,al
	rep stosb

	mov al,_end
	mov [filenames],al	;Clear filename list
	;
	mov al,_tiny
	call init_std_segments	;Clear segmentname list
	;
	; Stacks
	mov w[filenameptr],offset filenames ;Stack for INCLUDEd files
	mov w[stc_includes-2],offset stc_includes
	mov w[ptr_macrostack],stc_macros ;Stack for macro pointers
	xor ax,ax
	mov w[ptr_nextmacro],macrobuffer;ax	    ;Macro buffer
	mov w[ptr_macroparms],macroparms;ax	   ;Macro parameter list
	mov b[processormode],_ppro	;CPU version we want to compile
					;our source for
	;
	; Keyword table initalisation
	mov di,map_legalchars	;Create identifier checklist needed by
	mov al,-1		; GETLABELLN in STRINGS.INC.
	mov cx,"/"+1
	rep stosb
	mov di,map_legalchars+":"
	mov cx,"@"-1-":"
	rep stosb
	mov di,map_legalchars+"["
	mov cx,"`"-"["
	rep stosb
	mov b[map_legalchars+"_"],0
	mov di,map_legalchars+"{"
	mov cx,256-"{"
	rep stosb
	call init_hash
	;
	; Command line analysis
	cmp b[flag_ed],1
	je >w1
	mov si,81h		;Get filename from comand line
	delspace
	cmp w[si],"e-"
	jne >d1
	mov b output_mode,_exe
	add si,2
d1:	mov di,SourceName
	call GetName
	jcxz >e6		;Error, no source file found
	mov di,DestName
	call GetName
	or cx,cx
	jne >e5 		;Destination name is given
	;
	; Create name of destination file
w1:	mov si,sourcename
l0:	mov di,destname
l1:	lodsb
	cmp al,"\"	  ;Jump over pathnames
	je l0
	cmp al,"."
	je >l2
	or al,al
	je >l2
	stosb
	jmp l1
l2:	mov al,"."
	stosb
	cmp b[output_mode],_exe
	je >i1
	mov ax,"oc"
	stosw
	mov ax,"m"
	stosw
	jmp >e5
i1:	mov ax,"xe"
	stosw
	xor ah,ah
	stosw
	jmp >e5

e6:	#if _edit
	jmp edit		;No filenames found, start the editor
	#else
	;
	; Display welcome message
	mov si,TXT_standard
	call asciiz
	call drline		;Draw a line
	mov si,TXT_help 	;Display help and exit
	call asciiz
	call drline
	jmp bye4
	#endif

e5:	mov es,40h		;Get time
	mov eax,[es:6ch]
	mov timer_start,eax
	mov si,TXT_standard
	call asciiz
	call drline
	mov si,txt_source
	call asciiz
	mov dx,SourceName
	mov si,dx
	call asciiz
	call cret

#if _screen
	mov ax,13h		;VGA mode 13h 320*200*256.
	int 10h
	pusha
	push ds
	mov ds,fs
	mov dx,txt_scrram
	mov ah,9
	int 21h
	xor ax,ax
	int 16h
	pop ds
	popa

	mov ax,0a000h
	mov [seg_code],ax
#else
	new 64k,seg_code
#endif
	mov ax,[seg_code]	;Assembled code
	mov es,ax
	xor di,di
	xor ax,ax
	mov cx,8000h
	rep stosw

	new 32k,seg_local	;(will return real segment in ax)
	mov cx,32k
	call clearvarseg
	;
	new 24k,seg_global ;PUBLIC variables
	mov [seg_labelmode],ax
	mov cx,24k
	call clearvarseg
	;
	new 32k,seg_input
	new size_localclr,seg_localclr
	;
	new 32k,seg_data
	mov cx,32k
	call clearvarseg
	;
	new 8k,seg_struc
	mov cx,8k
	call clearvarseg
	;
	new 8k,seg_macro
	mov cx,8k
	call clearvarseg
	;
	new 4k,seg_internal
	new 4k,seg_reloc
	;
;	 new 32k,seg_tmp
	new 1k,seg_strucsizes
	new 1k,seg_eaoverrides
	
;	 new 16k,seg_macrobuffer
;	 new 2k,seg_macroparms
;	 new 2k,seg_macroparmnames

;	 delete [seg_tmp]
;	 call GarbageCollection
; 
	; Initialize 1st pass
	mov dx,SourceName
	call open_file		;Open main source file (Load it to XMS).
	call init_symbols	;Initialise keyword tables.
	mov b[pass],1		;This is our first pass.
	mov es,w[seg_input]
	call readsource 	;Read the first block.
	call showpass		;Display pass number
	call initpass		; and initalise it.
	;
	; 1st Pass
l1:	call parse		;Assemble a line.
#if _view
	call showline		;Display line.
#endif
	jc l1			;Assemble the next line if there is one
	call j_pcode		;Switch to CODE segment to flush the
				;generation buffer.
	call arrange_segments	;Arrange segment information if the desired
				; memory model needs it.
	call get_segment_positions ;Get segment positions relative to the
				; first byte generated.
	;
	; Pass 2+
l2:	inc b[pass]		;Next pass.
	call showpass		;Display new pass number.
	call initpass
	; Reset pointer within the virtual data segment
	xor eax,eax
	mov d[segflags+seg_size+seg_ptr],eax
	call clearlocals	;Clear references to local labels.
	mov dx,SourceName
	call open_file
	mov es,w[seg_input]
	call readsource
l1:	call parse		;Assemble once more
#if _view
	call showline
#endif
	jc l1			;...line by line...
	call j_pcode		;Flush code generation buffer
	call get_segment_positions
	;
	cmp w[total_errors],0	;Exit in case an error occured.
	jne bye
	cmp b[newpass],1	;If adresses have changed assemble again
	je l2			;with the new database.

; Output generation statistics
bye:	mov al," "
	mov cx,79
l1:	call int29
	loop l1
	mov al,13
	call int29
	mov ax,w[total_errors]
	or ax,ax
	je >o1
	mov dx,TXT_errors
	call printword
	jmp bye3
o1:	mov si,txt_destination	;Display name of destination file
	call asciiz
	mov si,destname
	call asciiz
	mov dx,destname
	cmp b[output_mode],_exe
	jne >n1
	mov si,txt_exe
	call asciiz
	call create_exefile
	jmp >n2

n1:	call create_comfile

n2:	call cret
bye2:	call drline
	mov ax,w[includecnt]
	inc ax
	mov dx,TXT_files
	call printword
	xor ax,ax
	mov al,b[pass]
	mov dx,TXT_passes
	call printword
	mov ax,w[lines]  ;Display number of asembled lines
	mov dx,TXT_lines
	call printword
	mov ax,w[used_labels]
	mov dx,txt_labels
	call printword
	mov ax,w[used_labels_c]
	mov dx,txt_codelabels
	call printword
	mov ax,w[used_labels_l]
	mov dx,txt_locallabels
	call printword
	mov ax,w[used_labels_d]
	mov dx,txt_datalabels
	call printword
	mov si,txt_code_size
	call asciiz
	mov dx,txt_bytes
	mov ax,w[sizeof_executable]
	call printword
	mov es,40h
	mov eax,[es:6ch]
	sub eax,timer_start
	mov ebx,1008h
	xor edx,edx
	div ebx
	mov eax,edx
	mov ebx,444h
	xor edx,edx
	div ebx
	push dx
	call printword_2d
	mov al,":"
	call int29
	cmp dl,10
	jb >a1
	mov al,"0"
	call int29
a1:	pop ax
	shl ax,4
	mov bx,123h
	xor dx,dx
	div bx
	call printword_2d
	mov si,txt_time
	call asciiz
	call drline
	;
bye3:	cmp b[flag_ed],1
	je >l1
	call Reallocmem
bye4:	cmp b[flag_ed],1
	je >l1
	mov ax,4c00h
	int 21h

l1:	mov si,asm_segs
	mov cx,(end_asm_segs-asm_segs)/2
l1:	delete [si]
	add si,2
	loop l1
	call GarbageCollection
	ret

o1:	call reallocmem
	jmp doserrorroutine

; 
; Puts segments in right order after the 1st pass.
;
; Move non-data segment to the beginning
; Put _data flag on segment of class 'DATA'
; Move the stack to the end
;
; No arguments.
; Returns nothing.
arrange_segments:
	mov es,fs
	mov di,tab_groups
	mov si,txt_data 	;Search for class named 'DATA'
	call getstring
	if nc mov al,-1
	mov dl,al
	mov di,arranged_segments
	mov bx,segflags
	mov cx,[segments]
	xor bp,bp
l1:	test b[seg_attr+bx],_data or sa_stack
	jnz >n1
	cmp [seg_class],dl
	je >n1
	mov ax,bx
	stosw
	inc bp
n1:	add bx,seg_size
	loop l1
	mov code_segments,bp

	mov bx,segflags
	mov cx,[segments]
l1:	cmp [seg_class],dl
	je >y1
	test b[seg_attr+bx],_data
	jz >n1
y1:	mov ax,bx
	stosw
n1:	add bx,seg_size
	loop l1

	mov bx,segflags
	mov cx,[segments]
l1:	test b[seg_attr+bx],sa_stack
	jz >n1
	mov ax,bx
	stosw
n1:	add bx,seg_size
	loop l1
	ret

; Computes segment positions relative to the executable's starting address.
;
; No arguments.
; Returns nothing.
get_segment_positions:
	mov cx,[segments]
	mov si,arranged_segments
	xor eax,eax
	mov bp,code_segments
r1:	mov bx,[si]
	add si,2
	
	mov edx,seg_ptr[bx]	  ;Store size of segment
	mov seg_max[bx],edx
	cmp b[actualmodel],_tiny
	je >n1
	cmp seg_pos[bx],eax	;Starting position of the next segment
	je >n1
	mov seg_pos[bx],eax
	mov b[newpass],1	;Segment position has changed, set flag that'll
				; force the main loop to another pass.
				; (old EXEs)
n1:	add eax,edx
	cmp bp,1		;Don't align last segment
	je >f2
	push eax,bx		;Align segment position
	xor ebx,ebx
	mov bx,16
	call align_eax_addr
	pop bx,edx
	sub edx,eax
	sub seg_max[bx],edx	;Correct size of segment
f2:	cmp b[actualmodel],_tiny
	jne >s1
	push eax
	shr eax,4
	mov seg_ptr[bx],ax
	pop eax
	jmp >f1
s1:	xor edx,edx		 ;Reset pointer within segment for next pass
	mov seg_ptr[bx],edx
f1:	cmp bp,1
	jne >h1
	mov exe_out,eax
h1:	dec bp
	loop r1
	mov exe_size,eax
	ret

; Initialise a new pass
;
; No arguments.
; Returns nothing.
initpass:
	call free_segments
;	 mov ax,tab_strucsizes
	xor ax,ax
	mov w[ptr_strucsizes],ax
;	 mov ax,tab_eaoverrides
	mov w[ptr_eaoverrides],ax
	push bx
	mov ax,offset label_data
	mov bx,offset label_update
	mov es,[seg_global]
	mov w[es:bx],ax
	mov es,[seg_local]
	mov w[es:bx],ax
	mov es,[seg_data]
	mov w[es:bx],ax
	pop bx
	xor eax,eax		;Reset pointer to start of source
	mov b[generation_mode],al ;(Code output)
	mov w[cnt_internal],ax
	mov w[inputptr],ax
	mov w[lines],ax
	mov w[used_labels],ax
	mov w[used_labels_c],ax
	mov w[used_labels_l],ax
	mov w[used_labels_d],ax
	mov w[includecnt],ax
	mov w[reloc_items],ax
	mov b[newpass],al	;Clear flag that forces another pass
	mov d[codeptr],100h	;Reset destination pointer for code segment
	ret

; 

; ========================================
; >>> Extracts line from source buffer <<<
; ========================================
e1:	mov ax,em_noparm
	jmp error

p1:	mov bx,w[ptr_macrostack]
	push si 	;Save position in this macro
	mov si,w[bx-2]	;New pointer to macro parameters
	and al,127	;Clear MSB to get number of parameter
	or al,al
	je >z1
	mov cl,al
	xor ch,ch
z3:	lodsb
	cmp al,_end
	je e1		;Error: this number isn't defined via MACRO directive
	or al,al	;Is there another parameter ?
	jne z3		;No, continue.
	loop z3

z1:	lodsb		;Copy parameter to line buffer
	cmp al,_end
	je e1		;Error: Parameter# not defined
	or al,al
	je >z2
	stosb
	jmp z1
z2:	pop si		;Restore position pointer on original source...
	jmp >l1 	; and rave on.
n30:	jmp near >n3

GETLINE:push ds,es
	mov ax,fs	;Load src/dest segments
	mov es,ax
	mov di,line
	cmp b[flag_macro],1	;Assemble Macro?
	jne >n1
		mov si,w[inputptr]
		jmp >l0
n1:	inc w[lines]		;(don't count lines within macros)
	mov si,w[inputptr]
	mov ds,w[seg_input]
	cmp si,w[fs:inputsize]
	jae n30 		;buffer is empty
l0:	;delspace		 ;Skip spaces.
l1:	call lnb	;Load new source block if needed.
	lodsb		;Get a character.
	cmp al,tab	;Skip TABs
	jne >x1
		mov cx,di
		sub cx,line
		mov al," "
	v1:	inc cl
		stosb
		test cl,111b
		jnz v1
		jmp l1
	p2:	jmp p1
x1:	cmp al,13h
	jb >e1
	cmp al,20h
	je >n1
		cmp al,";"
		je >r1		;Ignore comments...
		cmp al,'"'
		je >k1		;Copy "string" immediately...
		cmp al,"'"
		je >k1		; "

		test al,128
		jne p2		;Found macro parameter...
		cmp al,_end
		je >m1		;Found end of macro...
		cmp al,"A"
		jb >n1
		cmp al,"Z"
		ja >n1
		add al,"a"-"A"	;Convert char into capital letter
n1:	stosb
	jmp l1

m1:	mov bx,w[ptr_macrostack]
	sub bx,6
	cmp bx,stc_macros
	je >m2			;No more macros...
	;
	mov ax,w[bx+4]		;Reset macro parm buffer.
	mov w[ptr_macroparms],ax
	mov w[ptr_macrostack],bx
	sub bx,6
	mov si,w[bx+2]		;Return pointer to parent macro source.
	jmp l1
	;
m2:	mov b[flag_macro],0
	mov w[ptr_macrostack],bx
	mov w[ptr_macroparms],macroparms
	mov si,w[bm_inputptr]
	mov ds,w[seg_input]
	jmp >n20

k1:	mov ah,al
	stosb
l2:	call lnb
	lodsb
	cmp al,20h
	jb >e1
	stosb
	cmp al,ah
	je l1
	jmp l2

e1:	call lnb
	lodsb			;Sorted!
	cmp al,tab
	je >g1
	cmp al,13 ;20h
	jb e1
g1:	dec si
	jmp >n20

r1:	call lnb		;Ignore comment (scan end of line)
	lodsb
	cmp al,13
	je >a1
	cmp al,10
	jne r1
a1:	call lnb
	lodsb
	jmp >n20

s1:	mov ah,al		;Copy "string" immediately
	stosb
l3:	call lnb
	lodsb
	stosb
	cmp al,ah
	jne l3

n3:	push es
	mov es,w[fs:seg_input]
	call readsource
	pop es
	or ax,ax
	jne >u0
	mov w[fs:inputptr],0
	pop es,ds
	clc
	ret

u0:	jmp l0

; Load next source block
lnb:	cmp b[flag_macro],1
	je >l1		;Don't check buffer range,source is a macro...
	cmp si,w[fs:inputsize]
	jb >l1
	push es
	mov es,w[fs:seg_input]
	call readsource ;Load next source block.
	pop es
	or ax,ax
	jz >n2
l1:	ret

n2:	pop ax		;dummy
n20:	mov w[fs:inputptr],si
	mov b[es:di],0
	pop es,ds
	mov si,line
	stc
	ret

; 


#if !_mdltiny
_text	segment para
#else
	.code
#endif
TXT_standard:
	db"TMA macro assembler - build M#62-07/01/1998 - http://www.devcon.net/~sven",13,10
	db"This is free software; read COPYING for details.",10,13
	db 0
tc_jmp: dw t_jmpshort,t_jmpnear,t_jmpfar
tc_call:dw 0,t_call,t_callfar
tc_j:	dw t_j,t_jn,1
dsc_jump:dw createconstants,dsc_o,dsc_ow,dsc_os,dsc_s,dsc_xrm,dsc_xpm,dsc_xsm

segments_std:	db "code",0,"data",0,"stack",_end ;Namen der Standardsegmente
;classes_langc: db 5,"_text",0,"const",0,"_bss",0,"data",0,"_stack",_end
;groups_langc:	db 1,"dgroup",_end
;tab_groupc:	db 2,3,4,0
classes_std:	db "data",_end
txt_data:	db"data",0
	
#if lang_english
txt_exe:	db" (old EXEcutable)",0
TXT_pass:	db"Pass ",0
TXT_source:	db"Primary file: ",0
TXT_external:	db"Other sources: ",10,13,0
TXT_include:	db"          ",0
TXT_destination:db"Assembly successful.",10,13
		db"Destination: ",0
TXT_passes:	db" passes. ",0
TXT_lines:	db" lines. ",0
TXT_files:	db" files. ",0
TXT_code_size:	db"Code size: ",0
TXT_errors:	db" errors found.",10,13,0

#if !_edit
TXT_help:	db"Syntax :",10,13,10
		db" TMA [options] <infile> [<outfile>]",10,13,10
		db"Options:",13,10,10
		db" -e  Generate EXE file.",13,10
		db 0
#endif

txt_codelabels: db" code labels.",10,13,0
txt_locallabels:db" local labels.",10,13,0
txt_datalabels: db" data"
txt_labels:	db" labels.",10,13,0
txt_bytes:	db" bytes.",10,13,0
txt_time:	db" min.",10,13,0
#endif
#if _screen
txt_scrram:	db 13 dup 10
		db"Using VGA RAM due to low memory.$"
debugimage:	db"tmacore.img",0
#endif
		db 1,"Ceterum censeo Cannabis legalisandum esse !",1 ;-?

_struc=2
;Geberation mode
_data=80h
_code=0

	code ends

; 

	.data
actualmnemdesc: dw ?		;Descriptor of last mnemonic.
actualmnemonic: db ?		;Token of last mnemonic.
operandsize:	db ?		;Operand size (b,w,d,bw,wb,dw)
register:	db ?		;last register code (no seg or sys)
opdesc: 	db ?,?,?	;Operand types (r,e,d,cc,sr,tr,dr,cr)
opdata: 	db ?,?,?	;Operand info (rg,co,ea)
constsize:	db ?		;Size of last constant.
constant:	dd ?		;Value of last constant.
constant_b:	dd ?		;2nd constant for ENTER.
pflag:		db ?		;Value of P-digit (class number).
brackets:	dw ?		;Open brackets.
timer_start	dd ?		;BIOS value to remember start of assembler.
sizeof_executable dd ?

	 even
lineinitstart:
flag_contline:	db ?	;true: The rest of the input line will be processed as
			;a new one.
lineinitstart2:
flag_lastlabel: db ?	;true: A label was found at line start
constflag:	db ?	;true: A constant was found.
randflag:	db ?	;true: rand: prefix 66h needed
addrflag:	db ?	;true: addr: prefix 67h  "
scndflag:	db ?
wbit:		db ?	;word bit in opcode 
dbit:		db ?	;direction bit in opcode
oplength:	db ?	;Number of operands for this instruction.
condition:	db ?	;Type of last conditional jump.

; Effective adress generation:
ea_r:		db ?	;r nibble in xrm byte.

eadesc: 	db ?,?	;Contains information about an parsed effective adress.
eascaling:	db ?	;Scaling in effective adress.
eaconstflag:	db ?	;true: Constant found in effective adress.
eaconstsize:	db ?	;      Size of the constant.
ealength:	db ?	;Number of registers in effective adress.
ea_xm:			;xrm byte.
ea_m:		db ?
ea_x:		db ?
lineinitend:	db ?

		even
ea_sirflag:	db ?	;Scaling in 32bit effective adress
ea_scaling:	db ?
ea_r2:		db ?	;Base register
ea_i:		db ?	;Index register
ea_s:		db ?	;Segment register
eaconst:	dd ?	;Value of constant in effective adress.
eaflag: 	db ?	;true: An effective adress was found.
override:	db ?	;segment override prefix needed or 0.
eadescend:

segregister:	db ?	;Segment override prefix needed or 0.
sysrnum:	db ?	;control/debug/taskreg index
sysrtype:	db ?	;system register type (cr,cr4,dr,tr)
sysrcode:	db ?	;encoded register type
scndconst:	db ?
afseg:		dw ?	;Segment of absolute far adress
inputptr:	dd ?	;Parser position in source
inputsize:	dd ?	;Size of loaded block.
codeptr:	dd ?	;Generator's code position and segment.
codeseg:	dw ?
destname:	db 64 dup ?  ;Name of destination file.
destptr:	dd ?	;Position in output buffer.
pass:		db ?	;Number of this pass.
newpass:	db ?	;true: Assemble again if this pass is done.
lineptr:	dw ?	;Points to parser's line position if a prefix was found.
generation_mode:dw ?	;true: Generate AND write code to the output buffer.
varflag:	dw ?	;true: A constant label was found (not only a constant)
processormode:	db ?	;Destination CPU (limits instruction set)
lines:		dw ?	;Number of currently assembled lines
used_labels_c:	dw ?	;Number of currently defined code labels
used_labels_l:	dw ?	; "                          local labels
used_labels_d:	dw ?	; "                          data labels
used_labels:	dw ?	;			     total labels.
line:		db 256 dup ?	;Line buffer
hlp:		dw ?
symbolend:	dw ?		;End of symbol list
buffer16:	db 64 dup ?	;Buffer for sorting string tables
strucofs:	dd ?		;Current STRUC OFFSET
		dw ?
stc_includes:	dd 64 dup ?	;Include file stack
includes:	dw ?		;Current # of include files
includecnt:	dw ?
flag_includes:	db ?		;true: include files were used
lastlabel:	dw ?		;Adress of last label in line buffer
lastlabelln:	dw ?		;Length of last label

cnt_internal:	dw ?		;# of internal labels
ptr_strucsize:	dw ?
ptr_strucsizes: dw ?
;tab_strucsizes: db 1k dup ?
ptr_eaoverrides:dw ?
;tab_eaoverrides:db 1k dup ?
actual_eaadr:	dw ?		;Currently used STRUC override parameter

ptr_gifstack:	dw ?		;Stack for multiple #IFs
stc_gif:	db 256 dup ?

ptr_macrostack: dw ?
stc_macros:	dw 64 dup ?	;Macrostack
ptr_nextmacro:	dw ?		;Pointer to free space in macro buffer
ptr_macroparms: dw ?
bm_inputptr:	dw ?
flag_macro:	db ?		;true: A macro source is currently assembled

; Lookup-Tables for fast mnemonic scan
st_mnemonics:	dw 26 dup ?
st_segregisters:dw 26 dup ?
st_mainregisters:dw 26 dup ?
st_maindirs:	dw 26 dup ?
st_sizes:	dw 26 dup ?
st_pointers:	dw 26 dup ?
st_constants:	dw 26 dup ?

symbols:	db 4k dup ?	;Symbol lists
macrobuffer:	db 8k dup ?	;Macro sources
macroparms:	db 1k dup ?	;Macro parameters
macroparmnames: db 1k dup ?	;Macro parameter names

segments:	dw ?		;current # of segments
code_segments	dw ?
groups: 	dw ?		;# of groups
classes:	dw ?		;# of classes
segflags:	db 256 dup ?	;Adresses and flags of segments
groupflags:	db 256 dup ?	;Group combinations
tab_assumes:	db 7 dup ?	;ASSUMEs
tab_segments:	db 256 dup ?	;Segment names
tab_groups:	db 256 dup ?	;Group names
tab_classes:	db 256 dup ?	;Class names
lastsegflag:	dw ?
actualmodel:	db ?		;Currently used memory model
flg_set_reloc_addr:		;Flag for CREATECONSTANTS in GENERATE.INC,
		db ?		;true: store relocation adrs for EXE generation
filenr: 	db ?
output_mode:	db ?
stack_size:	dw ?		;Size of STACK segment
arranged_segments: dw 64 dup ?	;Segment order


freespace:			;Free space for anything
dataend:

