{ Copyright (C) 1997 Wolfgang J Moeller. All rights reserved. NO WARRANTY! }

unit dsk_cio;

{ cached I/O to
{ - raw ("physical") disks via Int13
{	- 528 MB with "old" BIOS
{	- *** TB with BIOS providing "IBM/MS Int13 Extensions" (ah=41..43,48)
{	- also, $IFDEF PS1_SPECIAL, and if Int13/ah=24..25 work,
{	  for HD units 0 and 1 only [?] - EXPERIMENTAL -, 
{		$IFDEF PS1_MULTI,
{			2 GB via "PS/1 style" Int13/ah=21..22
{			(not useful with PS/1 model 2121 BIOS
{			 which never goes beyond 1023*16*63)
{		$ELSE
{			*** GB via direct access to PS/1 (and maybe PS/2 [?])
{			       IDE controller (in CHS or LBA mode)
{		$ENDIF
{
{ - logical drive via "new style" Int25/26 (up to 2 GB)
{	NOTE: Int25/26 work reliably only with DOS-formatted drives
{		(i.e. drives whose 1st block has valid "geometry" info)
{
{ w.j.m. jan 1997
{ ...
{ wjm 02-apr-1997: always "share" disks & caches among clients
{ wjm 27-may-1997: slightly raise the number of concurrent clients
{
{>>> Except for "PS1_SPECIAL" code, this program is based solely on information
{>>> available from version 53 of Ralf Brown's "Interrupt List" (INTER53?.ZIP),
{>>> which no-one claims to be all correct. NO WARRANTIES of any kind!
{
{ NOTE: geometry returned has best effort H and S; C<>0 only if C*H*S=#blocks
}

{*** experimental parameters, DON'T define them ***}
{*$DEFINE PS1_SPECIAL}	{*NOTE: direct access to IDE controller doesn't }
			{  (usually) work under Windows - needs REAL mode }
{*$UNDEF PS1_MULTI}	{ PS/1 model 2121 BIOS won't go beyond 1024 cylinders }
{*$DEFINE PS1_LBA}	{ LBA mode does not work for my older 400MB disk }

{*$UNDEF DOS7_LCK}	{ don't know yet how this is supposed to work }
{*** end experimental parameters ***}

interface

type
	dsk_t_devc = (dsk_k_fd, dsk_k_hd, dsk_k_drv);
	dsk_t_dev = record case devcls: dsk_t_devc of
		dsk_k_fd,dsk_k_hd: (unitno: 0..127);
		dsk_k_drv: (letter: char);
	end;
	dsk_t_off = record
		lbn: longint;
		boff: 0..511;
	end;
	dsk_t_geom = record case integer of	{ ala VMS; real big disk = ??? }
		1: (l: longint);
		2: (r: record
			sec: byte;
			trk: byte;
			cyl: word;
		end);
	end;
	dsk_t_sts = integer;


const
	dsksts_ok = 0;
	dsksts_eom = 1;		{ R/W/S: lbn out of range }
	dsksts_erd = 2;		{ read I/O error }
	dsksts_ewr = 3;		{ write I/O error }
	dsksts_inv = -1;	{ invalid argument(s) }
	dsksts_ond = -2;	{ OPEN: no drive }
	dsksts_onh = -3;	{ OPEN: no free handle }


function dsk_open(dev: dsk_t_dev; var hnd: byte; var blks: longint;
		  var geom: dsk_t_geom): dsk_t_sts;

{ "buflen" and current offset not restricted }
function dsk_read(hnd: byte; buflen: word; var buf; var retlen: word): dsk_t_sts;

{ "buflen" and current offset must be whole blocks [?] }
function dsk_write(hnd: byte; buflen: word; var buf; var retlen: word): dsk_t_sts;

function dsk_seek(hnd: byte; offset: dsk_t_off): dsk_t_sts;

{ always "hnd" released }
function dsk_close(hnd: byte): dsk_t_sts;


implementation
uses wjmp, dos;

const
	n_ctx = 10;	{ # client contexts = max.number of clients }
	n_dctx = 4;	{ # disk/drive contexts = max. number of d/d accessed }

type
	byteptr = ^byte;
	byte_array = packed array[0..65534] of byte;
	byte_arrayptr = ^byte_array;
	word_array = packed array[0..32766] of word;
	word_arrayptr = ^word_array;
	block = packed array[0..(512 - 1)] of byte;
	block_array = array[0..126] of block;
	block_arrayptr = ^block_array;

	dsk_t_cache = record
		bufp: block_arrayptr;
		lbn0: longint;
		blkmax: word;
		blkused: word;
		dirty: boolean;
	end;
	io_type = (ty_pdsk,ty_ldsk);
	dsk_t_id = record case ty: io_type of
		ty_pdsk: (a1: byte);
		ty_ldsk: (bin: byte);
	end;
	dsk_t_dctx = record
		refcnt: word;
		id: dsk_t_id;
		ext_ok: boolean;
		track_s: byte;
		heads: byte;
		cylinders: word;
		nblk: longint;
		c: dsk_t_cache;
{$IFDEF PS1_SPECIAL}
		indos_p: byteptr;	{ => "InDOS" flag }
		win3: boolean;		{ Windows 3+ detected }
		ps1_ok: boolean;
		multi_s: byte;		{ 0, or (PS/1) multi-sector count }
{$ENDIF}
{$IFDEF DOS7_LCK}
		lck_done: boolean;
{$ENDIF}
	end;
	dsk_t_dctxptr = ^dsk_t_dctx;
	dsk_t_ctx = record
		dctx_p: dsk_t_dctxptr;
		voff: dsk_t_off;
		inuse: boolean;
	end;
	dsk_t_ctxptr = ^dsk_t_ctx;

var
	ctxa: array[1..n_ctx] of dsk_t_ctx;
	dctxa: array[1..n_dctx] of dsk_t_dctx;

function find_ctx(hnd: byte): dsk_t_ctxptr;
begin
	if (hnd < 1) or
	   (hnd > n_ctx) or{_else}
	   not ctxa[hnd].inuse then
		find_ctx := nil
	else
		find_ctx := addr(ctxa[hnd]);
end;


{$IFDEF DOS7_LCK}
{ try to "lock" (DOS V7 style) PDSK or LDSK, and remember if it worked }
procedure dsk_lck(var dctx: dsk_t_dctx);
var
	reg: registers;
begin
	if dctx.lck_done then exit;

	reg.AX := $440D;
	reg.BH := 0;		{ [?] lock level (0-3) }
	reg.DX := 0;		{ [?] }
	case dctx.id.ty of
	  ty_pdsk:	begin
		reg.CX := $084B;	{ category code 08h, minor code 4Bh }
		reg.BL := dctx.id.bin;	{ physical drive number }
{$IFDEF DBG}
		write('Lock PDSK ',hex2(dctx.id.bin),' level ',reg.BH,' ... ');
{$ENDIF}
			end;

	  ty_ldsk:	begin;
		reg.CX := $084A;	{ category code 08h, minor code 4Ah }
		reg.BL := dctx.id.a1;	{ drive number (00h=default,01h=A: }
{$IFDEF DBG}
		write('Lock LDSK ',hex2(dctx.id.a1),' level ',reg.BH,' ... ');
{$ENDIF}
			end;
	end;
	msdos(reg);					{ block device IOCTL }
	if (reg.flags and FCarry) <> 0 then begin
{$IFDEF DBG}
		writeln('failed, AX=',hex4(reg.ax));
{$ENDIF}
	end else begin
{$IFDEF DBG}
		writeln('OK');
{$ENDIF}
		dctx.lck_done := true;
	end;
end;

{ "unlock" PDSK or LDSK, if applicable }
procedure dsk_unlck(var dctx: dsk_t_dctx);
var
	reg: registers;
begin
	if not dctx.lck_done then exit;

	reg.AX := $440D;
	case dctx.id.ty of
	  ty_pdsk:	begin
		reg.CX := $086B;	{ category code 08h, minor code 6Bh }
		reg.BL := dctx.id.bin;	{ physical drive number }
{$IFDEF DBG}
		write('Unlock PDSK ',hex2(dctx.id.bin),' ... ');
{$ENDIF}
			end;

	  ty_ldsk:	begin
		reg.CX := $086A;	{ category code 08h, minor code 6Ah }
		reg.BL := dctx.id.a1;	{ drive number (00h=default,01h=A: }
{$IFDEF DBG}
		write('Unlock LDSK ',hex2(dctx.id.a1),' ... ');
{$ENDIF}
			end;
	end;
	msdos(reg);					{ block device IOCTL }
	if (reg.flags and FCarry) <> 0 then begin
{$IFDEF DBG}
		writeln('failed, AX=',hex4(reg.ax));
{$ENDIF}
	end else begin
{$IFDEF DBG}
		writeln('OK');
{$ENDIF}
	end;
	dctx.lck_done := false;		{ always clear, for re-entrancy }
end;
{$ENDIF}{DOS7_LCK}


function pdsk_get_param(var dctx: dsk_t_dctx): boolean;
type
	int13_ext_params = record
		size: word;		{ in/out: size of buffer, max. $1E }
		iflags: word;		{ information flags #0184 }
		cylinders: longint;	{ number of physical cylinders on drive }
		heads: longint;		{ number of physical heads on drive }
		track_s: longint;	{ number of physical sectors per track }
		sectors_lo: longint;	{ total number of sectors on drive }
		sectors_hi: longint;	{ [QWORD continued] }
		sector_b: word;		{ bytes per sector }
		edd_ptr: pointer;	{ -> EDD configuration parameters #0186, }
					{ or FFFFh:FFFFh if not available }
	end;
var
	reg: registers;
	l,lc,ld: longint;
	dtc,fds: byte;
	extparm: int13_ext_params;

{$IFDEF PS1_SPECIAL}
type
	ata_26_info = record		{ ATA drive info block, #0177 }
		config: word;		{ general drive configuration #0178 }
		cylinders: word;	{ # cylinders }
		reserved1: word;
		heads: word;		{ # heads }
		raw_track_b: word;	{ # unformatted bytes per track }
		raw_sector_b: word;	{ # unformatted bytes per sector }
		track_s: word;		{ # sectors per track }
		vendor1: array[1..6] of byte;
		serial: array[1..20] of char;	{ serial number in ASCII, or 0 }
		buffertype: word;	{ buffer type }
		buffersize: word;	{ buffer size / 512, or 0 }
		eccbytes: word;		{ # ECC bytes passed on R/W Long, or 0 }
		firmware: array[1..8] of char;	{ firmware rev in ASCII, or 0 }
		model: array[1..40] of char;	{ model number in ASCII, or 0 }
		multi_s: byte;		{ 0, or max # sectors for R/W multiple }
		vendor2: byte;
		dwordio: word;		{ 0 or 1, can perform doubleword I/O }
		capabilities: word;	{ bit 8: DMA Supported }
		reserved3: word;
		piotiming: word;
		dmatiming: word;
		trans_valid: word;	{ bit 0: following 4 fields are valid }
		cur_cylinders: word;	{ # current cylinders }
		cur_heads: word;	{ # current heads }
		cur_track_s: word;	{ # current sectors per track }
		cur_sectors: longint;	{ current capacity in sectors }
		reserved4: word;
		undefined1: array[1..136] of byte;
		vendor64: array[1..64] of byte;
		reserved5: array[1..192] of byte;	{ pad to 512 bytes }
	end;
var
	atainf: ata_26_info;
label
	not_ps1;
{$ENDIF}

label
	old_style;
begin
	pdsk_get_param := false;

	reg.ah := $15;		{ get disk type }
	reg.dl := dctx.id.bin;
	intr($13,reg);

	dtc := reg.ah;
{$IFDEF DBG}
	write('PDSK disk type: ',hex2(dtc));
	if (reg.flags and FCarry) <> 0 then write(' (carry set)');
{$ENDIF}
	if ((reg.flags and FCarry) <> 0) or (dtc = 0) then begin
{$IFDEF DBG}
		writeln;
{$ENDIF}
		exit;
	end;

{$IFDEF DBG}
	write('  cx:dx = ',hex4(reg.cx),':',hex4(reg.dx));
	l := reg.cx; l := (l shl 16) or reg.dx;
	writeln(' = ',l,'.');
{$ENDIF}
	if (dtc = 1) or (dtc = 2) then begin	{ floppy }
		reg.ah := $16;			{ get floppy disk status }
		reg.dl := dctx.id.bin;
		intr($13,reg);

		fds := reg.ah;
{$IFDEF DBG}
		write('floppy disk status: ',hex2(fds));
		if (reg.flags and FCarry) <> 0 then write(' (carry set)');
		writeln;
{$ENDIF}
		if (fds = $80) then exit;	{ "not ready" }
	end;

	{ IBM/MS INT 13 Extensions - INSTALLATION CHECK }
	dctx.ext_ok := false;
	if (dctx.id.bin and $80) = 0 then goto old_style;	{ n/a to floppy }

	reg.ah := $41;
	reg.bx := $55AA;
	reg.dl := dctx.id.bin;
	intr($13,reg);
{$IFDEF DBG}
	write('check INT 13 Extensions: ');
{$ENDIF}
	if (reg.flags and FCarry) <> 0 then begin
{$IFDEF DBG}
		writeln('error ',hex2(reg.ah));
{$ENDIF}
		goto old_style;
	end;
	if reg.bx <> $AA55 then begin
{$IFDEF DBG}
		writeln('not installed');
{$ENDIF}
		goto old_style;
	end;
{$IFDEF DBG}
	write('version ',hex2(reg.ah),', support ',hex4(reg.cx));
{$ENDIF}
	if (reg.cx and 1) = 0 then begin
{$IFDEF DBG}
		writeln(' (no use)');
{$ENDIF}
		goto old_style;
	end;
{$IFDEF DBG}
	writeln;
{$ENDIF}

	extparm.size := sizeof(extparm);
	reg.ah := $48;
	reg.dl := dctx.id.bin;
	reg.ds := seg(extparm);
	reg.si := ofs(extparm);
	intr($13,reg);
{$IFDEF DBG}
	write('ext. DRIVE PARAMETERS: ');
{$ENDIF}
	if (reg.flags and FCarry) <> 0 then begin
{$IFDEF DBG}
		writeln('error ',hex2(reg.ah));
{$ENDIF}
		goto old_style;
	end;
{$IFDEF DBG}
	writeln('return buffer size ',hex4(extparm.size));
{$ENDIF}
	if extparm.size < $1A then goto old_style;
{$IFDEF DBG}
	writeln('flags: ',hex4(extparm.iflags),', c/h/s: ',
		extparm.cylinders,'/',extparm.heads,'/',extparm.track_s,
		', bytes/s: ',extparm.sector_b);
	write('total sectors: ',extparm.sectors_lo);
	if extparm.sectors_hi <> 0 then
		writeln(' + ',extparm.sectors_hi,' * 2^32')
	else
		writeln;
{$ENDIF}
	if (extparm.sector_b <> 512) or
	   ((extparm.track_s and not $FF) <> 0) or
	   ((extparm.heads and not $FF) <> 0) or
	   ((extparm.cylinders and not $FFFF) <> 0) or
	   (extparm.sectors_hi <> 0) then 
		goto old_style;				{ overflow! [?] }

	dctx.nblk := extparm.sectors_lo;
	dctx.track_s := extparm.track_s;
	dctx.heads := extparm.heads;
	l := dctx.track_s * dctx.heads;
	if (l * extparm.cylinders) = dctx.nblk then begin
		dctx.cylinders := extparm.cylinders;	{ CHS ok }
	end else begin
		dctx.cylinders := 0;		{ inconsistent geometry }
	end;

	if (dctx.track_s = 0) or
	   (dctx.heads = 0) then begin		{ get old style [C]HS geom. }
		reg.ah := $08;
		reg.dl := dctx.id.bin;
		intr($13,reg);
		dctx.track_s := reg.cl and $3F;			{ 1..cl }
		dctx.heads := reg.dh + 1;			{ 0..dh }
		l := dctx.heads * dctx.track_s;
		dctx.cylinders := dctx.nblk div l;
		l := l * dctx.cylinders;
		if l <> dctx.nblk then dctx.cylinders := 0;	{ inconsistent }
{$IFDEF DBG}
		writeln('faking old style geometry: ',
			dctx.cylinders,'/',dctx.heads,'/',dctx.track_s,
			' ==> ',l,' blocks');
{$ENDIF}
	end;

	dctx.ext_ok := true;
	pdsk_get_param := true;
	exit;

old_style:

{$IFDEF PS1_SPECIAL}
	dctx.ps1_ok := false;
	dctx.multi_s := 0;

	{ try to get PS/1 style _hard_ drive parameters }
	{ *** subtract 1 from #cylinders: last cylinder reserved for diags *** }

	if (dctx.id.bin and $80) = 0 then goto not_ps1;	{ floppy: don't try }
	if (dctx.id.bin and $7F) > 1 then goto not_ps1;	{ units 0..1 only [?] }

	reg.ah := $25;				{ identify drive }
	reg.dl := dctx.id.bin;
	reg.es := seg(atainf);
	reg.bx := ofs(atainf);
	intr($13,reg);
{$IFDEF DBG}
	write('PS/1 identify drive ',hex2(dctx.id.bin),':');
{$ENDIF}
	if (reg.flags and FCarry) <> 0 then begin
{$IFDEF DBG}
		writeln(' error ',hex2(reg.ah));
{$ENDIF}
		goto not_ps1;
	end;
{$IFDEF DBG}
	writeln(' config ',hex4(atainf.config));
{$ENDIF}
	ld := atainf.cylinders - 1;
	ld := ld * atainf.heads;
	ld := ld * atainf.track_s;
{$IFDEF DBG}
	writeln('default s/t, t/c, #c-1: ',atainf.track_s,', ',
		atainf.heads,', ',atainf.cylinders - 1,
		'  ==> ',ld,' blocks');
{$ENDIF}
	lc := atainf.cur_cylinders - 1;
	lc := lc * atainf.cur_heads;
	lc := lc * atainf.cur_track_s;
{$IFDEF DBG}
	write('"current" geometry valid: ',hex4(atainf.trans_valid),' (');
{$ENDIF}
	if (atainf.trans_valid and 1) <> 0 then begin
		{ use current "translation mode" geometry }
{$IFDEF DBG}
		writeln('yes), capacity: ',atainf.cur_sectors);
		writeln('current s/t, t/c, #c-1: ',atainf.cur_track_s,', ',
			atainf.cur_heads,', ',atainf.cur_cylinders - 1,
			'  ==> ',lc,' blocks');
{$ENDIF}
		dctx.track_s := atainf.cur_track_s;
		dctx.heads := atainf.cur_heads;
		dctx.cylinders := atainf.cur_cylinders - 1;
		dctx.nblk := lc;
		if lc > atainf.cur_sectors then goto not_ps1;	{ ??? }
	end else begin
		{ use defaults }
{$IFDEF DBG}
		writeln('no)');
{$ENDIF}
		dctx.track_s := atainf.track_s;
		dctx.heads := atainf.heads;
		dctx.cylinders := atainf.cylinders - 1;
		dctx.nblk := ld;
	end;
	if (dctx.nblk < 2) or
	   (atainf.multi_s < 2) then goto not_ps1;		{ sorry }

	dctx.multi_s := 16;
	while dctx.multi_s > atainf.multi_s do
		dctx.multi_s := dctx.multi_s div 2;

	reg.ah := $24;				{ set multiple mode }
	reg.al := dctx.multi_s;
	reg.dl := dctx.id.bin;
	intr($13,reg);
{$IFDEF DBG}
	write('Set PS/1 multiple mode to ',dctx.multi_s,': ');
{$ENDIF}
	if (reg.flags and FCarry) <> 0 then begin
{$IFDEF DBG}
		writeln('error ',hex2(reg.ah));
{$ENDIF}
		goto not_ps1;
	end;
{$IFDEF DBG}
	writeln('OK');
{$ENDIF}
	{ get address of InDOS flag }
	reg.ah := $34;
	msdos(reg);
{$IFDEF DBG}
	writeln('InDOS flag @ ',hex4(reg.es),':',hex4(reg.bx));
{$ENDIF}
	dctx.indos_p := ptr(reg.es,reg.bx);

	{ detect Windows 3+ }
	dctx.win3 := false;
	reg.ax := $160A;
	intr($2F,reg);
	if reg.ax = 0 then begin		{ supposedly Windows 3.1+ }
{$IFDEF DBG}
		writeln('Windows ',reg.bh,'.',reg.bl,' detected');
{$ENDIF}
		dctx.win3 := true;
	end else begin
		reg.ax := $4680;
		intr($2F,reg);
		if reg.ax = 0 then begin
			dctx.win3 := true;	{ Windows 3.0 non-enhanced }
		end else begin
			reg.ax := $1600;
			intr($2F,reg);
			dctx.win3 := not (reg.al in [$00,$01,$80,$FF]);
						{ enhanced Windows -> 3.0+ }
		end;
{$IFDEF DBG}
		if dctx.win3 then writeln('Windows 3.0+');
{$ENDIF}
	end;

	dctx.ps1_ok := true;
	pdsk_get_param := true;
	exit;

not_ps1:
{$ENDIF}{PS1_SPECIAL}

	{ "old style" Int13 }

	reg.ah := $08;			{ get drive parameters }
	reg.dl := dctx.id.bin;
	intr($13,reg);
{$IFDEF DBG}
	write('drive type: ',hex2(reg.bl));
	if (reg.flags and FCarry) <> 0 then write(' (carry set)');
	writeln;
	writeln('drive param tbl @ ',hex4(reg.es),':',hex4(reg.di));
	writeln('#drives: ',reg.dl);
{$ENDIF}
	dctx.track_s := reg.cl and $3F;					{ 1..cl }
	dctx.heads := reg.dh + 1;					{ 0..dh }
	dctx.cylinders := (((reg.cl and $C0) shl 2) or reg.ch) + 1;	{ 0..ch }
{$IFDEF DBG}
	write('s/t, t/c, #c: ',dctx.track_s,'., ',
	      dctx.heads,'., ',dctx.cylinders,'.');
{$ENDIF}
	dctx.nblk := dctx.cylinders;
	dctx.nblk := dctx.nblk * dctx.heads;
	dctx.nblk := dctx.nblk * dctx.track_s;
{$IFDEF DBG}
	writeln('  =>  total # of sectors: ',dctx.nblk,'.');
{$ENDIF}
	pdsk_get_param := (reg.ax = 0) and ((reg.flags and FCarry) = 0) and
			  (dctx.nblk > 1);
end;

function ldsk_get_param(var dctx: dsk_t_dctx): boolean;
type
	ioctl_bpb = record			{ BPB, #1004, DOS 4.0+ }
		sector_b: word;		{ bytes per sector }
		cluster_s: byte;	{ sectors per cluster }
		reserved_s: word;	{ # reserved sectors at start of disk }
		fat_cnt: byte;		{ # FATs }
		rootdir_cnt: word;	{ # entries in root directory }
		sectors1: word;		{ total # sectors, or 0 }
		media_id: byte;		{ media ID byte (see #0703) }
		fat_s: word;		{ sectors per FAT }
		track_s: word;		{ sectors per track }
		heads: word;		{ # heads }
		hidden_secs: longint;	{ # hidden sectors }
		sectors2: longint;	{ total # sectors, if sectors1 == 0 }
		{ ... not returned by 21440D get_params ... }
		{	reserved: array[1..6] of byte;
		{	cylinders: word;	{ # cylinders }
		{	devtype: byte;		{ device type }
		{	devattr: word;		{ device attributes }
	end;

	ioctl_bd_parm = record		{ #0902, int21 ax=440D cx=0860 }
		special: byte;
		devtype: byte;		{ device type (see #0903) }
		devattr: word;		{ device attributes }
		cylinders: word;	{ # cylinders }
		mediatype: byte;	{ media type }
		bpb: ioctl_bpb;
	end;
var
	reg: registers;
	l: longint;
	parm: ioctl_bd_parm;
begin
	ldsk_get_param := false;

	reg.ax := $440D;	{ block device IOCTL, }
	reg.cx := $0860;	{ ... get device parameters, traditional disk }
	reg.bl := dctx.id.a1;	{ driver number, 1 -> A: }
	reg.dx := ofs(parm);	{ => parameters }
	reg.ds := seg(parm);
	reg.di := ofs(parm);	{ same for OS/2 ??? }
	reg.si := seg(parm);
	msdos(reg);

{$IFDEF DBG}
	write('LDSK get logical drive parameters: ');
{$ENDIF}
	if (reg.flags and FCarry) <> 0 then begin
{$IFDEF DBG}
		writeln('error, AX=',hex4(reg.ax));
{$ENDIF}
		exit;
	end;
{$IFDEF DBG}
	writeln('ok');
	write('- devtype: ',hex2(parm.devtype));
	writeln(', devattr: ',hex4(parm.devattr));
	write('- media_id ',hex2(parm.bpb.media_id));
	writeln(', bytes/sector: ',parm.bpb.sector_b);
{$ENDIF}
	dctx.nblk := parm.bpb.sectors1;
	if dctx.nblk = 0 then dctx.nblk := parm.bpb.sectors2;
{$IFDEF DBG}
	writeln('- #sectors: ',dctx.nblk,
		', hidden: ',parm.bpb.hidden_secs);
{$ENDIF}
	dctx.track_s := parm.bpb.track_s;
	dctx.heads := parm.bpb.heads;
	l := parm.cylinders;
	l := l * dctx.heads;
	l := l * dctx.track_s;
	if l <> dctx.nblk then begin
		dctx.cylinders := 0;		{ inconsistent geometry }
	end else begin
		dctx.cylinders := parm.cylinders;	{ CHS o.k. }
	end;
{$IFDEF DBG}
	writeln('- s/t, t/c, #c: ',dctx.track_s,'., ',
		dctx.heads,'., ',dctx.cylinders,'.');
{$ENDIF}
	ldsk_get_param := (dctx.nblk > 1);
end;


type
	hwio_op = (op_read,op_write);

{$IFDEF PS1_SPECIAL}
{$IFNDEF PS1_MULTI}
{$IFNDEF NO_REP_INSW} {$G+} {enable REP INSW instruction} {$ENDIF}
{$IFDEF PS1_LBA}
function ps1_hard_hdio(var dctx: dsk_t_dctx; op: hwio_op; lbn: longint;
{$ELSE}
function ps1_hard_hdio(var dctx: dsk_t_dctx; op: hwio_op; c,h,s: integer;
{$ENDIF}
		       bufbkc: word; var buf; var retbkc: word): dsk_t_sts;

{nested}procedure hdonoff(turnon: boolean);	{ pure magic, PS/1 model 2121 }
	const
		ps2_092 = $92;	{ PS/2 system control port A #P075 }
		ps2_094 = $94;	{ PS/2 system board enable/setup reg. #P076 }
		ps2_102 = $102; { PS/2 option select data byte 1 #P082 }
		ps2_103 = $103; { PS/2 option select data byte 2 }
	var
		b: byte;
	begin
		{ enter "setup" mode }
		asm
			CLI
		end;
		port[ps2_094] := $20;

		{ card enable ??? - apparently a no-op }
		port[ps2_102] := port[ps2_102] or 1;

		{ somehow enable/disable disk access, switch light accordingly }
		b := port[ps2_103];
		if turnon then begin
			b := (b or $08) and not $06;
			{ activity light on }
			port[ps2_092] := port[ps2_092] or $C0;
		end else begin
			b := (b and not $08) or $04;
			{ activity light off }
			port[ps2_092] := port[ps2_092] and not $C0;
		end;
		port[ps2_103] := b;

		{ leave "setup" mode }
		port[ps2_094] := $A0;
		asm
			STI
		end;
{nested}end;

const
	pic2_ocw1 = $0A1;

	fdc_data = $3F6;	{ #P0197 }

	hdc1_base = $1F0;	{ #P083 ff. }
	hdc1_data = hdc1_base;
	hdc1_err = hdc1_base + 1;
	hdc1_sts = hdc1_base + 7;
	{ #P085 }
	hdcsts_m_bsy = $80;
	hdcsts_m_rdy = $40;
	hdcsts_m_wrf = $20;	{ write fault }
	hdcsts_m_skc = $10;	{ seek complete }
	hdcsts_m_drq = $08;
	hdcsts_m_ecc = $04;	{ ecc success }
	hdcsts_m_idx = $02;	{ index pulse }
	hdcsts_m_err = $01;

var
	wp: word_arrayptr;
	ib,iw: word;
	dh,csts,cerr: byte;
	error: boolean;
	errloc: string[80];
	reg: registers;
label
	wrapup;
begin
	{ init. }
	error := false;
	retbkc := 0;
	wp := addr(buf);

	{***** START critical region *****}
	if dctx.indos_p^ > 0 then fehler('ps1_hard_hdio(): start, InDOS>0');

	{*NOTE: This won't (usually) work under Windows - }
	{   REAL mode required! But at least I'll try ... }

	{ WIN 3+ begin critical section }
	if dctx.win3 then begin
		reg.ax := $1681; intr($2F,reg);
	end;

	{ increment InDOS flag }
	inc(dctx.indos_p^);

	{ Now *pray* that no-one interupting us (SMARTDRV, WIN, ...) }
	{  will attempt to concurrently access the disk controller. }
	{ (I don't like busy loops with interrupts disabled :-) }

	{ better _disable_ IRQ14 - it's all "wait I/O" }
	asm
		CLI
	end;
	port[pic2_ocw1] := port[pic2_ocw1] or (1 shl 6);
	asm
		STI
	end;

	{ enable access to disk controller }
	hdonoff(true);

	{ ??? enable head select 3 ??? }
	port[fdc_data] := $08;

	{ wait for hdc1 not bsy }
	repeat
		nop;
		csts := port[hdc1_sts]
	until (csts and hdcsts_m_bsy) = 0;

{$IFDEF PS1_LBA}
	{ LBA mode, drive 0 or 1, LBN bits 24..27 }
	dh := $E0 or ((dctx.id.bin and 1) shl 4) or ((lbn shr 24) and $0F);
	{ ??? select drive ???, and also LBA mode }
{$ELSE}
	{ CHS mode, drive 0 or 1, head }
	dh := $A0 or ((dctx.id.bin and 1) shl 4) or (h and $0F);
	{ ??? select drive ??? }
{$ENDIF}
	port[hdc1_base + 6] := dh;

	{ wait for hdc1 not bsy, test ready or error }
	repeat
		nop;
		csts := port[hdc1_sts]
	until (csts and hdcsts_m_bsy) = 0;
	if ((csts and hdcsts_m_err) <> 0) or
	   ((csts and hdcsts_m_rdy) = 0) then begin
		cerr := port[hdc1_err];
		error := true;
		errloc := '2nd wait(!bsy)';
		goto wrapup;
	end;

	{ load registers }
	port[hdc1_base + 1] := $FF;	{ "<write precomp cyl>/4" }
	port[hdc1_base + 2] := bufbkc;	{ #sectors }
{$IFDEF PS1_LBA}
	port[hdc1_base + 3] := lbn and $FF;		{ LBN bit 0..7 }
	port[hdc1_base + 4] := (lbn shr 8) and $0FF;	{ LBN bit 8..15 }
	port[hdc1_base + 5] := (lbn shr 16) and $0FF;	{ LBN bit 16..23 }
	port[hdc1_base + 6] := dh;		{ drive,  LBN bit 24..27 }
{$ELSE}
	port[hdc1_base + 3] := s;			{ sector }
	port[hdc1_base + 4] := c and $0FF;		{ cylinder low }
	port[hdc1_base + 5] := (c shr 8) and $0FF;	{ cylinder high }
	port[hdc1_base + 6] := dh;			{ drive, head }
{$ENDIF}
	if op = op_write then
		port[hdc1_base + 7] := $C5	{ write multiple }
						{ $30 = write w/retry }
	else
		port[hdc1_base + 7] := $C4;	{ read multiple }
						{ $20 = read w/retry }

	for ib := 1 to bufbkc do begin
		{ wait for hdc1 not bsy, and DRQ or error }
		repeat
			nop;
			csts := port[hdc1_sts]
		until ((csts and hdcsts_m_bsy) = 0) and
		      ((csts and (hdcsts_m_err or hdcsts_m_drq)) <> 0);

		{ stop on error [?] }
		if (csts and hdcsts_m_err) <> 0 then begin
			cerr := port[hdc1_err];
			error := true;
			errloc := 'wait(!bsy && (err|drq)), ib=' + hex4(ib);
			goto wrapup;
		end;

{$IFNDEF NO_REP_INSW}
		{ normalize pointer }
		wp := ptr((ofs(wp^) shr 4) + seg(wp^),ofs(wp^) and $000F);
{$ENDIF}
		if op = op_read then begin	{ copy one block of data }
{$IFNDEF NO_REP_INSW}
			asm
				{ REP INSW:  CX times INw [ES:DI++],DX }
				MOV	DX,hdc1_data
				LES	DI,wp		{ load ES & DI }
				MOV	CX,$0100
				CLD
				CLI			{ after BIOS }
				REP INSW
				STI
			end;
{$ELSE}
			for iw := 0 to ((512 div 2) - 1) do begin
				wp^[iw] := portw[hdc1_data];
			end;
{$ENDIF}
		end else begin
{$IFNDEF NO_REP_INSW}
			asm
				PUSH	DS
				{ REP OUTSW:  CX times OUTw DX,[DS:SI++] }
				MOV	DX,hdc1_data
				MOV	CX,$0100
				LDS	SI,wp		{ load DS & SI }
				CLD
				CLI			{ after BIOS }
				REP OUTSW
				STI
				POP	DS
			end;
{$ELSE}
			for iw := 0 to ((512 div 2) - 1) do begin
				portw[hdc1_data] := wp^[iw];
			end;
{$ENDIF}
		end;
		wp := addr(wp^[256]);
	end;

	{ wait for hdc1 not bsy, and ready or drq or error }
	repeat
		nop;
		csts := port[hdc1_sts]
	until ((csts and hdcsts_m_bsy) = 0) and
	      ((csts and (hdcsts_m_err or
			  hdcsts_m_drq or
			  hdcsts_m_rdy)) <> 0);

	{ consider err _or_ drq [?] an error here }
	if (csts and (hdcsts_m_err or hdcsts_m_drq)) <> 0 then begin
		cerr := port[hdc1_err];
		error := true;
		errloc := 'final wait(!bsy&(err|drq|rdy))';
		goto wrapup;
	end;

wrapup:
	if error then begin
		{ try to reset }
		port[fdc_data] := $08 or $04;	{ bit 2 is "reset enable" }
	end;

	{ disable access to disk controller }
	hdonoff(false);

	{ decrement InDOS flag }
	dec(dctx.indos_p^);

	{ WIN 3+ end critical section }
	if dctx.win3 then begin
		reg.ax := $1682; intr($2F,reg);
	end;

	if(dctx.indos_p^ > 0) then fehler('ps1_hard_hdio(): end, InDOS>0');
	{***** END critical region *****}

	if error then begin
		write('??? HDSK ');
		case op of
		  op_read: begin
			write('read ');
			ps1_hard_hdio := dsksts_erd;
			end;
		  op_write: begin
			write('write ');
			ps1_hard_hdio := dsksts_ewr;
			end;
		end;
		writeln('error, [',hex4(hdc1_sts),']=',hex2(csts),', ',
			'[',hex4(hdc1_err),']=',hex2(cerr),', ',
			'id=',hex2(dctx.id.bin),', ',
{$IFDEF PS1_LBA}
			'lbn=',lbn,'., nb=',bufbkc,'.');
{$ELSE}
			'c,h,s=',c,',',h,',',s,' nb=',bufbkc);
{$ENDIF}
		writeln('bad status after: ',errloc);
	end else begin
		retbkc := bufbkc;
		ps1_hard_hdio := dsksts_ok;
	end;
end;
{$IFNDEF NO_REP_INSW} {$G-} {$ENDIF}
{$ENDIF}{PS1_MULTI}
{$ENDIF}{PS1_SPECIAL}

function pdsk_hwio(var dctx: dsk_t_dctx; op: hwio_op; lbn: longint;
		   bufbkc: word; var buf; var retbkc: word): dsk_t_sts;
type
	ext_disk_addr = record		{ #0182 }
		size: byte;		{ = 10h (size of packet) }
		reserved: byte;
		blocks: word;		{ number of blocks to transfer, }
					{ max 007Fh for Phoenix EDD }
		bufp: pointer;		{ -> transfer buffer }
		lbn_lo: longint;	{ starting absolute block number }
		lbn_hi: longint;	{ [QWORD continued] }
	end;
var
	reg: registers;
	c,h,s: integer;
	l: longint;
	extaddr: ext_disk_addr;
label
{$IFDEF PS1_SPECIAL}
	ps1_hwio,
{$ENDIF}
	old_style;
begin
	retbkc := 0;

	if (lbn >= dctx.nblk) then begin
		pdsk_hwio := dsksts_eom;
		exit;
	end;

	s := (lbn mod dctx.track_s) + 1;
	l := (lbn div dctx.track_s);
	h := (l mod dctx.heads);
	c := (l div dctx.heads);

	{ at least with my floppy drive, read/write can't cross tracks ... }
	l := ((lbn div dctx.track_s) + 1) * dctx.track_s - 1;
		{ max lbn w/i same track }
	if (lbn + bufbkc - 1) > l then bufbkc := l - lbn + 1;

	{ NOTE that we don't really check for end-of-medium here }

	if not dctx.ext_ok then goto old_style;

	{ IBM/MS INT 13 Extensions }

	extaddr.size := $10;
	extaddr.reserved := 0;
	extaddr.blocks := bufbkc;
	extaddr.bufp := addr(buf);
	extaddr.lbn_lo := lbn;
	extaddr.lbn_hi := 0;

	case op of
	  op_read:
		reg.ah := $42;
	  op_write:
		reg.ah := $43;
	end;
	reg.al := 0;			{ write flags }
	reg.dl := dctx.id.bin;		{ drive: $80..$FF }
	reg.ds := seg(extaddr);
	reg.si := ofs(extaddr);
	intr($13,reg);
	if (reg.flags and FCarry) <> 0 then begin
		write('??? PDSK (ext) ');
		case op of
		  op_read: begin
			write('read ');
			pdsk_hwio := dsksts_erd;
			end;
		  op_write: begin
			write('write ');
			pdsk_hwio := dsksts_ewr;
			end;
		end;
		retbkc := extaddr.blocks;
		writeln('error, ah=',hex2(reg.ah),
			', id=',hex2(dctx.id.bin),
			', lbn=',lbn,'., blocks rq/ok ',bufbkc,'/',retbkc);
	end else begin
		retbkc := bufbkc;
		pdsk_hwio := dsksts_ok;
	end;
	exit;


	{ "old style" INT 13 }
old_style:

{$IFDEF PS1_SPECIAL}
	if dctx.ps1_ok then goto ps1_hwio;
{$ENDIF}

	case op of
	  op_read:
		reg.ah := $02;
	  op_write:
		reg.ah := $03;
	end;
	reg.al := bufbkc;				{ # sectors }
	reg.ch := c and $FF;				{ track }
	reg.cl := (s and $3F) or ((c and $300) shr 2);	{ sector }
	reg.dh := h;					{ head }
	reg.dl := dctx.id.bin;			{ drive: $00..01, $80..81 }
	reg.es := seg(buf);
	reg.bx := ofs(buf);
	intr($13,reg);					{ Disk Services }

	if (reg.flags and FCarry) <> 0 then begin
		write('??? PDSK ');
		case op of
		  op_read: begin
			write('read ');
			pdsk_hwio := dsksts_erd;
			end;
		  op_write: begin
			write('write ');
			pdsk_hwio := dsksts_ewr;
			end;
		end;
		writeln('error, ax = ',hex4(reg.ax),
			'  id=',hex2(dctx.id.bin),
			' c,h,s ',c,'.,',h,'.,',s,'. nb=',bufbkc);
	end else begin
		retbkc := bufbkc;
		pdsk_hwio := dsksts_ok;
	end;
	exit;

{$IFDEF PS1_SPECIAL}
{$IFNDEF NO_REP_INSW} {$G+} {$ENDIF}
ps1_hwio:
{$IFDEF DBG2}
	writeln('buf @ ',hex4(seg(buf)),':',hex4(ofs(buf)));
{$ENDIF}
{$IFDEF PS1_MULTI}	{ this does work, but is BIOS-limited with model 2121 }
	{ PS/1 read/write multiple disk sectors }
	case op of
	  op_read:
		reg.ah := $21;
	  op_write:
		reg.ah := $22;
	end;
	reg.al := bufbkc;				{ # sectors }
	reg.ch := c and $FF;				{ cylinder low byte }
	{ CL = starting sector (bits 0-5) and bits 8-9 of cylinder (bits 6-7) }
	reg.cl := (s and $3F) or ((c and $300) shr 2);
	{ DH = head number (bits 0-5) and bits 10-11 of cylinder (bits 6-7) }
	reg.dh := (h and $3F) or ((c and $C00) shr 4);
	reg.dl := dctx.id.bin;				{ drive: $80..81 }
	reg.es := seg(buf);
	reg.bx := ofs(buf);
	intr($13,reg);

	if (reg.flags and FCarry) <> 0 then begin
		write('??? PDSK ');
		case op of
		  op_read: begin
			write('read ');
			pdsk_hwio := dsksts_erd;
			end;
		  op_write: begin
			write('write ');
			pdsk_hwio := dsksts_ewr;
			end;
		end;
		writeln('multi(',dctx.multi_s,') error, ah=',hex2(reg.ah),
			' * id=',hex2(dctx.id.bin),
			' c,h,s=',c,',',h,',',s,' nb=',bufbkc);
	end else begin
		retbkc := bufbkc;
		pdsk_hwio := dsksts_ok;
	end;
{$ELSE}
{$IFDEF PS1_LBA}
	pdsk_hwio := ps1_hard_hdio(dctx,op,lbn,bufbkc,buf,retbkc);
{$ELSE}
	pdsk_hwio := ps1_hard_hdio(dctx,op,c,h,s,bufbkc,buf,retbkc);
{$ENDIF}
{$ENDIF}{PS1_MULTI}
{$IFNDEF NO_REP_INSW} {$G-} {$ENDIF}
{$ENDIF}{PS1_SPECIAL}
end;


function ldsk_hwio(var dctx: dsk_t_dctx; op: hwio_op; lbn: longint;
		   bufbkc: word; var buf; var retbkc: word): dsk_t_sts;
type
{ * doesn't seem to work on PS/1 *
{	ioctl_bd_rw = record			{ #0904, int21 ax=440D r/w }
{		special: byte;		{ special functions (must be zero) }
{		h: word;		{ head # }
{		c: word;		{ cylinder # }
{		s: word;		{ first sector to read/write }
{		count: word;		{ # sectors }
{		bp: pointer;		{ transfer address }
{	end;
}
	int2526_pkt = record
		lbn: longint;
		count: word;
		bp: pointer;
	end;
var
	reg: registers;
	l: longint;
	prm: int2526_pkt;
begin
	retbkc := 0;

	if (lbn >= dctx.nblk) then begin
		ldsk_hwio := dsksts_eom;
		exit;
	end;

	{ at least with my floppy drive, read/write can't cross tracks ... }
	l := ((lbn div dctx.track_s) + 1) * dctx.track_s - 1;
		{ max lbn w/i same track }
	if (lbn + bufbkc - 1) > l then bufbkc := l - lbn + 1;

	{ NOTE that we don't really check for end-of-medium here }

	prm.count := bufbkc;
	prm.lbn := lbn;
	prm.bp := addr(buf);

	reg.al := dctx.id.a1 - 1;
	reg.ah := 0;			{ unspecified? }
	reg.cx := $FFFF;
	reg.ds := seg(prm);
	reg.bx := ofs(prm);

	{*** int 25 & 26 "leave flags word on stack" ***}
	{*** so ``intr(func[op],reg);'' doesn't work ***}
	{"may destroy all registers except segment registers"}
	{ Turbo PASCAL only wants SS,SP,DS,BP preserved }
	case op of
	  op_read:	asm
		MOV	CX,reg.&cx
		MOV	BX,reg.&bx
		MOV	AX,reg.&ax
		PUSH	BP
		PUSH	DS
		MOV	DS,reg.&ds
		INT	$25
		PUSHF
		POP	BX		{ new flags }
		POP	CX		{ old flags, garbage }
		POP	DS		{ re-establish DS }
		POP	BP		{ restore BP }
		MOV	reg.&flags,BX
		MOV	reg.&ax,AX
			end;
	  op_write:	asm
		MOV	CX,reg.&cx
		MOV	BX,reg.&bx
		MOV	AX,reg.&ax
		PUSH	BP
		PUSH	DS
		MOV	DS,reg.&ds
		INT	$26
		PUSHF
		POP	BX		{ new flags }
		POP	CX		{ old flags, garbage }
		POP	DS		{ re-establish DS }
		POP	BP		{ restore BP }
		MOV	reg.&flags,BX
		MOV	reg.&ax,AX
			end;
	end;
	{*** end fake int 25 & 26 ***}
	{ only reg.flags & reg.ax are valid now }

	if (reg.flags and FCarry) <> 0 then begin
		write('??? LDSK ');
		case op of
		  op_read: begin
			write('read ');
			ldsk_hwio := dsksts_erd;
			end;
		  op_write: begin
			write('write ');
			ldsk_hwio := dsksts_ewr;
			end;
		end;
		writeln('error, ax = ',hex4(reg.ax),
			'  id=',hex2(dctx.id.a1 - 1),
			'  lbn=',prm.lbn,
			'.  count ',bufbkc,'/',prm.count);
	end else begin
		retbkc := bufbkc;
		ldsk_hwio := dsksts_ok;
	end;
end;


function dsk_open(dev: dsk_t_dev; var hnd: byte; var blks: longint;
		  var geom: dsk_t_geom): dsk_t_sts;
var
	h: byte;
	geo_fixed: boolean;
	newcyl: word;
	i: integer;
	l: longint;
	d: dsk_t_dctxptr;
	x: dsk_t_ctxptr;
	xid: dsk_t_id;
label
	dctx_ok;
begin
	hnd := 0;

	x := nil;
	h := 0; repeat
		inc(h);
		if not ctxa[h].inuse then x := addr(ctxa[h]);
	until (x <> nil) or (h >= n_ctx);
	if x = nil then begin
		dsk_open := dsksts_onh;
		exit;
	end;

	case dev.devcls of
	  dsk_k_fd:	begin
		xid.ty := ty_pdsk;
		xid.bin := dev.unitno;
			end;
	  dsk_k_hd:	begin
		xid.ty := ty_pdsk;
		xid.bin := dev.unitno or $80;
			end;
	  dsk_k_drv:	begin
		xid.ty := ty_ldsk;
		case dev.letter of
		  'A'..'Z':
			xid.a1 := ord(dev.letter) - ord('A') + 1;
		  'a'..'z':
			xid.a1 := ord(dev.letter) - ord('a') + 1;
		else begin
			dsk_open := dsksts_inv;
			exit;
		     end;
		end;
			end;
	else begin
		dsk_open := dsksts_inv;
		exit;
	     end;
	end;

	{ either locate dctx, or create a new one }
	d := nil;
	for i := 1 to n_dctx do begin
		if (dctxa[i].refcnt > 0) and
		   (dctxa[i].id.ty = xid.ty) and
		   (((xid.ty = ty_pdsk) and (dctxa[i].id.bin = xid.bin)) or
		    ((xid.ty = ty_ldsk) and (dctxa[i].id.a1 = xid.a1)))
		   then begin
			d := addr(dctxa[i]);
			goto dctx_ok;
		end else if (d = nil) and (dctxa[i].refcnt = 0) then begin
			d := addr(dctxa[i]);
		end;
	end;

	if d = nil then begin
		dsk_open := dsksts_onh;
		exit;
	end;

	d^.id := xid;

	if xid.ty = ty_pdsk then begin
		if not pdsk_get_param(d^) then begin
			dsk_open := dsksts_ond;
			exit;
		end;
	end else begin
		if not ldsk_get_param(d^) then begin
			dsk_open := dsksts_ond;
			exit;
		end;
	end;

	{ fix geometry, so at least H & S make some sense }
	geo_fixed := false;
	{ fix S }
	if (d^.track_s > d^.nblk) or (d^.track_s = 0) then begin
		d^.track_s := 63;				{ <<< }
		if d^.track_s > d^.nblk then d^.track_s := d^.nblk;
		geo_fixed := true;
	end;
	{ fix H }
	if geo_fixed or
	   ((d^.track_s * d^.heads) > d^.nblk) or
	   (d^.heads = 0) then begin
		d^.heads := 255;				{ <<< }
		if (d^.id.ty = ty_pdsk) and not d^.ext_ok then
			d^.heads := 16;				{ <<< }
		if (d^.track_s * d^.heads) > d^.nblk then
			d^.heads := d^.nblk div d^.track_s;
		geo_fixed := true;
	end;
	{ fix or zero C }
	if geo_fixed or
	   (d^.cylinders = 0) then begin
		l := d^.track_s * d^.heads;
		newcyl := d^.nblk div l;
		l := l * newcyl;
		if l <> d^.nblk then newcyl := 0;
		if d^.cylinders <> newcyl then begin
			d^.cylinders := newcyl;
			geo_fixed := true;
		end;
	end;
{$IFDEF DBG}
	if geo_fixed then
		writeln('*fixed* C/H/S: ',d^.cylinders,'/',
			d^.heads,'/',d^.track_s);
{$ENDIF}

	d^.c.blkmax := min(d^.track_s,63);
	d^.c.blkmax := min(d^.c.blkmax,(maxavail div 512));
	if (d^.c.blkmax <= 0) then begin
		dsk_open := dsksts_onh;
		exit;
	end;

{$IFDEF DOS7_LCK}
	d^.lck_done := false;
	dsk_lck(d^);
{$ENDIF}

	getmem(d^.c.bufp,(d^.c.blkmax * 512));
	d^.c.blkused := 0;
	d^.c.dirty := false;

dctx_ok:
	inc(d^.refcnt);
	x^.dctx_p := d;
	x^.voff.lbn := 0;
	x^.voff.boff := 0;
	x^.inuse := true;

	geom.r.sec := d^.track_s;
	geom.r.trk := d^.heads;
	geom.r.cyl := d^.cylinders;
	blks := d^.nblk;
	hnd := h;
	dsk_open := dsksts_ok;
end;

function cache_flush(var dctx: dsk_t_dctx): dsk_t_sts;
var
	sts: dsk_t_sts;
	bp: block_arrayptr;
	lbn: longint;
	nb1,nb2: word;
begin
	sts := dsksts_ok;
	if dctx.c.dirty and (dctx.c.blkused > 0) then begin
		bp := dctx.c.bufp;
		lbn := dctx.c.lbn0;
		nb1 := dctx.c.blkused;
		while (nb1 > 0) do begin
			if dctx.id.ty = ty_pdsk then
				sts := pdsk_hwio(dctx,op_write,lbn,nb1,bp^,nb2)
			else
				sts := ldsk_hwio(dctx,op_write,lbn,nb1,bp^,nb2);
			if (sts <> dsksts_ok) then begin
				cache_flush := sts;
				exit;		{ cache left all dirty }
			end;
			dec(nb1,nb2);
			inc(lbn,nb2);
			bp := addr(bp^[nb2]);
		end;
		dctx.c.dirty := false;
	end;
	cache_flush := sts;
end;

function dsk_read(hnd: byte; buflen: word; var buf; var retlen: word): dsk_t_sts;
var
	x: dsk_t_ctxptr;
	d: dsk_t_dctxptr;
	sts: dsk_t_sts;
	bp: block_arrayptr;
	lbn: longint;
	nb2,ct,usemax: word;
	bytp: byte_arrayptr;
begin
	retlen := 0;

	x := find_ctx(hnd);
	if x = nil then begin
		dsk_read := dsksts_inv;
		exit;
	end;
	d := x^.dctx_p;

	sts := cache_flush(d^);
	if sts <> dsksts_ok then begin
		dsk_read := sts;
		exit;
	end;

	bytp := addr(buf);
	while buflen > 0 do begin
		while not ((x^.voff.lbn >= d^.c.lbn0) and
			   (x^.voff.lbn < (d^.c.lbn0 + d^.c.blkused))) do begin
			{ try to fill cache }
			d^.c.lbn0 := x^.voff.lbn;
			d^.c.blkused := 0;

			usemax := d^.c.blkmax;
			if ((usemax + d^.c.lbn0) > d^.nblk) then
				usemax := d^.nblk - d^.c.lbn0;
			if usemax <= 0 then begin
				dsk_read := dsksts_eom;
				exit;
			end;

			bp := d^.c.bufp;
			lbn := d^.c.lbn0;
			sts := dsksts_ok;
			while (d^.c.blkused < usemax) and
			      (sts = dsksts_ok) do begin
				if d^.id.ty = ty_pdsk then
					sts := pdsk_hwio(d^,op_read,lbn,
							usemax - d^.c.blkused,
							bp^,nb2)
				else
					sts := ldsk_hwio(d^,op_read,lbn,
							usemax - d^.c.blkused,
							bp^,nb2);
				inc(d^.c.blkused,nb2);
				inc(lbn,nb2);
				bp := addr(bp^[nb2]);
			end;
			if (d^.c.blkused = 0) then begin	{ sts not ok }
				dsk_read := sts;
				exit;
			end;		{ else ignore error for now }
		end;

		ct := min(buflen,(d^.c.blkused + d^.c.lbn0 - x^.voff.lbn) * 512 - 
				 x^.voff.boff);
		move(d^.c.bufp^[x^.voff.lbn - d^.c.lbn0][x^.voff.boff],bytp^,ct);
		inc(retlen,ct);
		dec(buflen,ct);
		bytp := addr(bytp^[ct]);

		ct := ct + x^.voff.boff;
		x^.voff.boff := (ct mod 512);
		inc(x^.voff.lbn,(ct div 512));
	end;
	dsk_read := dsksts_ok;
end;

function dsk_write(hnd: byte; buflen: word; var buf; var retlen: word): dsk_t_sts;
var
	x: dsk_t_ctxptr;
	d: dsk_t_dctxptr;
	sts: dsk_t_sts;
	bp: block_arrayptr;
	lbn: longint;
	ct,usemax: word;
	bytp: byte_arrayptr;
begin
	retlen := 0;

	x := find_ctx(hnd);
	if (x = nil) or{_else}
	   (((buflen mod 512) <> 0) or		{ whole blocks only! [?] }
	   (x^.voff.boff <> 0)) then begin	{ ... ditto ... }
		dsk_write := dsksts_inv;
		exit;
	end;
	d := x^.dctx_p;

	bytp := addr(buf);
	while buflen > 0 do begin
		while not ((x^.voff.lbn >= d^.c.lbn0) and
			   (x^.voff.lbn < (d^.c.lbn0 + d^.c.blkmax)) and
			    { no gap! }
			   (x^.voff.lbn <= (d^.c.lbn0 + d^.c.blkused)))
		      do begin
			sts := cache_flush(d^);
			if sts <> dsksts_ok then begin
				dsk_write := sts;
				exit;
			end;
			d^.c.lbn0 := x^.voff.lbn;
			d^.c.blkused := 0;
		end;

		usemax := d^.c.blkmax;
		if ((usemax + d^.c.lbn0) > d^.nblk) then
			usemax := d^.nblk - d^.c.lbn0;
		if (d^.c.lbn0 + usemax) <= x^.voff.lbn then begin
			dsk_write := dsksts_eom;
			exit;
		end;

		ct := min(buflen,(usemax + d^.c.lbn0 - x^.voff.lbn) * 512);
		d^.c.blkused := max(d^.c.blkused,
				    (ct div 512) + x^.voff.lbn - d^.c.lbn0);
		d^.c.dirty := true;
		move(bytp^,d^.c.bufp^[x^.voff.lbn - d^.c.lbn0][0],ct);
		inc(retlen,ct);
		dec(buflen,ct);
		bytp := addr(bytp^[ct]);

		inc(x^.voff.lbn,(ct div 512));
	end;
	dsk_write := dsksts_ok;
end;

function dsk_seek(hnd: byte; offset: dsk_t_off): dsk_t_sts;
var
	x: dsk_t_ctxptr;
begin
	x := find_ctx(hnd);
	if x = nil then begin
		dsk_seek := dsksts_inv;
		exit;
	end;

	if (offset.lbn >= x^.dctx_p^.nblk) then begin
		dsk_seek := dsksts_eom;
	end else begin
		x^.voff := offset;
		dsk_seek := dsksts_ok;
	end;
end;

{ always "hnd" released }
function dsk_close(hnd: byte): dsk_t_sts;
var
	x: dsk_t_ctxptr;
	d: dsk_t_dctxptr;
begin
	x := find_ctx(hnd);
	if x = nil then begin
		dsk_close := dsksts_inv;
		exit;
	end;

	d := x^.dctx_p;
	if d <> nil then begin
		dsk_close := cache_flush(d^);

		dec(d^.refcnt);
		if d^.refcnt = 0 then begin
			{ free_dctx() }

{$IFDEF DOS7_LCK}
			dsk_unlck(d^);
{$ENDIF}

			freemem(d^.c.bufp,d^.c.blkmax);
			d^.c.blkmax := 0;
		end;

		x^.dctx_p := nil;
	end;

	x^.inuse := false;
end;


{ exit handler, supposedly called _after_ caller's (if any) }
procedure dsk_exith; far;
var
	h: byte;
begin
	{ DOS7 "unlock", if applicable }
	for h := 1 to n_ctx do begin	{ using known "hnd" range }
		if dsk_close(h) <> dsksts_ok then nop;
	end;
end;


{ initialization }
var
	i: integer;
begin
	for i := 1 to n_ctx do begin
		ctxa[i].inuse := false;
		ctxa[i].dctx_p := nil;
	end;
	for i := 1 to n_dctx do dctxa[i].refcnt := 0;
	userex(dsk_exith);
end.
