{ Copyright (C) 1997 Wolfgang J Moeller. All rights reserved. NO WARRANTY! }

unit etherrcv;

{ packet driver "receiver" callback & related routines
{
{ w.j.m. dec 1996
{
{ NOTE: only a single receive queue is provided, handles are ignored
}

interface


{ callback for pktd_access_type() }
procedure rcv;

{ provide receive buffers }
procedure rcv_put(p: pointer; siz: word);

{ poll for input }
function rcv_get(var p: pointer; var len: word): boolean;

{ read & zero error counters }
procedure rcv_errors(var no_buf,too_long: longint);


implementation uses wjmp;


const
	rcvqmax = 16;		{ # of buffers we can accomodate }
type
	rcvqelt = record
		len: word;	{ 0 means empty }
		bp: pointer;	{ must be valid when (len <> 0) }
	end;
	rcvqueue = record
		xi: word;	{ insert position }
		xo: word;	{ remove position }
		e: array[0..(rcvqmax-1)] of rcvqelt;
	end;
var
	rcvfree,rcvdone: rcvqueue;
	rcv_nbuf: word;			{ #buffers present }
	rcv_lost,rcv_long: longint;	{ error counters }


procedure rcv_errors(var no_buf,too_long: longint);
begin
	{ disable interrupts }
	asm
		CLI
	end;

	no_buf := rcv_lost;	rcv_lost := 0;
	too_long := rcv_long;	rcv_long := 0;

	{ enable interrupts }
	asm
		STI
	end;
end;

{+++ feed the free queue +++}
procedure rcv_put(p: pointer; siz: word);
{ NOTE: "siz" info is not preserved. Does this matter? }
begin
	if (p = nil) or (siz = 0) then fehler('rcv_qin(): invalid argument(s)');
	if rcv_nbuf >= rcvqmax then fehler('rcv_qin(): too many buffers');
	with rcvfree do begin
		if (e[xi].len <> 0) or (e[xi].bp <> nil) then begin
			fehler('rcv_qin(): free queue overflow');
		end else begin
			inc(rcv_nbuf);
			e[xi].bp := p;
			e[xi].len := siz;
			{ advance index }
			xi := (xi + 1) mod rcvqmax;
		end;
	end;
end;

{+++ poll for input +++}
function rcv_get(var p: pointer; var len: word): boolean;
begin
	with rcvdone do begin
		if (e[xo].len <> 0) and (e[xo].bp <> nil) then begin
			p := e[xo].bp;
			len := e[xo].len;
			rcv_get := true;

			{ free slot }
			e[xo].len := 0;
			e[xo].bp := nil;
			dec(rcv_nbuf);
			{ advance index }
			xo := (xo + 1) mod rcvqmax;
		end else begin
			rcv_get := false;
		end;
	end;
end;

{$S-} { running on some (small) stack provided by the packet driver }
{$F+}
procedure rcv_int(Flags,CS,IP,AX,BX,CX,DX,SI,DI,DS,ES,BP: Word); interrupt;
begin
	if AX = 0 then begin	{ pass buffer address }
				{ BX=handle, CX=len }
		with rcvfree do begin
			if (e[xo].len = 0) or (e[xo].bp = nil) then begin
				inc(rcv_lost);
				ES := 0;
				DI := 0;
			end else if CX <= e[xo].len then begin
				ES := seg(e[xo].bp^);
				DI := ofs(e[xo].bp^);
				{ trust packet driver to pass the pointer back }
				e[xo].len := 0;
				e[xo].bp := nil;
				{ advance index }
                                xo := (xo + 1) mod rcvqmax;
			end else begin
				inc(rcv_long);
				ES := 0;
				DI := 0;
			end;
		end;
	end else begin		{ process buffer }
				{ BX=handle, CX=len, DS:SI=^buffer }
		with rcvdone do begin
			{ the "rcv_nbuf" logic above supposedly guarantees
			  that the "rcvdone" slot is free }
			e[xi].bp := ptr(DS,SI);
			e[xi].len := CX;
			{ advance index }
			xi := (xi + 1) mod rcvqmax;
		end;
	end
end;	

{+++ callback to be used with pktd_access_type() +++}
procedure rcv;
begin  { call "interrupt" routine via fake interrupt }
	asm
		PUSHF
		CALL	FAR PTR rcv_int
	end
end;
{$F-}
{$S+}


{----- initialization -----}

var
	i: integer;
begin
	rcv_lost := 0;
	rcv_long := 0;

	rcv_nbuf := 0;

	with rcvfree do begin
		xi := 0;
		xo := 0;
		for i := 0 to (rcvqmax-1) do begin
			e[i].len := 0;
			e[i].bp := nil;
		end;
	end;

	with rcvdone do begin
		xi := 0;
		xo := 0;
		for i := 0 to (rcvqmax-1) do begin
			e[i].len := 0;
			e[i].bp := nil;
		end;
	end;
end.
