{ Copyright (C) 1997 Wolfgang J Moeller. All rights reserved. NO WARRANTY! }

unit nd_const;

{ NDFP constants (all versions)
{
{ w.j.m. dec 1996 ff.
}

interface

type
	ndfp_ptype_t = record case integer of
		1: (w: word);
		2: (b: array[0..1] of byte);
	end;

const
	{ NDFP_PTY (Ethernet protocol type) in network byte order }
	ndfp_ptype: ndfp_ptype_t = (b: ($60,$06));

	NDFP_VERSION1 = 10;	{ V1.0 }
	NDFP_VERSION2 = 20;	{ V2, has window size (1..NDFP_MAX_FRAG) added }
	NDFP_VERSION3 = 30;	{ V3, window size added }
	NDFP_VERSION4 = 40;	{ V4, window size added }
	NDFP_VERSION5 = 50;	{ V5, window size added }

	NDFP_DATA_MAX1 = 1024;	{ V1.0 }
	NDFP_DATA_MAX2 = 1024;	{ V2 }
	NDFP_DATA_MAX3 = 1472;	{ V3 }		{ 23*512/8; header size = 28 }
	NDFP_DATA_MAX4 = NDFP_DATA_MAX3;
	NDFP_DATA_MAX5 = NDFP_DATA_MAX3;

	NDFP_MAX_FRAG = 8;	{ V2+ }

	NDFP_PKT_MINLEN = 48;

	NDFP_OP_RESET = 0;
	NDFP_OP_OPEN = 1;
	NDFP_OP_READ = 2;
	NDFP_OP_WRITE = 3;
	NDFP_OP_TRUNC = 4;
	NDFP_OP_CLOSE = 5;
	NDFP_OP_TIME = 8;
	NDFP_OP_M_REPLY = $0100;	{ (link-level) direction }
	NDFP_OP_M_NAK = $0200;	{ V2+ }	{ (link-level) retransmit request }

	NDOM_READ = 1;
	NDOM_WRITE = 2;
	NDOM_FATTR = 4;		{ obsolete as of V4 }
	NDOM_FTIME = 8;		{ obsolete as of V4 }
	{ NDOM_CREATERW = 16;	- obsolete as of V1 }
	NDOM_DISK = 32;
        NDOM_DRV = 64;
	NDOM_DIR = 128;

	NDCM_DELETE = 1;
	NDCM_RENAME = 2;
	NDCM_FATTR = 4;
	NDCM_FTIME = 8;

	NDTM_ADD = 1;
	NDTM_SET = 2;

	{ success }
	NDSS_OK =		$0001;
	{ warning }
	NDSS_EOF =		$0870;	{ beyond end of file/dir/disk }
	NDSS_NOTDEL =		$2338;	{ close/delete failed to delete }
	{ error }
	NDSS_NOTREN =		$02D2;	{ close/rename failed to rename }
	{ fatal }
	NDSS_IVPARAM =		$0014;	{ invalid parameter value }
	NDSS_IVHANDLE =		$00AC;	{ handle not open, or invalid }
	NDSS_NODRIVE =		$01C4;	{ no such disk or drive }
	NDSS_RONLY =		$025C;	{ write-lock error }
	NDSS_IVOFFSET =		$02DC;	{ invalid "offset" parameter }
	NDSS_IVDATALEN =	$034C;	{ invalid length of data or string }
	NDSS_IVMODE =		$0354;	{ operation incompatible with "mode" }
	NDSS_NOACCESS =		$0804;	{ file/dir not accessible [vague] }
	NDSS_IVNAK =		$0834;	{ (link-level) NAK not valid }
	NDSS_FNF =		$0914;	{ file not found }
	NDSS_UNSUP =		$0E4C;	{ operation not supported (yet) }
	NDSS_OPENERR =		$109C;	{ error opening ... }
	NDSS_CREATERR =		$10A4;	{ error creating ... }
	NDSS_READERR =		$10B4;	{ error reading ... }
	NDSS_WRITERR =		$10D4;	{ error writing ... }
	NDSS_DOSFAIL =		$11B4;	{ (some unspecified error) }
	NDSS_IVPATH =		$133C;	{ invalid file/dir "path" name }
	NDSS_IVPROTO =		$2074;	{ protocol error }
	NDSS_NOROOM =		$232C;	{ failure due to lack of ressources }


implementation

{ void }

end.
