{ Copyright (C) 1997 Wolfgang J Moeller. All rights reserved. NO WARRANTY! }

unit nd_prot5;

{ NDFP V5 packet header & constants
{
{ w.j.m. mar 1997
}

interface uses dsk_cio { for dsk_geom only }, nd_const;

const
	NDFP_VERSION = NDFP_VERSION5;
	NDFP_DATA_MAX = NDFP_DATA_MAX5;

type
	ndfp_pkt = record
		cseq: word;
		ifrag: byte;				{ V2+ }
		nfrag: byte;				{ V2+ }
		chandle: word;
		shandle: word;
		op: word;
		ndata: word;				{ "datalen" in V1 }
		{ argw[0] }
		rp_sts: word;
		{ argw[1] }
		w1: record case integer of
			0: (rp_reset_vers : word);
			1: (rq_open_mode  : word);
			2: (rp_open_fattr : word);
			3: (rq_read_count : word);
			4: (rp_read_count : word);	{ nfrag > 0 only }
			5: (rq_write_count: word);	{ nfrag > 0 only }
			6: (rp_write_count: word);
			7: (rq_close_mode : word);
			8: (rq_time_mode : word);
		end;
		{ argw[2] }
		w2: record case integer of
			0: (rq_open_fattr: word);
			1: (rp_read_boff : word);	{ nfrag > 0 only }
			2: (rq_write_boff: word);	{ nfrag > 0 only }
			3: (rq_close_fattr: word);
		end;
		{ argw[3] }
		w3: record case integer of
			0: (rp_open_fsizebyt: word);
			1: (rq_read_offsetbyt: word);
			2: (rq_write_offsetbyt: word);
			3: (rq_trunc_offsetbyt: word);
		end;
		{ argl[0] }
		l0: record case integer of
			{--- following field was called "_fsize" prior to V5 }
			0: (rp_open_fsizeblk: longint);		{ v5+ }
			1: (rq_time_q_lo: longint);
			2: (rp_time_q_lo: longint);
		end;
		{ argl[1] }
		l1: record case integer of
			0: (rq_open_ftime     : longint);
			1: (rp_open_ftime     : longint);
			2: (rp_opendsk_geom   : dsk_t_geom);
			{--- following 3 fields were "_offset" prior to V5 }
			{--- NOTE *incompatibility* with older clients }
			3: (rq_read_offsetblk : longint);	{ v5+ }
			4: (rq_write_offsetblk: longint);	{ v5+ }
			5: (rq_trunc_offsetblk: longint);	{ v5+ }
			6: (rq_close_ftime    : longint);
			7: (rq_time_q_hi: longint);
			8: (rp_time_q_hi: longint);
		end;
		data: packed array[0..(NDFP_DATA_MAX - 1)] of byte;
	end;


implementation

{ void }

end.
