unit time64;
{$N+}{$E+}

interface

type
	t_numtim = record
		year,mon,day,hh,mm,ss,cc: word;
	end;

procedure get_numtim(var n: t_numtim);
function set_numtim(n: t_numtim): boolean;

procedure cvt_numtim_64b1980(n: t_numtim; var lo,hi: longint);
procedure cvt_64b1980_numtim(lo,hi: longint; var n: t_numtim);

procedure adjtim_64b(dlo,dhi: longint);

implementation uses dos,wjmp;

const
	mdn: array[1..12] of integer = (31,28,31,30,31,30,31,31,30,31,30,31);
	mds: array[1..12] of integer =
				(0,31,59,90,120,151,181,212,243,273,304,334);
type
	i64 = record case integer of
		1: (q: comp);
		2: (l: record lo,hi: longint; end);
	end;

procedure get_numtim(var n: t_numtim);
var
	dow,y2,m2,d2: word;
begin
	repeat
		getdate(n.year,n.mon,n.day,dow);
		gettime(n.hh,n.mm,n.ss,n.cc);
		getdate(y2,m2,d2,dow);
	until (d2 = n.day) and (m2 = n.mon) and (y2 = n.year);
end;

function set_numtim(n: t_numtim): boolean;
begin
	if (n.hh = 23) and (n.mm = 59) and (n.ss > 50) then begin
		{ better refuse, due to danger of date roll-over }
		set_numtim := false;
		exit;
	end;

	settime(n.hh,n.mm,n.ss,n.cc);
	setdate(n.year,n.mon,n.day);
	set_numtim := true;
end;

{ convert t_numtim to 64 bit time (10^-7 sec since 01-JAN-1980:00:00:00.00) }
procedure cvt_numtim_64b1980(n: t_numtim; var lo,hi: longint);
var
	off: i64;
	leap_y: boolean;
begin
	leap_y := ((n.year mod 4) = 0) and
		  (((n.year mod 400) = 0) or ((n.year mod 100) <> 0));

{	valid := (n.year >= 1980) and (n.mon >= 1) and (n.mon <= 12) and
{		(n.day >= 1) and ((n.day <= mdn[n.mon]) or
{			((n.day = 29) and (n.mon = 2) and leap_y)) and
{		(n.hh >= 0) and (n.hh <= 23) and
{		(n.mm >= 0) and (n.mm <= 59) and
{		(n.ss >= 0) and (n.ss <= 59) and	! <= 60 ???
{		(n.cc >= 0) and (n.cc <= 99);
}
	{ #days till n.day-n.mon-n.year:00:00:00.00 }
	off.q := 365 * (n.year - 1980) +
		(n.year div 4) - (n.year div 100) + (n.year div 400) - 479 +
		mds[n.mon] + n.day - 1;
	if (n.mon < 3) and leap_y then off.q := off.q - 1;

	{ #10^-7 sec }
	off.q := 100000 *
		 (n.cc + 100 * (n.ss + 60 * (n.mm + 60 * (n.hh + 24 * off.q))));

	lo := off.l.lo;
	hi := off.l.hi;
end;

{ convert 64 bit time (10^-7 sec since 01-JAN-1980:00:00:00.00) to t_numtim }
procedure cvt_64b1980_numtim(lo,hi: longint; var n: t_numtim);
var
	off: i64;
	q1,q2: comp;
	d,d_1_1: longint;
	m: word;
	leap_y: boolean;
label
	test_y,mon_ok;
begin
	off.l.hi := hi;
	off.l.lo := lo;
	q1 := int(off.q / 100000);

	q2 := int(q1 / 100);
	n.cc := trunc(q1 - 100 * q2);

	q1 := int(q2 / 60);
	n.ss := trunc(q2 - 60 * q1);

	q2 := int(q1 / 60);
	n.mm := trunc(q1 - 60 * q2);

	q1 := int(q2 / 24);
	n.hh := trunc(q2 - 24 * q1);

	d := trunc(q1);			{ #days }

	n.year := 1980 + (d div 365);	{ 1st guess, >= true year }

test_y:
	leap_y := ((n.year mod 4) = 0) and
		  (((n.year mod 400) = 0) or ((n.year mod 100) <> 0));

	d_1_1 := 365 * (n.year - 1980) +	
		 (n.year div 4) - (n.year div 100) + (n.year div 400) - 479;
	if leap_y then d_1_1 := d_1_1 - 1;

	if (d_1_1 > d) then begin
		n.year := n.year - 1;
		goto test_y;
	end;

	d := d - d_1_1;
	for m := 1 to 12 do begin
		if d < mdn[m] then goto mon_ok;
		if leap_y and (m = 2) then begin
			if d = 28 then goto mon_ok;
			d := d - 29;
		end else
			d := d - mdn[m];
	end;
	fehler('cvt_64b1980_numtim(): month > 12');

mon_ok:
	n.mon := m;
	n.day := d + 1;
end;

{ adjust time by some number of 10^-7 sec }
{ may *loop* until after midnight }
procedure adjtim_64b(dlo,dhi: longint);
var
	off,delta: i64;
	n: t_numtim;
begin
	delta.l.lo := dlo;
	delta.l.hi := dhi;

	repeat
		get_numtim(n);
		cvt_numtim_64b1980(n,off.l.lo,off.l.hi);
		off.q := off.q + delta.q;
		cvt_64b1980_numtim(off.l.lo,off.l.hi,n);
	until set_numtim(n);
end;

end.
