{ Copyright (C) 1997 Wolfgang J Moeller. All rights reserved. NO WARRANTY! }

unit wjmp;

{ general purpose subroutines
{
{ w.j.m. dec 1996
}

interface

function j2(i: word): string;			{ printf "%02d" }
function j4(i: word): string;			{ printf "%04d" }
function hex2(b: byte): string;			{ printf "%02X" }
function hex4(w: word): string;			{ printf "%04X" }

function min(a,b: integer): integer;
function max(a,b: integer): integer;

procedure dump_16(d: pointer; nbyt: word);	{ hex + ascii dump }

procedure nop;

procedure fehler(s: string);			{ abort with error message }

var
	exitproc: record end;	{ use of SYSTEM.exitproc strongly discouraged }
type
	t_procedure_noarg_far = procedure;	{ "procedure XXX; far; ... " }
						{ Not checked! unfortunately }
procedure userex(pf: t_procedure_noarg_far);		{ declare exit handler }
procedure cancel_userex(pf: t_procedure_noarg_far);	{ cancel exit handler }


implementation


function j2(i: word): string;
var s: string[11];
begin
	str(i,s);
	while length(s) < 2 do s := concat('0',s);
	j2 := s;
end;

function j4(i: word): string;
var s: string[11];
begin
	str(i,s);
	while length(s) < 4 do s := concat('0',s);
	j4 := s;
end;


const
	hextab: array[0..$F] of char = '0123456789ABCDEF';

function hex2(b: byte): string;
begin
	hex2 := hextab[b shr 4] + hextab[b and $F];
end;

function hex4(w: word): string;
begin
	hex4 := hex2(hi(w)) + hex2(lo(w));
end;


function min(a,b: integer): integer;
begin
	if a<b then min := a else min := b;
end;

function max(a,b: integer): integer;
begin
	if a>b then max := a else max := b;
end;


procedure dump_16(d: pointer; nbyt: word);
type
	b16 = array[0..16] of byte;
var
	o: word;
	i,j: integer;
	a: string[16];
	lp: ^b16;
begin
	lp := d; o := 0;
	for j := 1 to ((nbyt + 15) div 16) do begin
		a := ''; i := 15;
		while i >= min(nbyt - o,16) do begin
			write('   '); a := '.' + a;
			i := i - 1;
		end;
		while i >= 0 do begin
			write(hex2(lp^[i]),' ');
			if (ord(lp^[i]) >= 32) and (ord(lp^[i]) < 127) then
				a := chr(lp^[i]) + a
			else
				a := '.' + a;
			i := i - 1;
		end;
		writeln('<- ',hex4(o),' -> ',a);
		lp := addr(lp^[16]); o := o + 16;
	end;
end;


procedure nop;
begin
end;


procedure fehler(s: string);
begin
	writeln('FEHLER: ',s);
	runerror(99);		{ error# apparently unused by PASCAL }
end;


type
	userexblkptr = ^userexblk;
	userexblk = record
		next: userexblkptr;
		proc: procedure;
	end;
var
	exblkp: userexblkptr;
	oldexitproc: pointer;

procedure myexit; far;		{ "exitproc" handler }
var
	prc: procedure;
	uep: userexblkptr;
begin
	{ Note: system zeroes system.exitproc prior to calling us }
	if exblkp <> nil then begin
		uep := exblkp;
		prc := uep^.proc;
		exblkp := uep^.next;
		system.exitproc := addr(myexit);	{ re-establish }
		dispose(uep);
		prc;
	end else 
		system.exitproc := oldexitproc;		{ establish previous }
end;

{ cancel latest 'userex' entry if present }
procedure cancel_userex(pf: t_procedure_noarg_far);
var
	uep1,uep2: userexblkptr;
begin
	uep2 := nil;
	uep1 := exblkp;
	while uep1 <> nil do begin
		if @uep1^.proc = @pf then begin
			if uep2 = nil then begin
				exblkp := uep1^.next;
			end else begin
				uep2^.next := uep1^.next;
			end;
			dispose(uep1);
			exit;
		end;
		uep2 := uep1;
		uep1 := uep1^.next;
	end;
end;

procedure userex(pf: t_procedure_noarg_far);
var
	uep: userexblkptr;
begin
	new(uep);
	uep^.proc := pf;
	uep^.next := exblkp;
	exblkp := uep;
end;


begin	{ initialization }

	{ userex() & friends }
	exblkp := nil;
	oldexitproc := system.exitproc;
	system.exitproc := addr(myexit);
end.
