 #if !defined(ND_USER_H)  #define ND_USER_H    /*  * "NDFP" client interface  *  * w.j.m. dec 1996 ff.  */   P /**************	data types ****************************************************/   #include "nd_types.h"     , /*** 32 bit date/time used with DOS files */   typedef struct { 	unsigned s05: 5;  	unsigned m: 6;  	unsigned h: 5;  	unsigned dd: 5; 	unsigned mm: 4; 	unsigned yy1980: 7; } ND_FTIME;     K /*** NDFP attribute structure ("NAB") used with nd_open2() & nd_close2() */    typedef struct nd_attributes {) 	int version;		/* == ND_ATTRIB_VERSION */  	union { 		uint32 l; 9 		ND_FTIME ftime;	/* DOS-style 32-bit *file* date/time */ 
 		struct { 			uchar s;  			uchar t;  			uint16 c;3 		} dskgeom;	/* VMS-style 32-bit *disk* geometry */ 
 	} packed;; 	uint16 fattr;		/* DOS *file* attribute bitmask (NDAM_*) */ 0 	uint16 fsize_low;	/* low 9 bits of file size */> 	uint32 size_blk;	/* hi 31 bits of file/disk size (#blocks) */> 	char path[256];		/* .ASCIZ; out: truename, in: RENAME spec */ } ND_ATTRIB; #define ND_ATTRIB_VERSION (-1)  G /* structure initializer (use "cc_nd_attrib" just like "cc$rms_fab") */ + #define cc_nd_attrib (*ndfp_cc_nd_attrib())   . /* helper function for preceding macro ONLY */0 extern const ND_ATTRIB *ndfp_cc_nd_attrib(void);    P /**************	public NDFP entry points **************************************/  1 extern int nd_init(void);	/* = fake SS$ status */   / /* pre-V5 nd_open() entry, obsolete as of V4 */ - extern int nd_open1(		/* = fake SS$ status */  	const char *path,	/* .ASCIZ */ % 	uint16 mode,		/* bitmask (NDOM_*) */ @ 	uint16 fattr,		/* only with NDOM_FATTR: DOS bitmask (NDAM_*) */? 	uint32 ftime,		/* only with NDOM_FTIME: DOS packed datetime */ ; 	uint16 *p_handle,	/* to be used for subsequent accesses */ $ 	uint16 *p_fattr,	/* (maybe NULL) */$ 	uint32 *p_ftime,	/* (maybe NULL) */% 	uint32 *p_fsize);	/* (maybe NULL) */    /* V5+ nd_open() (V4+) */ 2 #define nd_open(_P,_M,_H,_N) nd_open2(_P,_M,_H,_N)- extern int nd_open2(		/* = fake SS$ status */  	const char *path,	/* asciz */% 	uint16 mode,		/* bitmask (NDOM_*) */ ; 	uint16 *p_handle,	/* to be used for subsequent accesses */ ? 	ND_ATTRIB *p_nab);	/* optional: attributes & truename [out] */   , extern int nd_read(		/* = fake SS$ status */ 	uint16 handle, ! 	uint32 count,		/* buffer size */  	uchar *buf,		/* data buffer */ + 	uint16 *p_count);	/* #bytes transferred */   - extern int nd_write(		/* = fake SS$ status */  	uint16 handle, * 	uint32 count,		/* #bytes to be written */$ 	const uchar *buf,	/* data buffer */+ 	uint16 *p_count);	/* #bytes transferred */   4 /* 32-bit format, sufficient for (2 GB) DOS files */> extern int nd_seek(		/* = fake SS$ status; no I/O done here */ 	uint16 handle, . 	uint32 offset);		/* value not checked here */  / /* 41-bit format, for disks up to 1 TB (V5+) */ ? extern int nd_seek2(		/* = fake SS$ status; no I/O done here */  	uint16 handle, / 	uint32 offset_block,	/* "block" (512 bytes) */ 6 	uint16 offset_byte);	/* byte within block (0..511) */  - extern int nd_trunc(		/* = fake SS$ status */  	uint16 handle);  " /* V5+ default nd_close() (V5+) */3 #define nd_close(_H) nd_close2(_H,0,(ND_ATTRIB *)0)   0 /* pre-V5 nd_close() entry, obsolete as of V4 */. extern int nd_close1(		/* = fake SS$ status */ 	uint16 handle, 1 	uint16 mode);		/* bit mask (NDCM_DELETE only) */   " /* extended functionality (V4+) */. extern int nd_close2(		/* = fake SS$ status */ 	uint16 handle, & 	uint16 mode,		/* bit mask (NDCM_*) */D 	ND_ATTRIB *p_nab);	/* optional: path[in/out],fattr[in],ftime[in] */  , extern int nd_time(		/* = fake SS$ status */& 	uint16 mode,		/* bit mask (NDTM_*) */> 	uint32 q_in[2],		/* 64 bit input (required with mode != 0) */= 	uint32 q_out[2]);	/* 64 bit output (10^-7 sec since 1980) */     P /************** NDFP constants ************************************************/   /*** nd_open() "mode" bits */    #define NDOM_READ	1  #define NDOM_WRITE	2 /* 	M_READ	M_WRITE	operation  *	-------------------------$  *	0	0	open for meta-operations only8  *	set	0	open with read-only access (NO meta-operations)&  *	0	set	create with read/write access&  *	set	set	open with read/write access  */   = #define NDOM_FATTR	4	/* obsolete as of V4, nd_open1() only */ = #define NDOM_FTIME	8	/* obsolete as of V4, nd_open1() only */   . #define NDOM_DISK	32	/* physical disk drive */1 #define NDOM_DRV	64	/* logical drive, "A".."Z" */ 2 #define NDOM_DIR	128	/* (pseudo) directory file */N /* none of the preceding bits set -> access by FILE name (maybe DOS device) */     /*** nd_close() "mode" bits */   #define NDCM_DELETE 1  #define NDCM_RENAME 2  #define NDCM_FATTR 4 #define NDCM_FTIME 8  * /*** "fattr" bits (DOS file attributes) */   #define NDAM_RONLY	1 #define NDAM_HIDDEN	2  #define NDAM_SYSFILE	4 #define NDAM_VOLUMEID	8  #define NDAM_DIRECTORY	16  #define NDAM_ARCHIVE	32      /*** nd_time() "mode" bits */   B #define NDTM_ADD 1	/* add rq_time_q to 64 bit pseudo "DOS time" */B #define NDTM_SET 2	/* set 64 bit (1980-based) pseudo "DOS time" */    @ /*** NDFP return codes (actually VMS SS$_* and SHR$_* values) */   /* severity = S */E #define NDSS_OK		0x0001  /* S-NORMAL, normal successful completion */    /* severity = W */7 #define NDSS_EOF	0x0870  /* W-ENDOFFILE, end of file */ F #define NDSS_NOTDEL	0x2338  /* W-NODELETE, object cannot be deleted */   /* severity = E */F #define NDSS_NOTREN	0x02D2  /* E-OPINCOMPL, operation is incomplete */   /* severity = F */B #define NDSS_IVPARAM	0x0014  /* F-BADPARAM, bad parameter value */M #define NDSS_IVHANDLE	0x00AC  /* F-FILNOTACC, file not accessed on channel */ @ #define NDSS_NODRIVE	0x01C4  /* F-NONEXDRV, nonexistent drive */< #define NDSS_RONLY	0x025C  /* F-WRITLCK, write lock error */L #define NDSS_IVOFFSET	0x02DC  /* F-ILLSEQOP, illegal sequential operation */F #define NDSS_IVDATALEN	0x034C  /* F-IVBUFLEN, invalid buffer length */O #define NDSS_IVMODE	0x0354  /* F-IVMODE, invalid mode for requested function */ F #define NDSS_NOACCESS	0x0804  /* F-ACCONFLICT, file access conflict */= #define NDSS_IVNAK	0x0834  /* F-CANCEL, operation canceled */ 9 #define NDSS_FNF	0x0914  /* F-NOSUCHFILE, no such file */ Q #define NDSS_UNSUP	0x0E4C  /* F-UNSUPPORTED, unsupported operation or function */ G #define NDSS_OPENERR	0x109C  /* F-OPENIN, error opening !AS as input */ J #define NDSS_CREATERR	0x10A4  /* F-OPENOUT, error opening !AS as output */? #define NDSS_READERR	0x10B4  /* F-READERR, error reading !AS */ @ #define NDSS_WRITERR	0x10D4  /* F-WRITEERR, error writing !AS */C #define NDSS_DOSFAIL	0x11B4  /* F-SYSERROR, system service error */ F #define NDSS_IVPATH	0x133C  /* F-FILNOTACC, file not accessible !AS */E #define NDSS_IVPROTO	0x2074  /* F-PROTOCOL, network protocol error */ ] #define NDSS_NOROOM	0x232C  /* F-TOOMUCHCTX, too many concurrent context streams requested */     P /**************	miscellaneous *************************************************/  $ /*** NDFP "directory file" record */  E #define NDIR_NAME_MAX (8+1+3)	/* not really an architectural limit */   ( typedef struct {	/* of varying length */* 	short rlen;			/* offset to next record */ 	uint16 struclev;		/* == 1 */ % 	uint32 ftime;			/* file date/time */   	uint32 fsize;			/* file size */& 	uint16 fattr;			/* file attributes */0 	short nlen;			/* length of file/dir/vol name */? 	char name[NDIR_NAME_MAX];	/* file/dir/vol name (not .ASCIZ) */ * 	/* actually, this is `char name[nlen]' */ } NDIR_RECORD;   #endif	/* ND_USER_H */