; /* "NDFP" routines for ethernet access & multi-process sync *  * non reentrant; multi-buffered interface  *  * w.j.m. jan 19977  * wjm 02-mar-1997: multi-proc interface (needs SYSLCK) K  * wjm 03-apr-1997: slightly improve exit handling; NDFP_ETH_DEVICE logname H  * wjm 12-apr-1997: DEVREQERR (on write) isn't fatal; lib$stop(oiosb[0])J  * wjm 04-may-1997: allow for change of physical address (so starting NDFP$  *		    prior to DECnet should work)  *  * BUGS:D  *	- Holding a system wide lock in user mode isn't too good an idea,D  *	  because of possible ^Y interrupts and other ways of delaying or  *	  SUSPENDing the process.9  *	- Not sure that exit handling _always_ works out o.k., A  *	  or that bypassing the exit handler (via STOP) won't possibly +  *	  disturb "concurrent" client processes.   */    #include <stdio.h> #include <stdlib.h>  #include <string.h>  #include <assert.h>    #include <descrip.h>& typedef struct dsc$descriptor_s DESCR;   #include <iodef.h> #include <ssdef.h>  ! #include "nmadef.h"	/* my own! */    #include "ndfp_proto.h"    #define extern #include "ndfp_ethuser.h" 
 #undef extern    extern void lib$stop(); 8 extern int lib$get_ef(),lib$free_ef(),lib$ast_in_prog(), 	   lib$getsyi(),lib$getdvi();: extern int sys$assign(),sys$qio(),sys$qiow(),sys$dassgn(),& 	   sys$enqw(),sys$deq(),sys$dclast(),) 	   sys$readef(),sys$wflor(),sys$setef(),  	   sys$setimr(),sys$cantim();   /* endian-ness conversion */ #define STORE16(p,w) do {\@ 	uchar *_p = (uchar *)&w; *p++ = _p[1]; *p++ = _p[0]; } while(0)    & static int/*logical*/ initialized = 0; static char landev[31+1]; ' static DESCR landsc = {0-0,0,0,landev}; 3 static int nullefn;		/* module-global event flag */ 2 static uint16 clno;		/* global client# (1..255) */ static volatile uint16 echan;     < /* per-transaction("active") and per-request("busy") data */ static struct trans { 0 	uchar/*logical*/ active;		/* set by _begin() */5 	uchar/*logical*/ busy;			/* set during _request() */ + 	LANADDR la_remote;			/* set by _begin() */  	int efn_i,efn_t;		/* temp */ % 	int ocnt;				/* set by _request() */ 1 	int/*logical*/ idelay;			/* set by _request() */ : 	NDFP_PKTDSC op[NDFP_MAX_FRAG],ip;	/* set by _request() */ } trans;    static uint16 iiosb[4],oiosb[4]; static struct {  	LANADDR dst,src; 
 	uint16 prot;  } ihdr;   G static const int itimeout[2] = {-2100000,-1};	/* 0.21 sec delta time */ G static const int rtimeout[2] = {-21000000,-1};	/* 2.1 sec delta time */      /*****/    /* read from LAN */ * static void start_input(struct trans *t) {	 	int sts;   + 	sts = sys$qio(t->efn_i,echan,IO$_READVBLK,  		      iiosb,NULL,0, / 		      t->ip.pp,sizeof(NDFP_PKT),0,0,&ihdr,0);  	if(!(sts & 1)) lib$stop(sts); }   / /* check for valid input, else restart input */ " /* "efn_i" assumed set on entry */3 static int/*logical*/ test_input(struct trans *t) {    	/* check status */  	if(!(iiosb[0] & 1)) {  		/* ignore transient failure */+ 		if(iiosb[0] == SS$_OPINCOMPL) goto again;  		lib$stop(iiosb[0]);  	}   	/* packet from server? */@ 	if(memcmp(&ihdr.src,&t->la_remote,sizeof(LANADDR))) goto again;   	/* o.k. */  	t->ip.len = iiosb[1];
 	return 1;   	/* re-start input */  again: 	start_input(t);
 	return 0; }    /*****/   = /* send output packet(s) zero or once, repeating the last one   * until a reply is received */ + static void send_receive(struct trans *t) { 	 	int sts;  	int i,lowi = 0; 	int/*logical*/ timeract = 0;  	uint32 efc;   	sts = lib$get_ef(&t->efn_t);  	if(!(sts & 1)) lib$stop(sts); 	sts = lib$get_ef(&t->efn_i);  	if(!(sts & 1)) lib$stop(sts);  E 	assert((t->efn_i / 32) == (t->efn_t / 32));	/* same cluster req'd */    	start_input(t);   	if(t->idelay) { 		/* initial delay */ / 		sts = sys$setimr(t->efn_t,itimeout,NULL,t,0);  		if(!(sts & 1)) lib$stop(sts);  		timeract = 1; 	 	} else {  		/* continue w/o waiting */ 		sts = sys$setef(t->efn_t); 		if(!(sts & 1)) lib$stop(sts);  	}   	do {  		/* wait for input or timer */ 4 		sts = sys$wflor(t->efn_i,(1U << (t->efn_i % 32)) | 					 (1U << (t->efn_t % 32)));  		if(!(sts & 1)) lib$stop(sts);   " 		sts = sys$readef(t->efn_i,&efc); 		if(!(sts & 1)) lib$stop(sts);   4 		if((efc >> (t->efn_i % 32)) & 1) {	/* efn_i set */ 			if(test_input(t)) break; # 			else continue;	/* ... waiting */  		}    		/* timer expired */ ' 		assert((efc >> (t->efn_t % 32)) & 1);  		timeract = 0;    		/* output */# 		for(i = lowi; i < t->ocnt; i++) { . 			sts = sys$qiow(nullefn,echan,IO$_WRITEVBLK, 			      		oiosb,NULL,0,( 			      		t->op[i].pp,t->op[i].len,0,0, 					&t->la_remote,0);  			if(!(sts & 1)) lib$stop(sts); 			if((oiosb[0] & 1) == 0 &&	 # 				/* ignore transient failures */ # 			    oiosb[0] != SS$_DEVREQERR && 5 			    oiosb[0] != SS$_OPINCOMPL) lib$stop(oiosb[0]);  		} 3 		lowi = t->ocnt - 1;	/* only repeat last packet */    		/* set timer */ / 		sts = sys$setimr(t->efn_t,rtimeout,NULL,t,0);  		if(!(sts & 1)) lib$stop(sts);  		timeract = 1;  	} while(1);   	if(timeract) {  		sts = sys$cantim(t,0); 		timeract = 0;  	} 	sts = lib$free_ef(&t->efn_i); 	if(!(sts & 1)) lib$stop(sts); 	sts = lib$free_ef(&t->efn_t); 	if(!(sts & 1)) lib$stop(sts); }   P /******************************************************************************/   #include <lckdef.h>  #include <dvidef.h>  #include <syidef.h>   ) typedef struct s_valblk {		/* 16 bytes */ 7 	uint16 cseq;		/* current seq# (never dequeued as 0) */ % 	uint16 s_vers;		/* (not used yet) */  	uint16 pad[5]; ' 	uint16 c_vers;		/* check field, = 3 */  } S_VALBLK;    typedef struct s_lksb {  	uint16 status;  	uint16 reserved; 
 	uint32 lkid;  	S_VALBLK v;	 } S_LKSB;    typedef struct lksb {  	uint16 status;  	uint16 reserved; 
 	uint32 lkid;  } LKSB;    typedef struct esctx { 	struct esctx *next; 	S_LKSB s_lksb;  	int/*logical*/ inuse; 	int/*logical*/ blocking;  	LANADDR lanaddr;  } ESCTX;   /* master lock */ I /* NOTE: for LAN drivers, ALLDEVNAM & friends don't have the node name */ 9 #define m_lkres_fmt "NDFP_%s%s"			/* (nodename,devnam) */ $ #define m_lkres_MAXLEN (5 + 15 + 64)( static char m_lkres[m_lkres_MAXLEN + 1];- static DESCR m_lkres_dsc = {0-0,0,0,m_lkres};  static LKSB m_lksb;    /* client# sub-lock */ #define c_lkres_fmt "C_%02X" #define c_lkres_LEN (2 + 2) % static char c_lkres[c_lkres_LEN + 1]; 5 static DESCR c_lkres_dsc = {c_lkres_LEN,0,0,c_lkres};  static LKSB c_lksb;    /* server-specific sub-lock */0 #define s_lkres_fmt "S_%02X%02X%02X%02X%02X%02X" #define s_lkres_LEN (2 + 6*2)      /* per-connection data */   static ESCTX *esctx_list = NULL;& static volatile ESCTX *cur_esx = NULL;     /*****/    static void start_lan(void) {  	uint16 iosb[4],w;	 	int sts; 
 	char *mp; 	static char modebuf[250];# 	DESCR modedsc = {0-0,0,0,modebuf};      	mp = modebuf;   	/* defaults used: fmt=eth */   3 	*((uint16 *)mp)++ = NMA$C_PCLI_PTY;	/* protocol */ + 	w = NDFP_PTY; 					/* little-endian ... */ + 	STORE16(mp,w);					/* ... converted ... */ " 	*((uint16 *)mp)++ = 0;		/* pad */   /* start shared access */ F /* NOTE: "shared default user" would have NMA$C_ACC_SHR and no _DES */  1 	*((uint16 *)mp)++ = NMA$C_PCLI_ACC;	/* access */ C 	*((uint32 *)mp)++ = NMA$C_ACC_LIM;	/* "shared with destination" */   D 	*((uint16 *)mp)++ = NMA$C_PCLI_DES;	/* the destination being ... */D 	*((uint16 *)mp)++ = sizeof(uint16) + sizeof(LANADDR);	/* "m.b.8" */% 	*((uint16 *)mp)++ = NMA$C_LINMC_SET; 6 	*((LANADDR *)mp)++ = cur_esx->lanaddr;	/* ... here */   /* end shared access */   6 	*((uint16 *)mp)++ = NMA$C_PCLI_BUS;	/* buffer size */& 	*((uint32 *)mp)++ = sizeof(NDFP_PKT);  < 	*((uint16 *)mp)++ = NMA$C_PCLI_BFN;	/* # receive buffers */6 	*((uint32 *)mp)++ = NDFP_MAX_FRAG;		/* default = 1 */  8 	*((uint16 *)mp)++ = NMA$C_PCLI_PAD;	/* "padding" off */% 	*((uint32 *)mp)++ = NMA$C_STATE_OFF;   9 	*((uint16 *)mp)++ = NMA$C_PCLI_RES;	/* enable restart */ & 	*((uint32 *)mp)++ = NMA$C_LINRES_ENA;  B 	*((uint16 *)mp)++ = NMA$C_PCLI_CCA;	/* "can change address" on */$ 	*((uint32 *)mp)++ = NMA$C_STATE_ON;  % 	modedsc.dsc$w_length = mp - modebuf;   E 	sts = sys$qiow(nullefn,echan,IO$_SETMODE | IO$M_CTRL | IO$M_STARTUP,  		       iosb,NULL,0,  		       0,&modedsc,0,0,0,0);  	if(!(sts & 1)) lib$stop(sts);& 	if(!(iosb[0] & 1)) lib$stop(iosb[0]); }    /*****/    static void blkast(void) {	 	int sts;   ' 	if(!echan) return;		/* not blocking */    	assert(cur_esx);  	if(cur_esx->inuse) {  		cur_esx->blocking = 1; 		return;			/* delay */  	}   	sts = sys$dassgn(echan);  	if(!(sts & 1)) lib$stop(sts); 	echan = 0;    	cur_esx->blocking = 0;   8 	sts = sys$enqw(nullefn,LCK$K_NLMODE,&(cur_esx->s_lksb),0 			LCK$M_CONVERT | LCK$M_VALBLK | LCK$M_SYNCSTS,
 			NULL,0, 			NULL,0,NULL,0,0); 	if(!(sts & 1)) lib$stop(sts); 	sts = cur_esx->s_lksb.status; 	if(!(sts & 1)) lib$stop(sts); }    static void call_blkast(void) { 	 	int sts;    	if(lib$ast_in_prog() & 1) { 		blkast(); 	 	} else {  		sts = sys$dclast(blkast,0,0);  		if(!(sts & 1)) lib$stop(sts);  	} }     % static void esctx_begin(ESCTX *esx) { 	 	int sts;    	if(cur_esx) { 		assert(!cur_esx->inuse); 		if(cur_esx != esx) { 			call_blkast();  			assert(!cur_esx->blocking); 		}  	}   	if(cur_esx != esx) {  		assert(echan == 0);  		cur_esx = esx; 	}   	assert(!cur_esx->inuse);  		 	cur_esx->inuse = 1;   	if(echan == 0) { ' 		sts = sys$assign(&landsc,&echan,0,0);  		if(!(sts & 1)) lib$stop(sts);   9 		sts = sys$enqw(nullefn,LCK$K_PWMODE,&(cur_esx->s_lksb), 2 			LCK$M_CONVERT | LCK$M_VALBLK | LCK$M_NODLCKBLK,
 			NULL,0, 			NULL,0,blkast,0,0); 		if(!(sts & 1)) lib$stop(sts);  		sts = cur_esx->s_lksb.status;  		if(sts == SS$_VALNOTVALID) { 			/* initalize valblk */ - 			cur_esx->s_lksb.v.cseq = 0;	/* lazy ??? */   			cur_esx->s_lksb.v.s_vers = 0;  			cur_esx->s_lksb.v.pad[0] = 0;  			cur_esx->s_lksb.v.pad[1] = 0;  			cur_esx->s_lksb.v.pad[2] = 0;  			cur_esx->s_lksb.v.pad[3] = 0;  			cur_esx->s_lksb.v.pad[4] = 0;  			cur_esx->s_lksb.v.c_vers = 3;& 		} else if(!(sts & 1)) lib$stop(sts);) 		assert(cur_esx->s_lksb.v.c_vers == 3 || 7 		       (cur_esx->s_lksb.v.cseq == 0 &&		/* all new */ # 			cur_esx->s_lksb.v.s_vers == 0 && # 			cur_esx->s_lksb.v.pad[0] == 0 && # 			cur_esx->s_lksb.v.pad[1] == 0 && # 			cur_esx->s_lksb.v.pad[2] == 0 && # 			cur_esx->s_lksb.v.pad[3] == 0 && # 			cur_esx->s_lksb.v.pad[4] == 0 && # 			cur_esx->s_lksb.v.c_vers == 0));  		cur_esx->s_lksb.v.c_vers = 3;    		start_lan(); 	} }   ) #define cur_cseq (cur_esx->s_lksb.v.cseq)    static void esctx_end(void) {    	assert(cur_esx->inuse);  ) 	/* advance seq#, always make non-zero */  	cur_cseq++; 	if(cur_cseq == 0) cur_cseq++;   	cur_esx->inuse = 0;% 	if(cur_esx->blocking) call_blkast();  }      /*****/   0 static ESCTX *find_usctx(NDETH_USER_SCTX *usx) { 	ESCTX *esx;   	/* shortcut */ ; 	if((ESCTX *)(usx->uh) == cur_esx) return (ESCTX *)cur_esx;   
 	/* search */ . 	for(esx = esctx_list; esx; esx = esx->next) {! 		if((ESCTX *)(usx->uh) == esx && . 		   memcmp(&(usx->s_lanaddr),&(esx->lanaddr), 			  sizeof(LANADDR)) == 0) {  			return esx; 		}  	}			 
 	return NULL;  }    /*****/   @ /* establish "server context" for subsequent ndeth_request()s */( void ndeth_begin(NDETH_USER_SCTX *usx) { 	ESCTX *esx;   	assert(initialized);  	assert(!trans.busy);  	assert(!trans.active);    	esx = find_usctx(usx); 
 	assert(esx);    	esctx_begin(esx);   	usx->s_cseq = cur_cseq;    	trans.la_remote = esx->lanaddr; 	trans.active = 1; }   , void ndeth_request(int/*logical*/ initdelay, 		   unsigned int rqcnt,* 		   /*const*/ NDFP_PKTDSC rqa[/*rqcnt*/], 		   uint16 *p_rplen,  		   NDFP_PKT *rp) { 	int i;    	assert(initialized);  	assert(trans.active); 	assert(!trans.busy);    	trans.busy = 1;  1 	if(rqcnt > NDFP_MAX_FRAG) rqcnt = NDFP_MAX_FRAG; . 	trans.ocnt = rqcnt;		/* # output buffer(s) */1 	for(i = 0; i < rqcnt; i++) trans.op[i] = rqa[i];   & 	trans.ip.pp = rp;		/* input buffer */ 	trans.idelay = initdelay;   	send_receive(&trans);   	*p_rplen = trans.ip.len;    	trans.busy = 0; 	trans.ocnt = 0; 	trans.ip.pp = NULL; }      /* release "server context" */ void ndeth_end(void) {   	assert(initialized);  	assert(!trans.busy);  	assert(trans.active);  
 	esctx_end();    	trans.active = 0; }      /*****/     static void (*client_exh)(void);   /* exit handler */ static void eth_exith(void) {    	/* release LAN context */ 	if(cur_esx) {@ 		/* advance seq# (maybe an extra time), always make non-zero */
 		cur_cseq++;  		if(cur_cseq == 0) cur_cseq++;    		cur_esx->inuse = 0;  		call_blkast(); 	} 	cur_esx = NULL;  6 	/* forget about current client transaction, if any */ 	trans.busy = 0; 	trans.active = 0;  $ 	/* now let client do its cleanup */ 	if(client_exh) { " 		void (*cexh)(void) = client_exh;  1 		atexit(eth_exith);	/* re-establish ourselves */ % 		client_exh = NULL;	/* avoid loop */  		(*cexh)(); 	} }      /* server-specific init */. void ndeth_init_server(NDETH_USER_SCTX *usx) { 	ESCTX *esx;	 	int sts; & 	static char s_lkres[s_lkres_LEN + 1];/ 	DESCR s_lkres_dsc = {s_lkres_LEN,0,0,s_lkres};    	assert(initialized);    	esx = find_usctx(usx);  	if(!esx) {  		esx = malloc(sizeof(ESCTX)); 		if(!esx) { 			perror("malloc(ESCTX)");  			abort();  		}   		esx->lanaddr = usx->s_lanaddr; 		esx->inuse = 0;  		esx->blocking = 0;  $ 		{ uchar *p = &(esx->lanaddr.b[0]);? 		  sprintf(s_lkres,s_lkres_fmt,p[0],p[1],p[2],p[3],p[4],p[5]);  		} 5 		sts = sys$enqw(nullefn,LCK$K_NLMODE,&(esx->s_lksb),   			LCK$M_SYSTEM | LCK$M_SYNCSTS, 			&s_lkres_dsc,m_lksb.lkid, 			NULL,0,NULL,0,0); 		if(!(sts & 1)) lib$stop(sts);  		sts = esx->s_lksb.status;  		if(!(sts & 1)) lib$stop(sts);    		esx->next = esctx_list; $ 		if(!esctx_list) atexit(eth_exith); 		esctx_list = esx;  	} 	 ( 	assert(sizeof(int) == sizeof(ESCTX *)); 	usx->uh = (void *)esx;  }     $ /* register client's exit handler */$ void ndeth_atexit(void (*f)(void)) {   	assert(initialized);    	client_exh = f; }      /* global init */ ( void ndeth_init_client(uint16 *p_clno) {	 	int sts; G 	unsigned int syi__nodename = SYI$_NODENAME, dvi__devnam = DVI$_DEVNAM; ( 	static char syibuf[15+1], dvibuf[64+1];: 	DESCR syidsc = {15,0,0,syibuf},	dvidsc = {64,0,0,dvibuf}; 	const char *cp;E 	static const char *default_landev = "_ESA0";	/* often applies ... */      	assert(!initialized);  * /* reserve an event flag for global use */ 	sts = lib$get_ef(&nullefn); 	if(!(sts & 1)) lib$stop(sts);  G /* no esctx block yet (=> no exit handler), no active lan connection */  	esctx_list = NULL;  	echan = 0;    /* find LAN interface name */   	cp = getenv("NDFP_ETH_DEVICE");= 	if(!cp || strlen(cp) >= sizeof(landev)) cp = default_landev;  	strcpy(landev,cp); & 	landsc.dsc$w_length = strlen(landev);  / /* get master lock (for "our" LAN interface) */ ! 	sts = lib$getsyi(&syi__nodename, 1 			 NULL,&syidsc,&syidsc.dsc$w_length,NULL,NULL);  	if(!(sts & 1)) lib$stop(sts);  , 	sts = lib$getdvi(&dvi__devnam,NULL,&landsc,' 			 NULL,&dvidsc,&dvidsc.dsc$w_length);  	if(!(sts & 1)) lib$stop(sts);  $ 	syibuf[syidsc.dsc$w_length] = '\0';$ 	dvibuf[dvidsc.dsc$w_length] = '\0';, 	sprintf(m_lkres,m_lkres_fmt,syibuf,dvibuf);, 	m_lkres_dsc.dsc$w_length = strlen(m_lkres);  - 	sts = sys$enqw(nullefn,LCK$K_CRMODE,&m_lksb,   			LCK$M_SYSTEM | LCK$M_SYNCSTS, 			&m_lkres_dsc,0, 			NULL,0,NULL,0,0); 	if(!(sts & 1)) lib$stop(sts); 	sts = m_lksb.status;  	if(!(sts & 1)) lib$stop(sts);  ; /* establish "client number" (try sub-locks in sequence) */ & 	for(clno = 1; clno <= 0xFF; clno++) {$ 		sprintf(c_lkres,c_lkres_fmt,clno);. 		sts = sys$enqw(nullefn,LCK$K_EXMODE,&c_lksb,0 			LCK$M_SYSTEM | LCK$M_NOQUEUE | LCK$M_SYNCSTS, 			&c_lkres_dsc,m_lksb.lkid, 			NULL,0,NULL,0,0);$ 		if(sts == SS$_NOTQUEUED) continue; 		if(!(sts & 1)) lib$stop(sts);  		sts = c_lksb.status; 		if(!(sts & 1)) lib$stop(sts);  		goto clno_ok;  	}) 	assert(clno < 255);	/* which is FALSE */ 2 	abort();	/* in case assert() has been disabled */ clno_ok:  
 /* done */ 	initialized = 1;  	*p_clno = clno; } 