 #if !defined(NDFP_PROTO_H) #define NDFP_PROTO_H   #if !defined(ND_TYPES_H) #include "nd_types.h"  #endif  B #define NDFP_PTY 0x6006		/* ethernet protocol type (big-endian) */( 				/* == "reserved to DEC customers" */  # #define NDFP_VERSION1 10	/* V1.0 */ G #define NDFP_VERSION2 20	/* V2, window size (1..NDFP_MAX_FRAG) added */ 6 #define NDFP_VERSION3 30	/* V3, using large packets */< #define NDFP_VERSION4 40	/* V4, new close() functionality */8 #define NDFP_VERSION5 50	/* V5, 40-bit offset & fsize */  & #define NDFP_DATA_MAX1 1024	/* V1.0 */$ #define NDFP_DATA_MAX2 1024	/* V2 */H #define NDFP_DATA_MAX3 1472	/* V3 (1472 = 23*512/8; header size = 28) */, #define NDFP_DATA_MAX4 1472	/* same as V3 */, #define NDFP_DATA_MAX5 1472	/* same as V3 */$ #define NDFP_DATA_MAX NDFP_DATA_MAX3   #define NDFP_MAX_FRAG 8    typedef struct ndfp_packet {& 	uint16 cseq;		/* command sequence# */3 	uchar ifrag;		/* fragment index - 1, or bitmask */ $ 	uchar nfrag;		/* # fragments - 1 */% 	uint16 chandle;		/* client handle */ % 	uint16 shandle;		/* server handle */ ' 	uint16 op;		/* opcode (NDFP_OP_***) */ ' 	uint16 ndata;		/* # bytes in "data" */ . 	uint16 argw[4];		/* 'word' size parameters */1 	uint32 argl[2];		/* 'longint' size parameters */ : 	uchar data[NDFP_DATA_MAX];	/* maximum size data buffer */ } NDFP_PKT;   E #define NDFP_PKT_MINLEN 48	/* (fixed) approx. "ethernet low limit" */      /* op codes */   #define NDFP_OP_RESET 0  #define NDFP_OP_OPEN 1 #define NDFP_OP_READ 2 #define NDFP_OP_WRITE 3  #define NDFP_OP_TRUNC 4  #define NDFP_OP_CLOSE 5  #define NDFP_OP_TIME 89 #define NDFP_OP_M_REPLY 0x100	/* set in server's reply */ E #define NDFP_OP_M_NAK 0x200	/* retransmit request, ifrag = bitmask */     7 /* mapping from function parameters to argw[]/argl[] */   = #define rp_sts		argw[0]		/* common to all replies (NDSS_*) */    #define rp_reset_vers	argw[1]    #define rq_open_mode	argw[1]6 #define rq_open_fattr	argw[2]		/* obsolete as of v4 */6 #define rq_open_ftime	argl[1]		/* obsolete as of v4 */  /*      rq_open_pathlen ndata */ /*      rq_open_path	data */   #define rp_open_fattr	argw[1] + #define rp_open_fsize	argl[0]		/* v1..v4 */ * #define rp_open_fsizeblk argl[0]	/* v5+ */* #define rp_open_fsizebyt argw[3]	/* v5+ */ #define rp_open_ftime	argl[1] * /*      rp_open_pathlen	ndata */	/* v5+ */' /*      rp_open_path	data */		/* v5+ */    #define rp_opendsk_geom	argl[1]    #define rq_read_count	argw[1] , #define rq_read_offset	argl[1]		/* v1..v4 */+ #define rq_read_offsetblk argl[1]	/* v5+ */ + #define rq_read_offsetbyt argw[3]	/* v5+ */   8 #define rp_read_count	argw[1]		/* ndata with nfrag==0 */7 #define rp_read_boff	argw[2]		/* only with nfrag > 0 */  /*      rp_read_data	data */  - #define rq_write_offset	argl[1]		/* v1..v4 */ , #define rq_write_offsetblk argl[1]	/* v5+ */, #define rq_write_offsetbyt argw[3]	/* v5+ */9 #define rq_write_count	argw[1]		/* ndata with nfrag==0 */ 8 #define rq_write_boff	argw[2]		/* only with nfrag > 0 */ /*      rq_write_data	data */    #define rp_write_count	argw[1]  - #define rq_trunc_offset	argl[1]		/* v1..v4 */ , #define rq_trunc_offsetblk argl[1]	/* v5+ */, #define rq_trunc_offsetbyt argw[3]	/* v5+ */   #define rq_close_mode	argw[1] ) #define rq_close_fattr	argw[2]		/* v4+ */ ) #define rq_close_ftime	argl[1]		/* v4+ */ 9 /*      rq_close_pathlen ndata */	/* v4+ (RENAME only) */ 1 /*	rq_close_path	data */		/* v4+ (RENAME only) */   9 /*      rp_close_pathlen ndata */	/* v5+ (RENAME only) */ 1 /*	rp_close_path	data */		/* v5+ (RENAME only) */    #define rq_time_mode	argw[1] #define rq_time_q_lo	argl[0] #define rq_time_q_hi	argl[1]   #define rp_time_q_lo	argl[0] #define rp_time_q_hi	argl[1]   #endif