8 /* ZT1 'tape' routines using a DOS disk file via NDFP V5  *0  * w.j.m. dec 1996, after ZT1D (w.j.m. feb 1994)+  * wjm 26-mar-1997: adapt to NDFP V5 open()   */   
 #ifndef TRACE  #define TRACE 1  #endif   #include <ssdef.h>   #include <stdio.h> #include <stdlib.h>  #include <string.h>  #include <errno.h>   #include "nd_user.h"   #include <descrip.h>$ typedef struct dsc$descriptor DESCR;    extern void LIB$STOP(),Fehler();D #define CHECK(x) do {unsigned s=x; if(!(s&1)) LIB$STOP(s);} while(0)= #define FEHLER(m) do {$DESCRIPTOR(d,m); Fehler(&d);} while(0)   & #define MIN(a,b) ((a < b) ? (a) : (b))  + /* data & entries used by "main" program */    extern unsigned char *bufp;  extern unsigned int *bufbctp;   J extern int /*logical*/ hw_online,hw_medonline,hw_bot,hw_eof,hw_eot,hw_hwl;  
 /* forward */ * void tape_init(char * /*disk file name*/); unsigned tape_writemark(void), 	tape_nop(void),( 	tape_rewind(int/*logical*/ /*unload*/),; 	tape_skiprec(int /*+-#blocks*/,int * /*#blocks skipped*/), * 	tape_compare(int/*logical*/ /*reverse*/),@ 	tape_read(int/*logical*/ /*reverse*/,int/*logical*/ /*check*/),& 	tape_write(int/*logical*/ /*check*/);  	 #if TRACE 9 static void trace_tape(char *,int,int,int);	/* forward */ 0 static int tpos;	/* true position (in blocks) */ #endif  2 /* 'disk tape' structure (STREAM-LF file assumed):<  *	int l0; char [l0]; int l0; int l1; char [l1]; int l1; ...'  *		l=0 stands for end of written area,   *		l=1 stands for tape mark  * "int" is to mean INTEGER*4   *E  * This is compatible with a unix [little-endian] FORTRAN BINARY file $  * (checked for ULTRIX & DEC OSF/1).  *B  * the very first "record" always contains the fixed string "ZT1 "  *%  * NOTE: I/O errors considered fatal.   * NOTE: no EOT handling (yet)!   */    #define T_MAXBLOCK 0xFFFF   , 	/* room for tape block & 2 length fields */. static unsigned char tbuf[4 + 4 + T_MAXBLOCK];I 	/* current byte offset in file (point between 'prev' & 'next' record) */  static int tp;& 	/* NDFP handle ("file descriptor") */ static unsigned short tfd; 	/* read-only flag */  static int/*logical*/ t_ro;  	/* NDFP (VMS) status */ static int/*logical*/ tns;   #define T_EOM 0  #define T_MARK 1   static const struct T_magic { 
 	int l0_1; 	char magic[4]; 
 	int l0_2;* } t_magic = { 4, {'Z', 'T', '1', ' '}, 4};   static int t_nextlen,t_prevlen;    #define T_nextlen t_nextlen  #define T_prevlen t_prevlen 6 #define T_data tbuf			/* tape block from TOP_read() */  ( #define T_prevpos (tp - (T_prevlen + 8))( #define T_nextpos (tp + (T_nextlen + 8))  % #define T_bot (tp == sizeof(t_magic)) " #define T_eom (T_nextlen == T_EOM)- #define T_eot 0				/* always false for now */    #define I4(bp) (*((int *)(bp)))   ! #define T_abort_perror(msg) do {\ 6 	fprintf(stderr,"Aborting (NDFP error) on %s\n",msg);\ 	LIB$STOP(tns);\
 } while(0)   #define T_abort() do {\ # 	fprintf(stderr,"Aborting ...\n");\ 
 	abort();\
 } while(0)   #define T_checklen(i) do {\  	if(i < 0 || i > T_MAXBLOCK) {\ . 		fprintf(stderr,"Bad block length: %d\n",i);\
 		T_abort();\  	}\ 
 } while(0)   /*****/   ? static long diskpos;		/* current file position (byte offset) */ @ static int diskeof = -1;	/* new EOF position to be set, or -1 */     static void disk_seek(int p) {  #if 1  	{' 		static void disk_write();	/*forward*/  		static int teom = T_EOM;  " 		if(diskeof > 0 && p < diskeof) {0 			disk_write(diskeof,4,(unsigned char *)&teom); #if 1 0 			/* assert "diskpos == {right after T_EOM}" */ 			tns = nd_trunc(tfd);  			if(!(tns & 1)) {  				T_abort_perror("trunc"); 			} #endif 			diskeof = -1; 		}  	} #endif
 	diskpos = p;  	tns = nd_seek(tfd,diskpos); 	if(!(tns & 1)) {  		T_abort_perror("seek");  	} }     static void disk_truncate(int p) {  #if 0  	if(p != diskpos) disk_seek(p);  #endif
 	diskeof = p;  }   6 static void disk_write(int p, int l, unsigned char *b) {  	unsigned short k; 	int ll = l; 	unsigned char *bb = b;      	if(p != diskpos) disk_seek(p);    	while(ll > 0) { 		tns = nd_write(tfd,ll,bb,&k);  		if(!(tns & 1)) { 			T_abort_perror("write");  		} 
 		ll -= k;
 		bb += k; 	} 	diskpos = diskeof = p + l;  }   N static void disk_read(int p, int l, unsigned char *b)	/* ggf. fill in T_EOM */ {  	unsigned short k; 	int ll = l; 	unsigned char *bb = b;      	if(p != diskpos) disk_seek(p);    	while(ll > 0) { 		tns = nd_read(tfd,ll,bb,&k); 		if(!(tns & 1)) { 			T_abort_perror("read"); 		}  		if(k == 0) {			/* EOF */, 			if(ll == 4) {		/* 4 bytes remain => ok */0 				*((int *)bb) = T_EOM;	/* provide sentinel */ 				diskpos = p + (l - 4); 				return;			/* success */  			} else { 4 				fprintf(stderr,"read() EOF at %d\n",p + l - ll); 				T_abort(); 			}
 		} else { 			ll -= k;  			bb += k;  		}  	}   	diskpos = p + l;  }  	  /*****/   F static void TOP_rewind()	/* permitted to occur at BOT, verify magic */ {  	if(T_bot) return;   	tp = sizeof(t_magic);' 	disk_read(0,sizeof(t_magic) + 4,tbuf); ( 	T_nextlen = I4(tbuf + sizeof(t_magic)); 	T_checklen(T_nextlen); 5 	if(memcmp(&t_magic,tbuf,sizeof(t_magic))) T_abort();    	T_prevlen = T_EOM;  }   2 static void TOP_bsr()		/* must not occur at BOT */ {  	tp = T_prevpos; 	if(T_bot) { 		int oldprevlen = T_prevlen;    		TOP_rewind(); ( 		if(T_nextlen != oldprevlen) T_abort();	 	} else {  		disk_read(tp - 4,2*4,tbuf); * 		if(I4(tbuf + 4) != T_prevlen) T_abort(); 		T_nextlen = T_prevlen; 		T_prevlen = I4(tbuf);  		T_checklen(T_prevlen); 	} }   2 static void TOP_fsr()		/* must not occur at EOM */ {  	tp = T_nextpos; 	disk_read(tp - 4,2*4,tbuf);% 	if(I4(tbuf) != T_nextlen) T_abort();  	T_prevlen = T_nextlen;  	T_nextlen = I4(tbuf + 4); 	T_checklen(T_nextlen);  }   3 static void TOP_read()		/* must not occur at EOM */  { ( 	disk_read(tp + 4,T_nextlen + 2*4,tbuf);  	tp = T_nextpos; 1 	if(I4(tbuf + T_nextlen) != T_nextlen) T_abort();  	T_prevlen = T_nextlen; & 	T_nextlen = I4(tbuf + T_nextlen + 4); 	T_checklen(T_nextlen);  }   L static void TOP_write(int l, unsigned char *b)	/* also used for writemark */ {  	T_checklen(l);    	if(!T_eom) disk_truncate(tp);   	T_nextlen = l; . 	disk_write(tp,4,(unsigned char *)&T_nextlen);  	disk_write(tp + 4,T_nextlen,b);> 	disk_write(tp + 4 + T_nextlen,4,(unsigned char *)&T_nextlen); 	tp = T_nextpos;   	T_prevlen = l;  	T_nextlen = T_EOM;  }  		 /*****/    void tape_init(char *fn) { 
 	char *mp; 	char fnbuf[256];  	ND_ATTRIB nab = cc_nd_attrib;  
 	diskpos = 0;    	if(!fn) fn = "ZT_DISK.TAP";   	nd_init();   - 	fprintf(stderr,"Going to open %s ...\n",fn); 4 	tns = nd_open(fn,NDOM_READ | NDOM_WRITE,&tfd,&nab); 	if(tns & 1) { 		mp = "opened r/w"; 		t_ro = 0; 	 	} else { ( 		tns = nd_open(fn,NDOM_READ,&tfd,&nab); 		if(tns & 1) {  			mp = "opened r/o";  			t_ro = 1;
 		} else {* 			tns = nd_open(fn,NDOM_WRITE,&tfd,&nab); 			if(tns & 1) { 				mp = "created"; 
 				t_ro = 0; ! 				disk_write(0,sizeof(t_magic), # 					   (unsigned char *)&t_magic);  			} else { " 				T_abort_perror("open/create"); 			} 		}    	}' 	fprintf(stderr,"%s %s\n",nab.path,mp);    	TOP_rewind();  	 #if TRACE 
 	tpos = 0; #endif   	hw_online = 1;  	hw_medonline = 1; 	hw_hwl = t_ro;    	hw_eof = 0; 	hw_bot = T_bot; 	hw_eot = T_eot; }    /*****/    unsigned tape_writemark(void)  { 	 #if TRACE  	trace_tape("WRITEMARK",0,0,0);  #endif& 	if(!hw_online) return SS$_DEVOFFLINE;% 	if(!hw_medonline) return SS$_MEDOFL;  	if(hw_hwl) return SS$_WRITLCK;   + 	TOP_write(T_MARK,(unsigned char *)"\026"); 	 #if TRACE 	 	tpos ++;  #endif   	hw_eof = 1; 		/* ??? */ 	hw_bot = T_bot; 	hw_eot = T_eot;   	return SS$_NORMAL;  }    unsigned tape_nop(void)  { 	 #if TRACE  	trace_tape("NOP",0,0,0);  #endif& 	/* tape status does not change ... */& 	if(!hw_online) return SS$_DEVOFFLINE;% 	if(!hw_medonline) return SS$_MEDOFL;  	return SS$_NORMAL;  }   + unsigned tape_rewind(int/*logical*/ unload)  { 	 #if TRACE ! 	trace_tape("REWIND",1,unload,0);  #endif& 	if(!hw_online) return SS$_DEVOFFLINE;% 	if(!hw_medonline) return SS$_MEDOFL;   < 	/* leave (mysteriously) medium online in spite of unload */" 	/* i.e. 'unload' is ignored(!) */   	TOP_rewind();	 #if TRACE 
 	tpos = 0; #endif   	hw_eof = 0; 	hw_bot = T_bot; 	hw_eot = T_eot;   	return SS$_NORMAL;  }   & unsigned tape_skiprec(int sb,int *sap)' /* sb = (signed) # blocks to be skipped >    sap = pointer to return value: absolute # blocks skipped */) /* terminate after EOF mark, or at BOT */  {  	unsigned xstat;    	 #if TRACE  	trace_tape("SKIPREC",1,sb,0); #endif& 	if(!hw_online) return SS$_DEVOFFLINE;% 	if(!hw_medonline) return SS$_MEDOFL;   
 	*sap = 0;  ( 	xstat = SS$_NORMAL;	/* assume success, * 				this includes EOF & BOT termination */
 	if(sb > 0) {  		do { 			if(T_eom) { 				xstat = SS$_TAPEPOSLOST;
 				break; 			}" 			hw_eof = (T_nextlen == T_MARK);
 			TOP_fsr(); 	 #if TRACE  			tpos ++;  #endif
 			(*sap) ++; " 		} while(!hw_eof && (*sap < sb)); 	} else if(sb < 0) { 		do { 			if(T_bot) break; " 			hw_eof = (T_prevlen == T_MARK);
 			TOP_bsr(); 	 #if TRACE  			tpos --;  #endif
 			(*sap) ++; ( 		} while(!hw_eof && ((*sap + sb) < 0)); 	}   	hw_bot = T_bot; 	hw_eot = T_eot;   	return xstat; }   - unsigned tape_compare(int/*logical*/ reverse) # /* (buffer,bufbct) has memory data.  	compare to tape block, ) 	return length of tape block in bufbct */  {  	unsigned xstat;    	 #if TRACE # 	trace_tape("COMPARE",1,reverse,0);  #endif& 	if(!hw_online) return SS$_DEVOFFLINE;% 	if(!hw_medonline) return SS$_MEDOFL;   = 	if(reverse) return SS$_BADPARAM;	/* reverse not supported */     < 	xstat = SS$_NORMAL;	/* assume success, includes EOF read */   	if(T_eom) { 		xstat = SS$_TAPEPOSLOST;	 	} else { 
 		TOP_read(); ! 		hw_eof = (T_prevlen == T_MARK);  		if(hw_eof) { 			*bufbctp = 0;
 		} else { 			if(*bufbctp < T_prevlen || & 			   memcmp(T_data,bufp,T_prevlen)) { 				xstat = SS$_DATACHECK; 			} 			*bufbctp = T_prevlen; 		} 	 #if TRACE 
 		tpos ++; #endif 	}   	hw_bot = T_bot; 	hw_eot = T_eot;   	return xstat; }     @ unsigned tape_read(int/*logical*/ reverse, int/*logical*/ check)# /* put data into (buffer,bufbct) */ . /* 'check' (ignored) requests data checking */ { 	 #if TRACE $ 	trace_tape("READ",2,reverse,check); #endif& 	if(!hw_online) return SS$_DEVOFFLINE;% 	if(!hw_medonline) return SS$_MEDOFL;   = 	if(reverse) return SS$_BADPARAM;	/* reverse not supported */   " 	if(T_eom) return SS$_TAPEPOSLOST;   	TOP_read();  	hw_eof = (T_prevlen == T_MARK);
 	if(hw_eof) {  		*bufbctp = 0; 	 	} else {  		*bufbctp = T_prevlen;   		memcpy(bufp,T_data,T_prevlen); 	}	 #if TRACE 	 	tpos ++;  #endif   	hw_bot = T_bot; 	hw_eot = T_eot;   	return SS$_NORMAL;  }   ) unsigned tape_write(int/*logical*/ check) ' /* process data from (buffer,bufbct) */ . /* 'check' (ignored) requests data checking */ { 	 #if TRACE  	trace_tape("WRITE",1,check,0);  #endif& 	if(!hw_online) return SS$_DEVOFFLINE;% 	if(!hw_medonline) return SS$_MEDOFL;  	if(hw_hwl) return SS$_WRITLCK;    	TOP_write(*bufbctp,bufp);	 #if TRACE 	 	tpos ++;  #endif   	hw_eof = 0; 	hw_bot = T_bot; 	hw_eot = T_eot;   	return SS$_NORMAL;  }      /*****/   	 #if TRACE   8 static void trace_tape(char *fname,int ac,int a1,int a2) { $ 	fprintf(stdout,"\tTAPE_%s(",fname);
 	if(ac > 0) {  		fprintf(stdout,"%d",a1); 		if(ac > 1) { 			fprintf(stdout,",%d",a2); 		}  	}$ 	fprintf(stdout,") tpos=%d\n",tpos); }    #endif