 /*@ ntpdate - set the time of day by polling one or more NTP servers */   /* History   A 1.0     24-Jun-1994     The first translation of ntpdate for Unix @ 1.1      6-Jan-1995     The number of seconds in binary time nowA                         overflows long fixed point in ntp.  Fixed <                         by subtracting the UTC offset first.; *wjm*	05-may-1995	fix ACCVIO with "-d" and stratum-1 target   *wjm*	24-sep-1996	add CMUIP codeH *wjm*	27-sep-1996	tidy up; with option "-a" don't use the local NTP port7 			(so I can use this program on a machine running NTP) H *wjm*	02-jun-1999	fix a bug not noticed compilers earlier than DECC V5.?  */    #if !defined(CMUIP)  #define CMUIP 0  #endif   /*   /*    Includes  */  	 #if CMUIP  #else 
 #ifdef __decc  #include        <in.h> #include        <inet.h> #endif #endif   #include <descrip.h> #include <iodef.h> #include <libdef.h>  #include <libdtdef.h>  #include <ssdef.h> #include <starlet.h> #include <stdio.h> #include <stdlib.h>  #include <string.h> 	 #if CMUIP  #else  #include <ucx$inetdef.h> #endif #include "config.h"    /*
    Defines */  7 #define FALSE 0                     /* Boolean stuff */  #define TRUE 1I #define TIMEOUT_FSECS 0.2           /* Timer timeout unit in frac secs */ F #define DEFTIMEOUT 5                /* Default num of timeout units */= #define HIGH_PRI 10                 /* High priority value */ H #define MAX_ERRSTR 257              /* Max len of an error msg string */B #define MAX_TIMESTR 32              /* Max len of a time string */	 #if CMUIP  #define NET$OPEN IO$_CREATE + #define NET_K_UDP 1		    /* UDP protocol */  #define NET$GTHST IO$_SKIPFILE< #define GTH_NAMADR 1		    /* subfunction: name -> address */@ #define NET$_CCAN 0x0863808A	    /* "I/O cancelled" substatus */> #define INET_DEVNAME "_IP0:"        /* Internet device name */ #else > #define INET_DEVNAME "_BG0:"        /* Internet device name */ #endif #define NTP_SHIFT 8 E #define NTP_PORT 123                /* Network port for ntp server */ = #define MIN_MAC_LEN (sizeof(u_long) + 8)            /* DES */ = #define MAX_MAC_LEN (sizeof(u_long) + 16)           /* MD5 */ = #define NTP_VERSION 3               /* Default ntp version */ 5 #define MODE_CLIENT 3               /* Client mode */ 5 #define MODE_SERVER 4               /* Server mode */ 9 #define NTP_MAXSTRATUM 15           /* Largest stratum */ J #define UTCBASE "01-JAN-1900 00:00:00.00"    /* UTC starts on this date */E #define SANE_TIME "01-JAN-1995 00:00:00.00"  /* A known, sane time */ @ #define NSPS 1000000000             /* Nanoseconds per second */L #define HNSPS 10000000              /* Hundreds of nanoseconds per second */ #define LEAP_NOTINSYNC 3E #define STRATUM_UNSPEC (NTP_MAXSTRATUM + 1) /* Stratum unspecified */ D #define STRATUM_PKT_UNSPEC 0        /* Packet stratum unspecified */? #define PKT_TO_STRATUM(s)       (((s) == STRATUM_PKT_UNSPEC) ?\ 8                                  (STRATUM_UNSPEC) : (s))= #define STRATUM_TO_PKT(s)       (((s) == (STRATUM_UNSPEC)) ?\ ;                                 (STRATUM_PKT_UNSPEC) : (s))  #define NTP_MINPOLL 4 < #define NTPDATE_PRECISION -6     /* Our claimed precision */; #define NTPDATE_DISTANCE 0x10000 /* 1 fixed-point second */ 1 #define NTPDATE_DISP 0x10000     /* Dispersion */ 3 #define NTPDATE_REFID 0          /* Reference ID */ H #define DEFSAMPLES 4             /* Default number of samples to take */7 #define HIGHBIT_MASK 0x80000000  /* Get the high bit */ F #define MASK_HIGHBIT 0x7fffffff  /* Get everything but the high bit */9 #define HR_SECS      60 * 60     /* Seconds in an hour */ : #define DAY_SECS     24 * HR_SECS   /* Seconds in a day */L #define DST_ADJ      HR_SECS     /* Secs Daylight Savings Time adjustment */L #define LTZ_ADJ      UTC_OFFSET * HR_SECS    /* Secs from UTC to local TZ */4 #define NTP_MAXSKW 100000        /* 0.01 in hnsps */4 #define NTP_MINDIST 200000       /* 0.02 in hnsps */1 #define PEER_MAXDISP 64          /* In seconds */  #define NTP_MAXCLOCK 10  #define NTP_INFIN 15 #define NTP_MAXWGT (8 * HNSPS)F #define NTP_MAXAGE 86400         /* maximum age, one day in seconds */E #define NTP_MAXLIST 5            /* Pick only the top best servers */    /*    Type Definitions  */  ; typedef unsigned char u_char;       /* Convenience types */  typedef unsigned short u_short;  typedef unsigned long u_long;    typedef struct {8    u_long qd_lo;                    /* Low-order word */L    long qd_hi;                      /* High-order word, negative is delta */=    } bintime;                       /* Quad word (64 bits) */    typedef struct {8    u_short cond;                    /* Condition code */8    u_short count;                   /* Transfer count */E    u_long dev_spec;                 /* Device-specific information */ 6    } itm_lst;                       /* An item list */   typedef struct {?    u_short len;                     /* Length of information */ 3    u_short item_code;               /* Item code */ @    char *address;                   /* Address of information */5    } itm_lst2;                      /* Item list 2 */    typedef struct {>    u_short buff_len;                /* Length of the buffer */3    u_short item_code;               /* Item code */ ?    char *buff;                      /* Pointer to the buffer */ H    u_long *ret_len;                 /* Length of returned information */5    } itm_lst3;                      /* Item list 3 */    typedef struct {A    u_short proto;                   /* Protocol (tcp, udp, ip) */ H    u_char ptype;                    /* Prototype (dgram, stream, raw) */K    u_char dname;                    /* Domain name (default of Internet) */ ;    } sock_parms;                    /* Socket parameters */    typedef struct {9    u_short family;                  /* Protocol family */ 7    u_short port;                    /* Protocol port */ 1    u_long addr;                     /* Address */     u_long reserved1;    u_long reserved2;8    } sock_addr;                     /* Socket address */   typedef struct {=    u_char type;                     /* Type of subfunction */     u_char call_code;    u_short reserved;    } sub_funct;   	 #if CMUIP  typedef struct { 	u_long src_host,dst_host; 	u_short src_port,dst_port; ) } CMUIP_UDPADDR;			/* "address buffer" */  #endif   typedef struct {?    u_long l_ui;                     /* Long unsigned integer */ B    u_long l_uf;                     /* Long unsigned fixed point*/:    } l_fp;                          /* Long fixed point */   typedef struct {2    char *hostname;         /* The server's name */3    sock_addr s_addr;       /* The socket address */ 6    u_char leap;            /* Leap second indicator */1    u_char stratum;         /* Server's startum */ 3    char precision;         /* Server's precision */ ;    u_long rootdelay;       /* Delay to the primary clock */ +    u_long rootdispersion;  /* dispersion */ 3    u_long refid;           /* reference clock ID */ =    bintime reftime;        /* Server's time of last update */ 5    u_long event_time;      /* Current clock period */ >    u_short xmtcnt;         /* Number of packets sent so far */<    u_short filter_nextpkt; /* Number/order of next packet */<    u_long filter_delay[NTP_SHIFT];    /* Delay of packets */?    bintime filter_offset[NTP_SHIFT];  /* Offset from packets */ F    bintime org;            /* Time the server originated the packet */D    bintime srec;           /* Time the server received the packet */A    bintime rec;            /* Time we received the packet back */ 8    bintime xmt;            /* Time we sent the packet */7    u_long delay;           /* Filter estimated delay */ <    bintime dispersion;     /* Filter estimated dispersion */>    bintime offset;         /* Filter estimated clock offset */9    } server;               /* Info from/about a server */    typedef struct {%    unsigned mode:3;        /* Mode */ (    unsigned version:3;     /* Version *//    unsigned leap:2;        /* Leap indicator */ /    u_char stratum;         /* peer's stratum */ :    u_char ppoll;           /* the peer polling interval */5    char precision;         /* peer clock precision */ <    u_long rootdelay;         /* distance to primary clock */3    u_long rootdispersion;    /* clock dispersion */ 3    u_long refid;           /* reference clock ID */ A    l_fp reftime;           /* time peer clock was last updated */ 5    l_fp org;               /* originate time stamp */ 3    l_fp rec;               /* receive time stamp */ 4    l_fp xmt;               /* transmit time stamp */M    u_long keyid;           /* (Here and below optional) key identification */ N    u_char mac[MAX_MAC_LEN - sizeof(u_long)]; /* message-authentication code */
    } ntp_pkt;    typedef struct rcvbuf { ;    struct rcvbuf *next;    /* Point to next one of these */ 5    ntp_pkt buf;            /* Holds one ntp packet */ 0    itm_lst iosb;           /* IO status block */3    sock_addr s_addr;       /* The socket address */ 	 #if CMUIP B    CMUIP_UDPADDR udpaddr;  /* remote port & IP address from QIO */ #else 0    itm_lst3 remote_host;   /* The remote host */?    u_long itm3_retlen;     /* Length of returned information */  #endif9    bintime bt_rcv;         /* Time packet was received */ 1    } rcv_buf;              /* A receive buffer */    typedef struct {5    u_short yr;                /* Year since year 0 */ 1    u_short mon;               /* Month of year */ 0    u_short day;               /* Day of month *//    u_short hr;                /* Hour of day */ 2    u_short min;               /* Minute of hour */4    u_short sec;               /* Second of minute */8    u_short hun;               /* Hundredths of second */M    } numtim;                  /* Structure for sys$numtim's "numeric time" */   A typedef struct dsc$descriptor_s dscr_s; /* A string descriptor */   2 #define MIN_PKTLEN (sizeof(ntp_pkt) - MAX_MAC_LEN)   /*    Function prototypes */   void Init(void); void Sanity_Check(void);) void Get_Args(int *argcnt, char *args[]);  void Usage(void);  void Open_Net(void);6 void Get_Servers(int maxarg, int argnum, char *args[],2                  int *nsrvs, server **srvs_lst[]);$ u_long Get_HostAddr(char *name_str);  rcv_buf *Get_RcvBufs(int nsrvs); void Poll_Srvs(void);  void Set_NetRead(void);  void NetRead_AST(void); ! void Set_Timer(bintime bt_delta);  void Timer_AST(void); % u_long Set_Priority(u_long priority); " void Print_Error(u_long err_code); void Poll_Inactive(void);  void Process_RcvPkts(void); < void Calc_Delays(u_long *dly, bintime *c_off, server *sptr);& server *Find_Server(sock_addr s_addr);< void Update_Filter(server *sptr, u_long dly, bintime c_off); void Poll_Server(server *sptr); C void Send_Pkt(sock_addr *s_addr, ntp_pkt *pkt_ptr, u_long pkt_len);  void Close_Net(void);   void Clock_Filter(server *sptr); server *Clock_Select(void);  void Clock_Adjust(void);# bintime FSecs2DBT(float frac_secs); # void *Get_ZMem(int num, int bytes);  bintime Str2Bt(char *time_str); ; char *Bt2ASC(bintime bt_time, char *time_str, int str_len); . int Bt_gt(bintime bt_time1, bintime bt_time2);. int Bt_lt(bintime bt_time1, bintime bt_time2);- int Bt_ge(bintime bt_time1, bintime bt_tim2); A void Bt2SecsRem(bintime bt_time, long *seconds, long *remainder); . int Bt_eq(bintime bt_time1, bintime bt_time2); l_fp Bt2Lfp(bintime bt_time); 8 bintime EMultUl(u_long multiplier, u_long multiplicand);3 bintime EMultL(long multiplier, long multiplicand); + bintime MultHigh(u_long num1, u_long num2);  bintime Lfp2Bt(l_fp lfp_time);3 bintime Bt_Sub(bintime bt_time1, bintime bt_time2); 3 bintime Bt_Add(bintime bt_time1, bintime bt_time2);   bintime Bt_Abs(bintime bt_time);- bintime Bt_ShiftR(bintime bt_time, int bits);  bintime Get_Time(void);  void Set_Time(bintime bt_time);  l_fp ntohl_fp(l_fp lfp_time);  l_fp htonl_fp(l_fp lfp_time); + int Lfp_eq(l_fp lfp_time1, l_fp lfp_time2); + int Lfp_ge(l_fp lfp_time1, l_fp lfp_time2);  int Dst(bintime bt_time); A void Dow_Adj(int cur_dow, int new_dow, int cmp, bintime *bt_dst); ) char *Bt2Str(bintime bt_time, char *str);   void Print_Server(server *sptr);  9 #if CMUIP	/* replacement for routines from UCX library */ " static char *inet_ntoa(u_long h) { 	static char s[16];   4 	sprintf(s,"%d.%d.%d.%d", h & 0xFF, (h >> 8) & 0xFF,& 		(h >> 16) & 0xFF, (h >> 24) & 0xFF);
 	return s; }   % static u_long cmuip_swap4(u_long x) { @ 	u_long y = ((x & 0xFFFF0000) >> 16) | ((x & 0x0000FFFF) << 16);: 	return ((y & 0xFF00FF00) >> 8) | ((y & 0x00FF00FF) << 8); } # #define htonl(__x) cmuip_swap4(__x) # #define ntohl(__x) cmuip_swap4(__x)  #endif	/* CMUIP */   /*    Global Variables  */  1 char *Program_Name;     /* How we were invoked */ < u_short inet_chan;      /* Internet device channel number *// u_long timer_exp;       /* Timer expire time */ . u_long timevt_flag;     /* Timer event flag */- u_long readevt_flag;    /* Read event flag */ . u_long writevt_flag;    /* Write event flag */8 rcv_buf *rbufq_head;    /* Received buffer queue head */8 rcv_buf *rbufq_tail;    /* Received buffer queue tail */- server **srv_lst;       /* List of servers */ / int sys_numservers;     /* Number of servers */ 6 int sys_version = NTP_VERSION;   /* Our ntp version */D bintime bt_utcoffset;   /* Binary time version of offset from utc */C bintime bt_dstadj;      /* Binary time version of DST adjustment */ 1 bintime bt_zero;        /* Zero in binary time */  bintime bt_maxage;1 char *utcbase_str = UTCBASE;  /* utc base time */ 2 char *sanetime_str = SANE_TIME;  /* A sane time */D u_long current_time = 1;   /* Our pseudo-clock with generic units */F u_long sys_timeout = DEFTIMEOUT; /* Timeout after this many periods */B int sys_samples = DEFSAMPLES;    /* Number of packets to sample */G int poll_num;                    /* Number of servers we are polling */ I int simple_query = FALSE;        /* True if just checking, not setting */ 8 int debug = FALSE;               /* True if debugging */
 #if 1 /*wjm*/ J int avoid_ntp_port = FALSE;	 /* True if using non-privileged local port */ #endif  $ $DESCRIPTOR(inet_dev, INET_DEVNAME);   main(int argc, char *argv[]) { A    int cur_arg;  /* Points to the current argument in the list */   
    Init();    Get_Args(&cur_arg, argv);    Open_Net();?    Get_Servers(argc, cur_arg, argv, &sys_numservers, &srv_lst); 9    rbufq_head = rbufq_tail = Get_RcvBufs(sys_numservers);     Poll_Srvs();     Close_Net();     Clock_Adjust(); }    void Init(void)  /*> Description:  Calculate the amount of the daylight saving timeF adjustment.  Calculate the adjustment from UTC.  Calculate the maximumC age we will allow on a packet.  Reserve event flags for the various  asynchronous functions.  */ { '    bt_dstadj = EMultUl(DST_ADJ, HNSPS); F    bt_utcoffset = Bt_Add(Str2Bt(utcbase_str), EMultL(LTZ_ADJ, HNSPS));*    bt_maxage = EMultUl(NTP_MAXAGE, HNSPS);    lib$get_ef(&timevt_flag);    lib$get_ef(&readevt_flag);     lib$get_ef(&writevt_flag);  }    void Sanity_Check(void)  /*H Description:  If the current time is somewhere in the past, set the time to something sane. */ { 9    bintime bt_sanetime;  /* Binary version of the time */   &    bt_sanetime = Str2Bt(sanetime_str);=    if (Bt_gt(bt_sanetime, Get_Time())) Set_Time(bt_sanetime);  }   ( void Get_Args(int *argcnt, char *args[]) /*> Description:  Get the command line switches and arguments.  IfF something's not right, set the error flag.  If there is an error or noD arguments are left for server names, tell the user how to invoke the program. */ { ;    int error_flag;      /* Counts each error encountered */ 9    int temp_samples;    /* Temporary number of samples */       Program_Name = args[0];    error_flag = 0;)    *argcnt = 1;   /* Skip program name */ 5    while (args[*argcnt] && (args[*argcnt][0] == '-'))     {%       if (strlen(args[*argcnt]) != 2) 7          printf("Unknown flag '%s'.\n", args[*argcnt]); 
       else+          switch (tolower(args[*argcnt][1])) 
          {1             case 'd':         /* Set debugging */                 debug++;                 break; 6             case 'o':         /* Select ntp version */                (*argcnt)++; 9                sscanf(args[*argcnt], "%d", &sys_version);                 break; ?             case 'p':         /* Number of packets to sample */                 (*argcnt)++;i:                sscanf(args[*argcnt], "%d", &temp_samples);A                if (temp_samples <= 0 || temp_samples > NTP_SHIFT)b                {L                   printf("Number of packets to sample (%d) ", temp_samples);@                   printf("is not between 0 and %d ", NTP_SHIFT);;                   printf("(default of %d).\n", DEFSAMPLES);9                   error_flag++;9                }/                else sys_samples = temp_samples;c                break;a7             case 'q':         /* Just a simple query */o#                simple_query = TRUE;?                break;C
 #if 1 /*wjm*/ P             case 'a':         /* simple query, from non-privileged local port */#                simple_query = TRUE;  	       avoid_ntp_port = TRUE;                break;  #endif             default:=                printf("Unknown flag '%s'.\n", args[*argcnt]);e                break;<
          }       (*argcnt)++;    }-    if (!args[*argcnt] || error_flag) Usage();c }n   void Usage(void) /*H Description:  Tell the user how to invoke the program.  Say what default$ and min/max values are, if possible. */ {n
 #if 1	/*wjm*/ I    printf("\nUsage:  ntpdate [-d] [-o version] [-p packets] [-q] [-a] ");  #else		/* [-v] is bad */I    printf("\nUsage:  ntpdate [-d] [-o version] [-p packets] [-q] [-v] ");y #endif!    printf("host [host ...]\n\n"); 7    printf("        -d            turn on debugging\n");E0    printf("        -o version    NTP version ");,    printf("(default is %d)\n", NTP_VERSION);@    printf("        -p packets    number of packets to sample ");+    printf("(default is %d)\n", DEFSAMPLES);cI    printf("        -q            simple query, don't set system time\n");d
 #if 1	/*wjm*/ J    printf("        -a            same as -q, not using local NTP port\n"); #endif    printf("\n");    exit(1);r }    void Open_Net(void)  /*G Description:  Assign the internet device and then open a UDP channel on 
 the NTP port.  */ { B    u_long status;          /* Return status of the system calls */3    u_long evt_flag;        /* Event flag for QIO */d1    itm_lst iosb;           /* I/O status block */r6    sock_parms s_parms;     /* The socket parameters */?    itm_lst2 host;          /* Item list for the host address */ 3    sock_addr host_addr;    /* Our socket address */m  4    status = sys$assign(&inet_dev, &inet_chan, 0, 0);    if (status != SS$_NORMAL)    {?       printf("Failed to assign channel to Internet device.\n");f       lib$signal(status);     }  	 #if CMUIPp    lib$get_ef(&evt_flag);     status = sys$qiow(evt_flag, 	inet_chan,n
 	NET$OPEN, 	&iosb,NULL,0,' 	0, 0,				/* destination host & port */T1 	avoid_ntp_port ? 0 : NTP_PORT,	/* source port */n! 	1,				/* (???) - after NETLIB */c 	NET_K_UDP,			/* protocol */( 	600);				/* (???) inactivity timeout */ #elseT    s_parms.proto = INET$C_UDP;'    s_parms.ptype = INET_PROTYP$C_DGRAM;d    s_parms.dname = 0; %    host_addr.family = INET$C_AF_INET; 
 #if 1 /*wjm*/     if(avoid_ntp_port)P 	host_addr.port = 0;    else_ #endif$    host_addr.port = htons(NTP_PORT);    host_addr.addr = 0;    host_addr.reserved1 = 0;0    host_addr.reserved2 = 0;d     host.len = sizeof(sock_addr);    host.item_code = 0;    host.address = &host_addr;       lib$get_ef(&evt_flag);     status = sys$qiow(evt_flag,       inet_chan,       IO$_SETMODE,       &iosb, 0, 0,       &s_parms, 0,       &host, 0, 0, 0); #endif    lib$free_ef(&evt_flag);      if (status != SS$_NORMAL)    {/       printf("Failed to create UDP socket.\n");d       lib$signal(status);S    }    if ((iosb.cond & 1) == 0)    {%       printf("Socket bind error.\n");a       lib$signal(iosb.cond);    } }D  6 void Get_Servers(int maxarg, int argnum, char *args[],1                  int *nsrvs, server **srvs_lst[])n /*E Description:  Get server names out of args[] until no more are left. ME Get the IP number of each server.  If an IP number is not found, warn C the user, ignore the name and get the next one.  If an IP number is0? found, create a server structure and fill it with the necessaryS information. */ {k4    u_long ipnum;        /* The server's IP number */D    server **srvs_ptr;   /* Pointer to the list of server pointers */2    server *srv_ptr;     /* Points to one server */@    int num_srv;         /* Number of acceptable servers found */A    int max_srv;         /* Max possible servers from arguments */*  ,    num_srv = 0;         /* None found yet */C    max_srv = maxarg - argnum;    /* Could find this many servers */uI    srvs_ptr = Get_ZMem(max_srv, sizeof(server *)); /* List of pointers */c    while (args[argnum])*    {)       ipnum = Get_HostAddr(args[argnum]);        if (!ipnum)c9          printf("Server not found - %s\n", args[argnum]);*
       else       {y/          srv_ptr = Get_ZMem(1, sizeof(server)); N          srv_ptr->hostname = Get_ZMem(strlen(args[argnum]) + 1, sizeof(char));1          strcpy(srv_ptr->hostname, args[argnum]);s	 #if CMUIPt)          srv_ptr->s_addr.port = NTP_PORT;  #else 0          srv_ptr->s_addr.family = UCX$C_AF_INET;0          srv_ptr->s_addr.port = htons(NTP_PORT); #endif&          srv_ptr->s_addr.addr = ipnum;'          srvs_ptr[num_srv++] = srv_ptr;P'          srv_ptr->event_time = num_srv;l       }        argnum++;t    }    if (!num_srv)    {$       printf("No servers found.\n");       exit(1);    }    *srvs_lst = srvs_ptr;    *nsrvs = num_srv; }   # u_long Get_HostAddr(char *name_str)a /*D Description:  Do a hostname lookup and return the IP number if it is found. */ { A    u_long status;          /* Return status of the system call */m?    u_long evt_flag;        /* Event flag for the system call */{6    u_long ip_num;          /* IP number of the host */:    sub_funct sfun;         /* A subfunction of the call */1    dscr_s subfunct_code;   /* Subfunction code */*@    dscr_s hname;           /* The host name string descriptor */<    dscr_s host_addr;       /* The host address descriptor */1    itm_lst iosb;           /* I/O status block */cC    u_short addr_len;       /* The length of the returned address */     	 #if CMUIP F    /* If you think the UCX QIO interface is weird, look at this :-) */    ip_num = 0;1    if(name_str[0] >= '0' && name_str[0] <= '9') {t 	int i1,i2,i3,i4;_  : 	if(sscanf(name_str,"%d.%d.%d.%d",&i1,&i2,&i3,&i4) == 4) { 		ip_num = (i1 & 0xFF) | 			 ((i2 & 0xFF) << 8) | 			 ((i3 & 0xFF) << 16) |  			 ((i4 & 0xFF) << 24); 	}    } else {y0 	struct {			/* GTHST (name => addr) structure */
 		int adrcnt;/- 		u_long adrlst[20];		/* addresses go here */e
 		int namlen;a2 		char namstr[128];		/* official name goes here */
 	} gthblk;   	lib$get_ef(&evt_flag);t 	status = sys$qiow(evt_flag, 		inet_chan,2 		NET$GTHST,		/* won't handle numeric addresses */ 		&iosb, 0, 0," 		&gthblk,		/* buffer structure */% 		sizeof(gthblk),		/* size of same */   		GTH_NAMADR,		/* subfunction */. 		name_str,		/* host name (zero terminated) */ 		0, 0); 	lib$free_ef(&evt_flag); 	if ((status & 1) && 	    (iosb.cond & 1) &&t4 	    (gthblk.adrcnt > 0)) ip_num = gthblk.adrlst[0];    } #elselG    sfun.type = INETACP_FUNC$C_GETHOSTBYNAME; /* Specific subfunction */P%    sfun.call_code = INETACPC$C_TRANS;b    sfun.reserved = 0;P,    subfunct_code.dsc$w_length = sizeof sfun;-    subfunct_code.dsc$b_dtype = DSC$K_DTYPE_T;d-    subfunct_code.dsc$b_class = DSC$K_CLASS_S;i'    subfunct_code.dsc$a_pointer = &sfun;b  )    hname.dsc$w_length = strlen(name_str);e%    hname.dsc$b_dtype = DSC$K_DTYPE_T; %    hname.dsc$b_class = DSC$K_CLASS_S;u"    hname.dsc$a_pointer = name_str;  *    host_addr.dsc$w_length = sizeof ip_num;)    host_addr.dsc$b_dtype = DSC$K_DTYPE_T;e)    host_addr.dsc$b_class = DSC$K_CLASS_S;o%    host_addr.dsc$a_pointer = &ip_num;       lib$get_ef(&evt_flag);     status = sys$qiow(evt_flag,       inet_chan,       IO$_ACPCONTROL,e       &iosb, 0, 0,       &subfunct_code,p
       &hname,e       &addr_len,       &host_addr, 0, 0);    lib$free_ef(&evt_flag);  D    if ((status != SS$_NORMAL) || ((iosb.cond & 1) == 0)) ip_num = 0; #endif    return(ip_num); }i   rcv_buf *Get_RcvBufs(int nsrvs)  /*D Description:  This function creates a circular receive queue using aF linked list for storing the packets from the servers when they arrive. */ {tM    int cnt;             /* Count through the buffers as they are linked in */ 9    int nbufs;           /* Number of buffers to create *//5    rcv_buf *head_ptr;   /* Head of the linked list */ 5    rcv_buf *tail_ptr;   /* Tail of the linked list */HK    rcv_buf *tmp_ptr;    /* Temporarily points to buffer before linked in */i  >    nbufs = nsrvs + ((nsrvs + 1) / 2);           /* 50% more */G    head_ptr = Get_ZMem(1, sizeof(rcv_buf));     /* Plus 1 additional */n    tail_ptr = head_ptr;t	 #if CMUIP  #else <    tail_ptr->remote_host.buff_len = sizeof tail_ptr->s_addr;'    tail_ptr->remote_host.item_code = 0;/2    tail_ptr->remote_host.buff = &tail_ptr->s_addr;:    tail_ptr->remote_host.ret_len = &tail_ptr->itm3_retlen; #endif$    for (cnt = 0; cnt < nbufs; cnt++)    {-       tmp_ptr = Get_ZMem(1, sizeof(rcv_buf));d       tail_ptr->next = tmp_ptr;i       tail_ptr = tmp_ptr;p	 #if CMUIPe #else*?       tail_ptr->remote_host.buff_len = sizeof tail_ptr->s_addr; *       tail_ptr->remote_host.item_code = 0;5       tail_ptr->remote_host.buff = &tail_ptr->s_addr;M=       tail_ptr->remote_host.ret_len = &tail_ptr->itm3_retlen;  #endif    }7    tail_ptr->next = head_ptr;    /* Make it circular */     return(head_ptr); }h   void Poll_Srvs(void) /*C Description:  First set the time to something sane.  Then raise ournC priority, set the asynchronous routine for reading packets from thesH network, and every time the timer has expired, poll any inactive serversG again, reset the timer and then hibernate until either a packet arrivesAG or the timer expires.  If any packets have arrived, process them and go_D through this all again as long as there are still servers we need to poll.  */ {e:    u_long norm_pri;     /* What the normal priority was */+    bintime bt_timeout;  /* Timer timeout */   0    Sanity_Check();      /* Make the time sane */)    bt_timeout = FSecs2DBT(TIMEOUT_FSECS);l;    timer_exp = TRUE;    /* Assume it has already expired */i%    norm_pri = Set_Priority(HIGH_PRI);     Set_NetRead();i    poll_num = sys_numservers;g    while (poll_num)i    {       if (timer_exp)       {_          Poll_Inactive();e          timer_exp = FALSE;_          Set_Timer(bt_timeout);f       }*C       sys$hiber();      /* Wait for a packet or timer expiration */rJ       if (rbufq_head != rbufq_tail) Process_RcvPkts();  /* Queue empty? */    }:    sys$cantim(0, 0);    /* Cancel the timer, we're done */    Set_Priority(norm_pri); }C   void Set_NetRead(void) /*F Description:  Specify the function to handle asynchronous reads when a packet arrives.  */ {*;    u_long status;    /* Return status of the system call */)  	 #if CMUIPA!    status = sys$qio(readevt_flag,        inet_chan,.       IO$_READVBLK,			/* a.k.a. NET$RECEIVE */       &rbufq_tail->iosb,       NetRead_AST, 0, G       &rbufq_tail->buf,          /* The buffer to receive the packet */m       sizeof rbufq_tail->buf,e9       &rbufq_tail->udpaddr, 0, 0, 0);  /* Sending host */B #elsei!    status = sys$qio(readevt_flag,_       inet_chan,       IO$_READVBLK,        &rbufq_tail->iosb,       NetRead_AST, 0,)G       &rbufq_tail->buf,          /* The buffer to receive the packet */_       sizeof rbufq_tail->buf,b=       &rbufq_tail->remote_host, 0, 0, 0);  /* Sending host */b #endif    if (status != SS$_NORMAL)    {0       printf("Failure to read from network.\n");       Print_Error(status);    } }d   void NetRead_AST(void) /*F Description:  Check if there was some kind of error on reception or ifB the read was cancelled somehow (e.g. internet device was closed). F Otherwise, stick the time in the packet, find the next free buffer and& set ourselves up to read the next one. */ {t(    if ((rbufq_tail->iosb.cond & 1) == 0)    {4 #if CMUIP			/* weird way of saying 'IO cancelled' *//       if (rbufq_tail->iosb.cond == SS$_ABORT &&t, 	  rbufq_tail->iosb.dev_spec == NET$_CCAN) {
 		/* no-op */%       } else #endif.       if (rbufq_tail->iosb.cond != SS$_CANCEL)       { (          printf("NetRead I/O error.\n");+          lib$signal(rbufq_tail->iosb.cond);|       }0    }    else;    {&       rbufq_tail->bt_rcv = Get_Time();=       rbufq_tail = rbufq_tail->next;   /* Next free buffer */n;       sys$wake(0, 0);   /* Wake ourselves up if sleeping */GF       Set_NetRead();    /* Set ourselves up for the the next packet */    } }r   void Poll_Inactive(void) /*C Description:  Go through the list of servers.  If any server has an*B event time (0 means we finished polling it) and it's less than the@ current time period, it is a candidate for polling again.  If weF transmitted a packet to it already, it didn't respond before the timerM expiration (or we wouldn't be here), so put a zero in the filter.  Then poll.  */ {s6    int cnt;    /* Count through the list of servers */  -    for (cnt = 0; cnt < sys_numservers; cnt++)u'       if ((srv_lst[cnt]->event_time) && 5           (srv_lst[cnt]->event_time <= current_time))t       { "          if (srv_lst[cnt]->xmtcnt)4             Update_Filter(srv_lst[cnt], 0, bt_zero);#          Poll_Server(srv_lst[cnt]);*       }t }     void Set_Timer(bintime bt_delta) /*C Description:  Set when the timer should expire (delta time) and the F function to execute when it does.  Resolution of the timer on a VAX is 10 milliseconds. */ {s;    u_long status;    /* Return status of the system call */o  #    status = sys$setimr(timevt_flag,        &bt_delta,       Timer_AST, 0, 0);e    if (status != SS$_NORMAL)    {,       printf("Failure to set the timer.\n");       lib$signal(status);     } }    void Timer_AST(void) /*D Description:  Set the flag that the timer has expired, increment the# time period, and wake ourselves up.R */ {n    timer_exp = TRUE;    current_time++;    sys$wake(0,0);  }t  $ u_long Set_Priority(u_long priority) /*G Description:  Set our priority to the requested priority and return the( previous priority value. */ { ;    u_long status;    /* Return status of the system call */l9    u_long prev_pri;  /* Value of the previous priority */e  2    status = sys$setpri(0, 0, priority, &prev_pri);    if (status != SS$_NORMAL)    {<       printf("Failure to set priority to %lu.\n", priority);       Print_Error(status);    }    return(prev_pri); }   ! void Print_Error(u_long err_code)  /*F Description:  Print the system error message using the specified error code.P */ { =    char err_str[MAX_ERRSTR];        /* Holds error message */PA    $DESCRIPTOR(err_msg, err_str);   /* Error string descriptor */mE    u_short msglen;                  /* Length of the error message */)  1    sys$getmsg(err_code, &msglen, &err_msg, 0, 0);     err_str[msglen] = '\0';    printf("%s\n", err_str);e }o   void Process_RcvPkts(void) /*I Description:  Process all of the packets currently in the receive queue. BH If the packet passes all of the tests (there are a lot of them), then weE move the information into the server structure, calculate the delays,:H move to the next buffer, update the filter for this server and poll this8 server again.  Do this to the next packet in the buffer.E    As times are moved into the server structure, they are adjusted by G the UTC offset.  This is so that the times are at least within one houriH of what our time should be.  This just makes it easier down the road for7 calculations.  It would be a lot easier if VMS stored a / timezone/daylight saving time independent time.sE    UTC is safe, but we can't add the DST adjustment here.  Though, it H would be really nice if we could.  First, it means a lot of calculations@ for each packet to find the current time when we are really onlyH interested in the offset at this point.  There would mucho problems withF filtering if one packet arrived and was adjusted but that the next oneG wasn't.  Even more unlikely but possible is a packet which was receivedy% in DST and was sent in standard time.  */ { @    ntp_pkt *pkt_ptr;    /* Points to a packet from the server */<    server *srv_ptr;     /* Points to server of the packet */1    u_long delay;        /* Delay of the packet */=.    bintime clk_offset;  /* The clock offset */$    l_fp lfp_zero;       /* A zero */  %    lfp_zero.l_ui = lfp_zero.l_uf = 0;;
    delay = 0; +    clk_offset.qd_hi = clk_offset.qd_lo = 0;I    srv_ptr = NULL;I    while (rbufq_head != rbufq_tail)    /* As long as there are packets */g    {	 #if CMUIP <       /* pick up host & port from CMUIP_UDPADDR structure */=       rbufq_head->s_addr.addr = rbufq_head->udpaddr.src_host;e=       rbufq_head->s_addr.port = rbufq_head->udpaddr.src_port;  #endif9       pkt_ptr= &rbufq_head->buf;       /* Get a packet */u2                /* Is the packet the right size? */3       if ((rbufq_head->iosb.count >= MIN_PKTLEN) &&U4                /* Is it the version we requested? */.           (pkt_ptr->version == sys_version) &&2                /* Is the server in server mode? */+           (pkt_ptr->mode == MODE_SERVER) &&r'                /* Is the stratum OK? */d1           (pkt_ptr->stratum <= NTP_MAXSTRATUM) &&o0                /* Is this a server we polled? */B           ((srv_ptr = Find_Server(rbufq_head->s_addr)) != NULL) &&C                /* Is our xmt and packet originate time the same? */ F           (Bt_eq(Bt_Add(Lfp2Bt(ntohl_fp(pkt_ptr->org)), bt_utcoffset),"                  srv_ptr->xmt)) &&,                /* Is the receive time OK? */.           (!Lfp_eq(pkt_ptr->rec, lfp_zero)) &&D                /* >= 0 delay between server receive and transmit? */C           (Lfp_ge(ntohl_fp(pkt_ptr->xmt), ntohl_fp(pkt_ptr->rec))))tF       {                                   /* Record the information */'          srv_ptr->leap = pkt_ptr->leap;s-          srv_ptr->stratum = pkt_ptr->stratum;(1          srv_ptr->precision = pkt_ptr->precision;N8          srv_ptr->rootdelay = ntohl(pkt_ptr->rootdelay);B          srv_ptr->rootdispersion = ntohl(pkt_ptr->rootdispersion);)          srv_ptr->refid = pkt_ptr->refid;o          srv_ptr->reftime =sE             Bt_Add(Lfp2Bt(ntohl_fp(pkt_ptr->reftime)), bt_utcoffset); M          srv_ptr->org = Bt_Add(Lfp2Bt(ntohl_fp(pkt_ptr->xmt)), bt_utcoffset);kN          srv_ptr->srec = Bt_Add(Lfp2Bt(ntohl_fp(pkt_ptr->rec)), bt_utcoffset);+          srv_ptr->rec = rbufq_head->bt_rcv; 3          Calc_Delays(&delay, &clk_offset, srv_ptr);m       }a$       rbufq_head = rbufq_head->next;       if (srv_ptr != NULL)       {)3          Update_Filter(srv_ptr, delay, clk_offset);e          Poll_Server(srv_ptr);       }     } }}  ; void Calc_Delays(u_long *dly, bintime *c_off, server *sptr)w /*3 Description:  Calculate the delay and clock offset.  */ {*1    bintime bt_t10;      /* Time 1 minus time 0 */ 1    bintime bt_t23;      /* Time 2 minus time 3 */e*    bintime bt_clkoff;   /* Clock offset */'    bintime bt_delay;    /* The delay */ <    bintime bt_tmp;      /* Temporarily holds a time value */  J    bt_t10 = Bt_Sub(sptr->org, sptr->rec);    /* Delay from server to us */J    bt_t23 = Bt_Sub(sptr->srec, sptr->xmt);   /* Delay from us to server */D    bt_clkoff = Bt_Add(bt_t23, bt_t10);       /* Total travel time */>    bt_clkoff = Bt_ShiftR(bt_clkoff, 1);      /* Divide by 2 */I    bt_delay = Bt_Sub(bt_t23, bt_t10);        /* Total processing delay */h    bt_tmp.qd_hi = 0;
 #if 0	/*wjm*/)1    bt_tmp.qd_lo = (HNSPS >> -NTPDATE_PRECISION) +,
 #else	/*wjm*/M3    bt_tmp.qd_lo = (HNSPS >> -(NTPDATE_PRECISION)) +h #endif	/*wjm*//                   (HNSPS >> -sptr->precision) +u                   NTP_MAXSKW;r'    bt_delay = Bt_Add(bt_delay, bt_tmp);      if (Bt_lt(bt_delay, bt_zero))    {,       bt_clkoff.qd_hi = bt_clkoff.qd_lo = 0;*       bt_delay.qd_hi = bt_delay.qd_lo = 0;    }    else     {!       bt_tmp.qd_lo = NTP_MINDIST;g"       if (Bt_gt(bt_tmp, bt_delay))          bt_delay = bt_tmp;t    }    *dly = bt_delay.qd_lo;r    *c_off = bt_clkoff; }n  % server *Find_Server(sock_addr s_addr)e /*I Description:  Given a socket address, run through the list of servers and H see if this is one that we know about.  Check the source port so that no- one spoofs us.  If found, return its pointer./ */ { 6    int cnt;    /* Count through the list of servers */      cnt = 0;r#    while ((cnt < sys_numservers) &&p5           (s_addr.addr != srv_lst[cnt]->s_addr.addr))r       cnt++;	 #if CMUIP <    if ((cnt >= sys_numservers) || (s_addr.port != NTP_PORT)) #else C    if ((cnt >= sys_numservers) || (ntohs(s_addr.port) != NTP_PORT))  #endif       return(NULL);x    elsex       return(srv_lst[cnt]);d }i  ; void Update_Filter(server *sptr, u_long dly, bintime c_off)e /*F Description:  Update the filter for the server with the delay time and the clock offset.[ */ {)3    int num_fpkts;    /* Number of filter packets */o  $    num_fpkts = sptr->filter_nextpkt;>    if (num_fpkts < NTP_SHIFT)    /* Have room for one more? */    {*       sptr->filter_delay[num_fpkts] = dly;-       sptr->filter_offset[num_fpkts] = c_off;_/       sptr->filter_nextpkt++;    /* Count it */     } }r   void Poll_Server(server *sptr) /*H Description:  If the filter array has enough samples, then if the serverF has an even time change it to zero to indicate we are finished pollingA it.  Otherwise, fill in the ntp packet and send it to the server.iE NB:  Ever since 1995, the number of seconds in binary time is greater{I than l_fp in ntp.  Be sure to subtract bt_utcoffset so that it will fit. =+ Remember to add it later on when comparing.g */ {s(    ntp_pkt pkt;   /* A network packet */  +    if (sptr->filter_nextpkt >= sys_samples)f    {       if (sptr->event_time)t       {           poll_num--;          sptr->event_time = 0;       }g    }    elsen    {        pkt.leap = LEAP_NOTINSYNC;        pkt.version = sys_version;       pkt.mode = MODE_CLIENT;;3       pkt.stratum = STRATUM_TO_PKT(STRATUM_UNSPEC);u       pkt.ppoll = NTP_MINPOLL;(       pkt.precision = NTPDATE_PRECISION;.       pkt.rootdelay = htonl(NTPDATE_DISTANCE);/       pkt.rootdispersion = htonl(NTPDATE_DISP);i'       pkt.refid = htonl(NTPDATE_REFID);k.       pkt.reftime.l_ui = pkt.reftime.l_uf = 0;&       pkt.org.l_ui = pkt.org.l_uf = 0;&       pkt.rec.l_ui = pkt.rec.l_uf = 0;?       sptr->xmt = Get_Time();    /* Remember when we sent it */rB       pkt.xmt = htonl_fp(Bt2Lfp(Bt_Sub(sptr->xmt, bt_utcoffset)));2       Send_Pkt(&(sptr->s_addr), &pkt, MIN_PKTLEN);P       sptr->event_time = current_time + sys_timeout;  /* When request expires */C       sptr->xmtcnt++;            /* Count the packet transmitted */=    } }t  B void Send_Pkt(sock_addr *s_addr, ntp_pkt *pkt_ptr, u_long pkt_len) /*@ Description:  Given an address and a packet, send it on its way. */ {gC    u_long status;          /* Return status from the system call */n?    u_long evt_flag;        /* Event flag for the system call */i1    itm_lst iosb;           /* I/O status block */i	 #if CMUIP)/    CMUIP_UDPADDR udpaddr;  /* Address buffer */t #else 8    itm_lst2 remote_host;   /* Remote host information */ #endif  	 #if CMUIPg    udpaddr.src_host = 0;#    udpaddr.dst_host = s_addr->addr;k    udpaddr.src_port = 0;#    udpaddr.dst_port = s_addr->port;."    status = sys$qiow(writevt_flag,       inet_chan,,       IO$_WRITEVBLK,			/* a.k.a. NET$SEND */       &iosb, 0, 0,       pkt_ptr,       pkt_len,-       1, 				/* "push" flag (after NETLIB) */d       0, 0,D       &udpaddr); #elsee$    remote_host.len = sizeof *s_addr;    remote_host.item_code = 0;n     remote_host.address = s_addr;"    status = sys$qiow(writevt_flag,       inet_chan,       IO$_WRITEVBLK,       &iosb, 0, 0,       pkt_ptr,       pkt_len,       &remote_host, 0, 0, 0);  #endif    if (status != SS$_NORMAL)    {)       printf("Unable to send packet.\n");=       Print_Error(status);    }    if ((iosb.cond & 1) == 0)    {3       printf("Error writing packet to network.\n");        Print_Error(iosb.cond);R    } }    void Close_Net(void) /*B Description:  Close the network by deassigning the network device. */ {l    sys$dassgn(inet_chan);  }    void Clock_Filter(server *sptr)o /*G Description:  Sort the delays to find the best one that isn't zero.  IfvE the best one is zero, save default information for the server.  If itcE isn't zero, save the delay and offset for the server.  Then calculatesC and save the dispersion (the sum of the difference between the bestt7 offset and all the rest of the offsets) for the server.  */ {N@    int order[NTP_SHIFT];   /* Holds each filter delay's order */2    int tmp;                /* Temporary storage */6    int cnt1;               /* Count through samples */6    int cnt2;               /* Count through samples */4    bintime bt_peermaxdisp; /* Peer max dispersion *//    bintime bt_disp;        /* The dispersion */   1    bt_peermaxdisp = EMultUl(PEER_MAXDISP, HNSPS); -    for (cnt1 = 0; cnt1 < sys_samples; cnt1++)f       order[cnt1] = cnt1;a:                               /* Sort delays into order */3    for (cnt1 = 0; cnt1 < (sys_samples - 1); cnt1++)r7       for (cnt2 = cnt1 + 1; cnt2 < sys_samples; cnt2++)f4          if (sptr->filter_delay[order[cnt2]] != 0 &&5              (sptr->filter_delay[order[cnt1]] == 0 ||=/               sptr->filter_delay[order[cnt1]] >e0                sptr->filter_delay[order[cnt2]]))
          {             tmp = order[cnt1];&             order[cnt1] = order[cnt2];             order[cnt2] = tmp;
          }A    if (sptr->filter_delay[order[0]] == 0)  /* Best delay is 0? */f    {       sptr->delay = 0;2       sptr->offset.qd_hi = sptr->offset.qd_lo = 0;(       sptr->dispersion = bt_peermaxdisp;    }    else     {D       sptr->delay = sptr->filter_delay[order[0]];   /* Best delay */E       sptr->offset = sptr->filter_offset[order[0]]; /* It's offset */ !       sptr->dispersion = bt_zero;eJ       for (cnt1 = 1; cnt1 < sys_samples; cnt1++)    /* Missing samples? */       {r2          if (sptr->filter_delay[order[cnt1]] == 0)%             bt_disp = bt_peermaxdisp;a
          elseh
          {E             bt_disp = Bt_Abs(Bt_Sub(sptr->filter_offset[order[cnt1]],hE                                      sptr->filter_offset[order[0]])); /             if (Bt_gt(bt_disp, bt_peermaxdisp))/(                bt_disp = bt_peermaxdisp;
          }4          sptr->dispersion = Bt_Add(sptr->dispersion,>                                     Bt_ShiftR(bt_disp, cnt1));       }     } }r   server *Clock_Select(void) /*+ Description:  The clock selection function.l */ {i    int done;    int num_good;    int cnt1;    int cnt2;    int cnt3;    server *sptr;    server *sys_server;%    server *server_list[NTP_MAXCLOCK]; (    bintime server_badness[NTP_MAXCLOCK];    bintime bt_disp;p    bintime bt_lthresh;    bintime bt_tmp;      num_good = 0;0    for (cnt1 = 0; cnt1 < sys_numservers; cnt1++)    {       sptr = srv_lst[cnt1];        if ((sptr->delay != 0) &&y)           (sptr->stratum <= NTP_INFIN) &&/(           (sptr->delay <= NTP_MAXWGT) &&+           (sptr->leap != LEAP_NOTINSYNC) &&a.           (Bt_ge(sptr->org, sptr->reftime)) &&=           Bt_lt(Bt_Sub(sptr->org, sptr->reftime), bt_maxage))i       { >          bt_disp = Bt_Add(sptr->dispersion, sptr->dispersion);          cnt2 = 0;"          while (cnt2 < num_good &&;                 sptr->stratum > server_list[cnt2]->stratum)o             cnt2++;a"          while (cnt2 < num_good &&>                 sptr->stratum >= server_list[cnt2]->stratum &&5                 Bt_ge(bt_disp, server_badness[cnt2]))              cnt2++;            if (cnt2 < NTP_MAXLIST)
          {6             for (cnt3 = num_good; cnt3 > cnt2; cnt3--)&                if (cnt3 < NTP_MAXLIST)                {<                   server_list[cnt3] = server_list[cnt3 - 1];B                   server_badness[cnt3] = server_badness[cnt3 - 1];                }%             server_list[cnt2] = sptr;h+             server_badness[cnt2] = bt_disp;e3             if (num_good < NTP_MAXLIST) num_good++;p
          }       }f    }    cnt2 = 0;    cnt3 = 0;+    while (cnt2 < num_good - 1 && cnt3 <= 2)a    {F       if (server_list[cnt2 + 1]->stratum > server_list[cnt2]->stratum)          cnt3++;
       cnt2++;b    }$    if (cnt3 >= 2) num_good = --cnt2;    if (num_good == 0){       sys_server = NULL;    elsed       if (num_good == 1)%          sys_server = server_list[0]; 
       else       {I4          for (cnt2 = 0; cnt2 < num_good - 1; cnt2++):             for (cnt3 = cnt2 + 1; cnt3 < num_good; cnt3++)P                if ((server_list[cnt2]->stratum >= server_list[cnt3]->stratum) &&J                    (server_list[cnt2]->delay >= server_list[cnt3]->delay))                {+                   sptr = server_list[cnt2];}8                   server_list[cnt2] = server_list[cnt3];+                   server_list[cnt3] = sptr;a                }          bt_lthresh.qd_hi = 0;
 #if 0	/*wjm*/nG          bt_lthresh.qd_lo = (HNSPS >> -NTPDATE_PRECISION) + NTP_MAXSKW;r
 #else	/*wjm*/kI          bt_lthresh.qd_lo = (HNSPS >> -(NTPDATE_PRECISION)) + NTP_MAXSKW;l #endif	/*wjm*/          done = FALSE;&          while (num_good > 1 && !done)
          {3             for (cnt1 = 0; cnt1 < num_good; cnt1++)<
             {;K                server_badness[cnt1].qd_hi = server_badness[cnt1].qd_lo = 0;e6                for (cnt3 = 0; cnt3 < num_good; cnt3++)#                   if (cnt3 != cnt1)e                   { G                      bt_disp = Bt_Abs(Bt_Sub(server_list[cnt3]->offset,SJ                                               server_list[cnt1]->offset));8                      for (cnt2 = 0; cnt2 < cnt3; cnt2++)?                         bt_disp = Bt_Add(Bt_ShiftR(bt_disp, 1), A                                           Bt_ShiftR(bt_disp, 2));s;                      server_badness[cnt1] = Bt_Add(bt_disp,eJ                                                     server_badness[cnt1]);                   } 
             }l             cnt2 = 0; -             cnt1 = server_list[0]->precision; 3             for (cnt3 = 1; cnt3 < num_good; cnt3++)p
             { E                if (Bt_ge(server_badness[cnt3], server_badness[cnt2]))s                   cnt2 = cnt3;8                if (cnt1 > server_list[cnt3]->precision);6                   cnt1 = server_list[cnt3]->precision;
             }              bt_tmp.qd_hi = 0; *             bt_tmp.qd_lo = HNSPS >> -cnt1;H             if (Bt_ge(server_badness[cnt2], Bt_Add(bt_lthresh, bt_tmp)))
             {r=                for (cnt3 = cnt2 + 1; cnt3 < num_good; cnt3++)n<                   server_list[cnt3 - 1] = server_list[cnt3];                num_good--;
             };             else done = TRUE; 
          }=          sys_server = server_list[0];   /* The best server */i       }r    return(sys_server); }r   void Clock_Adjust(void)* /*F Description:  Print information about the servers and adjust the clock8 as requested.  The adjustment is done in one fell swoop. */ {f@    int cnt;                      /* Count through the servers */9    server *sptr;                 /* Points to a server */rI    bintime bt_offset;            /* Adjust system clock by this amount */f;    char time_str[MAX_TIMESTR];   /* Holds time as string */   -    for (cnt = 0; cnt < sys_numservers; cnt++),    {F       Clock_Filter(srv_lst[cnt]);   /* Find best delays and offsets */<       if (debug || simple_query) Print_Server(srv_lst[cnt]);    }9    sptr = Clock_Select();        /* Select best server */b    if (sptr == NULL)@       printf("No server suitable for synchronization found.\n");    elseT    {       bt_offset = sptr->offset;iK       if (Dst(Bt_Add(Get_Time(), bt_offset)))   /* Daylight saving time? */h2          bt_offset = Bt_Add(bt_offset, bt_dstadj);       if (!simple_query)1          Set_Time(Bt_Add(Get_Time(), bt_offset)); F       printf("Selected server is %s (%s) offset %s\n", sptr->hostname,D          inet_ntoa(sptr->s_addr.addr), Bt2Str(bt_offset, time_str));    } }    bintime Get_Time(void) /*- Description:  Return the current system time.  */ {i    bintime bt_time;o    sys$gettim(&bt_time);    return(bt_time);  }    void Set_Time(bintime bt_time) /*" Description:  Set the system time. */ { =    u_long status;    /* Return status from the system call */e  !    status = sys$setime(&bt_time);*    if (status != SS$_NORMAL)    {1       printf("Unable to set the system time.\n");t       Print_Error(status);    } }   " bintime FSecs2DBT(float frac_secs) /*@ Description:  Convert fractional seconds to a delta binary time. */ { E    u_long cvt_opt = LIB$K_DELTA_SECONDS_F;  /* Conversion opertion */d4    bintime bt_result;   /* The binary time result */  ?    lib$cvtf_to_internal_time(&cvt_opt, &frac_secs, &bt_result);*    return(bt_result);  }   " void *Get_ZMem(int num, int bytes) /*H Description:  Get zeroed memory.  This function returns a pointer to the@ number or requested bytes or prints a warning message and exits. */ {f-    void *memptr;  /* Pointer to the memory */       memptr = calloc(num, bytes);t    if (memptr == NULL)    {4       printf("Cannot allocate requested memory.\n");       exit(1);    }    return(memptr); }t   bintime Str2Bt(char *time_str) /*H Description:  This function takes the time string and converts it to the binary time equivalent.O */ {E4    dscr_s time_dscr;    /* Time string descriptor */0    bintime bt_result;   /* Binary time result */  -    time_dscr.dsc$w_length = strlen(time_str); )    time_dscr.dsc$b_dtype = DSC$K_DTYPE_T;>)    time_dscr.dsc$b_class = DSC$K_CLASS_S;o&    time_dscr.dsc$a_pointer = time_str;  &    sys$bintim(&time_dscr, &bt_result);    return(bt_result);t }c  : char *Bt2ASC(bintime bt_time, char *time_str, int str_len) /*E Description:  Accept a binary time, an empty string and the length of&H the string, and return the string time and date equivalent of the binary time.  */ {(2    dscr_s time_dscr;  /* Time string descriptor */5    u_short time_len;  /* Length of the time string */   $    time_dscr.dsc$w_length = str_len;)    time_dscr.dsc$b_dtype = DSC$K_DTYPE_T; )    time_dscr.dsc$b_class = DSC$K_CLASS_S;c&    time_dscr.dsc$a_pointer = time_str;  2    sys$asctim(&time_len, &time_dscr, &bt_time, 0);D    time_str[time_len] = '\0'; /* Don't forget that null character */    return(time_str); }-  - int Bt_gt(bintime bt_time1, bintime bt_time2)  /*+ Description:  Return (bt_time1 > bt_time2).t */ {).    return((bt_time1.qd_hi > bt_time2.qd_hi) ||0           ((bt_time1.qd_hi == bt_time2.qd_hi) &&/            (bt_time1.qd_lo > bt_time2.qd_lo)));  }u  - int Bt_lt(bintime bt_time1, bintime bt_time2)t /*+ Description:  Return (bt_time1 < bt_time2).  */ {).    return((bt_time1.qd_hi < bt_time2.qd_hi) ||0           ((bt_time1.qd_hi == bt_time2.qd_hi) &&/            (bt_time1.qd_lo < bt_time2.qd_lo)));  }   - int Bt_ge(bintime bt_time1, bintime bt_time2)d /*- Description:  Return (bt_time1 >=  bt_time2).p */ {*.    return((bt_time1.qd_hi > bt_time2.qd_hi) ||0           ((bt_time1.qd_hi == bt_time2.qd_hi) &&0            (bt_time1.qd_lo >= bt_time2.qd_lo))); }i  - int Bt_eq(bintime bt_time1, bintime bt_time2)o /*, Description:  Return (bt_time1 == bt_time2). */ {n/    return((bt_time1.qd_hi == bt_time2.qd_hi) &&u.           (bt_time1.qd_lo == bt_time2.qd_lo)); }   @ void Bt2SecsRem(bintime bt_time, long *seconds, long *remainder) /*B Description:  Convert a binary time to seconds and a remainder (inA hundred nanoseconds per second).  This function does not handle al negative binary time.e */ {/1    long nsps;        /* Nanoseconds per second */o      nsps = NSPS;y1    lib$ediv(&nsps, &bt_time, seconds, remainder);m?    *seconds = (*seconds * (NSPS / HNSPS)) + *remainder / HNSPS;_#    *remainder = *remainder % HNSPS;S })   l_fp Bt2Lfp(bintime bt_time) /*F Description:  Convert a binary time to a long fixed point (ntp type). E Care must be taken.  Since 1995, the number of seconds in binary time G will no longer fit into l_fp.  One solution is to subtract bt_utcoffset=E so that the resulting value is in line with the ntp protocol expects.N */ { 2    l_fp lfp_time;    /* A long fixed point time */1    long nsps;        /* Nanoseconds per second */*5    long quotient;    /* Quotient from the division */ :    long remainder;   /* The remainder from the division */5    bintime bt_frac;  /* Fraction of time in binary */e  3    Bt2SecsRem(bt_time, &lfp_time.l_ui, &remainder);o,    bt_frac.qd_hi = remainder;    /* << 32 */    bt_frac.qd_lo = 0;n3    Bt2SecsRem(bt_frac, &lfp_time.l_uf, &remainder);w>    lfp_time.l_uf += remainder / (HNSPS / 2);    /* Round up */    return(lfp_time); }   * bintime MultHigh(u_long num1, u_long num2) /*D Description:  Mutiply by the high bit only and return the value as a binary time. */ {d;    bintime bt_result;      /* The result of the multiply */x  )    bt_result.qd_hi = bt_result.qd_lo = 0;d    if (num1 & HIGHBIT_MASK)n1    {                             /* num2 << 31 */e       bt_result.qd_hi = num2; 4       bt_result.qd_lo = (bt_result.qd_hi & 1) << 31;       bt_result.qd_hi >>= 1;    }    return(bt_result);= }t  7 bintime EMultUl(u_long multiplier, u_long multiplicand)e /*D Description:  Do an extended multiply with unsigned long numbers and# return the result as a binary time.= */ {_8    bintime bt_result;   /* The result of the multiply */D    bintime bt_high1;    /* Value of multiplying by high order bit */D    bintime bt_high2;    /* Value of multiplying by high order bit */@    long addend;         /* The addend of an extended multiply */      addend = 0;1    bt_high1 = MultHigh(multiplier, multiplicand);5    multiplier &= MASK_HIGHBIT;1    bt_high2 = MultHigh(multiplicand, multiplier);u     multiplicand &= MASK_HIGHBIT;=    lib$emul(&multiplier, &multiplicand, &addend, &bt_result); 2    lib$addx(&bt_high1, &bt_result, &bt_result, 0);2    lib$addx(&bt_high2, &bt_result, &bt_result, 0);    return(bt_result);  }   2 bintime EMultL(long multiplier, long multiplicand) /*F Description:  Do an extended multiply with long numbers and return the result as a binary time. */ { >    long addend;         /* Addend for the extended multiply */<    bintime bt_result;   /* Resut of the extended multiply */      addend = 0;=    lib$emul(&multiplier, &multiplicand, &addend, &bt_result);     return(bt_result);o }N   bintime Lfp2Bt(l_fp lfp_time)  /*E Description:  Convert a long fixed point (ntp type) value to a binary   time and return the binary time. */ { .    bintime bt_result;   /* The final result */5    bintime bt_frac;     /* Fractional part of time */ 9    bintime bt_int;      /* Integer portion of the time */)0    bintime bt_round;    /* Number to round on */0    u_long frac_secs;    /* Fractional seconds */1    u_long multiplier;   /* Multiplier for time */m      bt_round.qd_hi = 0;!    bt_round.qd_lo = HIGHBIT_MASK;     multiplier = HNSPS;B    bt_frac = Bt_Add(EMultUl(multiplier, lfp_time.l_uf), bt_round);/    bt_frac.qd_lo = bt_frac.qd_hi;   /* >> 32 */.    bt_frac.qd_hi = 0;t/    bt_int = EMultUl(multiplier, lfp_time.l_ui);l.    lib$addx(&bt_frac, &bt_int, &bt_result, 0);    return(bt_result);  }i  2 bintime Bt_Sub(bintime bt_time1, bintime bt_time2) /*+ Description:  Return (bt_time1 - bt_time2).r */ {e4    bintime bt_result;   /* Result of the subtract */  1    lib$subx(&bt_time1, &bt_time2, &bt_result, 0);     return(bt_result);  }_  2 bintime Bt_Add(bintime bt_time1, bintime bt_time2) /*+ Description:  Return (bt_time1 + bt_time2).e */ {,4    bintime bt_result;   /* Result of the addition */  1    lib$addx(&bt_time1, &bt_time2, &bt_result, 0);     return(bt_result);/ }p   bintime Bt_Abs(bintime bt_time)  /*" Description:  Return abs(bt_time). */ {t    if (Bt_lt(bt_time, bt_zero))_)       bt_time = Bt_Sub(bt_zero, bt_time);s    return(bt_time);  }y  , bintime Bt_ShiftR(bintime bt_time, int bits) /*( Description:  Return (bt_time1 >> bits). */ {     if (bits < 32)r    {       bt_time.qd_lo >>= bits; J       bt_time.qd_lo |= (bt_time.qd_hi & ((2 << bits) - 1)) << (32 - bits);       bt_time.qd_hi >>= bits;     }    elsen    {3       bt_time.qd_lo = bt_time.qd_hi >> (bits - 32);e       bt_time.qd_hi >>= 32;o    }    return(bt_time);  }d   l_fp ntohl_fp(l_fp lfp_time) /*E Description:  Accept a long fixed point time, convert it from networks- to host order long fixed point and return it.r */ {o(    lfp_time.l_ui = ntohl(lfp_time.l_ui);(    lfp_time.l_uf = ntohl(lfp_time.l_uf);    return(lfp_time); }f   l_fp htonl_fp(l_fp lfp_time) /*B Description:  Convert a long fixed point time from host to network byte order and return it.e */ {t(    lfp_time.l_ui = htonl(lfp_time.l_ui);(    lfp_time.l_uf = htonl(lfp_time.l_uf);    return(lfp_time); }   * int Lfp_eq(l_fp lfp_time1, l_fp lfp_time2) /*. Description:  Return (lfp_time1 == lfp_time2). */ { /    return((lfp_time1.l_ui == lfp_time2.l_ui) &&h.           (lfp_time1.l_uf == lfp_time2.l_uf)); }n  * int Lfp_ge(l_fp lfp_time1, l_fp lfp_time2) /*. Description:  Return (lfp_time1 >= lfp_time2). */ { .    return((lfp_time1.l_ui > lfp_time2.l_ui) ||0           ((lfp_time1.l_ui == lfp_time2.l_ui) &&0            (lfp_time1.l_uf >= lfp_time2.l_uf))); }    int Dst(bintime bt_time) {S /*F Description:  This function returns true or false depending on whether: the given time is during the Daylight Savings Time period.;   Convert the given binary time into numeric time.  Use the H same year and find the binary time of the beginning of DST.  If a day ofF the week was specified, adjust the beginning of DST to that particular+ day.  Do the same thing for the end of DST.;D    Convert the begin DST, end DST, and time to seconds of the year. G Then return the result of whether the time falls into the period of DSTi or not. C    The day-of-week adjustment requires the dow number to be 0 to 6,.G Sunday through Saturday.  VMS dow is 1 to 7, Monday through Sunday, and{G the defines for DST are 1 to 7, Sunday through Saturday.  These numbers ? are modified before being given to the dow adjustment function.* */  <    numtim timbuf;    /* Buffer for storing "numeric time" */H    bintime bt_bdst;  /* Begin of Daylight Savings Time in binary time */F    bintime bt_edst;  /* End of Daylight Savings Time in binary time */-    u_long day_num;   /* Day of week number */d)    u_long cvt_opt = LIB$K_SECOND_OF_YEAR;e:    u_long bdst_secs; /* Seconds in year of begin of DST */8    u_long edst_secs; /* Seconds in year of end of DST */2    u_long time_secs; /* Seconds in year of time */  I    if (DSTON_DOW < 0 || DSTOFF_DOW < 0) return(0); /* Check turned off */   M    sys$numtim(&timbuf, &bt_time);      /* Convert bin time to numeric time */eE    timbuf.mon = DSTON_MON;             /* Insert begin of DST info */n    timbuf.day = DSTON_DOM;    timbuf.hr = DSTON_TIM / 100;i     timbuf.min = DSTON_TIM % 100;    timbuf.sec = 0;    timbuf.hun = 0;L    lib$cvt_vectim(&timbuf, &bt_bdst);  /* Get begin of DST in binary time */K    if (DSTON_DOW)                      /* Begin on specific day of week? */     {*       lib$day_of_week(&bt_bdst, &day_num);?       Dow_Adj(day_num % 7, DSTON_DOW - 1, DSTON_CMP, &bt_bdst);     }  C    timbuf.mon = DSTOFF_MON;            /* Insert end of DST info */     timbuf.day = DSTOFF_DOM;t     timbuf.hr = DSTOFF_TIM / 100;!    timbuf.min = DSTOFF_TIM % 100;t    timbuf.sec = 0;    timbuf.hun = 0;J    lib$cvt_vectim(&timbuf, &bt_edst);  /* Get end of DST in binary time */I    if (DSTOFF_DOW)                     /* End on specific day of week? */n    {*       lib$day_of_week(&bt_edst, &day_num);A       Dow_Adj(day_num % 7, DSTOFF_DOW - 1, DSTOFF_CMP, &bt_edst);<    }I                                        /* Get seconds in year for each */ >    lib$cvt_from_internal_time(&cvt_opt, &bdst_secs, &bt_bdst);>    lib$cvt_from_internal_time(&cvt_opt, &edst_secs, &bt_edst);>    lib$cvt_from_internal_time(&cvt_opt, &time_secs, &bt_time);  ;    return(bdst_secs <= time_secs && time_secs < edst_secs);v }l  @ void Dow_Adj(int cur_dow, int new_dow, int cmp, bintime *bt_dst) {t /*E Description:  This function calculates the number of days to adjust anC time in order for the current day of week to be the new day of week   based on a specified comparison.D    This allows a person to find the first new day of week before theE current day, before or on the current day, after the current day, andn after or on the current day.H    If any days were calculated for adjustment, the days are converted to@ binary time and then added to or subtracted from the given time. */  8    int days;         /* Number of days to adjust time */9    bintime bt_dayadj;/* Days adjustment in binary time */=      days = 0;    switch (cmp)     {
       case 0:           break;<       case 1: /* < before */#       case 2: /* <= before or on */>-          days -= (cur_dow - new_dow + 7) % 7; *          if (cmp == 1 && !days) days = -7;          break;        case 3: /* > after */ "       case 4: /* >= after or on */,          days = (new_dow - cur_dow + 7) % 7;)          if (cmp == 3 && !days) days = 7;3          break;        default:          break;d    }  .    if (days)         /* Any days to adjust? */    {7       bt_dayadj = EMultUl(abs(days) * DAY_SECS, HNSPS);        if (days > 0) .          *bt_dst = Bt_Add(*bt_dst, bt_dayadj);
       else.          *bt_dst = Bt_Sub(*bt_dst, bt_dayadj);    } }1  ( char *Bt2Str(bintime bt_time, char *str) /*G Description:  Convert a binary time to its string equivalent in secondss< and fractions thereof.  We assume the string is long enough. */ {(9    int is_neg;       /* True if the number is negative */n"    long seconds;     /* Seconds *//    long remainder;   /* Remainder of seconds */e      is_neg = FALSE;    if (bt_time.qd_hi < 0)     {       is_neg = TRUE;        bt_time = Bt_Abs(bt_time);    }-    Bt2SecsRem(bt_time, &seconds, &remainder); E    sprintf(str, "%s%d.%07d", is_neg ? "-" : "+", seconds, remainder);     return(str);  }    void Print_Server(server *sptr)  /*5 Description:  Print the information about the server.  */ { >    int cnt;             /* Count through the filter entries */?    bintime bt_offset;   /* Offset of true time from our time */ 6    bintime bt_tmp;      /* Temporarily holds a time */@    char time_str[MAX_TIMESTR];   /* Holds time in string form */9    char tmp_str[5];     /* Holds bytes of reference id */2      bt_offset = bt_zero;2K    if (Dst(Bt_Add(Get_Time(), sptr->offset)))  /* Daylight savings time? */        bt_offset = bt_dstadj;    bt_tmp.qd_hi = 0;    bt_tmp.qd_lo = sptr->delay;"    if (!debug)    /* Short form */    {,       printf("Server %s (%s), stratum %d\n",              sptr->hostname,:              inet_ntoa(sptr->s_addr.addr), sptr->stratum);:       printf("offset %s, ", Bt_eq(sptr->offset, bt_zero) ?$          Bt2Str(bt_zero, time_str) :<          Bt2Str(Bt_Add(sptr->offset, bt_offset), time_str));5       printf("delay %s\n", Bt2Str(bt_tmp, time_str));]    }!    else           /* Long form */r    {9       printf("server %s (%s), port %d\n", sptr->hostname,o	 #if CMUIPn@                inet_ntoa(sptr->s_addr.addr), sptr->s_addr.port); #elsesG                inet_ntoa(sptr->s_addr.addr), ntohs(sptr->s_addr.port));  #endif5       printf("stratum %d, precision %d, leap %c%c\n", .                sptr->stratum, sptr->precision,,                sptr->leap & 0x2 ? '1' : '0',-                sptr->leap & 0x1 ? '1' : '0'); K       if (sptr->stratum == 1)    /* Primary servers have names of clocks */ :       {                          /* for the time source */          tmp_str[4] = 0;
 #if 1	/*wjm*/_,          memcpy(tmp_str, &(sptr->refid), 4); #elsel)          memcpy(tmp_str, sptr->refid, 4);* #endif	/*wjm*/(          printf("refid [%s] ", tmp_str);       }h
       elseL          printf("refid [%lu] ", sptr->refid);   /* Others have IP numbers */4       printf("delay %s ", Bt2Str(bt_tmp, time_str));C       printf("dispersion %s ", Bt2Str(sptr->dispersion, time_str));(<       printf("offset %s\n\n", Bt_eq(sptr->offset, bt_zero) ?$          Bt2Str(bt_zero, time_str) :<          Bt2Str(Bt_Add(sptr->offset, bt_offset), time_str));.       printf("transmitted %d, in filter %d\n",-          sptr->xmtcnt, sptr->filter_nextpkt);t)       printf("reference time:      %s\n", J          Bt2ASC(Bt_Add(sptr->reftime, bt_offset), time_str, MAX_TIMESTR));)       printf("originate timestamp: %s\n",cF          Bt2ASC(Bt_Add(sptr->org, bt_offset), time_str, MAX_TIMESTR));)       printf("transmit timestamp:  %s\n", 3          Bt2ASC(sptr->xmt, time_str, MAX_TIMESTR));)%       printf("filter delay:       ");        bt_tmp.qd_hi = 0; I       for (cnt = 0; cnt < NTP_SHIFT; cnt++)     /* Print filter delays */e       {:0          bt_tmp.qd_lo = sptr->filter_delay[cnt];5          printf(" %-8.8s", Bt2Str(bt_tmp, time_str)); K          if (cnt == (NTP_SHIFT >> 1) - 1) printf("\n                    ");        }l       printf("\n");i  %       printf("filter offset:      "); J       for (cnt = 0; cnt < NTP_SHIFT; cnt++)     /* Print filter offsets */       { E          printf(" %-8.8s", Bt_eq(sptr->filter_offset[cnt], bt_zero) ?s'             Bt2Str(bt_zero, time_str) : K             Bt2Str(Bt_Add(sptr->filter_offset[cnt], bt_offset), time_str)); K          if (cnt == (NTP_SHIFT >> 1) - 1) printf("\n                    ");c       }s       printf("\n\n");     } } 