: /* handle IP packets (in particular VJ header compression);  *	"in" direction: forward to IPTRANS (PPPMBX or eqivalent) (  *	"out" direction: forward to tty_out()  */    #include "ppp.h" #include "pppprot.h" #include "ipcp.h"    #include "rfc1144_user.h"    #include <stdio.h> #include <stdlib.h>  #include <assert.h>    #include <descrip.h>   static int active;$ static struct slcompress sl_context;    3 /* mainline calls init_ip(), and also ip_input() */  void init_ip(void) {	 	int sts;    	if(active) return;   " 	/* take care of VJ compression */" 	if(ipcp_params.comprs_in.vj_ok) {4 		assert(ipcp_params.comprs_in.m == MAX_STATES - 1); 	}# 	if(ipcp_params.comprs_out.vj_ok) { 5 		assert(ipcp_params.comprs_out.m == MAX_STATES - 1);  	}B 	if(ipcp_params.comprs_in.vj_ok || ipcp_params.comprs_out.vj_ok) {2 		assert(sizeof(sl_context) == slcompress_size());  		sl_compress_init(&sl_context); 	}   	active = 1;   	init_iptrans();  I 	printf("===== ready to start IP - lcl= %d.%d.%d.%d  rem= %d.%d.%d.%d\n", ( 		(ipcp_params.ipaddr_lcl >> 24) & 0xFF,( 		(ipcp_params.ipaddr_lcl >> 16) & 0xFF,( 		(ipcp_params.ipaddr_lcl >>  8) & 0xFF,( 		(ipcp_params.ipaddr_lcl >>  0) & 0xFF,( 		(ipcp_params.ipaddr_rem >> 24) & 0xFF,( 		(ipcp_params.ipaddr_rem >> 16) & 0xFF,( 		(ipcp_params.ipaddr_rem >>  8) & 0xFF,) 		(ipcp_params.ipaddr_rem >>  0) & 0xFF);  }    /* turn off IP */  void close_ip(void) {  	active = 0; }     4 /* IP input (MBX output) routine for use by mainline.  *  - eventually disposes of the PPPBUF passed  */  void ip_input(PPPBUF *bp) {  	int new_boff;
 	uchar *p;   	if(!active) { 		free_pppbuf(bp);	 		return;  	}   	switch(bp->prot) { : 	  case P_IP:		/* no reason to call sl_uncompress_tcp() */ 		break;   	  case P_UTCP: 0 		if(!ipcp_params.comprs_in.vj_ok) goto discard; 			 ? 		/* sl_uncompress_tcp() isn't supposed to modify the packet */ 3 		p = sl_uncompress_tcp(bp->buf + bp->boff,bp->len, - 				      TYPE_UNCOMPRESSED_TCP,&sl_context); " 		assert(p == bp->buf + bp->boff); 		break;   	  case P_CTCP: 0 		if(!ipcp_params.comprs_in.vj_ok) goto discard;  6 		if(bp->boff < MAX_HDR) {	/* have to make room ... */ 			PPPBUF *bp2;   ) 			bp2 = alloc_pppbuf(MAX_HDR + bp->len);  			bp2->prot = bp->prot; 			bp2->boff = MAX_HDR; $ 			bp2->len = bp->len;	/* for now */9 			memcpy(bp2->buf + MAX_HDR,bp->buf + bp->boff,bp->len);  			free_pppbuf(bp);  			bp = bp2; 		} 3 		p = sl_uncompress_tcp(bp->buf + bp->boff,bp->len, + 				      TYPE_COMPRESSED_TCP,&sl_context);  		new_boff = p - bp->buf;  		assert(new_boff >= 0);! 		bp->len += bp->boff - new_boff;  		bp->boff = new_boff; 		break;   	  default: 
 		abort(); 	}   	/* forward to IPTRANS */  	iptrans_in(bp);   	return;   discard: 	free_pppbuf(bp);  	return; }     1 /* ip_output() called (at AST level) from IPTRANS 1  * NOTE: ought not interfere with "in" direction, <  *	since `sl_context' data are separate for either direction  */  void ip_output(PPPBUF *bp) {   	if(!active) { 		free_pppbuf(bp);	 		return;  	}  # 	if(ipcp_params.comprs_out.vj_ok) {  		struct mbuf sl_mb;  # 		sl_mb.m_off = bp->buf + bp->boff;  		sl_mb.m_len = bp->len;, 		switch(sl_compress_tcp(&sl_mb,&sl_context,' 				       ipcp_params.comprs_out.c)) {  		  case TYPE_IP:  			bp->prot = P_IP; 	 			break;  		  case TYPE_UNCOMPRESSED_TCP:  			bp->prot = P_UTCP; 	 			break;  		  case TYPE_COMPRESSED_TCP:  			bp->prot = P_CTCP; 	 			break;  		  default: 			abort();  		} # 		bp->boff = sl_mb.m_off - bp->buf;  		bp->len = sl_mb.m_len; 	}   	/* send to serial line */
 	tty_out(bp);  } 