 /* IPCP negotiation ... */   #include "ppp.h" #include "pppprot.h" #include "lcp.h" #include "ipcp.h"  #include "state.h"   #include <string.h>   . /* check IPCP message length vs. buffer length*  *  and option lengths vs. message length.,  * return message length if all o.k., else 0  */ " extern uint16 llcheck(PPPBUF *bp);   static int/*logical*/ active;      /* our own CNFREQ */ /*  / -	COMPRS	desired, with _fixed_ parameters only  = -	IPADDR	to be learned (or defaulted if 0.0.0.0 not rejected)   */    static struct {  	int retry;  	uint32 ipaddr; 
 	uint16 bufl; 4 	uchar comprs_vj_ok;		/* incoming VJ compression? */6 	uchar buf[4 + 6 + 6];		/* room for COMPRS & IPADDR */ } ocnf;   0 static void start_ip_cnfreq(void);	/* forward *// static void send_ip_cnfreq(void);	/* forward */   " static void init_ip_cnfreq(void) { 	ocnf.ipaddr = 0; 1 	ocnf.comprs_vj_ok = ipcp_params.comprs_in.vj_ok;    	start_ip_cnfreq();  }   # static void start_ip_cnfreq(void) {  	uchar *cp;    	ocnf.buf[0] = C_CNFREQ;! 	ocnf.buf[1] ++;			/* sequence */    	cp = ocnf.buf + 4;    	if(ocnf.comprs_vj_ok) { 		uint16 cprot = P_CTCP;   		*cp++ = O_COMPRS;  		*cp++ = 6; 		STORE16(cp,cprot);" 		*cp++ = ipcp_params.comprs_in.m;" 		*cp++ = ipcp_params.comprs_in.c; 	}   	*cp++ = O_IPADDR; 	*cp++ = 6;  	STORE32(cp,ocnf.ipaddr);    	ocnf.bufl = cp - ocnf.buf;  	cp = ocnf.buf + 2;  	STORE16(cp,ocnf.bufl);    	ocnf.retry = max_configure; 	send_ip_cnfreq(); }    /* maybe called from timer */ " static void send_ip_cnfreq(void) { 	PPPBUF *bp;   	if(!active) return;   	if(ocnf.retry-- <= 0) { 		set_state(T_IPCPREQ_FAILED);	 		return;  	}   	bp = alloc_pppbuf(ocnf.bufl); 	bp->boff = 0;$ 	memcpy(bp->buf,ocnf.buf,ocnf.bufl); 	bp->len = ocnf.bufl;  	bp->prot = P_IPCP;  	 
 	tty_out(bp);   ) 	set_timer(send_ip_cnfreq,restart_timer);  }   ' static void rcv_ip_cnfrej(PPPBUF *bp) {  	uint16 ll;  	uchar *cp;  	uchar rej_comprs = 0;  & 	if(!(ll = llcheck(bp))) goto discard;   	cp = bp->buf + bp->boff; 7 	if(cp[1] != ocnf.buf[1]) goto discard;		/* bad seq# */    	cp += 4; ll -= 4; 	while(ll > 0) { 		switch(*cp) {  		  case O_COMPRS: 			rej_comprs = 1;	 			break;    		  case O_IPADDR: 			/* no-op, sorry */ 	 			break;    		  default: goto discard; 		}  		ll -= cp[1]; cp += cp[1];  	}   	/* parsed o.k. */   	free_pppbuf(bp);   & 	if(rej_comprs) ocnf.comprs_vj_ok = 0;   	/* cancel timeout */  	clr_timer(send_ip_cnfreq);    	start_ip_cnfreq();  	return;   discard: 	free_pppbuf(bp);  	return; }   ' static void rcv_ip_cnfnak(PPPBUF *bp) {  	uint16 ll;  	uint32 tmp_ipaddr;  	uint16 tmp_comprs_p; ! 	uchar tmp_comprs_m,tmp_comprs_c;  	uchar *cp;  	uchar nak_comprs = 0, 	      nak_ipaddr = 0;  & 	if(!(ll = llcheck(bp))) goto discard;   	cp = bp->buf + bp->boff; 7 	if(cp[1] != ocnf.buf[1]) goto discard;		/* bad seq# */    	cp += 4; ll -= 4; 	while(ll > 0) { 		switch(*cp) {  			uchar *cp1;   		  case O_COMPRS: 			if(cp[1] < 4) goto discard;' 			if(!ocnf.comprs_vj_ok) goto discard;  			nak_comprs = 1; 			cp1 = cp + 2; 			FETCH16(cp1,tmp_comprs_p);  			if(tmp_comprs_p == P_CTCP) {   				if(cp[1] != 6) goto discard; 				tmp_comprs_m = *cp1++; 				tmp_comprs_c = *cp1++;- 			} /* else no idea about additional data */  			ll -= cp[1]; cp += cp[1];	 			break;    		  case O_IPADDR: 			if(cp[1] != 6) goto discard;  			cp += 2;  			nak_ipaddr = 1; 			FETCH32(cp,tmp_ipaddr); 			ll -= 6; 	 			break;    		  default: goto discard; 		}  	}   	/* parsed o.k. */   	free_pppbuf(bp);    	if(nak_comprs) {  		if(tmp_comprs_p != P_CTCP) {0 			ocnf.comprs_vj_ok = 0;	/* unknown protocol */
 		} else { 			/* might look at _m & _c */8 			ocnf.comprs_vj_ok = 0;	/* only support the default */ 		}  	}   	if(nak_ipaddr) {  		ocnf.ipaddr = tmp_ipaddr;  	}   	/* cancel timeout */  	clr_timer(send_ip_cnfreq);    	start_ip_cnfreq();  	return;   discard: 	free_pppbuf(bp);  	return; }     ' static void rcv_ip_cnfack(PPPBUF *bp) {  	uint16 ll;  	uchar ack_ipaddr; 	uint32 tmp_ipaddr;  	uchar *cp;   & 	if(!(ll = llcheck(bp))) goto discard;   	cp = bp->buf + bp->boff; 7 	if(cp[1] != ocnf.buf[1]) goto discard;		/* bad seq# */   : 	if(ll != ocnf.bufl) goto discard;	/* mismatch if false */  + 	/* explicitly check for returned IPADDR */  	cp += 4; ll -= 4; 	while(ll > 0) { 		switch(*cp) {  		  case O_COMPRS:' 			if(!ocnf.comprs_vj_ok) goto discard;  			/* assume matching data */  			ll -= cp[1]; cp += cp[1];	 			break;    		  case O_IPADDR: 			if(cp[1] != 6) goto discard;  			cp += 2;  			ack_ipaddr = 1; 			FETCH32(cp,tmp_ipaddr); 			ll -= 6; 	 			break;    		  default: goto discard; 		}  	} 	if(!ack_ipaddr) goto discard;   	/* parsed o.k. */   	free_pppbuf(bp);   ( 	/* allow for changing IPADDR w/o NAK */ 	if(ack_ipaddr) {  		ocnf.ipaddr = tmp_ipaddr;  	}   	/* cancel timeout */  	clr_timer(send_ip_cnfreq);   ( 	/* we can't start with a zero IPADDR */ 	if(ocnf.ipaddr == 0) {  		/* default IPADDR *// 		ocnf.ipaddr = ipcp_params.ipaddr_lcl_default;    		start_ip_cnfreq();	 		return;  	}  1 	/* establish negotiated input ipaddr & comprs */ & 	ipcp_params.ipaddr_lcl = ocnf.ipaddr;1 	ipcp_params.comprs_in.vj_ok = ocnf.comprs_vj_ok;    	set_state(T_IPCPREQ_DONE);    	return;   discard: 	free_pppbuf(bp);  	return; }      /* peer's CNFREQ */  /*  - 	COMPRS	accepted only with default parameters 3 	IPADDR	accepted if nonzero, else nak(some default)   */   ' static void rcv_ip_cnfreq(PPPBUF *bp) { 
 	uint16 ll,l;  	uchar *cp,*op;  	uint32 tmp_ipaddr;  	uint16 tmp_comprs_p; ! 	uchar tmp_comprs_m,tmp_comprs_c;  	uchar req_ipaddr = 0, 	      req_comprs = 0;  & 	if(!(ll = llcheck(bp))) goto discard;   	cp = bp->buf + bp->boff;    	cp += 4; l = ll - 4;  	while(l > 1) {  		switch(*cp) {  			uchar *cp1;   		  case O_COMPRS:. 			if(!ipcp_params.comprs_out.vj_ok) goto rej; 			if(cp[1] != 6) goto nak;  			cp1 = cp + 2; 			FETCH16(cp1,tmp_comprs_p); ' 			if(tmp_comprs_p != P_CTCP) goto nak;  			tmp_comprs_m = *cp1++;  			tmp_comprs_c = *cp1++; 1 			if(tmp_comprs_m != ipcp_params.comprs_out.m || 9 			   tmp_comprs_c != ipcp_params.comprs_out.c) goto nak;  			req_comprs = 1; 			cp += 6; l -= 6; 	 			break;    		  case O_IPADDR: 			if(cp[1] != 6) goto nak;  			cp1 = cp + 2; 			FETCH32(cp1,tmp_ipaddr);   			if(tmp_ipaddr == 0) goto nak; 			req_ipaddr = 1; 			cp += 6; l -= 6; 	 			break;    		  default: 			goto rej; 		}  	}   	/* parsed o.k. */  ( 	/* convert to CNFACK & send as reply */" 	*(bp->buf + bp->boff) = C_CNFACK;
 	tty_out(bp);   4 	if(req_ipaddr) ipcp_params.ipaddr_rem = tmp_ipaddr;  + 	ipcp_params.comprs_out.vj_ok = req_comprs;    	set_state(T_IPCPACK_DONE);    	return;  9 nak:	/* cp -> offending item; only NAK the current one */  	op = bp->buf + bp->boff + 4; 
 	*op++ = *cp;  	switch(*cp) { 	  case O_IPADDR:  		l = *op++ = 6;- 		STORE32(op,ipcp_params.ipaddr_rem_default);  		break; 	  case O_COMPRS: - 		if(!ipcp_params.comprs_out.vj_ok) goto rej; ; 		if(bp->len < 4 + 6) goto rej;	/* will this ever occur? */  		l = *op++ = 6;2 		tmp_comprs_p = P_CTCP; STORE16(op,tmp_comprs_p);# 		*op++ = ipcp_params.comprs_out.m; # 		*op++ = ipcp_params.comprs_out.c;  		break; 	  default:  		goto rej;  	} 	ll = l + 4; 	op = bp->buf + bp->boff;  	*op++ = C_CNFNAK; 	op++; 	STORE16(op,ll); 	bp->len = ll;  
 	tty_out(bp);  	return; 	 < rej:	/* cp -> offending item; only reject the current one */ 	op = bp->buf + bp->boff;  	l = cp[1];  	if(cp != op + 4) {  		int i;  + 		for(i = 0; i < l; i++) op[i + 4] = cp[i];  	} 	ll = l + 4; 	*op++ = C_CNFREJ; 	op++; 	STORE16(op,ll); 	bp->len = ll;  
 	tty_out(bp);  	return;   discard: 	free_pppbuf(bp);  	return; }     ! void send_ip_coderj(PPPBUF *bp) {  	PPPBUF *bp2 = NULL; 	uint16 ll;  	uchar *op;  	static uchar seq = 0;   	if(bp->boff >= 4) { 		bp->boff -= 4; 		ll = bp->len += 4; 		op = bp->buf + bp->boff;	 	} else { " 		bp2 = alloc_pppbuf(bp->len + 4); 		bp2->boff = 0; 		ll = bp2->len = bp->len + 4; 		bp2->prot = P_IPCP;  		op = bp2->buf; 	} 	*op++ = C_CODERJ; 	*op++ = ++seq;  	STORE16(op,ll);
 	if(bp2) {( 		memcpy(op,bp->buf + bp->boff,bp->len); 		tty_out(bp2);  		free_pppbuf(bp);	 	} else {  		tty_out(bp); 	} }      /* dispatch packets for IPCP */  void ipcp_input(PPPBUF *bp) {  	uchar *cp;     	if(bp->prot != P_IPCP) abort();   	if(!active) goto discard;  6 	if(bp->len < 4) goto discard;		/* ??? maybe coderj */ 	cp = bp->buf + bp->boff;  	switch(*cp) { 	  case C_CNFREQ: & 		rcv_ip_cnfreq(bp); bp = NULL; break; 	  case C_CNFACK: & 		rcv_ip_cnfack(bp); bp = NULL; break; 	  case C_CNFNAK: & 		rcv_ip_cnfnak(bp); bp = NULL; break; 	  case C_CNFREJ: & 		rcv_ip_cnfrej(bp); bp = NULL; break; 	  case C_TRMREQ: $ 		*cp = C_TRMACK;		/* quick reply */ 		tty_out(bp); bp = NULL; ' 		set_state(T_TRMREQ);		/* fatal ??? */  		break; 	  case C_TRMACK: ' 		set_state(T_TRMACK);		/* fatal ??? */  		break; 	  case C_CODERJ: ( 		set_state(T_CODEREJ);		/* fatal ??? */ 		break; 	  default: ' 		send_ip_coderj(bp); bp = NULL; break;  	}   	if(bp == NULL) return;    discard: 	free_pppbuf(bp);  	return; }      /* IPCP init */  void init_ipcp(void) { 	  	if(active) return;   : 	/* ipcp_params.ipaddr_*_default must be set externally */  9 	ipcp_params.ipaddr_lcl = ipcp_params.ipaddr_lcl_default; 9 	ipcp_params.ipaddr_rem = ipcp_params.ipaddr_rem_default;   6 	/* set (fixed & default) VJ compression parameters */4 	ipcp_params.comprs_in.vj_ok = 1;	/* do allow ... */7 	ipcp_params.comprs_in.m = 0x0F;			/* VJ max-slot-id */ 5 	ipcp_params.comprs_in.c = 1;			/* VJ comp-slot-id */   5 	ipcp_params.comprs_out.vj_ok = 1;	/* do allow ... */ 7 	ipcp_params.comprs_out.m = 0x0F;		/* VJ max-slot-id */ 6 	ipcp_params.comprs_out.c = 1;			/* VJ comp-slot-id */   	/* get us going */  	active = 1; 	init_ip_cnfreq(); }    void close_ipcp(void) {  	active = 0; } 