? /* LCP protocol supporting at most a single open/close cycle */    #include "ppp.h" #include "pppprot.h" #include "lcp.h" #include "state.h"   #include <string.h>     typedef enum {EV_START,EV_CLOSE, 	EV_TOplus,EV_TOminus,' 	EV_RCRplus,EV_RCRminus,	EV_RCA,EV_RCN, " 	EV_RTR,EV_RTA,EV_RXJminus} EVENT;  - static enum {st3,st45,st6,st7,st8,st9} state;    static int retry;    static struct { 
 	uint32 accm;  	uchar accm_ok;  	uchar pfc_ok; 	uchar acfc_ok; 
 	uint16 bufl; < 	uchar buf[4 + 6 + 2 + 2];		/* <<<<< given current policy */ } ocnf;    static struct {  	uchar buf[4]; } otrm;   5 static int/*logical*/ lcp_event(EVENT);	/* forward */    /* our own CNFREQ */ /*  ( 	MRU	always use default (PPP_MRU = 1500)8 -	ACCM	desired "minimum" specified by TTY; => cur_accm_i 	AP	not used 	MAGIC	not used (yet)  -	PFC	desired; noop  -	ACFC	desired; noop  */   5 static void send_cnfreq(void) {			/* "scr" (retry) */  	PPPBUF *bp;   	bp = alloc_pppbuf(ocnf.bufl); 	bp->boff = 0;$ 	memcpy(bp->buf,ocnf.buf,ocnf.bufl); 	bp->len = ocnf.bufl;  	bp->prot = P_LCP; 	 
 	tty_out(bp);   	 	retry--;  }   ; static void start_cnfreq(void) {		/* "scr" (new request) */  	uchar *cp;    	ocnf.buf[0] = C_CNFREQ;! 	ocnf.buf[1] ++;			/* sequence */    	cp = ocnf.buf + 4;  	if(ocnf.accm_ok) {  		*cp++ = O_ACCM;  		*cp++ = 6; 		STORE32(cp,ocnf.accm); 	} 	if(ocnf.pfc_ok) { 		*cp++ = O_PFC; 		*cp++ = 2; 	} 	if(ocnf.acfc_ok) {  		*cp++ = O_ACFC;  		*cp++ = 2; 	}   	ocnf.bufl = cp - ocnf.buf;  	cp = ocnf.buf + 2;  	STORE16(cp,ocnf.bufl);    	send_cnfreq();  }   = static void init_cnfreq(void) {			/* new negotiation cycle */ # 	ocnf.accm = lcp_params.accm_i_min;  	ocnf.accm_ok = 1; 	ocnf.pfc_ok = 1;  	ocnf.acfc_ok = 1;   	start_cnfreq(); }     5 static void send_trmreq(void) {			/* "str" (retry) */  	PPPBUF *bp;  % 	bp = alloc_pppbuf(sizeof(otrm.buf));  	bp->boff = 0;+ 	memcpy(bp->buf,otrm.buf,sizeof(otrm.buf));  	bp->len = sizeof(otrm.buf); 	bp->prot = P_LCP;  
 	tty_out(bp);   	 	retry--;  }   - static void start_trmreq(void) {		/* "str" */  	uchar *cp;   	uint16 bufl = sizeof(otrm.buf);   	cp = otrm.buf;  	*cp++ = C_TRMREQ; 	*cp++ += 1; 	STORE16(cp,bufl);   	send_trmreq();  }     5 /* "sta" required by protocol (not a TRMREQ reply) */  static void send_trmack(void) {  	PPPBUF *bp; 	uchar *cp;  	uint16 bufl = 4;    	bp = alloc_pppbuf(bufl);  	bp->prot = P_LCP; 	bp->boff = 0; 	bp->len = bufl;   	cp = bp->buf; 	*cp++ = C_TRMACK;5 	cp++;			/* leave seq# as is - not meaningful here */  	STORE16(cp,bufl);  
 	tty_out(bp);  }      /** input events **/  $ static void rcv_cnfrej(PPPBUF *bp) { 	uint16 ll;  	uchar *cp;  	uchar rej_accm = 0, 	      rej_pfc = 0,  	      rej_acfc = 0;  & 	if(!(ll = llcheck(bp))) goto discard;   	cp = bp->buf + bp->boff; 7 	if(cp[1] != ocnf.buf[1]) goto discard;		/* bad seq# */    	cp += 4; ll -= 4; 	while(ll > 0) { 		switch(*cp) {  		  case O_ACCM: 			rej_accm = 1;	 			break;  		  case O_PFC:  			rej_pfc = 1; 	 			break;  		  case O_ACFC: 			rej_acfc = 1;	 			break;    		  default: goto discard; 		}  		ll -= cp[1]; cp += cp[1];  	}   	/* parsed o.k. => RCN */ % 	if(!lcp_event(EV_RCN)) goto discard;   " 	/* take care of REJected codes */ 	if(rej_accm) ocnf.accm_ok = 0;  	if(rej_pfc) ocnf.pfc_ok = 0;  	if(rej_acfc) ocnf.acfc_ok = 0;    	/* send another CNFREQ */ 	start_cnfreq();   	/* drop thru */ discard: 	free_pppbuf(bp);  	return; }   $ static void rcv_cnfnak(PPPBUF *bp) { 	uint16 ll;  	uint32 tmp_accm;  	uchar *cp;  	uchar nak_accm = 0;  & 	if(!(ll = llcheck(bp))) goto discard;   	cp = bp->buf + bp->boff; 7 	if(cp[1] != ocnf.buf[1]) goto discard;		/* bad seq# */    	cp += 4; ll -= 4; 	while(ll > 0) { 		switch(*cp) {  		  case O_ACCM: 			if(cp[1] != 6) goto discard;  			cp += 2; " 			if(!ocnf.accm_ok) goto discard; 			nak_accm = 1; 			FETCH32(cp,tmp_accm); 			ll -= 6; 	 			break;    		  default: goto discard; 		}  	}   	/* parsed o.k. => RCN */ % 	if(!lcp_event(EV_RCN)) goto discard;    	/* take care of NAKed codes */  	if(nak_accm) {  		ocnf.accm |= tmp_accm; 	}   	/* send another CNFREQ */ 	start_cnfreq();   	/* drop thru */ discard: 	free_pppbuf(bp);  	return; }   $ static void rcv_cnfack(PPPBUF *bp) { 	uint16 ll;  	uchar *cp;   & 	if(!(ll = llcheck(bp))) goto discard;   	cp = bp->buf + bp->boff; 7 	if(cp[1] != ocnf.buf[1]) goto discard;		/* bad seq# */   C 	if(ll != ocnf.bufl) goto discard;	/* simplistic check for match */    	/* parsed o.k. => RCA */ % 	if(!lcp_event(EV_RCA)) goto discard;   & 	/* establish negotiated input ACCM */# 	lcp_params.accm_i_cur = ocnf.accm;    	/* drop thru */ discard: 	free_pppbuf(bp);  	return; }      /* peer's CNFREQ */  /*  6 	MRU	accept default or higher, else nak(default); noopE 	ACCM	accept "minimum" specified by TTY or more, else nak(min); => _o 3 	AP	accept PAP, else nak(PAP); => ggf. outgoing PAP  	MAGIC	accept anything; noop 	PFC	accept; => cur_pfc  	ACFC	accept; => cur_acfc   */   $ static void rcv_cnfreq(PPPBUF *bp) { 	uint16 ll,l,tmp_w;  	uchar *cp,*op;  	uint32 tmp_accm, tmp_l; 	uchar req_accm = 0, 	      req_pap = 0,  	      req_pfc = 0,  	      req_acfc = 0;  & 	if(!(ll = llcheck(bp))) goto discard;   	cp = bp->buf + bp->boff;    	cp += 4; l = ll - 4;  	while(l > 1) {  		switch(*cp) {  			uchar *cp1;   		  case O_MRU:  			if(cp[1] != 4) goto nak;  			cp1 = cp + 2; #ifndef MRU_ANY  			FETCH16(cp1,tmp_w);  			if(tmp_w < PPP_MRU) goto nak; #endif
 			/* noop */  			cp += 4; l -= 4; 	 			break;    		  case O_ACCM: 			if(cp[1] != 6) goto nak;  			cp1 = cp + 2; 			FETCH32(cp1,tmp_accm); + 			if((tmp_accm & lcp_params.accm_o_min) != & 			   lcp_params.accm_o_min) goto nak; 			req_accm = 1; 			cp += 6; l -= 6; 	 			break;    		  case O_AP:3 			if(cp[1] != 4) goto nak;	/* no params for PAP */  			cp1 = cp + 2; 			FETCH16(cp1,tmp_w); 			if(tmp_w != P_PAP) goto nak;  			req_pap = 1;  			cp += 4; l -= 4; 	 			break;    		  case O_MAGIC:  			if(cp[1] != 6) goto nak;  			/* ??? noop */  			cp += 6; l -= 6; 	 			break;    		  case O_PFC:  			if(cp[1] != 2) goto nak;  			req_pfc = 1;  			cp += 2; l -= 2; 	 			break;    		  case O_ACFC: 			if(cp[1] != 2) goto nak;  			req_acfc = 1; 			cp += 2; l -= 2; 	 			break;    		  default: 			goto rej; 		}  	}   	/* parsed o.k. => RCR+ */) 	if(!lcp_event(EV_RCRplus)) goto discard;   ( 	/* convert to CNFACK & send as reply */" 	*(bp->buf + bp->boff) = C_CNFACK;
 	tty_out(bp);    	/* remember parameters *// 	if(req_accm) lcp_params.accm_o_cur = tmp_accm; ( 	if(req_acfc) lcp_params.acfc_o_cur = 1;& 	if(req_pfc) lcp_params.pfc_o_cur = 1;' 	if(req_pap) set_state(T_PAP_REQUIRED);    	return;   nak:	/* RCR- */ * 	if(!lcp_event(EV_RCRminus)) goto discard;  / 	/* cp -> offending item (only NAK one item) */  	op = bp->buf + bp->boff + 4; 
 	*op++ = *cp;  	switch(*cp) { 	  case O_MRU: 		l = *op++ = 4;% 		tmp_w = PPP_MRU; STORE16(op,tmp_w);  		break; 	  case O_ACCM:  		l = *op++ = 6;$ 		STORE32(op,lcp_params.accm_o_min); 		break;
 	  case O_AP:  		l = *op++ = 4;# 		tmp_w = P_PAP; STORE16(op,tmp_w);  		break;3 	  case O_MAGIC:		/* only used with wrong length */  		l = *op++ = 6; 		tmp_l = 1;	/* ??? */ 		STORE32(op,tmp_l); 		break; 	  case O_PFC: 	  case O_ACFC:  		l = *op++ = 2; 		break; 	  default:  		goto rej2; 	} 	ll = l + 4; 	op = bp->buf + bp->boff;  	*op++ = C_CNFNAK; 	op++; 	STORE16(op,ll); 	bp->len = ll;  
 	tty_out(bp);  	return; 	  rej:	/* RCR- */ * 	if(!lcp_event(EV_RCRminus)) goto discard;   rej2: 2 	/* cp -> offending item (only reject one item) */ 	op = bp->buf + bp->boff;  	l = cp[1];  	if(cp != op + 4) {  		int i;  + 		for(i = 0; i < l; i++) op[i + 4] = cp[i];  	} 	ll = l + 4; 	*op++ = C_CNFREJ; 	op++; 	STORE16(op,ll); 	bp->len = ll;  
 	tty_out(bp);  	return;   discard: 	free_pppbuf(bp);  	return; }   $ static void rcv_trmreq(PPPBUF *bp) {
 	char *cp;  
 	/* RTR */ 	if(lcp_event(EV_RTR)) { 		cp = bp->buf + bp->boff;% 		*cp = C_TRMACK;			/* cheap reply */  		tty_out(bp);	 	} else {  		free_pppbuf(bp); 	} }    void rcv_trmack(PPPBUF *bp) { 
 	/* RTA */ 	lcp_event(EV_RTA);  	free_pppbuf(bp);  }   2 static void send_xxxxrj(PPPBUF *bp, uint16 code) { 	PPPBUF *bp2 = NULL; 	uint16 ll,hl; 	uchar *op;  	static uchar seq = 0;   	switch(code) {  	  case C_CODERJ:  		hl = 4; break; 	  case C_PROTRJ:  		hl = 6; break; 	  default: 
 		abort(); 	}   	if(bp->boff >= hl) {  		bp->boff -= hl;  		ll = bp->len += hl;  		op = bp->buf + bp->boff;	 	} else { # 		bp2 = alloc_pppbuf(bp->len + hl);  		bp2->boff = 0; 		ll = bp2->len = bp->len + hl;  		bp2->prot = P_LCP; 		op = bp2->buf; 	} 	*op++ = code; 	*op++ = ++seq;  	STORE16(op,ll); 	if(code == C_PROTRJ) {  		STORE16(op,bp->prot);  	}
 	if(bp2) {( 		memcpy(op,bp->buf + bp->boff,bp->len); 		tty_out(bp2);  		free_pppbuf(bp);	 	} else {  		bp->prot = P_LCP;  		tty_out(bp); 	} }     5 /* dispatch packets for LCP or unknown destination */  void lcp_input(PPPBUF *bp) { 	uchar *cp;   % 	/* PROTRJ is independent of state */  	if(bp->prot != P_LCP) { 		send_xxxxrj(bp,C_PROTRJ); 	 		return;  	}  6 	if(bp->len < 4) goto discard;		/* ??? maybe coderj */ 	cp = bp->buf + bp->boff;  	switch(*cp) { 	  case C_CNFREQ:  		rcv_cnfreq(bp);  		break; 	  case C_CNFACK:  		rcv_cnfack(bp);  		break; 	  case C_CNFNAK:  		rcv_cnfnak(bp);  		break; 	  case C_CNFREJ:  		rcv_cnfrej(bp);  		break; 	  case C_TRMREQ:  		rcv_trmreq(bp);  		break; 	  case C_TRMACK:  		rcv_trmack(bp);  		break;   	  case C_CODERJ:  	  case C_PROTRJ: , 		/* RXJ- (assumed, RXJ+ not implemented) */ 		lcp_event(EV_RXJminus);  		free_pppbuf(bp); 		break;   	  case C_ECHORQ: ! 		/* RXR does not modify state */  		if(state == st9) {- 			*cp = C_ECHORP;		/* quick & dirty reply */ 0 			if(bp->len >= 8) {	/* must replace magic # */ 				uchar *dp = cp + 4; - 				uint32 magic = 0;	/* no magic # in use */    				STORE32(dp,magic); 			} 			tty_out(bp); 	 			break;  		} /* else drop thru */ 	  case C_ECHORP:  	  case C_DISCRQ:  		goto discard;  	  default: ! 		/* RUC does not modify state */  		send_xxxxrj(bp,C_CODERJ);  		break; 	} 	return;   discard: 	free_pppbuf(bp);  	return; }      /* "close" LCP */  void close_lcp(void) { 	lcp_event(EV_CLOSE);  }     * /* delayed check for termination in st3 */# static void lcp_timeout_st3(void) {  	if(state == st3 && 1 	   (lcp_params.closed || !lcp_params.passive)) { 
 		lcp_exit();  	} }    /* delayed TLU event */ # static void lcp_delayed_tlu(void) {  	if(state == st9) {  		set_state(T_LCP_TLU);  	} }    /* called via timer */ static void lcp_timeout(void) { 1 	lcp_event((retry > 0) ? EV_TOplus : EV_TOminus);  }    /* LCP event processing ,  * returns 1 to request "normal" processing,'  *	   0 to request discarding the event !  * timers always set/cleared here   */   * #define irc_cnfreq() retry = max_configure* #define irc_trmreq() retry = max_terminate #define zrc_trmreq() retry = 0  * static int/*logical*/ lcp_event(EVENT e) { 	int rc = 0;& 	int/*logical*/ timeract,timernew = 0;   	/* old timer state? */  	if(e == EV_START) { 		timeract = 0;  	} else switch(state) { 
 	  case st45:  	  case st6: 	  case st7: 	  case st8: 		timeract = (e != EV_TOplus &&  			    e != EV_TOminus); 		break;   	  case st3: 	  case st9: 		timeract = 0;  		break;   	  default: 
 		abort(); 	}   	switch(e) {; 	  case EV_START:		/* initialisation: one time UP & OPEN */  		state = st6; 		irc_cnfreq();  		init_cnfreq(); timernew = 1;	 		rc = 1;  		break;  ' 	  case EV_CLOSE:		/* one time CLOSE */ 4 		lcp_params.closed = 1;		/* st45 becomes state 4 */   		switch(state) { 
 		  case st3:  			lcp_exit();	 			break;  		  case st45:	 			break;   
 		  case st9:  			set_state(T_LCP_TLD); 			/* drop thru */
 		  case st6: 
 		  case st7: 
 		  case st8:  			state = st45; 			irc_trmreq();  			start_trmreq(); timernew = 1;	 			break;  		} 	 		rc = 1;  		break;  ) 	  case EV_TOplus:			/* no rc=1 action */  		switch(state) { 
 		  case st3: 
 		  case st9:  			abort();    		  case st45: 			send_trmreq(); timernew = 1; 	 			break;   
 		  case st7:  			state = st6;  			/* drop thru */
 		  case st6: 
 		  case st8:  			send_cnfreq(); timernew = 1; 	 			break;  		} 	 		rc = 1;  		break;  * 	  case EV_TOminus:			/* no rc=1 action */ 		switch(state) { 
 		  case st3: 
 		  case st9:  			abort();    		  case st45: 			lcp_exit();	 			break;   
 		  case st6: 
 		  case st7: 
 		  case st8: 1 			if(lcp_params.passive && !lcp_params.closed) {  				state = st3; 			} else {  				lcp_exit();  			}	 			break;  		} 	 		rc = 1;  		break;  3 	  case EV_RCRplus:		/* rc=1 action: send cnfack */  		switch(state) {  		  case st45: 			break;		/* rc=0 */   
 		  case st3:  			irc_cnfreq(); 			init_cnfreq(); timernew = 1;  			/* drop thru */
 		  case st6:  			state = st8;  			/* drop thru */
 		  case st8: 
 			rc = 1;	 			break;   
 		  case st7:  			state = st9; 2 			lcp_params.closed = 0;		/* undo spurious RTR */2 			set_timer(lcp_delayed_tlu,0);	/* don't hurry */
 			rc = 1;	 			break;   
 		  case st9:  			state = st8;  			set_state(T_LCP_TLD); 			init_cnfreq(); timernew = 1; 
 			rc = 1;	 			break;  		}  		break;  > 	  case EV_RCRminus:		/* rc=1 action: send cnfnak or cnfrej */ 		switch(state) {  		  case st45: 			break;		/* rc=0 */   
 		  case st3:  			irc_cnfreq(); 			init_cnfreq(); timernew = 1;  			/* drop thru */
 		  case st8:  			state = st6;  			/* drop thru */
 		  case st6: 
 		  case st7: 
 			rc = 1;	 			break;   
 		  case st9:  			state = st6;  			set_state(T_LCP_TLD); 			init_cnfreq(); timernew = 1; 
 			rc = 1;	 			break;  		}  		break;  : 	  case EV_RCA:			/* rc=1 action: use ack'ed parameters */ 		switch(state) { 
 		  case st3:  			send_trmack();  			break;		/* rc=0 */    		  case st45: 			break;		/* rc=0 */   
 		  case st6:  			irc_cnfreq(); 			state = st7; 
 			rc = 1;	 			break;   
 		  case st7:  			state = st6;  			send_cnfreq(); timernew = 1;  			break;		/* rc=0 */   
 		  case st8:  			irc_cnfreq(); 			state = st9; 2 			lcp_params.closed = 0;		/* undo spurious RTR */2 			set_timer(lcp_delayed_tlu,0);	/* don't hurry */
 			rc = 1;	 			break;   
 		  case st9:  			state = st6;  			set_state(T_LCP_TLD); 			init_cnfreq(); timernew = 1;  			break;		/* rc=0 */  		}  		break;  9 	  case EV_RCN:			/* rc=1 action: send modified cnfreq */  		switch(state) { 
 		  case st3:  			send_trmack();  			break;		/* rc=0 */    		  case st45: 			break;		/* rc=0 */   
 		  case st6: 
 		  case st8:  			irc_cnfreq();
 			rc = 1;	 			break;   
 		  case st7:  			state = st6; 3 			/* cnfreq was ACKed already, so don't re-init */  			send_cnfreq(); timernew = 1;  			break;		/* rc=0 */   
 		  case st9:  			state = st6;  			set_state(T_LCP_TLD); 			init_cnfreq(); timernew = 1;  			break;		/* rc=0 */  		}  		break;  0 	  case EV_RTR:			/* rc=1 action: send trmack */5 		lcp_params.closed = 1;		/* take it seriously ... */    		switch(state) { 
 		  case st3: ) 			/* terminate _after_ sending trmack */ , 			set_timer(lcp_timeout_st3,restart_timer);
 			rc = 1;	 			break;   
 		  case st7: 
 		  case st8:  			state = st6;  			/* drop thru */
 		  case st6:  		  case st45:
 			rc = 1;	 			break;   
 		  case st9:  			state = st45; 			set_state(T_LCP_TLD); 			zrc_trmreq(); timernew = 1;
 			rc = 1;	 			break;  		}  		break;  ' 	  case EV_RTA:				/* no rc=1 action */  		switch(state) { 
 		  case st3: 	 			break;    		  case st45: 			lcp_exit();	 			break;   
 		  case st7:  			state = st6; 
 		  case st6: 
 		  case st8: 	 			break;   
 		  case st9:  			state = st6;  			set_state(T_LCP_TLD); 			init_cnfreq(); timernew = 1; 	 			break;  		} 	 		rc = 1;  		break;  + 	  case EV_RXJminus:			/* no rc=1 action */  		if(state == st9) { 			state = st45; 			set_state(T_LCP_TLD); 			irc_trmreq();  			start_trmreq(); timernew = 1;
 		} else { 			lcp_exit(); 		} 	 		rc = 1;  		break;   	  default: 
 		abort(); 	}  & 	/* disable, start or restart timer */ 	switch(state) {
 	  case st45:  	  case st6: 	  case st7: 	  case st8: 		/* timer required */ 		if(!timeract && !timernew) { 			/* hope to never get here */a: 			printf("????? LCP bug: no timer, state#%d, event#%d\n",
 				state,e);. 			timernew = 1; 		}i2 		if(timeract && timernew) clr_timer(lcp_timeout);4 		if(timernew) set_timer(lcp_timeout,restart_timer); 		break;   	  case st3: 	  case st9: 		/* no timer */& 		if(timeract) clr_timer(lcp_timeout); 		break;   	  default: 
 		abort(); 	}   	return rc;s }c     /* LCP init */ void init_lcp(void) {h  % 	/* initial LCP parameters (fixed) */l$ 	lcp_params.accm_i_cur = 0xFFFFFFFF;$ 	lcp_params.accm_o_cur = 0xFFFFFFFF; 	lcp_params.acfc_o_cur = 0;f 	lcp_params.pfc_o_cur = 0;  3 	/* lcp_params.passive (variable) set externally */o   	lcp_params.closed = 0;w   	/* can start TTY only now */  	tty_open();   	/* get us going */  	lcp_event(EV_START);	 } 