 /* PPP layer 2&3 framing */    #include "ppp.h" #include "pppprot.h"   /* FCS-16 stuff */7 #define PPPINITFCS16    0xFFFF  /* Initial FCS value */ : #define PPPGOODFCS16    0xF0B8  /* Good final FCS value */$ uint16 pppfcs16(uint16,uchar *,int);    L /* given a complete PPP/HDLC input frame (without leading or trailing flags).  * - remove escapes, verify FCS-16 & remove it/  * - (L3) parse off address, control & protocol @  * - return dynamic BUF structure (with a copy of data), or NULL  */   - static void l3_parse(PPPBUF *);	/* forward */   / PPPBUF *l2l3_decode(unsigned char *dp, int l) {  	PPPBUF *bp; 	int ll;   	/* minimum length */  	if(l < 4) return NULL;    	/* allocate */  	bp = alloc_pppbuf(l);   	/* copy ... */  	for(ll = 0; l > 0; l--) { 		unsigned int k = *dp++;   - 		/* drop control characters in input_accm */ ' 		if(k < 32 && INPUT_ACCM(k)) continue;    		/* un-escape */  		if(k == CTLESC) { 0 			if(--l == 0) 	/* trailing CTLESC, RFC 1662 */ 				goto discard;   			bp->buf[ll++] = *dp++ ^ 0x20;
 		} else { 			bp->buf[ll++] = k;  		}  	}    	/* minimum length, once more */ 	if(ll < 4) goto discard;   8 	if(pppfcs16(PPPINITFCS16,bp->buf,ll) == PPPGOODFCS16) {7 		bp->prot = 0;	/* invalid, unless L3 parse succeeds */  		bp->boff = 0;  		bp->len = ll - 2;    		l3_parse(bp); ! 		if(bp->prot == 0) goto discard;    		return bp;	 	} else {  		LINE_ERROR(E_FCS16); 	}   discard: 	free_pppbuf(bp); 
 	return NULL;  }     " static void l3_parse(PPPBUF *bp) {  	uchar *cp = bp->buf + bp->boff; 	int l = bp->len;  	uint16 pp;   " 	if(l < 2) return;		/* can't be */   	/* ACF-Compression? */ - 	if(*cp == 0xFF && cp[1] == 0x03) {		/* no */ ' 		l -= 2; cp += 2;			/* so strip 'em */  	}  ) 	if(l < 2) return;		/* must be garbage */    	/* protocol field ... */  	pp = *cp++; l--; 
 	if(pp & 1) { - 		/* ... compressed, l.s.byte is just fine */ 	 	} else { * 		/* 2nd octet _assumed_ to be l.s.byte */ 		pp = (pp << 8) | *cp++; l--; 	}   	bp->boff = cp - bp->buf; 
 	bp->len = l;  	bp->prot = pp;  }   C /* given PPPBUF, generate buffer for serial output (w/o flag bytes) =  * - 2nd arg points to a buffer "guaranteed" to be big enough   * - return # of bytes produced   */   C static uchar *l2_escape(uchar *op, uchar *ip, int l, int accm_ok) { 	 	uchar k;    	for(;l > 0;l--) { 		k = *ip++;2 		if((k < 0x20 && (!accm_ok || OUTPUT_ACCM(k))) || 		   k == FLAG ||  		   k == CTLESC) {  			*op++ = CTLESC; 			*op++ = k ^ 0x20;
 		} else {
 			*op++ = k;  		}  	}   	return op;  }     ( int l3l2_encode(PPPBUF *bp, uchar *dp) {" 	uchar l3_hdr[4],fcs_b[2],*hp,*cp; 	uint16 fcs_w;   /* L3 stuff */  
 	hp = l3_hdr;   ( 	/* ACF-Compression forbidden for LCP */' 	if(OUTPUT_ACFC && bp->prot != P_LCP) { ( 		/* send neither address nor control */	 	} else {  		*hp++ = 0xFF;	/* "address" */  		*hp++ = 0x03;	/* "control" */  	}  > 	/* PF-Compression & compressable? (LCP will fail 2nd test) */- 	if(OUTPUT_PFC && (bp->prot & 0xFF00) == 0) { . 		*hp++ = bp->prot & 0xFF;	/* l.s.byte only */	 	} else { 1 		*hp++ = (bp->prot >> 8) & 0xFF;	/* high byte */ ) 		*hp++ = bp->prot & 0xFF;	/* low byte */  	}		   /* L2 stuff */  3 	fcs_w = pppfcs16(PPPINITFCS16,l3_hdr,hp - l3_hdr); E 	cp =             l2_escape(dp,l3_hdr,hp - l3_hdr,bp->prot != P_LCP); 4 	fcs_w = pppfcs16(fcs_w,bp->buf + bp->boff,bp->len);F 	cp =      l2_escape(cp,bp->buf + bp->boff,bp->len,bp->prot != P_LCP);& 	fcs_w ^= 0xFFFF;		/* complement it */. 	fcs_b[0] = fcs_w & 0xFF;	/* low byte first */  	fcs_b[1] = (fcs_w >> 8) & 0xFF;. 	cp = l2_escape(cp,fcs_b,2,bp->prot != P_LCP);   	return (cp - dp); } 