- /* PPP main progam + some utility routines */    #include "ppp.h" #include "pppprot.h" #include "state.h" #include "ipcp.h"    #include <stdio.h> #include <stdlib.h>  #include <string.h>    extern void close_lcp(void); static int do_close = 0;  ) static void cc_setup(void);	/* forward */    main(int argc, char **argv) {    	redirect(&argc,&argv);   ' 	/***** setup variable parameters ****/   8 	/* [0|1] - if 1, wait forever for initial connection */ 	lcp_params.passive = 1;  1 	/* bit masks of control characters (0x00..0x1F)  % 	 * to be escaped in in/out direction           */ 4 	/* e.g. for convenience, have XON/XOFF filtered: */2 	lcp_params.accm_i_min = (1 << XON) | (1 << XOFF);2 	lcp_params.accm_o_min = (1 << XON) | (1 << XOFF);  ; 	/* IP addresses to be used if peer doesn't provide them */  	{$ 		uchar lcl_def[4] = {192,168,2,45};% 		uchar rem_def[4] = {192,168,2,145};   ' 	/***** end of variable paramters ****/  		uchar *cp;   		cp = lcl_def; - 		FETCH32(cp,ipcp_params.ipaddr_lcl_default);  		cp = rem_def; - 		FETCH32(cp,ipcp_params.ipaddr_rem_default);  	}   	/* get q-aligned queue head */  	q_inhead = malloc(8); 	memset(q_inhead,0,8);  * 	/* try to enable LCP termination on ^C */ 	cc_setup();   	/* get us going */  	init_timer(); 	init_lcp();   	/* main loop */ 	do { 
 		PPPBUF *bp; 
 		int sts; 	 
 		/* sleep */  		sys$hiber();   		/* closing? */ 		if(do_close) { 			close_lcp();  			do_close = 0; 		}   + 		/* dispatch packets from "input" queue */ $ 		while(lib$remqhi(&q_in,&bp) & 1) {   			trace_pppbuf(bp,bp->out);  - 			if(bp->out) {		/* queued for trace only */  				free_pppbuf(bp);
 				continue;  			}   			/* PPP input */ 			switch(bp->prot) {  			  case P_IP:  			  case P_CTCP:  			  case P_UTCP:  				ip_input(bp); 
 				break; 			  case P_PAP: 				pap_input(bp);
 				break; 			  case P_IPCP:  				ipcp_input(bp); 
 				break;
 			  default:  				lcp_input(bp); 			} 		}   ! 		/* ggf. process timer events */  		check_timer();   		/* check for [line] errors */  		trace_errors();    	} while(1); }     + /* normal program exit (called from LCP) */  void lcp_exit(void) {  	/* ??? hangup */  	/* ??? wait for quiet line */
 	sleep(3);
 	sys$exit(1);  }      /** "close" via ^C **/   #include <descrip.h>& typedef struct dsc$descriptor_s DESCR;   #include <jpidef.h>  #include <iodef.h>   typedef struct { 	unsigned short len; 	unsigned short code;  	void *buf;  	unsigned short *retlenp; 	 } ITEM_3;    static uint16 cc_chan;) static int cc_enable(void);	/* forward */    /* ^C AST */! static void cc_routine(int arg) {  	do_close = 1; 	sys$wake(0,0); 
 	cc_enable();  }    /* establish ^C AST */ static int cc_enable(void) {	 	int sts;  	uint16 iosb[4];  6 	sts = sys$qiow(0,cc_chan,IO$_SETMODE | IO$M_CTRLCAST,% 			iosb,0,NULL,cc_routine,1,0,0,0,0);  	if(sts & 1) sts = iosb[0];  	return sts; }   & /* find controlling terminal for ^C */ static void cc_setup(void) { 	int liosb[2]; 	int sts,jmode,jpid,jowner;  	char name[32];   	DESCR namedsc = {0-0,0,0,name}; 	ITEM_3 jpiitm[4] = { & 		{sizeof(int),JPI$_MODE,&jmode,NULL},: 		{sizeof(name),JPI$_TERMINAL,name,&namedsc.dsc$w_length},( 		{sizeof(int),JPI$_OWNER,&jowner,NULL}, 		{0,0,NULL,NULL}  	};   2 	for(jpid = 0; ; ) {	/* start with this process */
 		jowner = 0; 0 		sts = sys$getjpiw(0,&jpid,0,jpiitm,liosb,0,0); 		if(sts & 1) sts = liosb[0];  		if(!(sts & 1)) goto failure;. 		if(jmode != JPI$K_INTERACTIVE) goto failure;; 		if(namedsc.dsc$w_length != 0) break;	/* terminal found */  		if(jowner == 0) goto failure; 3 		jpid = jowner;		/* continue with owner process */  	}  ' 	/* terminal found, assign a channel */ ) 	sts = sys$assign(&namedsc,&cc_chan,0,0);  	if(!(sts & 1)) goto failure;    	/* enable ^C */6 	if(cc_enable() & 1) printf("Will close on Ctrl-C\n");   failure: }      /* state management */A /* NOTE: protocols other than LCP are not completely implemented; <  *	simple single-shot control has been sufficient so far ...  */   + extern void init_pap(void),close_pap(void); - extern void init_ipcp(void),close_ipcp(void); ) extern void init_ip(void),close_ip(void);  extern void close_lcp(void);   static struct {  	uchar lcp,pap,ipcp; } state;   void set_state(int tr) {
 	switch(tr) {  	  case T_LCP_TLU: 		printf("* LCP opened\n");  		state.lcp = 1; 		if(state.pap == 1) { 			set_timer(init_pap,0); 
 		} else { 			state.ipcp = 1; 			set_timer(init_ipcp,0); 		}  		break;   	  case T_LCP_TLD: 		printf("* LCP going down\n");  		/* re-init */ ) 		state.lcp = state.pap = state.ipcp = 0;  		clr_timer(init_ip); 
 		close_ip();  		clr_timer(init_ipcp);  		close_ipcp();  		clr_timer(init_pap); 		close_pap(); 		break;   	  case T_PAP_REQUIRED:  		state.pap = 1; break;    	  case T_PAPREQ_DONE: 		printf("* PAP sucessful\n"); 		state.pap = 2; 		close_pap(); 		state.ipcp = 1;  		set_timer(init_ipcp,0);  		break; 	  case T_PAPREQ_FAILED: 		printf("* PAP failed\n");  		state.pap = 0; 		close_pap(); 		set_timer(close_lcp,0);  		break;   	  case T_IPCPREQ_DONE:  		state.ipcp |= 2; 		if(state.ipcp != 7) break; 		goto ipcp_done;  	  case T_IPCPACK_DONE:  		state.ipcp |= 4; 		if(state.ipcp != 7) break; 	ipcp_done: 8 		if(ipcp_params.ipaddr_lcl != ipcp_params.ipaddr_rem) { 			close_ipcp(); 			set_timer(init_ip,0);	 			break; 2 		} /* else we have bad (matching) IP addresses */> 		printf("* IPCP failed, local IP = remote IP (loopback?)\n"); 		/* drop thru */  	  case T_IPCPREQ_FAILED:  		state.ipcp = 0;  		close_ipcp();  		set_timer(close_lcp,0);  		break;  , 	/* IPCP doesn't know how to handle these */ 	  case T_TRMREQ:  	  case T_TRMACK:  	  case T_CODEREJ: 	  case T_PROTREJ: 		printf("* IPCP aborting\n"); 		state.ipcp = 0;  		close_ipcp();  		set_timer(close_lcp,0);  		break;   	  default: 
 		abort(); 	} }    /*****/   2 /* check LCP/IPCP message length vs. buffer length*  *  and option lengths vs. message length.,  * return message length if all o.k., else 0  */  uint16 llcheck(PPPBUF *bp) {
 	uint16 ll,l;  	uchar *cp;    	if(bp->len < 4) return 0;   	cp = bp->buf + bp->boff + 2;  	FETCH16(cp,ll);% 	if(ll > bp->len || ll < 4) return 0;   ! 	/* check lengths of tlv-items */  	l = ll - 4; 	while(l > 1) {  		if(l < cp[1]) return 0; 
 		l -= cp[1];  		cp += cp[1]; 	} 	if(l != 0) return 0;    	return ll;  } 