/* TTY input & output */

#include "ppp.h"

#include <stdlib.h>
#include <string.h>
#include <assert.h>

#include <descrip.h>
#include <iodef.h>
#include <ssdef.h>

#define tty_i_efn 1	/* event flag # for TTY input, write-only */
#define tty_o_efn 2	/* event flag # for TTY output, write-only */


/* make the input buffer(s) large enough to accomodate any message -
    worst case: every byte (except for the trailing flag) might be escaped
 */
#define TTYBUFSIZE (2*(2 + 2 + PPP_MRU + 2) + 1)

#define TTY_I_COUNT 3	/* number of outstanding READs */

static int ttychan;
static struct ttyin {
	uint16 iosb[4];	
	uchar buf[TTYBUFSIZE];
} ttyin[TTY_I_COUNT];

static double *q_ohead;
#define ttyo_q (*q_ohead)
static uchar ttyo_ready;


static void tty_i_start(int);	/* forward */

/* initialize TTY & start input */
void tty_open(void) {
	int sts;
	$DESCRIPTOR(ttydsc,"TTY");

	q_ohead = malloc(8);	/* q-align */
	memset(q_ohead,0,8);

	sts = sys$assign(&ttydsc,&ttychan,0,0);
	if(!(sts & 1)) lib$stop(sts);

	/* lcp_params.accm_i_min & .accm_o_min could be modified here */

	/* ??? IO$_SETMODE (PASTHRU, NOECHO);
	 * 	if XON & XOFF aren't set in lcp_params.accm_*_min,
	 *	also (NOHOSTSYNC, NOTTSYNC)
	 */

	ttyo_ready = 1;		/* mark output not busy */

	tty_i_start(0);
	tty_i_start(1);
	tty_i_start(2);
}


static void tty_i_ast(int n) {
	struct ttyin *tp = &ttyin[n];

	if(!(tp->iosb[0] & 1)) {
		/* do terminate on HANGUP */
		if(tp->iosb[0] == SS$_HANGUP) sys$exit(tp->iosb);
		/* else report & try again */
		LINE_ERROR(E_INPUT);
		ast_signal(tp->iosb[0]);
	} else if(tp->iosb[1] > 0) {
		PPPBUF *bp;

		bp = l2l3_decode(tp->buf,tp->iosb[1]);
		if(bp) {
			lib$insqti(bp,&q_in);
			sys$wake(0,0);
		} /* else it was garbage */
	} /* else it was just a FLAG */

	tty_i_start(n);
}


static void tty_i_start(int n) {
	/* terminator mask: terminate on FLAG = (128 - 2) */
	static uchar tmask[16] = {0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0x40};
	static struct { int tl; uchar *tp; } term = {16, tmask};
	int sts;
	struct ttyin *tp = &ttyin[n];

	assert(FLAG == (128 - 2));
	sts = sys$qio(tty_i_efn,ttychan,
		IO$_READVBLK | IO$M_NOECHO | IO$M_NOFILTR,
		tp->iosb,tty_i_ast,n,
		tp->buf,TTYBUFSIZE,0,&term,0,0);		/* timeout? */
	if(!(sts & 1)) lib$stop(sts);
}

/*****/

static uint16 ttyo_iosb[4];
static uchar ttyo_buf[1 + TTYBUFSIZE];		/* may contain leading FLAG */

static void tty_o_ast(int);	/* forward */

/* for synchronisation, this routine must only run at AST level */
static void tty_o_start(int/*logical*/ btb) {
	int sts,l;
	PPPBUF *bp;
	uchar *dp;

	if(!ttyo_ready) return;

	sts = lib$remqhi(&ttyo_q,&bp);
	if(!(sts & 1)) return;			/* no work */

	/* ok to proceeed */

	ttyo_ready = 0;				/* lock the door ... */

	dp = ttyo_buf;
	if(!btb) *dp++ = FLAG;		/* send leading flag */

	/* generate message from buffer */
	l = l3l2_encode(bp,dp);
	if(!btb) l++;

	ttyo_buf[l++] = FLAG;			/* add trailing flag */

	/* dispose of buffer */
#if 1
	lib$insqti(bp,&q_in);			/* let mainline trace it */
	sys$wake(0,0);
#else
	free_pppbuf(bp);
#endif

	/* start output ... */
	sts = sys$qio(tty_o_efn,ttychan,
		IO$_WRITEVBLK | IO$M_NOFORMAT | IO$M_BREAKTHRU,
		ttyo_iosb,tty_o_ast,0,
		ttyo_buf,l,0,0,0,0);
	if(!(sts & 1)) lib$stop(sts);
}


static void tty_o_ast(int n) {

	if(!(ttyo_iosb[0] & 1)) {
		LINE_ERROR(E_OUTPUT);
		ast_signal(ttyo_iosb[0]);
	}

	ttyo_ready = 1;

	tty_o_start(1);		/* test for back-to-back output */
}


/* "TTY" output routine for general use
 *  - eventually disposes of the PPPBUF passed
 */
void tty_out(PPPBUF *bp) {
	int sts;

	bp->out = 1;			/* flag outgoing buffer */
	lib$insqti(bp,&ttyo_q);

	if(ttyo_ready) {
		sts = sys$dclast(tty_o_start,0,0);
		if(!(sts & 1)) lib$stop(sts);
	} /* else the AST is already pending */
}
