< /* wjm 04-nov-1996: this file comes from Don Stokes's CSDRV.)  *			slighly modified for PPP environment   */   6 /* rfc1144.c	Van Jacobson TCP compression			8/5/93/dcs  *G  * Gratuitously cribbed from Jacobson 1990, "Compressing TCP/IP Headers *  * for Low-Speed Serial Links (RFC 1144)."  *<  * For issues about compression contact the original author:  * 	Van Jacobson  * 	Real Time Systems Group   * 	Mail Stop 46A    * 	Lawrence Berkeley Laboratory  * 	Berkeley, CA 94720/  * 	Phone: Use email (author ignores his phone)    * 	EMail: van@helios.ee.lbl.govC  * (this is the address given in the RFC -- it may be out of date.)   */    /* A  Sample Implementation   *H  * The following is a sample implementation of the protocol described in  * this document.   *H  * Since many people who might have the deal with this code are familiarK  * with the Berkeley Unix kernel and its coding style (affectionately known I  * as kernel normal form), this code was done in that style.  It uses the C  * Berkeley `subroutines' (actually, macros and/or inline assembler <  * expansions) for converting to/from network byte order andB  * copying/comparing strings of bytes.  These routines are briefly;  * described in sec. A.5 for anyone not familiar with them.   *I  * This code has been run on all the machines listed in the table on page C  * 24.  Thus, the author hopes there are no byte order or alignment I  * problems (although there are embedded assumptions about alignment that ?  * are valid for Berkeley Unix but may not be true for other IP ?  * implementations --- see the comments mentioning alignment in *  * sl_compress_tcp and sl_decompress_tcp).  *K  * There was some attempt to make this code efficient.  Unfortunately, that H  * may have made portions of it incomprehensible.  The author apologizesK  * for any frustration this engenders.  (In honesty, my C style is known to I  * be obscure and claims of `efficiency' are simply a convenient excuse.)   *B  * This sample code and a complete Berkeley Unix implementation isJ  * available in machine readable form via anonymous ftp from Internet hostH  * ftp.ee.lbl.gov (128.3.254.68), file cslip.tar.Z. This is a compressed3  * Unix tar file.  It must be ftped in binary mode.   *J  * All of the code in this appendix is covered by the following copyright:  *  */    /*>  * Copyright (c) 1989 Regents of the University of California.  * All rights reserved.   *8  * Redistribution and use in source and binary forms are>  * permitted provided that the above copyright notice and this:  * paragraph are duplicated in all such forms and that any<  * documentation, advertising materials, and other materials<  * related to such distribution and use acknowledge that the:  * software was developed by the University of California,;  * Berkeley.  The name of the University may not be used to 9  * endorse or promote products derived from this software -  * without specific prior written permission. >  * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS<  * OR IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE:  * IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A  * PARTICULAR PURPOSE.  */     " /* A.1  Definitions and State Data  */ 2 /*-wjm	#include "cmuip-vms.h"					/* 8/5/93/dcs */$ #include "rfc1144-vms.h"		/* +wjm */  1 #define MAX_STATES 16   /* must be >2 and <255 */ E #define MAX_HDR 128     /* max TCP+IP hdr length (by protocol def) */    /* packet types */ #define TYPE_IP 0x40" #define TYPE_UNCOMPRESSED_TCP 0x70  #define TYPE_COMPRESSED_TCP 0x80B #define TYPE_ERROR 0x00 /* this is not a type that ever appears on. 			 * the wire.  The receive framer uses it to. 			 * tell the decompressor there was a packet 			 * transmission error. */ /*+  * Bits in first octet of compressed packet   */   , /* flag bits for what changed in a packet */   #define NEW_C  0x40  #define NEW_I  0x20  #define TCP_PUSH_BIT 0x10    #define NEW_S  0x08  #define NEW_A  0x04  #define NEW_W  0x02  #define NEW_U  0x01   , /* reserved, special-case values of above */M #define SPECIAL_I (NEW_S|NEW_W|NEW_U)        /* echoed interactive traffic */ F #define SPECIAL_D (NEW_S|NEW_A|NEW_W|NEW_U)  /* unidirectional data *// #define SPECIALS_MASK (NEW_S|NEW_A|NEW_W|NEW_U)      /*F  * "state" data for each active tcp conversation on the wire.  This isM  * basically a copy of the entire IP/TCP header from the last packet together I  * with a small identifier the transmit & receive ends of the line use to   * locate saved header.   */  struct cstate { I 	struct cstate *cs_next;  /* next most recently used cstate (xmit only)*/ : 	u_short cs_hlen;         /* size of hdr (receive only) */G 	u_char cs_id;            /* connection # associated with this state */  	u_char cs_filler; 	union { 		char hdr[MAX_HDR];> 		struct ip csu_ip;   /* ip/tcp hdr from most recent packet */
 	} slcs_u; }; #define cs_ip slcs_u.csu_ip  #define cs_hdr slcs_u.csu_hdr    /*J  * all the state data for one serial line (we need one of these per line).  */  struct slcompress { C 	struct cstate *last_cs;            /* most recently used tstate */ < 	u_char last_recv;                  /* last rcvd conn. id */< 	u_char last_xmit;                  /* last sent conn. id */ 	u_short flags; @ 	struct cstate tstate[MAX_STATES];  /* xmit connection states */C 	struct cstate rstate[MAX_STATES];  /* receive connection states */  }; int							/* 16/5/93/dcs */ P slcompress_size() { return sizeof(struct slcompress); }	/* Make size available*/ 							/* to caller */     /* flag values */ G #define SLF_TOSS 1       /* tossing rcvd frames because of input err */    /*H  * The following macros are used to encode and decode numbers.  They allL  * assume that `cp' points to a buffer where the next byte encoded (decoded)I  * is to be stored (retrieved).  Since the decode routines do arithmetic, 7  * they have to convert from and to network byte order.   */    /*L  * ENCODE encodes a number that is known to be non-zero.  ENCODEZ checks for:  * zero (zero has to be encoded in the long, 3 byte form).  */  #define ENCODE(n) { \  	if ((u_short)(n) >= 256) { \  		*cp++ = 0; \ 		cp[1] = (n); \ 		cp[0] = (n) >> 8; \  		cp += 2; \ 	} else { \  		*cp++ = (n); \ 	} \ }  #define ENCODEZ(n) { \2 	if ((u_short)(n) >= 256 || (u_short)(n) == 0) { \ 		*cp++ = 0; \ 		cp[1] = (n); \ 		cp[0] = (n) >> 8; \  		cp += 2; \ 	} else { \  		*cp++ = (n); \ 	} \ }    /*F  * DECODEL takes the (compressed) change at byte cp and adds it to theK  * current value of packet field 'f' (which must be a 4-byte (long) integer M  * in network byte order).  DECODES does the same for a 2-byte (short) field. I  * DECODEU takes the change at cp and stuffs it into the (short) field f. G  * 'cp' is updated to point to the next field in the compressed header.   */  #define DECODEL(f) { \ 	if (*cp == 0) {\ 3 		(f) = htonl(ntohl(f) + ((cp[1] << 8) | cp[2])); \  		cp += 3; \ 	} else { \ * 		(f) = htonl(ntohl(f) + (u_long)*cp++); \ 	} \ }  #define DECODES(f) { \ 	if (*cp == 0) {\ 3 		(f) = htons(ntohs(f) + ((cp[1] << 8) | cp[2])); \  		cp += 3; \ 	} else { \ * 		(f) = htons(ntohs(f) + (u_long)*cp++); \ 	} \ }  #define DECODEU(f) { \ 	if (*cp == 0) {\ & 		(f) = htons((cp[1] << 8) | cp[2]); \ 		cp += 3; \ 	} else { \  		(f) = htons((u_long)*cp++); \  	} \ }      /* A.2  Compression   *K  * This routine looks daunting but isn't really.  The code splits into four C  * approximately equal sized sections:  The first quarter manages a >  * circularly linked, least-recently-used list of `active' TCPG  * connections./47/  The second figures out the sequence/ack/window/urg K  * changes and builds the bulk of the compressed packet.  The third handles C  * the special-case encodings.  The last quarter does packet ID and J  * connection ID encoding and replaces the original packet header with the  * compressed header.   *@  * The arguments to this routine are a pointer to a packet to beK  * compressed, a pointer to the compression state data for the serial line, J  * and a flag which enables or disables connection id (C bit) compression.  *H  * Compression is done `in-place' so, if a compressed packet is created,H  * both the start address and length of the incoming packet (the off andJ  * len fields of m) will be updated to reflect the removal of the originalD  * header and its replacement by the compressed header.  If either aI  * compressed or uncompressed packet is created, the compression state is J  * updated.  This routines returns the packet type for the transmit framer;  * (TYPE_IP, TYPE_UNCOMPRESSED_TCP or TYPE_COMPRESSED_TCP).   *I  * Because 16 and 32 bit arithmetic is done on various header fields, the J  * incoming IP packet must be aligned appropriately (e.g., on a SPARC, theI  * IP header is aligned on a 32-bit boundary).  Substantial changes would H  * have to be made to the code below if this were not true (and it wouldD  * probably be cheaper to byte copy the incoming header to somewhere1  * correctly aligned than to make those changes).   *F  * Note that the outgoing packet will be aligned arbitrarily (e.g., it/  * could easily start on an odd-byte boundary).   *  * ---------------------------- J  *  47. The two most common operations on the connection list are a `find'I  * that terminates at the first entry (a new packet for the most recently H  * used connection) and moving the last entry on the list to the head ofF  * the list (the first packet from a new connection).  A circular list,  * efficiently handles these two operations.  */    u_char& sl_compress_tcp(m, comp, compress_cid) 	struct mbuf *m; 	struct slcompress *comp;  	int compress_cid; { 5 	register struct cstate *cs = comp->last_cs->cs_next; / 	register struct ip *ip = mtod(m, struct ip *); ! 	register u_int hlen = ip->ip_hl; 9 	register struct tcphdr *oth;       /* last TCP header */ < 	register struct tcphdr *th;        /* current TCP header */E 	register u_int deltaS, deltaA;     /* general purpose temporaries */ 5 	register u_int changes = 0;        /* change mask */ F 	u_char new_seq[16];                /* changes from last to current */ 	register u_char *cp = new_seq;    	/* = 	 * Bail if this is an IP fragment or if the TCP packet isn't D 	 * `compressible' (i.e., ACK isn't set or some other control bit isF 	 * set).  (We assume that the caller has already made sure the packet 	 * is IP proto TCP).  	 */5 	if ((ip->ip_off & htons(0x3fff)) || m->m_len < 40 || 1 	    ip->ip_p != IPPROTO_TCP)			/* 18/5/93/dcs */  		return (TYPE_IP);   - 	th = (struct tcphdr *) & ((int *) ip)[hlen]; D 	if ((th->th_flags & (TH_SYN | TH_FIN | TH_RST | TH_ACK)) != TH_ACK) 		return (TYPE_IP);    	/* : 	 * Packet is compressible -- we're going to send either aE 	 * COMPRESSED_TCP or UNCOMPRESSED_TCP packet.  Either way we need to C 	 * locate (or create) the connection state.  Special case the most F 	 * recently used connection since it's most likely to be used again &4 	 * we don't have to do any reordering if it's used. 	 */4 	if (ip->ip_src.s_addr != cs->cs_ip.ip_src.s_addr ||4 	    ip->ip_dst.s_addr != cs->cs_ip.ip_dst.s_addr ||< 	    *(int *) th != ((int *) &cs->cs_ip)[cs->cs_ip.ip_hl]) {   		/*' 		 * Wasn't the first -- search for it.  		 *= 		 * States are kept in a circularly linked list with last_cs > 		 * pointing to the end of the list.  The list is kept in lru= 		 * order by moving a state to the head of the list whenever 4 		 * it is referenced.  Since the list is short and,> 		 * empirically, the connection we want is almost always near: 		 * the front, we locate states via linear search.  If we= 		 * don't find a state for the datagram, the oldest state is  		 * (re-)used.  		 */  		register struct cstate *lcs;1 		register struct cstate *lastcs = comp->last_cs;    		do { 			lcs = cs; 			cs = cs->cs_next;3 			if (ip->ip_src.s_addr == cs->cs_ip.ip_src.s_addr 6 			    && ip->ip_dst.s_addr == cs->cs_ip.ip_dst.s_addr? 			    && *(int *) th == ((int *) &cs->cs_ip)[cs->cs_ip.ip_hl])  				goto found;  		} while (cs != lastcs);    		/*5 		 * Didn't find it -- re-use oldest cstate.  Send an 7 		 * uncompressed packet that tells the other side what > 		 * connection number we're using for this conversation. Note< 		 * that since the state list is circular, the oldest state< 		 * points to the newest and we only need to set last_cs to 		 * update the lru linkage. 		 */  		comp->last_cs = lcs; 		hlen += th->th_off; 
 		hlen <<= 2;  		goto uncompressed;   found:= 		/* Found it -- move to the front on the connection list. */  		if (lastcs == cs)  			comp->last_cs = lcs;  		else { 			lcs->cs_next = cs->cs_next;! 			cs->cs_next = lastcs->cs_next;  			lastcs->cs_next = cs; 		}  	} 	/* C 	 * Make sure that only what we expect to change changed. The first D 	 * line of the `if' checks the IP protocol version, header length &C 	 * type of service.  The 2nd line checks the "Don't fragment" bit. C 	 * The 3rd line checks the time-to-live and protocol (the protocol D 	 * check is unnecessary but costless).  The 4th line checks the TCPD 	 * header length.  The 5th line checks IP options, if any.  The 6th@ 	 * line checks TCP options, if any.  If any of these things areB 	 * different between the previous & current datagram, we send the$ 	 * current datagram `uncompressed'. 	 */6 	oth = (struct tcphdr *) & ((int *) &cs->cs_ip)[hlen]; 	deltaS = hlen;  	hlen += th->th_off; 	hlen <<= 2;  : 	if (((u_short *) ip)[0] != ((u_short *) &cs->cs_ip)[0] ||: 	    ((u_short *) ip)[3] != ((u_short *) &cs->cs_ip)[3] ||: 	    ((u_short *) ip)[4] != ((u_short *) &cs->cs_ip)[4] ||! 	    th->th_off != oth->th_off || G 	    (deltaS > 5 && BCMP(ip + 1, &cs->cs_ip + 1, (deltaS - 5) << 2)) || F 	    (th->th_off > 5 && BCMP(th + 1, oth + 1, (th->th_off - 5) << 2))) 		goto uncompressed;   	/* B 	 * Figure out which of the changing fields changed.  The receiver; 	 * expects changes in the order: urgent, window, ack, seq.  	 */ 	if (th->th_flags & TH_URG) {  		deltaS = ntohs(th->th_urp);  		ENCODEZ(deltaS); 		changes |= NEW_U; & 	} else if (th->th_urp != oth->th_urp) 		/*4 		 * argh! URG not set but urp changed -- a sensible; 		 * implementation should never do this but RFC793 doesn't 4 		 * prohibit the change so we have to deal with it. 		 */  		goto uncompressed;  C 	if (deltaS = (u_short) (ntohs(th->th_win) - ntohs(oth->th_win))) {  		ENCODE(deltaS);  		changes |= NEW_W;  	}7 	if (deltaA = ntohl(th->th_ack) - ntohl(oth->th_ack)) {  		if (deltaA > 0xffff) 			goto uncompressed;  		ENCODE(deltaA);  		changes |= NEW_A;  	}7 	if (deltaS = ntohl(th->th_seq) - ntohl(oth->th_seq)) {  		if (deltaS > 0xffff) 			goto uncompressed;  		ENCODE(deltaS);  		changes |= NEW_S;  	} 	/* ( 	 * Look for the special-case encodings. 	 */ 	switch (changes) {    	case 0: 		/*? 		 * Nothing changed. If this packet contains data and the last < 		 * one didn't, this is probably a data packet following an= 		 * ack (normal on an interactive connection) and we send it 7 		 * compressed.  Otherwise it's probably a retransmit, = 		 * retransmitted ack or window probe.  Send it uncompressed : 		 * in case the other side missed the compressed version. 		 */ ' 		if (ip->ip_len != cs->cs_ip.ip_len && & 		    ntohs(cs->cs_ip.ip_len) == hlen)	 			break;    		/* (fall through) */   	case SPECIAL_I: 	case SPECIAL_D: 		/*> 		 * Actual changes match one of our special case encodings -- 		 * send packet uncompressed. 		 */  		goto uncompressed;   	case NEW_S | NEW_A: 		if (deltaS == deltaA && 1 		    deltaS == ntohs(cs->cs_ip.ip_len) - hlen) { 1 			/* special case for echoed terminal traffic */  			changes = SPECIAL_I;  			cp = new_seq; 		}  		break;   	case NEW_S:1 		if (deltaS == ntohs(cs->cs_ip.ip_len) - hlen) { # 			/* special case for data xfer */  			changes = SPECIAL_D;  			cp = new_seq; 		}  		break; 	}4 	deltaS = ntohs(ip->ip_id) - ntohs(cs->cs_ip.ip_id); 	if (deltaS != 1) {  		ENCODEZ(deltaS); 		changes |= NEW_I;  	} 	if (th->th_flags & TH_PUSH) 		changes |= TCP_PUSH_BIT; 	/* A 	 * Grab the cksum before we overwrite it below.  Then update our $ 	 * state with this packet's header. 	 */ 	deltaA = ntohs(th->th_sum); 	BCOPY(ip, &cs->cs_ip, hlen);    	/* F 	 * We want to use the original packet as our compressed packet. (cp -C 	 * new_seq) is the number of bytes we need for compressed sequence C 	 * numbers.  In addition we need one byte for the change mask, oneuA 	 * for the connection id and two for the tcp checksum. So, (cp -*D 	 * new_seq) + 4 bytes of header are needed.  hlen is how many bytesE 	 * of the original packet to toss so subtract the two to get the newy 	 * packet size. 	 */ 	deltaS = cp - new_seq;r 	cp = (u_char *) ip;9 	if (compress_cid == 0 || comp->last_xmit != cs->cs_id) {s 		comp->last_xmit = cs->cs_id; 		hlen -= deltaS + 4; 
 		cp += hlen;e 		*cp++ = changes | NEW_C; 		*cp++ = cs->cs_id;	 	} else {e 		hlen -= deltaS + 3;*
 		cp += hlen;i 		*cp++ = changes; 	} 	m->m_len -= hlen; 	m->m_off += hlen; 	*cp++ = deltaA >> 8;e 	*cp++ = deltaA; 	BCOPY(new_seq, cp, deltaS); 	return (TYPE_COMPRESSED_TCP);  
 uncompressed:l 	/*i9 	 * Update connection state cs & send uncompressed packet > 	 * ('uncompressed' means a regular ip/tcp packet but with theD 	 * 'conversation id' we hope to use on future compressed packets in 	 * the protocol field). 	 */ 	BCOPY(ip, &cs->cs_ip, hlen);g 	ip->ip_p = cs->cs_id; 	comp->last_xmit = cs->cs_id;y  	return (TYPE_UNCOMPRESSED_TCP); }      i   /* A.3  DecompressionT  *D  * This routine decompresses a received packet.  It is called with aJ  * pointer to the packet, the packet length and type, and a pointer to theJ  * compression state structure for the incoming serial line.  It returns aF  * pointer to the resulting packet or zero if there were errors in theI  * incoming packet.  If the packet is COMPRESSED_TCP or UNCOMPRESSED_TCP,s)  * the compression state will be updated.t  *  K  * The new packet will be constructed in-place.  That means that there must D  * be 128 bytes of free space in front of bufp to allow room for theF  * reconstructed IP and TCP headers.  The reconstructed packet will be   * aligned on a 32-bit boundary.  */o  n u_char *( sl_uncompress_tcp(bufp, len, type, comp) 	u_char *bufp;	 	int len;t 	u_int type; 	struct slcompress *comp;f {  	register u_char *cp;I 	register u_int hlen, changes; 	register struct tcphdr *th; 	register struct cstate *cs; 	register struct ip *ip;   	switch (type) {   	case TYPE_ERROR: 	 	default:s 		goto bad;c   	case TYPE_IP: 		return (bufp);   	case TYPE_UNCOMPRESSED_TCP: 		/*> 		 * Locate the saved state for this connection.  If the state. 		 * index is legal, clear the 'discard' flag. 		 */f 		ip = (struct ip *) bufp; 		if (ip->ip_p >= MAX_STATES)t 			goto bad;  1 		cs = &comp->rstate[comp->last_recv = ip->ip_p];t 		comp->flags &= ~SLF_TOSS;t 		/*; 		 * Restore the IP protocol field then save a copy of thiso> 		 * packet header.  (The checksum is zeroed in the copy so we< 		 * don't have to zero it each time we process a compressed 		 * packet. 		 */d 		ip->ip_p = IPPROTO_TCP;  		hlen = ip->ip_hl; ; 		hlen += ((struct tcphdr *) & ((int *) ip)[hlen])->th_off; 
 		hlen <<= 2;A 		BCOPY(ip, &cs->cs_ip, hlen); 		cs->cs_ip.ip_sum = 0;M 		cs->cs_hlen = hlen;D 		return (bufp);   	case TYPE_COMPRESSED_TCP: 		break; 	}% 	/* We've got a compressed packet. */A 	cp = bufp;* 	changes = *cp++;e 	if (changes & NEW_C) {  		/*9 		 * Make sure the state index is in range, then grab thee> 		 * state. If we have a good state index, clear the 'discard'
 		 * flag. 		 */  		if (*cp >= MAX_STATES) 			goto bad;   		comp->flags &= ~SLF_TOSS;  		comp->last_recv = *cp++;	 	} else {x 		/*= 		 * This packet has an implicit state index.  If we've had ax< 		 * line error since the last time we got an explicit state' 		 * index, we have to toss the packet.a 		 */s 		if (comp->flags & SLF_TOSS)s 			return ((u_char *) 0);  	} 	/*s> 	 * Find the state then fill in the TCP checksum and PUSH bit. 	 */% 	cs = &comp->rstate[comp->last_recv];p 	hlen = cs->cs_ip.ip_hl << 2; 8 	th = (struct tcphdr *) & ((u_char *) &cs->cs_ip)[hlen];( 	th->th_sum = htons((*cp << 8) | cp[1]);	 	cp += 2;  	if (changes & TCP_PUSH_BIT) 		th->th_flags |= TH_PUSH; 	elseo 		th->th_flags &= ~TH_PUSH;    	/*N@ 	 * Fix up the state's ack, seq, urg and win fields based on the 	 * changemask.A 	 */# 	switch (changes & SPECIALS_MASK) {d 	case SPECIAL_I: 		{W; 		register u_int i = ntohs(cs->cs_ip.ip_len) - cs->cs_hlen;v, 		th->th_ack = htonl(ntohl(th->th_ack) + i);, 		th->th_seq = htonl(ntohl(th->th_seq) + i); 		}e 		break;   	case SPECIAL_D:@ 		th->th_seq = htonl(ntohl(th->th_seq) + ntohs(cs->cs_ip.ip_len) 				   - cs->cs_hlen); 		break;  	 	default:t 		if (changes & NEW_U) { 			th->th_flags |= TH_URG; 			DECODEU(th->th_urp) 		} else 			th->th_flags &= ~TH_URG;f 		if (changes & NEW_W) 			DECODES(th->th_win) 		if (changes & NEW_A) 			DECODEL(th->th_ack) 		if (changes & NEW_S) 			DECODEL(th->th_seq) 		break; 	} 	/* Update the IP ID */d 	if (changes & NEW_I)e 		DECODES(cs->cs_ip.ip_id) 	else 6 		cs->cs_ip.ip_id = htons(ntohs(cs->cs_ip.ip_id) + 1);   	/*eE 	 * At this point, cp points to the first byte of data in the packet. D 	 * If we're not aligned on a 4-byte boundary, copy the data down soA 	 * the IP & TCP headers will be aligned.  Then back up cp by thecF 	 * TCP/IP header length to make room for the reconstructed header (weD 	 * assume the packet we were handed has enough space to prepend 128E 	 * bytes of header).  Adjust the lenth to account for the new headere" 	 * & fill in the IP total length. 	 */ 	len -= (cp - bufp);
 	if (len < 0)s 		/*< 		 * we must have dropped some characters (crc should detect) 		 * this but the old slip framing won't)L 		 */1 		goto bad;s   	if ((int) cp & 3) { 		if (len > 0): 			OVBCOPY(cp, (char*)((int)cp & ~3), len);/*23/4/95/dcs*/" 		cp = (u_char *) ((int) cp & ~3); 	} 	cp -= cs->cs_hlen;w 	len += cs->cs_hlen; 	cs->cs_ip.ip_len = htons(len);d$ 	BCOPY(&cs->cs_ip, cp, cs->cs_hlen);  ' 	/* recompute the ip header checksum */  	{( 		register u_short *bp = (u_short *) cp;( 		for (changes = 0; hlen > 0; hlen -= 2) 			changes += *bp++;1 		changes = (changes & 0xffff) + (changes >> 16);e1 		changes = (changes & 0xffff) + (changes >> 16); ( 		((struct ip *) cp)->ip_sum = ~changes; 	}
 	return (cp);;   bad: 	comp->flags |= SLF_TOSS;  	return ((u_char *) 0);+ }    \ /* A.4  Initialization  * )I  * This routine initializes the state structure for both the transmit and	G  * receive halves of some serial line.  It must be called each time the+  * line is brought up.  */*   void sl_compress_init(comp) 	struct slcompress *comp;i {o 	register u_int i;/ 	register struct cstate *tstate = comp->tstate;o   	/*e= 	 * Clean out any junk left from the last time line was used.- 	 */% 	bzero((char *) comp, sizeof(*comp));a 	/*t2 	 * Link the transmit states into a circular list. 	 */' 	for (i = MAX_STATES - 1; i > 0; --i) {c 		tstate[i].cs_id = i;% 		tstate[i].cs_next = &tstate[i - 1];) 	}- 	tstate[0].cs_next = &tstate[MAX_STATES - 1];] 	tstate[0].cs_id = 0;} 	comp->last_cs = &tstate[0]; 	/*+6 	 * Make sure we don't accidentally do CID compression 	 * (assumes MAX_STATES < 255).t 	 */ 	comp->last_recv = 255;) 	comp->last_xmit = 255;s } 