 /* trace & dump routines */    #include "ppp.h" #include "pppprot.h"   #include <stdio.h>   /* LCP [etc.] codes */ #define C_CNFREQ 1 #define C_CNFACK 2 #define C_CNFNAK 3 #define C_CNFREJ 4 #define C_TRMREQ 5 #define C_TRMACK 6 #define C_CODERJ 7 #define C_PROTRJ 8 #define C_ECHORQ 9 #define C_ECHORP 10  #define C_DISCRQ 11    /* LCP options */ * #define O_MRU	1	/* Maximum-Receive-Unit */2 #define O_ACCM	2	/* Async-Control-Character-Map */, #define O_AP	3	/* Authentication-Protocol */% #define O_QP	4	/* Quality-Protocol */ $ #define O_MAGIC 5	/* Magic-Number */0 #define O_PFC	7	/* Protocol-Field-Compression */< #define O_ACFC	8	/* Address-and-Control-Field-Compression */   /* IPCP options */6 #define O_COMPRS	2	/* [header] compression protocol */# #define O_IPADDR	3	/* IP address */   ; void dump16(const unsigned char *, int,	int);	/* forward */   ' /* maximum control protocol elements */  #define MAXC_LCP (C_DISCRQ)  #define MAXC_PAP (C_CNFNAK)  #define MAXC_IPCP (C_CODERJ)  & /* decode control protocol elements */' static const char *c_name(PPPBUF *bp) { + 	static const char *names[1 + MAXC_LCP] = {  		"",  		"ConfReq", 		"ConfAck", 		"ConfNak", 		"ConfRej", 		"TermReq", 		"TermAck", 		"CodeRej", 		"ProtRej", 		"EchoReq", 		"EchoRep",
 		"DiscReq"};  	static char name_buf[31];	 	uchar c;    	c = bp->buf[bp->boff];  	switch(bp->prot) {  	  case P_LCP:- 		if(c > 0 && c <= MAXC_LCP) return names[c];  		break; 	  case P_PAP:- 		if(c > 0 && c <= MAXC_PAP) return names[c];  		break; 	  case P_IPCP: . 		if(c > 0 && c <= MAXC_IPCP) return names[c]; 		break; 	}  + 	sprintf(name_buf,"unknown code 0x%02X",c);  	return name_buf;  }   9 static void opt_lcp_ipcp(uint16 prot, uchar *cp, int l) {  	while(l > 1) {  		switch(prot) { 		  case P_LCP:  			switch(cp[0]) { 			  case O_MRU: 				printf(" MRU"); 
 				break; 			  case O_ACCM:  				printf(" ACCM");
 				break; 			  case O_AP:  				printf(" AP");
 				break; 			  case O_QP:  				printf(" QP");
 				break; 			  case O_MAGIC: 				printf(" MAGIC"); 
 				break; 			  case O_PFC: 				printf(" PFC"); 
 				break; 			  case O_ACFC:  				printf(" ACFC");
 				break;
 			  default:  				printf(" 0x%02X",cp[0]);
 				break; 			}	 			break;    		  case P_IPCP: 			switch(cp[0]) { 			  case O_COMPRS:  				printf(" COMPRS");
 				break; 			  case O_IPADDR:  				printf(" IPADDR");
 				break;
 			  default:  				printf(" 0x%02X",cp[0]);
 				break; 			}	 			break;    		  default: 			abort();  		}    		if(cp[1] > 2) {  			uchar *p = cp + 2; 
 			int ll;   			printf("(%02X",*p++);& 			for(ll = cp[1] - 3; ll > 0; ll--) { 				printf("%02X",*p++); 			} 			printf(")");  		}   
 		l -= cp[1];  		cp += cp[1]; 	} 	printf("\n"); }    /* LCP/IPCP buffer trace */ 6 static void trace_lcp_ipcp(PPPBUF *bp, int outgoing) { 	const char *pname;  	uchar c,s,*cp; 
 	uint16 l;   	switch(bp->prot) {  	  case P_LCP: 		pname = "LCP ";  		break; 	  case P_IPCP:  		pname = "IPCP "; 		break; 	  default: 
 		abort(); 	}   	cp = bp->buf + bp->boff;  	c = *cp++;  	s = *cp++;  	FETCH16(cp,l);    	if(l == bp->len) { $ 		printf("%s %s%s * id=%02X l=%d. ", 			outgoing ? "<--o" : "-->i", 			pname,c_name(bp),s,l); 	 	} else { , 		printf("%s %s%s * len=%d. id=%02X l=%d. ", 			outgoing ? "<--o" : "-->i",! 			pname,c_name(bp),bp->len,s,l);  	}   	if(bp->len >= 4 && l == 4) {  		printf("\n"); 	 		return;  	} 	if(bp->len <= 4 || l <= 4) {  		printf(" ???\n"); 	 		return;  	}   	switch(c) { 	  case C_CNFREQ:  	  case C_CNFACK:  	  case C_CNFNAK:  	  case C_CNFREJ:  		if(llcheck(bp)) {  			printf("*"); # 			opt_lcp_ipcp(bp->prot,cp,l - 4); 
 			return; 		}  		break;   	  case C_TRMREQ:	 	  case C_TRMACK:  		/* 4 + data */ 		break; 			  	  case C_CODERJ:  		/* 4 + rej.p. */ 		break;   	  case C_PROTRJ:  		/* 4 + prot[2] + rej.p. */ 		if(l >= 6) {
 			uint16 pr;    			FETCH16(cp,pr);" 			printf("* prot=%04X ...\n",pr);
 			return; 		}  		break;   	  case C_ECHORQ:  	  case C_ECHORP:  	  case C_DISCRQ:  		/* 4 + magic[4] + data */  		if(l >= 8) {
 			uint32 mg;    			FETCH32(cp,mg);# 			printf("* magic=%08X ...\n",mg); 
 			return; 		}  		break;   	  default:  		break; 	} 	printf("\n"); 	dump16(cp,l - 4,4); 	return; }      /* PAP buffer trace */1 static void trace_pap(PPPBUF *bp, int outgoing) {  	const char *pname = "PAP "; 	uchar c,s,*cp; 
 	uint16 l;   	cp = bp->buf + bp->boff;  	c = *cp++;  	s = *cp++;  	FETCH16(cp,l);    	if(l == bp->len) { $ 		printf("%s %s%s * id=%02X l=%d. ", 			outgoing ? "<--o" : "-->i", 			pname,c_name(bp),s,l); 	 	} else { , 		printf("%s %s%s * len=%d. id=%02X l=%d. ", 			outgoing ? "<--o" : "-->i",! 			pname,c_name(bp),bp->len,s,l);  	}  , 	if(bp->len <= 4 || l <= 4 || l > bp->len) { 		printf(" ???\n"); 	 		return;  	}   	switch(c) { 	  case C_CNFREQ:  		if(l - 4 < 1 + cp[0] + 1 || 2 		   l - 4 < 1 + cp[0] + 1 + cp[1 + cp[0]]) break;1 		printf("* ident(\"%.*s\") password(len=%d.)\n",  			cp[0],cp + 1,cp[1 + cp[0]]); 	 		return;    	  case C_CNFACK:  	  case C_CNFNAK:  		if(l - 4 < 1 + cp[0]) break; 		printf("*\n");# 		if(cp[0]) dump16(cp + 1,cp[0],5); 	 		return;    	  default:  		break; 	} 	printf("\n"); 	dump16(cp,l - 4,4); 	return; }      /* PPP buffer trace/dump */ - void trace_pppbuf(PPPBUF *bp, int outgoing) {  	const char *pname;    	switch(bp->prot) {  	  case P_LCP: 	  case P_IPCP:  		trace_lcp_ipcp(bp,outgoing);	 		return;    	  case P_PAP: 		trace_pap(bp,outgoing); 	 		return;   
 	  case P_IP:  		pname = "IP data"; 		break; 	  case P_CTCP:  		pname = "IP(cTCP) data"; 		break; 	  case P_UTCP:  		pname = "IP(uTCP) data"; 		break; 	  default: ! 		{	static char pname_buf[2+4+1];   ( 			sprintf(pname_buf,"0x%04X",bp->prot); 			pname = pname_buf;  		}  		break; 	}   	printf("%s %s * len=%d.\n",, 		outgoing ? "<--o" : "-->i",pname,bp->len);   #if !defined(DUMP_ALL)0 	if(bp->prot > 0x00FF)	/* exclude client data */ #endif) 		dump16(bp->buf + bp->boff, bp->len, 0);    	return; }      /* line error trace */ void trace_errors(void) {  	static int esum = 0; 
 	int csum;  5 	csum = line_errors.count[0] + line_errors.count[1] +  		line_errors.count[2];  	if(csum != esum) {  		esum = csum;3 		printf("Errors: OUTPUT %d, INPUT %d, FCS16 %d\n", - 			line_errors.count[0],line_errors.count[1],  			line_errors.count[2]);  	} }     , /* dump 16 bytes/line (big-endian, indented)(  * w.j.m. nov 1996, after code from FOD3  */    #include <stdio.h> #include <ctype.h> #define BPL 16  = void dump16(const unsigned char *bp,	/* in: buffer address */ # 	    int n,			/* in: buffer size */ 9 	    int base) {			/* in: base address (printout only) */    int a,i,m,mb;    const unsigned char *lp;   unsigned char trl[BPL+1];  #if 1 G   static const int/*logical*/ bigendian = 1;	/* IP always big-endian */  #else "   static int/*logical*/ bigendian; #endif1   static unsigned char atoa[256], *trtabp = NULL;      /* one-time init */    if(!trtabp) {      for(i = 0; i < 256; i++) {3       if(isprint(i)) atoa[i] = i; else atoa[i] = 0;      }      trtabp = atoa;   #if 0 /     {	/* test for this machine's endian-ness */        static int c1 = 1;,       bigendian = ( *((char *)(&c1)) != 1 );     }  #endif   }      for(a = base, lp = bp, m = n;        m > 0;&       lp += BPL, a += BPL, m -= BPL) {       mb = (m > BPL) ? BPL : m;    #if 1	/* add indentation */        printf("\t");  #endif       if(bigendian) {        printf("%08X ->",a);       for(i = 0; i < mb; i++) {  	if(i % 4 == 0) printf(" "); 	printf("%02X",lp[i]);) 	trl[i] = trtabp ? trtabp[lp[i]] : lp[i]; ! 	if(trl[i] == '\0') trl[i] = '.';        }        if(mb < BPL) {4 	for(i = ((BPL-1)*9)/4 - ((mb-1)*9)/4; i > 0; i--) { 	  printf(" ");  	} 	for(i = mb; i < BPL; i++) { 	  trl[i] = ' '; 	}       }       } else {	/* not bigendian */       if(mb < BPL) {4 	for(i = ((BPL-1)*9)/4 - ((mb-1)*9)/4; i > 0; i--) { 	  printf(" ");  	} 	for(i = mb; i < BPL; i++) { 	  trl[i] = ' '; 	}       } #       for(i = mb-1 ; i >= 0; i--) {  	printf("%02X",lp[i]); 	if(i % 4 == 0) printf(" ");) 	trl[i] = trtabp ? trtabp[lp[i]] : lp[i]; ! 	if(trl[i] == '\0') trl[i] = '.';        }          printf("<- %08X",a);     }        trl[BPL] = '\0';     printf(" -> %s <-\n",trl);   }  } 