5 /* ARP for finding address of just one remote node */   5 #include "arp1_h.h"	/* some "standard" definitions */ ! #include "nmadef.h"	/* my own! */    #include <stdio.h> #include <stdlib.h>  #include <string.h>    #include <descrip.h>& typedef struct dsc$descriptor_s DESCR;   #include <iodef.h> #include <ssdef.h>   /* LAN & ARP structures */   typedef struct lan_address { 	uchar b[6];
 } LANADDR;  1 typedef struct arp_packet {	/* ... RFC 826 ... */ 0 	uint16 hrd,pro;		/* hardware, protocol space */> 	uchar hln,pln;		/* length of hardware & protocol addresses */. 	uint16 op;		/* opcode (1=request, 2=reply) */. 	LANADDR sha;		/* sender's hardware address */' 	uint32 spa;		/* sender's IP address */ , 	LANADDR tha;		/* target hardware address */% 	uint32 tpa;		/* target IP address */  } AR$;     /* externally visible data */  LANADDR arp1_laddr_lcl;  LANADDR arp1_laddr_dst; % char/*logical*/ arp1_laddr_dst_valid;      /* static data */  static struct { 
 	uint16 chan;  	uint16 ariosb[4]; 	AR$ ar;			/* request packet */  	uint16 iiosb[4]; 	 	struct {  		LANADDR from,to; 		uint16 prot;$ 	} ihdr;			/* input header buffer */ 	union { 		uchar b[512]; 	 		AR$ ar; " 	} ibuf;			/* input data buffer */ } arp1;   A static const LANADDR broadcast = {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF};   - static void arp1_request(void);	/* forward */ + static void arp1_input(void);	/* forward */     $ /* externally visible entry point */ void arp1_init( % 	uint32 ourip,	/* local IP address */ % 	uint32 dstip	/* remote IP address */  ) {  	uint16 iosb[4],w;	 	int sts; D 	$DESCRIPTOR(landsc,"ESA0");	/* note that ESA0 _may_be_ a logname */ 	char modebuf[250], *mp;# 	DESCR modedsc = {0-0,0,0,modebuf};    /* assign channel */* 	sts = sys$assign(&landsc,&arp1.chan,0,0); 	if(!(sts & 1)) lib$stop(sts);  
 /* startup */  	mp = modebuf;  1 	/* defaults used: bfn=1, bus=512 (?), fmt=eth */   9 	*((uint16 *)mp)++ = NMA$C_PCLI_PTY;	/* protocol = ARP */  	w = 0x0806; STORE16(mp,w); ! 	*((uint16 *)mp)++ = 0;	/* pad */   < 	*((uint16 *)mp)++ = NMA$C_PCLI_MCA;	/* enable broadcasts */) 	*((uint16 *)mp)++ = 2 + sizeof(LANADDR); % 	*((uint16 *)mp)++ = NMA$C_LINMC_SET;  	*(LANADDR *)mp = broadcast;  	(uchar *)mp += sizeof(LANADDR);  6 	*((uint16 *)mp)++ = NMA$C_PCLI_PAD;	/* padding off */% 	*((uint32 *)mp)++ = NMA$C_STATE_OFF;   9 	*((uint16 *)mp)++ = NMA$C_PCLI_RES;	/* enable restart */ & 	*((uint32 *)mp)++ = NMA$C_LINRES_ENA;  % 	modedsc.dsc$w_length = mp - modebuf; C 	sts = sys$qiow(0,arp1.chan,IO$_SETMODE | IO$M_CTRL | IO$M_STARTUP,  		       iosb,NULL,0,  		       0,&modedsc,0,0,0,0);  	if(!(sts & 1)) lib$stop(sts);& 	if(!(iosb[0] & 1)) lib$stop(iosb[0]);   /* get local enet-addr */ ( 	modedsc.dsc$w_length = sizeof(modebuf);6 	sts = sys$qiow(0,arp1.chan,IO$_SENSEMODE | IO$M_CTRL, 		       iosb,NULL,0,  		       0,&modedsc,0,0,0,0);  	if(!(sts & 1)) lib$stop(sts);& 	if(!(iosb[0] & 1)) lib$stop(iosb[0]);   	mp = modebuf;  	while(mp - modebuf < iosb[1]) {9 		if((*(uint16 *)mp >> 12) & 1) {		/* string parameter */ 4 			if((*((uint16 *)mp)++ & 0xFFF) == NMA$C_PCLI_PHA) 				goto found_pha;   			/* advance by length field */( 			mp += sizeof(uint16) + *(uint16 *)mp;& 		} else {				/* longword parameter */) 			mp += sizeof(uint16) + sizeof(uint32);  		}  	} 	abort();	/* must not happen */ 
 found_pha:4 	if((*((uint16 *)mp)++ != sizeof(LANADDR))) abort();! 	arp1_laddr_lcl = *(LANADDR *)mp;   # /* build request packet - RFC826 */ B 	mp = (char *)&arp1.ar.hrd; w = 1; STORE16(mp,w);	/* "ethernet" */? 	mp = (char *)&arp1.ar.pro; w = 0x0800; STORE16(mp,w);	/* IP */  	arp1.ar.hln = sizeof(LANADDR);  	arp1.ar.pln = sizeof(uint32);G 	mp = (char *)&arp1.ar.op; w = 1; STORE16(mp,w);	/* ares_op$request */   	arp1.ar.sha = arp1_laddr_lcl;E 	mp = (char *)&arp1.ar.spa; STORE32(mp,ourip);	/* saved big-endian */ & 	/* arp1.ar.tha left as 0-0-0-0-0-0 */E 	mp = (char *)&arp1.ar.tpa; STORE32(mp,dstip);	/* saved big-endian */    /* start input */  	arp1_input();   /* start output */ 	arp1_request(); }       /* write (request) completion */ static void arp1_wrqast(void) { 	 	int sts; I 	static const int to_short[2] =  {-31000000,-1};	/* 3.1 sec delta time */ I 	static const int to_long[2] = {-1010000000,-1};	/* 101 sec delta time */    	/* check status */ ! 	if((arp1.ariosb[0] & 1) == 0 &&	 D 	   arp1.ariosb[0] != SS$_OPINCOMPL) 	/* ignore transient failure */ 	 	lib$stop(sts);    	/* set new timer */> 	sts = sys$setimr(0,arp1_laddr_dst_valid ? to_long : to_short, 			 arp1_request,0,0); 	if(!(sts & 1)) lib$stop(sts); }    /* write (request) to LAN */  static void arp1_request(void) {	 	int sts;   ) 	sts = sys$qio(0,arp1.chan,IO$_WRITEVBLK, " 		      arp1.ariosb,arp1_wrqast,0,3 		      &arp1.ar,sizeof(arp1.ar),0,0,&broadcast,0);  	if(!(sts & 1)) lib$stop(sts); }    /* process input from LAN */ static void arp1_rcvast(void) { 	 	int sts;  	uint16 prot,opcod,iosb[4]; 
 	char *cp;   	/* check status */  	if(!(arp1.iiosb[0] & 1)) {   		/* ignore transient failure */0 		if(arp1.iiosb[0] == SS$_OPINCOMPL) goto again;   		lib$stop(arp1.iiosb[0]); 	}   	/* plausibility checks */: 	if(arp1.iiosb[1] < sizeof(AR$)) goto again;		/* ignore */' 	/* ... better don't look at hrd ... */ 2 	cp = (char *)&arp1.ibuf.ar.pro; FETCH16(cp,prot);6 	if(prot != 0x0800) goto again;			/* not IP, ignore */* 	if(arp1.ibuf.ar.hln != sizeof(LANADDR) ||@ 	   arp1.ibuf.ar.pln != sizeof(uint32)) goto again;	/* ignore */2 	cp = (char *)&arp1.ibuf.ar.op; FETCH16(cp,opcod);7 	if(opcod != 1 && opcod != 2) goto again;		/* ignore */   * 	/* ggf. learn about target's enet-addr */? 	if(arp1.ibuf.ar.spa == arp1.ar.tpa) {		/* packet from dstip */ $ 		arp1_laddr_dst = arp1.ibuf.ar.sha; 		arp1_laddr_dst_valid = 1;    		/* tell the world */ 		sys$wake(0,0); 	}  
 	/* reply? */ = 	if(arp1.ibuf.ar.tpa == arp1.ar.spa &&		/* packet to ourip */ + 	   opcod == 1) {				/* & it's a request */  		/* convert into reply */> 		cp = (char *)&arp1.ibuf.ar.op; opcod = 2; STORE16(cp,opcod);& 		arp1.ibuf.ar.tpa = arp1.ibuf.ar.spa;! 		arp1.ibuf.ar.spa = arp1.ar.spa; & 		arp1.ibuf.ar.tha = arp1.ibuf.ar.sha;$ 		arp1.ibuf.ar.sha = arp1_laddr_lcl; 		* 		sts = sys$qio(0,arp1.chan,IO$_WRITEVBLK, 			       NULL,arp1_input,0,( 			       &arp1.ibuf.ar,sizeof(AR$),0,0, 				&arp1.ibuf.ar.tha,0);  		/* ignore errors! */7 		if(sts & 1) return;	/* continue via completion AST */  	}   	/* re-start input */  again: 	arp1_input(); }    /* read from LAN */  static void arp1_input(void) {	 	int sts;   ( 	sts = sys$qio(0,arp1.chan,IO$_READVBLK,! 		      arp1.iiosb,arp1_rcvast,0, 7 		      &arp1.ibuf,sizeof(arp1.ibuf),0,0,&arp1.ihdr,0);  	if(!(sts & 1)) lib$stop(sts); }      /*****/    char *lan2str(LANADDR *lap) {  	static char s[17+1];   + 	sprintf(s,"%02X-%02X-%02X-%02X-%02X-%02X",  		lap->b[0], 		lap->b[1], 		lap->b[2], 		lap->b[3], 		lap->b[4],
 		lap->b[5]); 
 	return s; }    char *ip2str(uint32 ipaddr) {  	static char s[15+1];  	  	sprintf(s,"%d.%d.%d.%d",  		(ipaddr >> 24) & 0xFF, 		(ipaddr >> 16) & 0xFF, 		(ipaddr >>  8) & 0xFF, 		(ipaddr >>  0) & 0xFF); 
 	return s; }      #ifdef TESTING   main() { 	uint32 ipaddr_lcl,ipaddr_rem;  	LANADDR la_rem = {0,0,0,0,0,0};  # 	{	/* IP addresses for this test */ . 		uchar lcl_def[4] = {192,168,1,145};	/* us *// 		uchar rem_def[4] = {192,168,1,45};	/* them */  		uchar *cp;   		cp = lcl_def;  		FETCH32(cp,ipaddr_lcl);  		cp = rem_def;  		FETCH32(cp,ipaddr_rem);  	}  " 	arp1_init(ipaddr_lcl,ipaddr_rem);  * 	printf("local LAN address: %s (IP %s)\n", 		lan2str(&arp1_laddr_lcl),  		ip2str(ipaddr_lcl));   	while(1) {  		sys$hiber();   		if(arp1_laddr_dst_valid &&< 		   memcmp(&la_rem,&arp1_laddr_dst,sizeof(LANADDR)) != 0) {- 			printf("remote LAN address: %s (IP %s)\n",  				lan2str(&arp1_laddr_dst),  				ip2str(ipaddr_rem)); 			la_rem = arp1_laddr_dst;  		}  	} }    #endif	/* TESTING */