/* wjm 03-nov-1995: simplified [VMS] modem I/O, plus data link protocol
 *		for XCEPT, partially lifted from ceptd/level2.c
 * wjm 19-nov-1995: add mi_efnmask() for [undoc.] XMultiplexInout()
 */

#include	<stdio.h>
#include	<descrip.h>
#include	<iodef.h>
#include	<ssdef.h>

extern void do_datalog(unsigned char *,int);	/* XCEPT callback */

/******************************* I/O *****************************************/

#define MI2_BUFSIZ 20000	/* buffering between "level2" & XCEPT */
char mi2_buf[MI2_BUFSIZ];	/* circular buffer, must not overflow ... */
int mi2_count = 0;
int mi2_ii = 0;			/* input index */
int mi2_oi = 0;			/* output index */

#define MI_BUFSIZ 2000		/* line input buffer size */
static unsigned char mi_buf[MI_BUFSIZ];
static int mi_count = 0;
static unsigned char *mi_bp;
static unsigned short mi_iosb[4];

static int modemchan = 0;

#define mi_efn 9		/* event flag # */


static void mi_start(int n)
{
	int sts,nb,term[2] = {0,0};
	unsigned short modebuf[4];

	if(modemchan == 0) return;

	if(n == 0) {
		sts = sys$qiow(0,modemchan,IO$_SENSEMODE | IO$M_TYPEAHDCNT,
			mi_iosb,0,0,
			modebuf,0,0,0,0,0);
		if(sts & 1) sts = mi_iosb[0];
		if(!(sts & 1)) lib$stop(sts);
		nb = modebuf[0];
	} else nb = n;

	if(nb < 1) nb = 1; else if(nb > sizeof(mi_buf)) nb = sizeof(mi_buf);

	sts = sys$qio(mi_efn,modemchan,IO$_READVBLK | IO$M_NOECHO,
		mi_iosb,0,0,
		mi_buf,nb,0,&term,0,0);		/* timeout? */
	if(!(sts & 1)) lib$stop(sts);
}


void modem_open(void)
{
	int sts;
	$DESCRIPTOR(modemdsc,"$MODEM");


	sts = sys$assign(&modemdsc,&modemchan,0,0);
	if(!(sts & 1)) lib$stop(sts);

	/* setmode (pasthru, etc.) ? */

	mi_start(1);
}


int/*logical*/ mi_avail(void)
{
	int sts;
	unsigned int mask;

	if(modemchan == 0) return 0;

	sts = sys$readef(mi_efn,&mask);
	if(!(sts & 1)) lib$stop(sts);

	return (mask >> (mi_efn & 31)) & 1;
}

int mi_efnmask(void)
{
	unsigned int mask;

	return (modemchan == 0) ? 0 : (1 << mi_efn);
}


static int getmodem(void)
{
	int sts;
	unsigned char c;

	if(modemchan == 0) return -1;

	while(mi_count == 0) {		/* QIO pending */
		sts = sys$synch(mi_efn,mi_iosb);
		if(!(sts & 1)) lib$stop(sts);
		sts = mi_iosb[0];
		if(!(sts & 1)) lib$stop(sts);
		mi_count = mi_iosb[1];
		mi_bp = mi_buf;
		if(mi_count == 0) mi_start(1);	
	}

	c = *mi_bp++;
	mi_count--;
	if(mi_count == 0) mi_start(0);

	return c;
}


void putmodem2(char *cp,int n)
{
	int sts;
	unsigned short iosb[4];

	if(modemchan == 0) return;

	sts = sys$qiow(0,modemchan,IO$_WRITEVBLK | IO$M_NOFORMAT,
		iosb,0,0,
		cp,n,0,0,0,0);
	if(sts & 1) sts = iosb[0];
	if(!(sts & 1)) lib$stop(sts);
}

void putmodem(char c)
{
	putmodem2(&c,1);
}


void modem_close(void)
{
	int sts;

	if(modemchan == 0) return;

	{
		double d_wait = 1.0;	/* for GCC */
		float f_wait = d_wait;

		putmodem('+');
		lib$wait(&f_wait);
		putmodem('+');
		lib$wait(&f_wait);
		putmodem('+');
		lib$wait(&f_wait); lib$wait(&f_wait);
		putmodem2("\rATH\r",5);
	}

	sts = sys$dassgn(modemchan);
	if(!(sts & 1)) lib$stop(sts);
	modemchan = 0;
}


/******************************************************************************/

static void putsocket(unsigned char c[], int n)
{
	int i;

	
	do_datalog(c,n);

	mi2_count += n;

#if 0
	fprintf(stderr,"putsocket(,%d)  mi2_count = %d\n",n,mi2_count);
#endif

	if(mi2_count > MI2_BUFSIZ) {
		fprintf(stderr,"FATAL: mi2_buf overflow\n");
		abort();
	}

	for(i = 0; i < n; i++) {
		mi2_buf[mi2_ii++] = c[i];
		if(mi2_ii >= MI2_BUFSIZ) mi2_ii = 0;
	}
}


/******************************************************************************
 * the following was lifted (& a little modified) from ceptd/level2.c
 *
 * Original copyright & disclaimers follow ...
 */
/*
XCept Version 2.2

Copyright (c) 1994, Department of Computer Science IV (Operating Systems), 
          University of Erlangen-Nrnberg, Germany.
Copyright (c) 1992, 1993 Arno Augustin, Frank Hoering, 
          University of Erlangen-Nrnberg, Germany.
All rights reserved.


Non-commercial, i.e. private and academic, redistribution and use in source
and binary forms, with or without modification, are permitted provided that
the following conditions are met:
1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. All advertising materials mentioning features or use of this software
   must display the following acknowledgement:
	This product includes software developed by the Department of
         Computer Science IV (Operating Systems), University of
	Erlangen-Nrnberg, Germany.
4. Neither the name of the University nor the names of its contributors
   may be used to endorse or promote products derived from this software
   without specific prior written permission.

All other kinds of redistribution and use, especially commercially, are
subject to license agreements, details of which are available on request
(contact: 
                Dipl.-Inf. Dirk Husemann
                Universitt Erlangen-Nrnberg
                IMMD IV
                Martensstrae 1
                D-91058 Erlangen
                
                Email:  husemann@informatik.uni-erlangen.de
                FAX:    +49 9131 858 732).

THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO
EVENT SHALL THE AUTHORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */


/* #include 	"config.h"	*/
/* #include 	"cept.h" 	*/
/********************  This is CONTROL SET C0 of CEPT ***********************/
#define NUL 0x00         /* Null                     (data link) */
#define SOH 0x01         /* start of heading         (data link) */
#define STX 0x02         /* start text               (data link) */
#define ETX 0x03         /* end text                 (data link) */
#define EOT 0x04         /* end of transmission      (data link) */
#define ENQ 0x05         /* enquiry                  (data link) */
#define ACK 0x06         /* acknowledge              (data link) */
#define ITB 0x07         /* end intermediate block   (data link) */
#define APB 0x08         /* active position back     (control sequence) */
#define APF 0x09         /* active position forward  (control sequence) */
#define APD 0x0a         /* active position down     (control sequence) */
#define APU 0x0b         /* active position up       (control sequence) */
#define CS  0x0c         /* clear screen             (control sequence) */
#define APR 0x0d         /* active position return   (control sequence) */
#define LS1 0x0e         /* locking shift 1          (control sequence) */
#define LS0 0x0f         /* locking shift 0          (control sequence) */
#define DLE 0x10         /* data link escape         (data link) */
#define CON 0x11         /* cursor on                (control sequence) */
#define RPT 0x12         /* repeat last character    (control sequence) */
#define INI 0x13         /* initiator '*'            (btx special) */
#define COF 0x14         /* cursor off               (control sequence) */
#define NAK 0x15         /* negative acknowledge     (data link) */
#define SYN 0x16         /*                          (data link) */
#define ETB 0x17         /* end textblock            (data link) */
#define CAN 0x18         /* cancel,clear eol         (control sequence) */
#define SS2 0x19         /* single shift for G2 SET  (control sequence) */
#define DCT 0x1a         /*                          (btx special) */
#define ESC 0x1b         /* escape                   (control sequence) */
#define TER 0x1c         /* terminator '#'           (btx special) */
#define SS3 0x1d         /* single shift for G3 SET  (control sequence) */
#define APH 0x1e         /* active position home     (control sequence) */
#define US  0x1f         /* active position (x,y)    (control sequence) */
/****************************************************************************/


#define NOBLOCK    0        /* not receiving a block */
#define TEXTBLOCK  1        /* normal text block     */
#define IMAGEBLOCK 2        /* transparent block     */
#define ERROR      0        /* status error          */

static unsigned short 	crc=0;


send_TFI()
{
   putmodem(SOH);
   putmodem('@');  /* @ = intermediate blocksize */
   putmodem('5');  /* 5 = max. 256 bytes         */
   putmodem(ETX);
}
   

static void calccrc(unsigned int c)
{

   register unsigned int 	cr = crc, ch = c;
   register unsigned int 	i,bit;

   for(i=0; i<8; i++){           /* for all bits in character c */
      bit = (cr & 1) ^ (ch & 1);
      cr >>= 1;                  /* bit 15 now cleared */
      if(bit) cr ^= 0xa001;      /* xor for polynom: x^16+x^15+x^2+x^0 */
      ch >>= 1;                  /* shift character for next bit */
   }
   crc=cr;
}


/* get 2 bytes from modem and calccrc, return value is crc (should be 0 if
 * no crc error), during check handle socket inputs
 */ 
static unsigned short getcheck()
{
	unsigned char 	c;

	/* get 2 checkbytes */
	/* wjm - be optimistic & assume getmodem() to complete quickly */
	 c=getmodem();
	 calccrc(c);
	 c=getmodem();
	 calccrc(c);

	if(crc) fprintf(stderr,"MODEMINPUT: CRC error %x\n",(int)crc);
	return crc;
}


/* modeminput: this is data link layer (level 2) for getting blocks from
 * btx, crc check is done and characters are send to client
 */

#define 	BLOCKBUFSIZ 2048

modeminput(void)	/* to be called while EVENT FLAG #mi_efn is set */
{
   static unsigned int		block = NOBLOCK, bufferlen = 0;
   static unsigned int		tfi = 0;
   static unsigned char 	ack01 = '0',st = EOT;
   static unsigned char 	buffer[BLOCKBUFSIZ];
   static unsigned char 	c = 0;
   static unsigned char         lastchar;
   
   c = getmodem();

   switch( block ) {
      case TEXTBLOCK:
         calccrc(c);
         switch(c) {
            case DLE:
            case NAK:
            case ACK:
            case SOH: fprintf(stderr,"MODEMINPUT: Bad char %x\n",c); break;
            case STX:
	      if(st == ERROR || st == ETB){
		 crc = 0; bufferlen = 0;
		 st = EOT;
	      }
	      break;
            case EOT: ack01 = '0'; block = NOBLOCK; break;
            case ITB: 
            case ETB:
            case ETX:
               if(getcheck() || st == ERROR){ 
                  bufferlen = 0; crc = 0; putmodem(NAK); st = ERROR;
		  break;
               }
	       if(bufferlen){
		  putsocket(buffer, bufferlen);
		  bufferlen = 0;
	       }
               st = c;
               if(c == ITB) putmodem(ACK);
               else {
                  ack01 ^= 1;  putmodem(DLE);  putmodem(ack01);
                  if(c == ETX) block = NOBLOCK;  /* end of textblock */
               }
               break;
            case ENQ:
               switch( st ) {
                  case ERROR: putmodem(NAK);  break;
		  case EOT:   putmodem(NAK);  break;
                  case ITB:   putmodem(ACK);  putmodem(NAK); break;
                  case ETX: 
                  case ETB:   putmodem(DLE);  putmodem(ack01);
		              putmodem(NAK); break;
               }
   	       break;
            default: 
               if(bufferlen < BLOCKBUFSIZ-1) buffer[bufferlen++] = c;
               else fprintf(stderr,"MODEMINPUT: Blockbuffer overflow!\n");
               break;
         }
	 break;
       default:     /* NOBLOCK */
         st = EOT;
	 if(tfi){
	    if(tfi == SOH) { lastchar = c; tfi = ENQ; }
	    else           { if(c == ENQ) send_TFI(); tfi=0;}
	 }
         switch(c) {
	  case EOT: 	ack01 = '0'; break;
	  case SOH:     tfi = SOH;
	  case STX: 	crc = 0;  block = TEXTBLOCK; bufferlen = 0;  break;
	  default: 	putsocket(&c,1);
         }
         break;
   }
   return 1;
}
