M /* VMS (external) reference clock support (to be called from REFCLOCK_LOCAL): 4  *	handle "local clock" poll of unit# VMS_LOCALUNIT.  *7  *	- Fail if logical name XNTP_LOCAL_VALID is undefined D  *	   	else report VMS system time (even for the XNTPD_TIC version).5  *	- If the logical name evaluates to an integer > 0, 1  *		take its value as dispersion in milliseconds, C  *		else dispersion = 10ms (as is the default with REFCLOCK_LOCAL).   */    #include "ntpd.h"  #include "ntp_refclock.h"  #include "ntp_stdlib.h"  #include "ntp_unixtime.h"   + #if defined(VMS) && defined(VMS_LOCALUNIT)	   $ /* start copy from REFCLOCK_LOCAL */E #define DISPERSION	(FP_SECOND / 100) /* default dispersion (10 ms) */    /*!  * Imported from the timer module   */  extern u_long current_time;  /* end copy */    . /* Imported from VMS_TICTIME or VMS_ADJTIME */# extern void current_VMS_ts(l_fp *);     & void vms_local_poll(struct peer *peer) { 
 	char *vp; 	int vi;& 	l_fp ntp_ts,vms_ts;	/* time stamps */ 	l_fp off;		/* clock offset */  $ /* start copy from REFCLOCK_LOCAL */ 	struct refclockproc *pp;    	pp = peer->procptr;
 	pp->polls++;  	pp->lasttime = current_time;  /* end copy */  1 	/* For now, fudgetime1 and fudgetime2 ignored */      	/* translate logical name.  	 * > 	 * NOTE: on VMS, the result of getenv() can change over time! 	 */ 	vp = getenv("XNTP_LCL_VALID"); 2 	if(!vp) return;			/* logname undefined => fail */    1 	/* dispersion depending on logical name value */ ) 	if(sscanf(vp,"%d",&vi) == 1 && vi > 0) {  		struct timeval vtv;  		l_fp vts;    		vtv.tv_sec = vi / 1000; # 		vtv.tv_usec = (vi % 1000) * 1000;  		TVTOTS(&vtv,&vts);  ! 		pp->dispersion = LFPTOFP(&vts); 	 	} else {  		pp->dispersion = DISPERSION; 	}     	/* time stamp(s) & offset */ & 	gettstamp(&ntp_ts);		/* XNTPD time */ 	pp->lastrec = ntp_ts;  7 	vms_ts = ntp_ts;		/* VMS == NTP, unless TICs based */	 7 	current_VMS_ts(&vms_ts);	/* no-op unless TICs based */    	off = vms_ts; 	L_SUB(&off, &ntp_ts);     	/* report results */ 2 	refclock_receive(peer, 			/* struct peer *peer */ 			&off, 			/* l_fp *offset */ 			0,			/* s_fp delay */$ /* start copy from REFCLOCK_LOCAL */) 			pp->dispersion,		/* u_fp dispersion */ % 			&pp->lastrec,		/* l_fp *reftime */ % 			&pp->lastrec,		/* l_fp *rectime */ . 			pp->sloppyclockflag);	/* int leap -- ??? */ /* end copy */ }   4 #endif 	/* defined(VMS) && defined(VMS_LOCALUNIT) */