 /* **  VMS readdir() routines. : **  Written by Rich $alz, <rsalz@bbn.com> in August, 1990. **  This code has no copyright.  **G **  Feb'95 --	reliance on <descrip.h> eliminated, here and in dirent.h; @ **		support for Unix-style directory specifications implemented;? **		vmsreaddirversions() modified to return prior flag setting; ? **		use ANSI headers <stdlib.h> and <string.h> plus VMS headers > **		<lib$routines.h> and <fscndef.h>; minor lint cleanup.	[pr]> **  Apr'95 --	change FSCN_DIR from list of things allowed in a> **		directory to complemented list of things not allowed.	[pr] ** **  Known problems: = **		garbage directory specifications aren't always diagnosed.  */ #include <stdlib.h>  #include <string.h>  #include <stdio.h> #include <ctype.h> #include <errno.h> #include <lib$routines.h> . #include <fscndef.h>	/* $FILESCAN arguments */ #include <rmsdef.h>  #include "dirent.h"   8     /* Uncomment the next line to get a test routine. */ /* #define TEST */  2     /* Number of elements in vms_versions array */G #define VERSIZE(e)	(sizeof e->vms_versions / sizeof e->vms_versions[0])   &     /* Simplified string descriptor */3 struct dsc { unsigned short len, mbz; char *adr; };    #if 0 B     /* Parts of file specification used to specify a directory. */I #define FSCN_DIR (FSCN$M_NODE|FSCN$M_DEVICE|FSCN$M_ROOT|FSCN$M_DIRECTORY)  #else O     /* (That doesn't work right under V6.1 because of extra node flag bits.) */ < #define FSCN_DIR (~(FSCN$M_NAME|FSCN$M_TYPE|FSCN$M_VERSION)) #endif  $ extern unsigned long sys$filescan();  ,     /* Filename syntax conversion routine */F #ifdef __DECC	/* (really depends on run-time library, not compiler) */ #define cvt__to_vms decc$to_vms  #else   #define cvt__to_vms shell$to_vms #endif; extern int	cvt__to_vms(char *,int (*)(char *,int),int,int); " static int	cvt_action(char *,int);  G     /* Callback routine uses non re-entrant communication w/ caller. */  static char	nambuf[255+1];   /*D **  XXX$to_vms callback routine.  Note: old versions of shell$to_vmsB **  didn't document the second argument, which indicates whether aB **  directory of foo/bar was converted into "[.foo]bar.dir" ratherG **  than "[.foo.bar]" (such conversion is requested by passing non-zero E **  as XXX$to_vms's 4th argument; also undocumented in old versions).  */
 static int- cvt_action(char *name, int dir_flag___unused)  { %     nambuf[sizeof nambuf - 1] = '\0'; 3     (void)strncpy(nambuf, name, sizeof nambuf - 1); B     /* An even value tells xxx$to_vms that conversion should stop;H        that point is moot here since wildcard processing is disabled. */
     return 0;  }    /*4 **  Open a directory, return a handle for later use. */ DIR * 
 opendir(name)      const char		*name; {      DIR			*dd;     struct dsc		name_dsc;      int			len, retry = 0;      unsigned long	flags;  F     /* Validate the directory name argument.  ("[...]" is allowed!) */1     if (!name || !*name || strchr(name, '*') != 0 <       || strchr(name, '%') != 0 || strchr(name, '?') != 0) {3 	/* Name is required; wildcards are not allowed. */  	errno = ENOTDIR; 
 	return NULL;      } J     nambuf[sizeof nambuf - 1] = '\0';	/* (strncpy doesn't guarantee it) */<     name_dsc.adr = strncpy(nambuf, name, sizeof nambuf - 1);     name_dsc.mbz = 0;      do {% 	name_dsc.len = len = strlen(nambuf); G 	/* Check which components of file specification seem to be present. */ A 	flags = ~0;	    /* (init so that we can ignore return status) */ 2 	(void)sys$filescan(&name_dsc, (void *)0, &flags);< 	if ((flags & ~FSCN_DIR) != 0 || strchr(nambuf, '/') != 0) {G 	    /* Didn't supply nice directory name; check for Unix-style one. */ 9 		/* (stupid shell$to_vms doesn't like trailing slash) */ C 	    if (len > 1 && nambuf[len - 1] == '/') nambuf[len - 1] = '\0';   E 	    if (++retry > 1 || cvt__to_vms(nambuf, cvt_action, 0, 0) != 1) {  		errno = ENOTDIR; 		return NULL;F 	    } /* else:	cvt_action() has updated `nambuf'; `retry' is now 1 */F 	} else retry = 0;  /* have something, possibly after retrying once */     } while (retry);  5     /* Get memory for the handle, and the pattern. */ 3     if ((dd = (DIR *)malloc(sizeof *dd)) == NULL) {  	errno = ENOMEM;
 	return NULL;      } H     dd->pattern = malloc((unsigned int)(strlen(nambuf) + sizeof "*.*"));     if (dd->pattern == NULL) { 	free((void *)dd); 	errno = ENOMEM;
 	return NULL;      }        /* Fill in the fields. */ 5     (void)strcat(strcpy(dd->pattern, nambuf), "*.*");      dd->context = 0;     dd->count = 0;     dd->vms_wantversions = 0;      dd->pat.adr = dd->pattern;&     dd->pat.len = strlen(dd->pattern);     dd->pat.mbz = 0;2     (void)memset(&dd->entry, 0, sizeof dd->entry);       return dd; }      /*J **  Set the flag to indicate we want versions or not.  Return old setting. */ int  vmsreaddirversions(dd, flag)
     DIR		*dd;      int		flag; { (     int old_flag = dd->vms_wantversions;        dd->vms_wantversions = flag;     return old_flag; }      /*  **  Free up an opened directory. */ void closedir(dd)
     DIR		*dd;  { 
     if (dd) { ' 	(void)lib$find_file_end(&dd->context);  	free(dd->pattern);  	free((void *)dd);     }  }      /*9 **  Collect all the version numbers for the current file.  */ static void  collectversions(dd)      DIR			*dd; {      struct dsc		pat;     struct dsc		res;     struct dirent	*e; 
     char		*p;      char		buff[sizeof nambuf];     int			i;     char		*text;     long		context;       /* Convenient shorthand. */      e = &dd->entry;   O     /* Add the name plus version wildcard, replacing the "*.*" put on before */      i = strlen(dd->pattern);  /* assert( i > 3 ); */ M     text = malloc((unsigned int)((i - 3) + strlen(e->d_name) + sizeof ";*"));      if (text == NULL)  	return;$     (void)strcpy(text, dd->pattern);8     (void)strcat(strcpy(&text[i - 3], e->d_name), ";*");  4     /* Set up the pattern and result descriptors. */     pat.adr = text;      pat.len = strlen(text);      res.adr = buff;      res.len = sizeof buff - 1;     pat.mbz = res.mbz = 0;  *     /* Read files, collecting versions. */J     for (context = 0; e->vms_verscount < VERSIZE(e); e->vms_verscount++) {E 	if (lib$find_file(&pat, &res, &context) == RMS$_NMF || context == 0)  	    break;  	buff[sizeof buff - 1] = '\0'; 	if (p = strchr(buff, ';')) 5 	    e->vms_versions[e->vms_verscount] = atoi(p + 1);  	else , 	    e->vms_versions[e->vms_verscount] = -1;     } &     if (e->vms_verscount < VERSIZE(e))( 	e->vms_versions[e->vms_verscount] = -1;  &     (void)lib$find_file_end(&context);     free(text);  }      /*+ **  Read the next entry from the directory.  */ struct dirent *  readdir(dd)      DIR			*dd; {      struct dsc		res;     char		*p, *q;      int			i;  6     /* Set up result descriptor, and get next file. */     res.adr = nambuf;       res.len = sizeof nambuf - 1;     res.mbz = 0;     dd->count++;L     /* (ought to check for generic success/failure, not a specific value) */?     if (lib$find_file(&dd->pat, &res, &dd->context) == RMS$_NMF       || dd->context == 0L) 	/* None left... */ 
 	return NULL;         /* Strip trailing blanks. */%     nambuf[sizeof nambuf - 1] = '\0'; E     for (p = &nambuf[sizeof nambuf - 1]; p > nambuf && *--p == ' '; )  	*p = '\0';   >     /* Skip any directory component and just copy the name. */     p = nambuf; B     while ((q = strchr(p, ']')) != 0 || (q = strchr(p, '>')) != 0) 	p = q + 1; D     (void)strncpy(dd->entry.d_name, p, sizeof dd->entry.d_name - 1);9     dd->entry.d_name[sizeof dd->entry.d_name - 1] = '\0';        /* Clobber the version. */1     if ((p = strchr(dd->entry.d_name, ';')) != 0)  	*p = '\0';         dd->entry.vms_verscount = 0;"     dd->entry.vms_versions[0] = 0;     if (dd->vms_wantversions)  	collectversions(dd);      return &dd->entry; }      /*9 **  Return something that can be used in a seekdir later.  */ long telldir(dd) 
     DIR		*dd;  {      return dd->count;  }      /*7 **  Return to a spot where we used to be.  Brute force.  */ void seekdir(dd, count)
     DIR		*dd;      long	count;  {      int		vms_wantversions;  ,     /* If we haven't done anything yet... */     if (dd->count == 0)  	return;  ,     /* Remember some state, and clear it. */,     vms_wantversions = dd->vms_wantversions;     dd->vms_wantversions = 0; *     (void)lib$find_file_end(&dd->context);     dd->context = 0;  (     /* The increment is in readdir(). */,     for (dd->count = 0; dd->count < count; ) 	(void)readdir(dd);   ,     dd->vms_wantversions = vms_wantversions; }      #ifdef	TEST  #include "dirent.h"    int  main() {      char		buff[256];     DIR			*dd;     struct dirent	*dp;     int			i;     int			j;       for ( ; ; ) {  	printf("\n\nEnter dir:  "); 	(void)fflush(stdout);$ 	if (!gets(buff) || buff[0] == '\0') 	    break; $ 	if ((dd = opendir(buff)) == NULL) { 	    perror(buff); 	    continue; 	}  = 	/* Print the directory contents twice, the second time print  	 * the versions. */ 	for (i = 0; i < 2; i++) { 	    while (dp = readdir(dd)) { 0 		printf("%s%s", i ? "\t" : "    ", dp->d_name);) 		for (j = 0; j < dp->vms_verscount; j++) * 		    printf("  %d", dp->vms_versions[j]); 		printf("\n");  	    } 	    rewinddir(dd);  	    vmsreaddirversions(dd, 1);  	} 	closedir(dd);     }      exit(0);     /*NOTREACHED*/
     return 0;  }  #endif	/* TEST */ 