/* duplicate "tape" (from/to "ZT" disk file)
 *
 * w.j.m. aug 1994
 * mod 11-aug-1994 wjm: if T2D or UNLOAD_OUTPUT, unload TAP2 when done
 *			(for 'dsktap', cache routines, etc.)
 * fix 10-oct-1995 wjm: fix block counts
 */

#ifdef T2D
#define T1REW TAPREW
#define T1RD TAPRD
#define T2REW TAP2REW
#define T2WR TAP2WR
#define T2WTM TAP2WTM
#define T2RUN TAP2RUN
#define T2_hwl TAP2_hwl
#define UNLOAD_OUTPUT 1
#endif

#ifdef D2T
#define T1REW TAP2REW
#define T1RD TAP2RD
#define T2REW TAPREW
#define T2WR TAPWR
#define T2WTM TAPWTM
#define T2RUN TAPRUN
#define T2_hwl TAPE_hwl
#endif

#ifndef UNLOAD_OUTPUT		/* unload output tape when successful */
#define UNLOAD_OUTPUT 0
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

extern int T1REW(void),T1RD(void *,int,int *);
extern int T2REW(void),T2WR(void *,int),T2WTM(void);

int T2_hwl;

/*****/

static void check(int rc, char *msg)
{
  if(rc == 0) return;

  printf("I/O failure: %s, rc=%d\n",msg,rc);
  exit(rc);
}

main()
{
  const int bl = 0xFFFF;
  char buf[0xFFFF];
  int rc,xrc,nf,nbt,nbf,nb,rl,cl;
  int/*logical*/ labelled = 0;


  check(T2REW(),"REWIND(output)");
  check(T2_hwl,"read-only output");
  check(T1REW(),"REWIND(input)");

  nbt = 0;
  xrc = 0;

  for(nf = 1; ; nf++) {   /* loop on "files" */
    nbf = nb = 0;
    cl = -1;

    rc = T1RD(buf,bl,&rl);
    if(rc == 2) {
      check(T2WTM(),"WRITEMARK(output)");
      if(labelled) {
        switch(nf % 3) {
        case 1: /* empty HDRn label group */
          printf("End of labelled tape\n");
          break;
        case 2: /* empty data */
          printf("Tape file %4d DATA: empty\n",(nf+1)/3);
          continue;     /* with next file */
        case 0: /* empty EOFn label group */
          printf("Tape file %4d EOFn: empty - BAD input tape format\n",nf/3);
          printf("End of tape ASSUMED\n");
          xrc = 10;
          break;
        }
        break;
      } else {
        printf("End of unlabelled tape (double tape mark)\n");
        break;
      }
    }
    check(rc,"READ(input)");
    
    if(nf == 1 &&
       rl >= 80 &&
       memcmp("VOL1",buf,4) == 0) labelled = 1;
      
    printf("Tape file ");
    if(labelled) {
      switch(nf % 3) {
      case 1:
        printf("%4d HDRn",(nf+2)/3);
        break;
      case 2:
        printf("%4d DATA",(nf+1)/3);
        break;
      case 0:
        printf("%4d EOFn",nf/3);
        break;
      }
    } else {
      printf("%4d",nf);
    }
    printf(": block sizes");

    do {        /* loop on data blocks */
      if(rl != cl) {
        if(nb != 0) {
          printf("[%d]",nb);
        }
        nb = 1;
        cl = rl;
        printf(" %d",cl); fflush(stdout);
      } else {
        nb++;
	nbf++;
      }

      rc = T2WR(buf,rl);
      if(rc != 0) {
        printf("[%d]\n",nb);
        check(rc,"WRITE(output)");
      }

      rc = T1RD(buf,bl,&rl);
      if(rc == 2) {
        printf("[%d].\n",nb);
        check(T2WTM(),"WRITEMARK(output)");
      } else if(rc != 0) {
        printf("[%d]\n",nb);
        check(rc,"READ(input)");
      }

    } while(rc != 2);   /* end loop on blocks */

    nbt += nbf;
  }             /* end loop on "files" */

  /* try to write one more tape mark for future safety */
  T2WTM();      /* no error check */

#if UNLOAD_OUTPUT	/* in addition, try to unload output tape */
  T2RUN();
#endif

  printf("Total of %d tape files, %d blocks copied.\n",
         labelled ? (nf-1)/3 : nf-1,
         nbt);

  exit(xrc);
}
