;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                                              ;;
;;   BOX                                        ;;
;;                                              ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;
; This macro prompts the user for the upper left corner, row and column
; followed by a prompt for the lower right corner.
; 
; The macro then draws a box of the specified size. If the port type of
; requesting port is ANSI, the box is drawn using the '*' character. If
; the port type is VT100, the macro draws the box in VT100 line drawing
; mode.
;
; This macro consist of three macro files. 
;
; macro file name             description
;
; box.m                       The top level macro
; box_ansi_sm.m               A sub-macro used to draw the box if port
;                             type is ANSI.
; box_vt_sm.m                 A sub-macro used to draw the box if port
;                             type is VT100.
; box_try_sm.m                A sub-macro used to display 'try again' 
;                             message.
;
; To execute this macro enter 'box'. 
;

;authip   ddd.ddd.ddd.ddd ports all
;authdev  ansi

descript "This macro draws a box of the specified size.\n"

beginmac

;cacheoff                    ; don't cache the macro
;debugon                     ; enable debug

if ( device < ansi )
   echo "\n\n"
   "This macro can only be run on an ANSI or VT100 compatible terminal.\n"
   "If your terminal is ANSI or VT100 compatible, use the port command\n"
   "SET/DEFINE/CHANGE PORT TYPE ANSI or VT100 to configure your port.\n"
   "Then re-issue the macro request.\n\n"

   exit
endif

currc 1 1
clr
echo "This macro demonstates how to draw a box using a macro subroutine.\n"

;
; Get row of uppper left corner
;

align                   ; force start of loop to new record
loop
   currc 4 1
   curon
   f1 = 0               ; reset error flag
   echo "Enter the row of the upper left corner (1:23): "
   clrends
   read                 ; wait for input
   atoi b1 kb           ; convert ascii input to decimal

;
; Check for valid input
;

   if (b1 < 1)
      f1 = 1            ; set error, input out of range
   elif ( b1 > 23)
      f1 = 1            ; set error, input out of range
   endif
   if (f1 == 1)         ; check input was out of range
      call box_try_sm
   else
      break             ; input was good, exit loop
   endif
endloop

;
; Get column of upper left corner
;

align                   ; force start of loop to new record
loop
   currc 5 1
   curon
   f1 = 0               ; reset error flag
   echo "Enter the column of the upper left corner (1:80): "
   clrends
   read                 ; wait for input
   atoi b2 kb           ; convert ascii input to decimal

;
; Check for valid input
;

   if (b2 < 1)
      f1 = 1            ; set error
   elif ( b2 > 80)
      f1 = 1            ; set error
   endif
   if (f1 == 1)         ; check input was out of range
      call box_try_sm
   else
      break             ; input was good, exit loop
   endif
endloop

;
; Get row of lower right corner
;

align                   ; force start of loop to new record
loop
   currc 6 1
   curon
   f1 = 0               ; reset error flag
   echo "Enter the row of the lower right corner (1:23): "
   clrends
   read                 ; wait for input
   atoi b3 kb           ; convert ascii input to decimal

;
; Check for valid input
;

   if (b3 < 1)
      f1 = 1            ; set error
   elif ( b3 > 23)
      f1 = 1            ; set error
   elif ( b3 <= b1)
      f1 = 1            ; set error
   endif
   if (f1 == 1)         ; check input was out of range
      call box_try_sm
   else
      break             ; input was good, exit loop
   endif
endloop

;
; Get column of lower right corner
;

align                   ; force start of loop to new record
loop
   currc 7 1
   curon
   f1 = 0               ; reset error flag
   echo "Enter the column of the lower right corner (1:80): "
   clrends
   read                 ; wait for input
   atoi b4 kb           ; convert ascii input to decimal

;
; Check for valid input
;

   if (b4 < 1)
      f1 = 1            ; set error
   elif ( b4 > 80)
      f1 = 1            ; set error
   elif ( b4 <= b2 )
      f1 = 1            ; set error
   endif
   if (f1 == 1)         ; check input was out of range
      call box_try_sm
   else
      break             ; input was good, exit loop
   endif
endloop
if (device == vt100)
   call box_vt_sm
else
   call box_ansi_sm
endif
currc 24 1
echo "Enter <return> to restart or break to exit: "
read                    ; wait for carriage return or break. Break if abort
                        ; macro.
jump box
endmac
                                                                                      