descript "This is a submacro called from box.m"
; Name: box_ansi_sm.m
;
; This macro is a submacro. It draws a box based on parameters b1:b4 setup
; by the calling macro. Do not execute this macro directly.
;
; Input parameters:
;    b1 = row of upper left corner
;    b2 = column of upper left corner
;    b3 = row of lower right corner
;    b4 = column of lower right corner

beginmac

;cacheoff
;debugon

turbo 50          ;turn up the RPM (min = 5, def = 10, max = 50)
currc 1 1
clr
;
;use b5, b6 as scratch bytes
;
currc b1 b2       ;upper left corner
b5=b4             ;copy right column
b5-b2             ;calulate number of characters in horizontal row
b5++              ;add a column
echo "%Pb5*"      ;display top line of box
b5=b3             ;copy bottom row
b5-b1             ;calculate number of vertical columns
b5--              ;subtract 1 for top and bottom row
b6=b1             ;copy top row
b6++              ;advance row 
loop b5
   currc b6 b2    ;left vertical
   echo "*"
   currc b6 b4    ;right vertical
   echo "*"
   b5--           ;decrement loop count
   b6++           ;advance row
endloop
currc b6 b2       ;lower left corner
b5=b4             ;copy right column
b5-b2             ;calulate number of characters in horizontal row
b5++              ;add a column
echo "%Pb5*"      ;display bottom line of box
endmac
                         