;Name:    defaultport.m
;
;This macro defaults a port(s) to a user defined default configuration.
;
;To execute this macro enter:
;   defaultport               defaults current port
;   OR defaultport 1          defaults port 1
;   OR defaultport 5,6        defaults ports 5,6
;   OR defaultport 5-10       defaults ports 5 thruough 10

beginmac
;cacheoff
;debugon

beginmac

currc 1 1
clr
if (priv != privileged)
   set priv
endif
if (priv != privileged)
   exit
endif

currc 1 1
clr
curoff
currc 5 10
echo "%HtDefault Port Macro"
currc 6 10
echo "%HbDefault Port Macro"
sleep 20

echo "\n\n\n\n"
"This macro will except a port_list. A port list can be entered as follows:\n\n"
"   defaultport            defaults current port\n"
"OR defaultport 1          defaults port 1\n"
"OR defaultport 5,6        defaults ports 5,6\n"
"OR defaultport 5-10       defaults ports 5 thruough 10\n\n"
"If you would like to restart this macro, hit break.\n\n\n\n"

loop
   currc 21 1
   curon
   echo "Display commands as they are executed (Y or N) "
   clrends
   read
   curoff
   if (kb == "N")
      f1 = 0
   elif (kb == "Y")
      f1 = 1
   else
      echo "\07" ;bad input
      currc 22 16
      echo "%HtTry Again"
      currc 23 16
      echo "%HbTry Again%N"
      sleep 10
      continue
   endif
   break
endloop 
curoff
if (f1 == 1)
   echoon
else
   echooff
endif
currc 1 1
clr

;port local screen

def port %1 access local
def port %1 break local
def port %1 broadcast enabled
def port %1 inactivity logout disabled
def port %1 interrupts disabled
def port %1 message codes enabled
def port %1 multisession disabled
def port %1 password disabled
def port %1 pause disabled
def port %1 queuing disabled
def port %1 security disabled
def port %1 session limit 4
def port %1 type vt100
def port %1 verification enabled
def port %1 forward none 
def port %1 backward none 
def port %1 local none 

;port tcp/ip screen

def port %1 crlf disabled
def port %1 verbose disabled
def port %1 telnet keys disabled

def port %1 telnet echo wont do
def port %1 telnet status wont dont
def port %1 telnet suppress ga will do
def port %1 telnet timing mark wont dont 
def port %1 telnet binary transmit wont dont

def port %1 telnet ao none
def port %1 telnet ayt none
def port %1 telnet brk none
def port %1 telnet ec none
def port %1 telnet el none
def port %1 telnet ga none
def port %1 telnet ip none
def port %1 telnet syn none

;port lat screen

def port %1 dialup disabled 
def port %1 loss notification enabled
def port %1 autoconnect disabled
def port %1 autoprompt enabled

def port %1 authorized groups 0

;port network screen

def port %1 protocol lat
def port %1 authorized protocol all
def port %1 preferred service none

;port hardware screen

def port %1 speed 9600
def port %1 parity none 
def port %1 character size 8
def port %1 autobaud enabled 
def port %1 break pulse 200
def port %1 echo local disabled

def port %1 flow control xon
def port %1 input flow control enabled
def port %1 output flow control enabled
def port %1 xon 11
def port %1 xoff 13

def port %1 modem control disabled
def port %1 dcdlogout delay enabled
def port %1 dsrlogout disabled
def port %1 dtrwait disabled
 
endmac
                                                                   