;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                           ;
;  Emulex Performance Series Terminal/Print Server Macro    ;
;                                                           ;
;  Macro Name: SECURE                                       ;
;                                                           ;
;  This macro calls or jumps to the following macro(s):     ;
;                                                           ;
;     smith_sm.m                                            ;
;     jones_sm.m                                            ;
;                                                           ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; This macro demonstrates how the macro feature can be used to enhance
; network security. This macro can be executed as a normal macro for 
; testing.
;
; Creating a secure server environment:
;
; A security macro can be used to create a more secure server environment.
; This is accomplished by configuring all server ports for login/captive
; and having a server login macro routing file target a security macro.
; All users who log into the secured server automatically execute the
; security macro. Upon username and password verification they are allowed
; to execute a unique connect menu and thereby gain access to a system.
; 
; A server login macro routing macro must be created on the netserver host
; for this server. If server ports 4 through 7 are being used for this demo,
; the server login macro routing file "server_name.l" should look as
; follows. Note that a server login macro routing file has a '.l' extision.
;
;---------------------------------------------------------------------
;
; ;server_name.l
;
; beginlogin
;
; port 4            secure         ;global username password macro
; port 5            secure         ;   "      "        "       "
; port 6            secure         ;   "      "        "       "
; port 7            secure         ;   "      "        "       "
;
; endlogin 
;
;----------------------------------------------------------------------
;
; The following command sequence will configure server ports 4-7
; for login/captive macro operation.
;
; define server macro limit 8
; init delay 0
; change port 4-7 macro auth ena exec ena login ena captive ena
;

descrip "A username/password security macro"

beginmac

;cacheoff
;debugon

curoff
currc  1 1
cls
currc  6 10
echo "%HtSecurity Macro Demo"
currc  7 10
echo "%HbSecurity Macro Demo%N"
sleep 30

currc  10 1
echo ""
"This security macro supports two usernames and their associated passwords."
"\n\n"
"Username - \"Smith\", Password \"sunrise\"\n"
"Username - \"Jones\", Password \"sunset\"\n"
"\n"
"This macro can be expanded to support more users.\n"
"\n\n"
"Enter <return> to continue "
read                        ;continue on upon <return>

b2 = 0                      ;counter
loop 3                      ;allow 3 attempts at password
   curon
   currc 1 1
   clr
   currc 3 1

   ;
   ; Prompt for Username
   ;

   b2++
   echo "Username: "
   read
   if (kb == "SMITH")
      b1 = 1
   elif (kb == "JONES")
      b1 = 2
   elif (kb == "")
      jump secure           ;CR only
   else
      b1 = 99               ;username unknown
   endif

   ;
   ;Prompt for Password
   ;

   echo "Password: "        ;Always ask password so that unauthorized user
                            ;attempting to gain access doesn't know whether
                            ;he missed username or password.
   echooff
   read
   echoon

   if (b1 != 99)
      if (kb == "EMULEX")   ;provide a way out, even if captive
         exit               ;go to local server mode regardless
      endif
   endif

   if ( b1 == 1)
      if (kb == "SUNRISE")
         jump smith_sm
      else
         b1 = 99
      endif
   elif ( b1 == 2)
      if (kb == "SUNSET")
         jump jones_sm
      else
         b1 = 99
      endif
   else
      b1 = 99               ;Password failure  
   endif
   if (b1 == 99)
      if (b2 != 3)
         curoff
         currc 18 16
         echo "%HtTry again"
         currc 19 16
         echo "%HbTry again\n%N"
         sleep 5
      endif
      continue
   endif
   exit                        ;exit macro, have return from host
endloop             
cls
currc 1 1
if ( b1 == 99)
   currc 10 12
   echo "%Ht%KIntruder Alert"
   currc 11 12
   echo "%HbIntruder Alert%N\n\n\n"
   if( captive == 1)
      logout
   endif
endif
echo "\n\n"
endmac
                                                                        