;
; ⥬ ࠡ⪨ 訡, (C) .⥪                          
;

    Include Support.inc
    Include Control.inc
    Include Global.inc
    Include Constant.inc

.Data
;ͻ
;  
;ͼ

lstAsk      DB  5 dup (0)
msgSubCode  DB  '(         ) '      ,0

;ͻ
; ⥬ ६ 
;ͼ
;-------------------------------;
_errCode        DW  NIL         ;  訡.
_errMessage     DW  NIL         ;  ᮮ饭  訡. ᯮ,
                                ; ᫨ _errCode = NIL.
_errType        DB  ET_ERROR    ;  訡.
_errAsk         DB  EA_NOASK    ;   ࠡ⪥ 訡.
_errRecommend   DB  ER_CONT     ; 樨  ࠡ⪥ 訡.
_errSubName     DW  __msgBase   ;  ਭ   ⥬.
_errSubCode     DW  0,0         ;  訡 ⥬.
_errObject      DW  NIL         ;  ਭ   ꥪ 訡.
_errScreen      DB  FALSE       ; ࠭ ० ࠡ⪨ 訡.
_errEntry       DW  _errGen     ; ⥫  㭪 ࠡ⪨ 訡.
_errWarning     DD  0           ; 稪 ।०.
_errSevere      DD  0           ; 稪 쥧 訡.
_errDos         DW  0           ;  訡 DOS.
;-------------------------------;

.Code
;ͻ
; ⠭⭠ 㭪 ࠡ⪨ 訡                                 
;͹
; Call  Assembler                                                     
;ͼ
_errGen proc near Uses ax bx cx dx di si ds es

    push cs
    pop  ds                     ;᫨ 祭 ࠭ ०
    @if _errScreen == TRUE then ;ࠡ⪨ 訡, 맢
;       call _errFullOut        ;ᮮ⢥ 㭪, 
    @else                       ;ᯮ짮 㭪 ࠡ⪨
        call _errDosOut         ;訡 १ ⠭⭮ ன⢮
    @endif                      ;/뢮.
    ret
endp

;ͻ
;  訡                                                      
;͹
; Call  Assembler                                                     
;ͼ
_errReset proc near Uses ds

    push    cs
    pop     ds
    mov     _errCode,      NIL
    mov     _errMessage,   NIL
    mov     _errType,      ET_ERROR
    mov     _errAsk,       EA_NOASK
    mov     _errRecommend, ER_CONT
    mov     _errSubName,   offset __msgBase
    mov     _errSubcode,   0
    mov     _errObject,    NIL
    mov     _errDos,       0
    ret
endp

;ͻ
; 㭪 ࠡ⪨ 訡 १ ⠭⭮ ன⢮ /            
;͹
; Call  Assembler                                                     
;ͼ
_errDosOut proc near

    @if _errType == ET_WARNING then     ;᫨ 뢮 ।०,
        lea     si,__msgWarning         ;⮢ ᮮ- ᮮ饭
        add     @low(_errWarning),1     ; 㢥 稪
        adc     @high(_errWarning),0    ;।०.
    @else
        lea     si,__msgError           ; ⮢ ᮮ饭 
        add     @low(_errSevere),0      ;쥧 訡  㢥
        adc     @high(_errSevere),0     ;ᮮ⢥騩 稪.
    @endif
    call    _dosDisplay     ;뢥 ᮮ饭  ⨯ 訡.

    @if _errSubName #= NIL then         ;᫨ 㪠  ⥬,
        mov     si,_errSubName          ;뢥   ࠭.
        call    _dosDisplay
        mov     dx,@high(_errSubCode)   ;᫥ 祣 ८ࠧ
        mov     ax,@low(_errSubCode)    ; ਭ  ⮡ࠧ 
        mov     cx,10                   ;訡 ⥬.
        lea     si,msgSubCode
        call    _intDCV
        dec     si
        mov     @byte(si),'('
        call    _dosDisplay
    @endif

    @if _errCode -= EC_MAX then         ;᫨ ।  訡,
        mov     bx,_errCode             ;뢥 ᮮ饭,
        dec     bx                      ;ᮮ⢥饥 .
        shl     bx,1
        mov     si,__ptrErrCode[bx]
        call    _dosDisplay
    @elseif _errMessage #= NIL then     ;, ᫨ । 
        mov     si,_errMessage          ;ᮮ饭, 뢥  ᮮ饭
        call    _dosDisplay             ; ࠭.
    @endif

    @if _errObject #= NIL then          ;᫨ । ꥪ 訡,
        mov     dl,':'                  ;뢥 ᫥ ᮮ饭
        @int    02h,21h                 ;ࠧ饥 稥.
    @endif
    mov     dl,' '
    @int    02h,21h             ;뢥 ࠧ騩 ஡.

    @if _errObject #= NIL then          ;᫨ । ꥪ 訡,
        mov     si,_errObject           ;뢥    ᯫ.
        call    _dosDisplay
    @endif

    mov     dl,CR                       ;३   ப.
    @int    02h,21h
    mov     dl,LF
    @int    02h,21h

    and     _errAsk, EA_IGNORE + \
                     EA_RETRY  + \
                     EA_ABORT  + \
                     EA_ABEND           ;客  ⮫.

    @if _errAsk #= EA_NOASK then
        xor     ax,ax
        mov     al,_errAsk
        mov     dx,EA_ABEND             ;᪠   ।.
        lea     bx,__ptrErrAsk          ;⥫  ᯨ᮪ ।.
        lea     di,lstAsk               ;⥫  ᯨ᮪ 祩.
        @for    4
            @if dx -= ax then           ;᫨ । ᮮ⢥饥
                mov     si,ds:[bx]      ;᪥ ।, ⮢
                mov     cl,ds:[si]      ;ᮮ⢥騩   뢥
                mov     ds:[di],cl      ;।  ࠭.
                inc     di
                call    _dosDisplay
                sub     ax,dx           ;᪫ ࠡ⠭ ।-.
                push    dx ax
                @if ZF == 1 then        ;᫨ ।  ,
                    mov     dl,':'      ;뢥 稥.
                @else
                    mov     dl,','      ; 뢥 .
                @endif
                @int    02h,21h
                mov     dl,' '          ;뢥 ࠧ騩 ஡.
                @int    02h,21h
                pop     ax dx
            @endif
            shr     dx,1    ; .
            add     bx,2    ;३  ᫥饬  ।.
        @next
        mov     @byte(di),0     ; ᯨ᮪ 祩.
        lea     si,lstAsk
        call    _dosAsk         ; ᯨ᮪  ᯨ.

        @if ah == '' then
            mov  al,ER_ABEND
        @endif
        @if ah == '' then
            mov  al,ER_ABORT
        @endif
        @if ah == '' then
            mov  al,ER_RETRY
        @endif
        @if ah == '' then
            mov  al,ER_CONT
        @endif
        mov _errRecommend,al

        mov     dl,ah
        @int    02h,21h         ;뢥 祢 ᨬ.
        mov     dl,CR           ;३   ப.
        @int    02h,21h
        mov     dl,LF
        @int    02h,21h

    @endif
    ret
endp
end
