; -------------------------------------------------------------------- ;
; : SUPPORT.INC                                                    ;
; -------------------------------------------------------------------- ;
; ம। ⥪ SUPPORT Turbo Assembler 3.XX             ;
; -------------------------------------------------------------------- ;
; ᪮ ࠢ (C) 07/09/95 ਩ .⥪                     ;
; -------------------------------------------------------------------- ;

.xlist
.xcref
.model tiny, basic

;ͻ
; । ⠭ 
;ͼ

;-------------------------------;
; 䨪:                     ;
;-------------------------------;
@ptr    equ <dword ptr [0]>     ;
@word   equ <word ptr [0] >     ;
@byte   equ <byte ptr [0] >     ;
@low    equ <word ptr [0] >     ; 襥 ᫮
@high   equ <word ptr [2] >     ; 襥 ᫮
@hgh    equ <word ptr [2] >     ; 襥 ᫮
;-------------------------------;
CR      equ 0Dh                 ; ॢ ⪨
LF      equ 0Ah                 ; ॢ ப
HT      equ 09h                 ; ਧ⠫쭠 ⠡
EOL     equ 24h                 ;  ப  Dos09
;-------------------------------;

;ͻ
; 稥 ம। 
;ͼ

?les macro ?reg, ?exp           ;㧨 ES  ॣ.

  if (type ?exp) eq 4           ;᫨ ࠦ  ⨯ DWORD,
     les  ?reg,?exp             ;㧨 ES  㪠 ॣ.
  else
     if (.type ?exp) and 10h    ;᫨ ࠦ  ॣ஬,
        ifdifi <?reg>,<?exp>    ;  ॣ ⫨祭  㦠,
           mov ?reg,?exp        ;   㪠 ॣ.
        endif
     else                       ; 㧨  㪠 ॣ
        lea  ?reg,?exp          ; । ࠦ.
     endif
  endif
endm

?lds macro ?reg, ?exp           ;㧨 DS  ॣ.

  if (type ?exp) eq 4           ;᫨ ࠦ  ⨯ DWORD,
     lds  ?reg,?exp             ;㧨 DS  㪠 ॣ.
  else
     if (.type ?exp) and 10h    ;᫨ ࠦ  ॣ஬,
        ifdifi <?reg>,<?exp>    ;  ॣ ⫨祭  㦠,
           mov ?reg,?exp        ;   㪠 ॣ.
        endif
     else                       ; 㧨  㪠 ॣ
        lea  ?reg,?exp          ; । ࠦ.
     endif
  endif
endm

?lax macro ?exp                 ;㧨 DX:AX  ॣ.

  if (type ?exp) eq 4           ;᫨ ࠦ  ⨯ DWORD,
     mov  ax,@low(?exp)         ;㧨 DX:AX 祭 
     mov  dx,@high(?exp)        ; ࠦ.
  else
     ifdifi <?exp>,<ax>         ;᫨ ࠦ   ॣ஬ AX,
        mov ax,?exp             ;   AX.
     endif
     xor dx,dx                  ;㫨 DX.
  endif
endm

;ͻ
; ࠡ⪠ ਭ  ᨬ 
;ͼ

@strCopy macro ?source, ?destination  ;஢ ਭ

  ?les di,?destination
  ?lds si,?source
  call _strCopy
endm

;ͻ
; ࠢ DOS  ணࠬ 
;ͼ

@out  macro ?exp                ;뢥 ⥪  ⠭⭮
      ?lds  si,?exp             ;ன⢮ 뢮.
      call  _dosDisplay
endm

@version macro ?high, ?low      ;஢  DOS.
      @int  30h,21h

      @if <al -- &?high> or \
         <<al == &?high> and <ah -- &?low>> then

          mov  _errCode, EC_VERSION
          call _errEntry
      @endif
endm

@err macro ?error
     mov  word ptr _errCode,?error
     call _errEntry
endm

;ͻ
; ⥬᪠ প 
;ͼ

@DCV macro ?number, ?label, ?len    ;८ࠧ 32-ࠧ來
                                    ; 楫  ப
    ?lax  ?number                   ; .
    mov   cx,?len
    ?lds  si,?label
    call  _intDCV
endm

@DCF macro ?number, ?label, ?len    ;८ࠧ 32-ࠧ來
                                    ; 楫  䨪஢
    ?lax  ?number                   ;ப  .
    mov   cx,?len
    ?lds  si,?label
    call  _intDCF
endm

@HCF macro ?number, ?label, ?len    ;८ࠧ 32-ࠧ來
                                    ; 楫  䨪஢
    ?lax  ?number                   ;ப 16- .
    mov   cx,?len
    ?lds  si,?label
    call  _intHCF
endm

@BCF macro ?number, ?label, ?len    ;८ࠧ 32-ࠧ來
                                    ; 楫  䨪஢
    ?lax  ?number                   ;ப  .
    mov   cx,?len
    ?lds  si,?label
    call  _intBCF
endm

;ͻ
;    
;ͼ

@grab macro ?label, ?size       ;墠  .

    mov   ax,?size
    call  _memGrab

    if (type ?label) eq 4
       mov  @high(?label),ax
       mov  @low(?label),0
    elseif (type ?label) eq 2
       mov  ?label,ax
    endif
endm

@free macro ?label              ;᢮  .

    if (type ?label) eq 4
       mov  ax,@high(?label)
    elseif (type ?label) eq 2
       mov  ax,?label
    endif
    call _memFree
endm

;ͻ
;   ணࠬ   㦥 
;ͼ

@quit macro ?code

      mov   al,?code
      @int  4Ch,21h
endm

;ͻ
; End 
;ͼ
.list
.sall
