;
; Screen Locator, (C) 1992 by D.Steklenev                             
;

    include support.inc
    include control.inc
    include global.inc
    include constant.inc
    include tsr.inc
    include keyboard.inc

public locIdent
public locHotList
public locPopup

.code
;ͻ
;   
;ͼ

;-----------------------------------;
locIdent    DB  'ScrLocator'        ; 䨪樮 ப ணࠬ
locActive   DB  FALSE               ; ਧ ⨢
;-----------------------------------;
savPos      DW  0                   ; ࠭  ப  ⮫
savShape    DW  0                   ; ࠭ ଠ 
savRows     DB  160 dup (0)         ;  ࠭ ଠ樮 ப
;-----------------------------------;
locPos      LABEL   WORD            ;   :
locCol      DB      0               ;    ⮫
locRow      DB      0               ;    ப
locUp       LABEL   WORD            ; 孨  㣮 ࠭:
locLeft     DB      0               ;    ᠬ  ⮫
locTop      DB      0               ;    ᠬ 孥 ப
locDown     LABEL   WORD            ;  ࠢ 㣮 ࠭:
locRight    DB      0               ;    ᠬ ࠢ ⮫
locBottom   DB      0               ;    ᠬ  ப
;-----------------------------------;
locCenter   DB      0               ;  業ࠫ쭮 ப ࠭
locDisplay  DW      0               ; न ଠ樮 ப
;-----------------------------------;
coCo80      DB      71h,74h         ;  ਡ⮢  梥⭮ ०
coMono      DB      70h,70h         ;  ਡ⮢   ०
coText      DB      0               ; ਡ  뢮 ⥪
coNumber    DB      0               ; ਡ  뢮 
;-----------------------------------;

msgLocator  DB  ' Screen locate: row ~  ~ col ~  ~',0
msgRow      EQU msgLocator[22]
msgCol      EQU msgLocator[31]

locHotList  TSH <TSRHOT_L, TSR_LCTRL + TSR_LALT > ; 
            TSH <>                                ; ᯨ᪠

;ͻ
; : ᭮ 楤 
;ͼ
locPopup proc near

    @if locActive == TRUE   ;᫨  㦥 ⨢,
        @int 0E07h,10h      ;ய  ⮬ 
        ret                 ; ࠢ.
    @endif

    call _tsrText?          ;஢ ⥪騩 ०.
    @if CF == 1 then        ;᫨  ᪨,
        @int 0E07h,10h      ;ய  ⮬ 
        ret                 ; ࠢ.
    @endif

    mov     locActive,TRUE

    call    _scrGetPos      ;࠭ ⥪騥  
    mov     savPos,dx       ; .
    call    _scrGetCursor
    mov     savShape,ax

    call    _scrEquip       ;஢ ⠭ .
    @if ax == SE_CGA then   ;᫨ 㦥  CGA 
        mov al,TRUE         ; ᭥,  ⪫
    @else                   ;.
        mov al,FALSE
    @endif
    call    _scrSnow

    call    _scrFrame       ; न ࠭
    mov     locUp,cx        ;࠭  ࠭ .
    mov     locDown,dx
    shr     dh,1            ;᫨  業ࠫ쭮
    mov     locCenter,dh    ;ப ࠭  ࠭ .

    @int    0Fh,10h         ;  ⥪饣
    @if al == SM_MONO then  ;०.
        lea si,coMono       ;᫨ ० ஬,
    @else                   ;ᯮ짮 ᮮ⢥騩
        lea si,coCo80       ; 梥⮢ ਡ⮢.
    @endif
    lea     di,coText
    movsb
    movsb

    mov     al,locRow           ;㧨  ⥪饩 ப
    @if al ++ locCenter then    ;. ᫨   
        mov ah,locTop           ;業ࠫ쭮 ப,  뢮
    @else                       ;ଠ樨 㤥 ᯮ짮
        mov ah,locBottom        ; ப ࠭,
    @endif                      ; 㤥 ᯮ짮
    mov     al,locLeft          ;.
    mov     locDisplay,ax

    call    rowSave         ;࠭ ᮤন ଠ樮 ப.
    call    rowClear        ; ଠ樮 ப.

@@redraw:

    mov al,locRow
    @if <al ++ locCenter> and <al -= @byte(locDisplay+1)> then

        call    rowRest
        mov     ah,locTop
        mov     al,locLeft
        mov     locDisplay,ax
        call    rowSave
        call    rowClear

    @elseif <al -- locCenter> and <al += @byte(locDisplay+1)> then

        call    rowRest
        mov     ah,locBottom
        mov     al,locLeft
        mov     locDisplay,ax
        call    rowSave
        call    rowClear
    @endif
    call    rowDisplay              ;뢥 ଠ樮 ப.

    @int    0,16h
    @if     al == K_ESC goto @@exit

    @if al == 0 then                ;஢  ७ .
        @if ah == K_LEFT then       ;᫨  ,
            mov al,locCol           ;㧨 ⥪騩 ⮫,
            @if al == locLeft then  ;᫨  ࠢ ,
                mov al,locRight     ;३  ࠢ,
            @else                   ;   ⮫ .
                dec al
            @endif
            mov locCol,al
        @endif
        @if ah == K_RIGHT then      ;᫨  ࠢ,
            mov al,locCol           ;㧨 ⥪騩 ⮫,
            @if al == locRight then ;᫨  ࠢ ࠢ,
                mov al,locLeft      ;३  ,
            @else                   ;   ⮫ ࠢ.
                inc al
            @endif
            mov locCol,al
        @endif
        @if ah == K_DOWN then       ;᫨  ,
            mov al,locRow           ;㧨 ⥪ ப,
            @if al == locBottom     ;᫨  ࠢ ,
                mov al,locTop       ;३  ,
            @else                   ;   ப .
                inc al
            @endif
            mov locRow,al
        @endif
        @if ah == K_UP then         ;᫨  ,
            mov al,locRow           ;㧨 ⥪ ப,
            @if al == locTop then   ;᫨  ࠢ 孥,
                mov al,locBottom    ;३  ,
            @else                   ;   ப .
                dec al
            @endif
            mov locRow,al
        @endif
    @endif
    jmp @@redraw

@@exit:

    call    rowRest         ;⠭ ଠ樮 ப.
    mov     ax,savShape     ;⠭ ⥪騥 
    call    _scrSetCursor   ;  .
    mov     dx,savPos
    call    _scrSetPos
    mov     locActive,FALSE
    ret
endp

;ͻ
; ८ࠧ  (0-99)   ᨬ                              
;͹
; Call  Assembler                                                     
;͹
; In    AL    ᮤন ᫮ 祭 (0-99)                       
;       DS:SI 㪠⥫    ࠧ饭 १ (2 byte)   
;ͼ
locDCF proc near Uses ax bx cx si

    mov bl,10
    inc si
    @cycle 2
        mov     ah,0            ;㫨  
        div     bl              ;ࠧ  ᭮
        or      ah,30h          ;   ASCII
        dec     si              ;㬥 ᬥ饭
        mov     ds:[si],ah      ; 
    @endcycle
    ret
endp

;ͻ
; ࠭ ᮤন ଠ樮 ப                           
;͹
; Call  Assembler                                                     
;ͼ
rowSave proc near Uses cx dx si

    mov     cx,locDisplay       ;㧨 न ଠ樮
    mov     dh,ch               ;ப.
    mov     dl,locRight         ;㧨 ࠢ ࠭.
    lea     si,savRows          ;࠭ ࠭   ࠭
    call    _scrSave            ;savRows.
    ret
endp

;ͻ
; ⠭ ᮤন ଠ樮 ப                        
;͹
; Call  Assembler                                                     
;ͼ
rowRest proc near Uses cx dx si

    mov     cx,locDisplay       ;㧨 न ଠ樮
    mov     dh,ch               ;ப.
    mov     dl,locRight         ;㧨 ࠢ ࠭.
    lea     si,savRows          ;࠭ ࠭   ࠭
    call    _scrRest            ;savRows.
    ret
endp

;ͻ
;  ଠ樮 ப                                       
;͹
; Call  Assembler                                                     
;ͼ
rowClear proc near Uses ax bx cx dx

    mov     cx,locDisplay       ;㧨 न ଠ樮
    mov     dh,ch               ;ப.
    mov     dl,locRight         ;㧨 ࠢ ࠭.
    mov     al,0
    mov     bl,coText
    call    _scrScroll          ; ଠ樮 ப.
    ret
endp

;ͻ
; 뢥  ࠭ ଠ樮 ப                               
;͹
; Call  Assembler                                                     
;ͼ
rowDisplay proc near Uses ax bx cx dx si

    mov     ax,SC_NONE          ;⪫ .
    call    _scrSetCursor

    mov     al,locRow           ;८ࠧ  ப 
    lea     si,msgRow           ;⥪饩 ப .
    call    locDCF
    mov     al,locCol           ;८ࠧ  ப 
    lea     si,msgCol           ;⥪饣 ⮫ .
    call    locDCF

    mov     dx,locDisplay       ;⠭   砫
    call    _scrSetPos          ;ଠ樮 ப.
    lea     si,msgLocator
    mov     bl,coText
    mov     bh,coNumber
    call    _scrPut             ;뢥 ଠ樮 ப.

    mov     dx,locPos           ;⠭   ⥪
    call    _scrSetPos          ; ࠭   .
    mov     ax,SC_BLOCK
    call    _scrSetCursor
    ret
endp
end
