/*
 * Decompiled with CFR 0.152.
 */
package com.fx702p.swing;

import com.fx702p.debug.Fx702pDebugger;
import com.fx702p.emulator.Fx702pBasicLine;
import com.fx702p.emulator.Fx702pEmulator;
import com.fx702p.emulator.InstructionBoundary;
import com.fx702p.emulator.Variable;
import com.fx702p.emulator.commands.Command;
import com.fx702p.interpreters.BasicInstructionIndex;
import com.fx702p.interpreters.Fx702pException;
import com.fx702p.parser.ASTCsr;
import com.fx702p.parser.ASTInputVariable;
import com.fx702p.parser.ASTLine;
import com.fx702p.parser.ASTPrtExpression;
import com.fx702p.parser.PrintSubExpressionNode;
import com.fx702p.swing.DebugWindow;

public class Fx702pSwingDebugger
extends Fx702pDebugger.AbstractFx702pDebugger {
    protected Fx702pEmulator emulator;
    protected DebugWindow debugWindow;

    public Fx702pSwingDebugger(Fx702pEmulator anEmulator, DebugWindow aDebugWindow) {
        this.emulator = anEmulator;
        this.debugWindow = aDebugWindow;
    }

    public void visitBreakpoint(BasicInstructionIndex aBasicInstructionIndex) {
        ASTLine line = this.emulator.getActiveProgram().getParsedProgram().getLine(aBasicInstructionIndex.getLineIndex());
        Fx702pBasicLine basicLine = this.emulator.getActiveProgram().getBasicSourceCode().getLine(line.getLineIndexInSourceCode());
        InstructionBoundary boundary = basicLine.getParsedLine().getInstructionBoundary(aBasicInstructionIndex.getInstructionIndex());
        this.debugWindow.selectBreakpoint(basicLine, boundary.begin, boundary.end);
    }

    public Object visit(ASTLine aLine, Object anInstructionIndex) {
        Fx702pBasicLine basicLine = this.emulator.getActiveProgram().getBasicSourceCode().getLine(aLine.getLineIndexInSourceCode());
        InstructionBoundary boundary = aLine.getInstructionBoundary((Integer)anInstructionIndex);
        this.debugWindow.select(basicLine, boundary.begin, boundary.end);
        return null;
    }

    public Object visit(ASTPrtExpression aNode, Object aData) {
        this.visitPrintSubExpression(aNode);
        return null;
    }

    public Object visit(ASTCsr aNode, Object aData) {
        this.visitPrintSubExpression(aNode);
        return null;
    }

    protected Object visitPrintSubExpression(PrintSubExpressionNode aNode) {
        Fx702pBasicLine basicLine = this.emulator.getActiveProgram().getBasicSourceCode().getLine(aNode.getLineIndexInSourceCode());
        InstructionBoundary boundary = aNode.getSubInstructionBoundary();
        if (boundary != null) {
            this.debugWindow.subSelect(basicLine, boundary.begin, boundary.end);
        }
        return null;
    }

    public Object visit(ASTInputVariable aNode, Object aData) {
        Fx702pBasicLine basicLine = this.emulator.getActiveProgram().getBasicSourceCode().getLine(aNode.getLineIndexInSourceCode());
        InstructionBoundary boundary = aNode.getSubInstructionBoundary();
        if (boundary != null) {
            this.debugWindow.subSelect(basicLine, boundary.begin, boundary.end);
        }
        return null;
    }

    public void visitProgramEnd() {
        this.debugWindow.clearSelection();
    }

    public void allClear() {
        this.debugWindow.allClear();
    }

    public void home() {
    }

    public void cont() {
        this.debugWindow.cont();
    }

    public void contProgram() {
        this.debugWindow.contProgram();
    }

    public void endProgram() {
        this.debugWindow.endProgram();
    }

    public void endScroll() {
        this.debugWindow.endScroll();
    }

    public void endWaitAfterPrint() {
        this.debugWindow.endWaitAfterPrint();
    }

    public void cancelWaitAfterPrint() {
        this.debugWindow.cancelWaitAfterPrint();
    }

    public void enterString(String aString) {
        this.debugWindow.enterString(aString);
    }

    public void execute(String aString) {
        this.debugWindow.execute(aString);
    }

    public void input(String aAnInputPrompt) {
        this.debugWindow.input(aAnInputPrompt);
    }

    public void reportFx702pError(Fx702pException aAnError) {
        this.debugWindow.reportFx702pError(aAnError);
    }

    public void resultPrinted() {
        this.debugWindow.resultPrinted();
    }

    public void startMultiLinePrint() {
    }

    public void endMultiLinePrint() {
    }

    public void runProgram() {
        this.debugWindow.runProgram();
    }

    public void setRunMode() {
        this.debugWindow.setRunMode();
    }

    public void setWrtMode() {
        this.debugWindow.setWrtMode();
    }

    public void startScroll() {
        this.debugWindow.startScroll();
    }

    public void stepInProgram() {
        this.debugWindow.stepInProgram();
    }

    public void debugAndStepActiveProgram() {
        this.debugWindow.debugAndStepActiveProgram();
    }

    public void nextLoop(Variable aVariable) {
        this.debugWindow.nextLoop(aVariable);
    }

    public void endLoop(Variable aVariable) {
        this.debugWindow.endLoop(aVariable);
    }

    public void stop() {
        this.debugWindow.stop();
    }

    public void stopProgram() {
        this.debugWindow.stopProgram();
    }

    public void suspendProgram() {
        this.debugWindow.suspendProgram();
    }

    public void resumeProgram() {
        this.debugWindow.resumeProgram();
    }

    public void loadProgram(int aProgramIndex) {
        this.debugWindow.loadProgram(aProgramIndex);
    }

    public void clearProgram(int aProgramIndex) {
        this.debugWindow.clearProgram(aProgramIndex);
    }

    public void setActiveProgramIndex(int aProgramIndex) {
        this.debugWindow.setActiveProgramIndex(aProgramIndex);
    }

    public void waitAfterPrint(int aPrintWait, Command aCommand) {
        this.debugWindow.waitAfterPrint(aPrintWait, null);
    }
}

