/*
 * Decompiled with CFR 0.152.
 */
package com.fx702p.swing;

import com.fx702p.emulator.Fx702pBasicLine;
import com.fx702p.emulator.Fx702pBasicProgram;
import com.fx702p.interpreters.BasicInstructionIndex;
import com.fx702p.interpreters.Fx702pAbstractParserVisitor;
import com.fx702p.parser.ASTLine;
import com.fx702p.parser.ASTProgram;
import com.fx702p.swing.DebugWindow;
import com.fx702p.swing.Fx702pLinePanel;
import com.fx702p.swing.IntelligentMenuItem;
import com.fx702p.swing.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;

public class SourceCodePanel
extends JPanel
implements Scrollable {
    protected Fx702pBasicProgram basicProgram;
    protected Dimension characterDimension;
    protected int height;
    protected int maxWidth;
    protected Vector<Integer> linePanelVerticalPositions;
    protected Vector<Fx702pLinePanel> linePanels;
    protected boolean alternate = true;
    protected HashMap<Fx702pBasicLine, Fx702pLinePanel> linePanelsByBasicLine = new HashMap();
    protected Fx702pLinePanel selectedLinePanel = null;
    protected boolean breakpointSelected = false;
    protected DebugWindow debugWindow;
    public static final int BORDER_SIZE = 5;
    public static final int LINE_SPACING = 5;
    public static final int PIXEL_SIZE = 2;
    public static final Color ALTERNATE_BACKGROUND = new Color(222, 251, 222);
    public static final String SET_BREAKPOINT_MENU_ITEM = "Set Breakpoint";
    public static final String REMOVE_BREAKPOINT_MENU_ITEM = "Remove Breakpoint";
    public static final String REMOVE_ALL_BREAKPOINTS_MENU_ITEM = "Remove All Breakpoints";

    public SourceCodePanel(DebugWindow aDebugWindow, Fx702pBasicProgram aBasicProgram) {
        this.debugWindow = aDebugWindow;
        this.basicProgram = aBasicProgram;
        this.characterDimension = Fx702pLinePanel.getCharacterDimension(2, 2, 0);
        this.setLayout(null);
        this.setBackground(Color.WHITE);
        this.buildLines();
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                for (Component component : SourceCodePanel.this.getComponents()) {
                    Rectangle bounds = component.getBounds();
                    bounds.width = SourceCodePanel.this.getSize().width - 10;
                    component.setBounds(bounds);
                }
            }
        });
        this.buildPopupMenuAndListeners();
    }

    protected void buildLines() {
        this.alternate = true;
        this.height = 0;
        this.maxWidth = 0;
        this.linePanels = new Vector();
        this.linePanelVerticalPositions = new Vector();
        if (this.basicProgram.getParsedProgram() != null) {
            this.basicProgram.getParsedProgram().jjtAccept(new Fx702pAbstractParserVisitor(){

                public Object visit(ASTProgram aProgram, Object aData) {
                    aProgram.childrenAccept(this, aData);
                    return null;
                }

                public Object visit(ASTLine aLine, Object aData) {
                    Fx702pBasicLine basicLine = SourceCodePanel.this.basicProgram.getBasicSourceCode().getLine(aLine.getLineIndexInSourceCode());
                    String lineAsString = basicLine.toString();
                    Color background = SourceCodePanel.this.alternate ? ALTERNATE_BACKGROUND : Color.WHITE;
                    SourceCodePanel.this.alternate = !SourceCodePanel.this.alternate;
                    Fx702pLinePanel linePanel = new Fx702pLinePanel(lineAsString.length(), Color.BLACK, background, 2, 2, 0, 2);
                    SourceCodePanel.this.linePanelsByBasicLine.put(basicLine, linePanel);
                    linePanel.setLine(lineAsString);
                    linePanel.setBasicInformations(SourceCodePanel.this.basicProgram, basicLine);
                    linePanel.setOpaque(false);
                    int counter = SourceCodePanel.this.getComponentCount();
                    SourceCodePanel.this.add(linePanel);
                    int lineHeight = linePanel.getPreferredSize().height + 5;
                    linePanel.setBounds(5, 5 + counter * lineHeight, linePanel.getPreferredSize().width, linePanel.getPreferredSize().height);
                    SourceCodePanel.this.linePanels.add(linePanel);
                    SourceCodePanel.this.linePanelVerticalPositions.add(SourceCodePanel.this.height);
                    SourceCodePanel.this.height += lineHeight;
                    SourceCodePanel.this.maxWidth = Math.max(SourceCodePanel.this.maxWidth, linePanel.getPreferredSize().width);
                    return null;
                }
            }, null);
        }
        this.linePanelVerticalPositions.add(this.height);
        this.height += 5;
        int panelWidth = this.maxWidth + 10;
        for (Component component : this.getComponents()) {
            Rectangle bounds = component.getBounds();
            bounds.width = this.maxWidth;
            component.setBounds(bounds);
        }
        this.setBounds(0, 0, panelWidth, this.height);
        this.setPreferredSize(new Dimension(panelWidth, this.height));
    }

    protected void buildPopupMenuAndListeners() {
        Window window = SwingUtilities.getWindowAncestor(this);
        final SwingUtils.ExtendedPopupMenu popupMenu = SwingUtils.buildPopupMenu(window, this, new MouseAdapter(){

            public void mousePressed(MouseEvent aMouseEvent) {
                SourceCodePanel.this.requestFocusInWindow();
                if (aMouseEvent.getClickCount() == 2) {
                    SourceCodePanel.this.toggleBreakpoint(aMouseEvent.getPoint());
                }
            }
        });
        IntelligentMenuItem loadMenuItem = this.debugWindow.getSwingKeyboardAndDisplay().buildOpenMenuItem();
        popupMenu.add(loadMenuItem);
        IntelligentMenuItem reloadMenuItem = this.debugWindow.getSwingKeyboardAndDisplay().buildReloadMenuItem();
        popupMenu.add(reloadMenuItem);
        IntelligentMenuItem reloadAllMenuItem = this.debugWindow.getSwingKeyboardAndDisplay().buildReloadAllMenuItem();
        popupMenu.add(reloadAllMenuItem);
        IntelligentMenuItem saveMenuItem = this.debugWindow.getSwingKeyboardAndDisplay().buildSaveMenuItem();
        popupMenu.add(saveMenuItem);
        IntelligentMenuItem saveAsMenuItem = this.debugWindow.getSwingKeyboardAndDisplay().buildSaveAsMenuItem();
        popupMenu.add(saveAsMenuItem);
        IntelligentMenuItem saveAllMenuItem = this.debugWindow.getSwingKeyboardAndDisplay().buildSaveAllMenuItem();
        popupMenu.add(saveAllMenuItem);
        IntelligentMenuItem saveAllAsMenuItem = this.debugWindow.getSwingKeyboardAndDisplay().buildSaveAllAsMenuItem();
        popupMenu.add(saveAllAsMenuItem);
        popupMenu.addSeparator();
        IntelligentMenuItem addBreakPointMenuItem = new IntelligentMenuItem(SET_BREAKPOINT_MENU_ITEM){

            public boolean isReallyEnabled(Point aClickPoint) {
                BasicInstructionIndex basicInstructionIndex = SourceCodePanel.this.getBasicInstructionIndex(aClickPoint);
                return basicInstructionIndex != null && !SourceCodePanel.this.basicProgram.containsBreakpoint(basicInstructionIndex);
            }
        };
        addBreakPointMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent anActionEvent) {
                SourceCodePanel.this.toggleBreakpoint(popupMenu.getClickPoint());
            }
        });
        popupMenu.add(addBreakPointMenuItem);
        IntelligentMenuItem removeBreakPointMenuItem = new IntelligentMenuItem(REMOVE_BREAKPOINT_MENU_ITEM){

            public boolean isReallyEnabled(Point aClickPoint) {
                BasicInstructionIndex basicInstructionIndex = SourceCodePanel.this.getBasicInstructionIndex(aClickPoint);
                return basicInstructionIndex != null && SourceCodePanel.this.basicProgram.containsBreakpoint(basicInstructionIndex);
            }
        };
        removeBreakPointMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent anActionEvent) {
                SourceCodePanel.this.toggleBreakpoint(popupMenu.getClickPoint());
            }
        });
        popupMenu.add(removeBreakPointMenuItem);
        IntelligentMenuItem removeAllBreakPointsMenuItem = new IntelligentMenuItem(REMOVE_ALL_BREAKPOINTS_MENU_ITEM){

            public boolean isReallyEnabled(Point aClickPoint) {
                return !SourceCodePanel.this.isBreakpointsCollectionEmpty();
            }
        };
        removeAllBreakPointsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent anActionEvent) {
                SourceCodePanel.this.removeAllBreakpoints();
            }
        });
        popupMenu.add(removeAllBreakPointsMenuItem);
    }

    protected void removeAllBreakpoints() {
        int answer = JOptionPane.showConfirmDialog(this, "Really remove all breakpoints?", "Remove all breakpoints confirmation", 2);
        if (answer == 0) {
            for (BasicInstructionIndex basicInstructionIndex : this.basicProgram.getBreakpoints()) {
                this.linePanels.get(basicInstructionIndex.getLineIndex()).setRefreshNeeded();
            }
            this.basicProgram.removeAllBreakpoints();
            this.repaint();
        }
    }

    protected void loadProgram() {
        this.debugWindow.getSwingKeyboardAndDisplay().loadProgram();
    }

    protected void reloadProgram() {
        this.debugWindow.getSwingKeyboardAndDisplay().reloadProgram();
    }

    protected void saveProgram() {
        this.debugWindow.getSwingKeyboardAndDisplay().saveProgram();
    }

    protected boolean isBreakpointsCollectionEmpty() {
        Collection<BasicInstructionIndex> breakpoints = this.basicProgram.getBreakpoints();
        return breakpoints == null || breakpoints.isEmpty();
    }

    protected void toggleBreakpoint(Point aPoint) {
        BasicInstructionIndex basicInstructionIndex = this.getBasicInstructionIndex(aPoint);
        if (basicInstructionIndex != null) {
            this.basicProgram.toggleBreakpoint(basicInstructionIndex);
            this.linePanels.get(basicInstructionIndex.getLineIndex()).setRefreshNeeded();
            this.repaint();
        }
    }

    protected BasicInstructionIndex getBasicInstructionIndex(Point aPoint) {
        Fx702pLinePanel linePanel;
        int instructionIndex;
        int lineIndex = this.getLineIndex(aPoint.y);
        if (lineIndex >= 0 && (instructionIndex = (linePanel = this.linePanels.get(lineIndex)).getInstructionIndex(aPoint.x)) >= 0) {
            return new BasicInstructionIndex(linePanel.getBasicLine().getParsedLine().getLineIndexInProgram(), instructionIndex);
        }
        return null;
    }

    protected int getLineIndex(int y) {
        if (this.linePanelVerticalPositions.isEmpty() || y < 0 || y >= this.linePanelVerticalPositions.lastElement()) {
            return -1;
        }
        int first = 0;
        int last = this.linePanelVerticalPositions.size() - 1;
        int middle = -1;
        while (middle != first || last > first + 1) {
            middle = first + (last - first) / 2;
            if (y >= this.linePanelVerticalPositions.get(middle)) {
                first = middle;
                continue;
            }
            last = middle;
        }
        return first;
    }

    protected void showProgram() {
        this.removeAll();
        this.linePanelsByBasicLine.clear();
        this.buildLines();
        this.setVisible(true);
    }

    public void setActiveProgram(Fx702pBasicProgram aBasicProgram) {
        this.basicProgram = aBasicProgram;
        if (this.basicProgram != null && !this.basicProgram.isEmpty()) {
            this.showProgram();
        } else {
            this.clearProgram();
        }
    }

    public void allClear() {
        if (this.selectedLinePanel != null) {
            this.selectedLinePanel.clearSelection();
            this.selectedLinePanel.setRefreshNeeded();
        }
        this.repaint();
    }

    public void clearProgram() {
        this.removeAll();
        this.linePanelsByBasicLine.clear();
        this.setVisible(false);
    }

    public void selectBreakpoint(Fx702pBasicLine aBasicLine, int aSelectionStart, int aSelectionEnd) {
        this.select(aBasicLine, aSelectionStart, aSelectionEnd, true);
    }

    public void select(Fx702pBasicLine aBasicLine, int aSelectionStart, int aSelectionEnd) {
        this.select(aBasicLine, aSelectionStart, aSelectionEnd, false);
    }

    protected void select(Fx702pBasicLine aBasicLine, int aSelectionStart, int aSelectionEnd, boolean aBreakpointSelected) {
        Fx702pLinePanel linePanel;
        this.breakpointSelected = aBreakpointSelected;
        if (this.selectedLinePanel != null) {
            this.selectedLinePanel.clearSelection();
        }
        if ((linePanel = this.linePanelsByBasicLine.get(aBasicLine)) != null) {
            linePanel.select(aSelectionStart, aSelectionEnd, this.breakpointSelected);
        }
        this.selectedLinePanel = linePanel;
        this.scrollRectToVisible(linePanel.getBounds());
    }

    public void subSelect(Fx702pBasicLine aBasicLine, int aSelectionStart, int aSelectionEnd) {
        if (this.selectedLinePanel != null) {
            this.selectedLinePanel.subSelect(aSelectionStart, aSelectionEnd);
        }
    }

    public void clearSelection() {
        if (this.selectedLinePanel != null) {
            this.selectedLinePanel.clearSelection();
        }
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle aVisibleRectangle, int anOrientation, int aDirection) {
        if (anOrientation == 1) {
            return this.characterDimension.height + 5;
        }
        return this.characterDimension.width;
    }

    public int getScrollableBlockIncrement(Rectangle aVisibleRectangle, int anOrientation, int aDirection) {
        if (anOrientation == 1) {
            return this.height / 3;
        }
        return this.maxWidth / 3;
    }

    public boolean getScrollableTracksViewportHeight() {
        return this.getParent() instanceof JViewport && ((JViewport)this.getParent()).getSize().height > this.getPreferredScrollableViewportSize().height;
    }

    public boolean getScrollableTracksViewportWidth() {
        return this.getParent() instanceof JViewport && ((JViewport)this.getParent()).getSize().width > this.getPreferredScrollableViewportSize().width;
    }
}

