/*
 * Decompiled with CFR 0.152.
 */
package com.edsdev.jconvert.presentation;

import com.edsdev.jconvert.presentation.ConversionTypeData;
import com.edsdev.jconvert.presentation.ConversionUnitData;
import com.edsdev.jconvert.presentation.component.ConvertListCellRenderer;
import com.edsdev.jconvert.presentation.component.ConvertListModel;
import com.edsdev.jconvert.presentation.component.NumericalTextField;
import com.edsdev.jconvert.util.Messages;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ConversionPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private ConversionTypeData ctd;
    private JList list;
    private JList list2;
    private JLabel labelFromUnit;
    private JLabel labelToUnit;
    private NumericalTextField txtFrom;
    private JTextField txtTo;
    private JTextField txtToFract;

    public void setConversionTypeData(ConversionTypeData conversionTypeData) {
        this.ctd = conversionTypeData;
        this.list2.setModel(new ConvertListModel(new ArrayList()));
        this.list.setModel(new ConvertListModel(this.ctd.getAllFromUnits()));
        this.setDefaultSelections();
    }

    public ConversionPanel(ConversionTypeData conversionTypeData) {
        this.ctd = conversionTypeData;
        this.init();
    }

    private String getSelectedValue(JList jList) {
        Object e = jList.getSelectedValue();
        if (e == null) {
            return null;
        }
        if (e instanceof ConversionUnitData) {
            return ((ConversionUnitData)e).getUnit();
        }
        return e.toString();
    }

    private String getSelectedTranslatedValue(JList jList) {
        Object e = jList.getSelectedValue();
        if (e == null) {
            return null;
        }
        if (e instanceof ConversionUnitData) {
            return ((ConversionUnitData)e).getTranslatedUnit();
        }
        return e.toString();
    }

    private void setSelectedStringValue(JList jList, String string) {
        for (int i = 0; i < jList.getModel().getSize(); ++i) {
            ConversionUnitData conversionUnitData = (ConversionUnitData)jList.getModel().getElementAt(i);
            if (!conversionUnitData.getUnit().equals(string)) continue;
            jList.setSelectedIndex(i);
            break;
        }
    }

    private int getGenerationAge(JList jList) {
        Object e = jList.getSelectedValue();
        if (e instanceof ConversionUnitData) {
            return ((ConversionUnitData)e).getGenerationAge();
        }
        return 0;
    }

    public void convert() {
        this.convert(false);
    }

    public String getFromValue() {
        return this.txtFrom.getText();
    }

    public void setFromValue(String string) {
        this.txtFrom.setText(string);
    }

    public String getFromUnit() {
        return this.getSelectedValue(this.list) + "";
    }

    public String getToUnit() {
        return this.getSelectedValue(this.list2) + "";
    }

    public void setFromUnit(String string) {
        this.setSelectedStringValue(this.list, string);
    }

    public void setToUnit(String string) {
        this.setSelectedStringValue(this.list2, string);
    }

    private void convert(boolean bl) {
        String string = this.getSelectedValue(this.list);
        String string2 = this.getSelectedValue(this.list2);
        if (string != null && string2 != null) {
            DecimalFormat decimalFormat = new DecimalFormat();
            decimalFormat.setMaximumFractionDigits(30);
            if (bl) {
                if (this.txtTo.getText() != null && !this.txtTo.getText().trim().equals("")) {
                    Double d = new Double(this.ctd.convert(this.txtTo.getText().trim().replaceAll(",", ""), string2, string));
                    this.txtFrom.setText(decimalFormat.format(d));
                    this.txtToFract.setText("");
                }
            } else if (this.txtFrom.getText() != null && !this.txtFrom.getText().trim().equals("")) {
                Double d = new Double(this.ctd.convert(this.txtFrom.getText().trim().replaceAll(",", ""), string, string2));
                this.txtTo.setText(decimalFormat.format(d));
                String string3 = this.ctd.convertFraction(this.txtFrom.getText().trim().replaceAll(",", ""), string, string2);
                this.txtToFract.setText(string3);
            }
        }
    }

    private void init() {
        Dimension dimension = new Dimension(280, 220);
        this.list = new JList();
        this.list.setCellRenderer(new ConvertListCellRenderer());
        this.list.setModel(new ConvertListModel(this.ctd.getAllFromUnits()));
        JScrollPane jScrollPane = new JScrollPane(this.list);
        jScrollPane.setPreferredSize(dimension);
        jScrollPane.setBorder(BorderFactory.createTitledBorder(Messages.getResource("fromUnitLabel")));
        this.list2 = new JList();
        this.list2.setModel(new ConvertListModel(new ArrayList()));
        this.list2.setCellRenderer(new ConvertListCellRenderer());
        JScrollPane jScrollPane2 = new JScrollPane(this.list2);
        jScrollPane2.setPreferredSize(dimension);
        jScrollPane2.setBorder(BorderFactory.createTitledBorder(Messages.getResource("toUnitLabel")));
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                String string = ConversionPanel.this.getSelectedValue((JList)listSelectionEvent.getSource());
                List list = ConversionPanel.this.ctd.getToUnits(string);
                String string2 = ConversionPanel.this.getSelectedValue(ConversionPanel.this.list2);
                ConversionPanel.this.list2.setModel(new ConvertListModel(list));
                ConversionPanel.this.list2.setCellRenderer(new ConvertListCellRenderer());
                ConversionPanel.this.labelFromUnit.setText(ConversionPanel.this.getSelectedTranslatedValue((JList)listSelectionEvent.getSource()));
                if (string2 != null) {
                    int n = 0;
                    for (int i = 0; i < ConversionPanel.this.list2.getModel().getSize(); ++i) {
                        ConversionUnitData conversionUnitData = (ConversionUnitData)ConversionPanel.this.list2.getModel().getElementAt(i);
                        if (!conversionUnitData.getUnit().equals(string2)) continue;
                        n = i;
                        break;
                    }
                    ConversionPanel.this.list2.setSelectedIndex(n);
                }
                ConversionPanel.this.convert();
            }
        });
        this.list2.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                String string = ConversionPanel.this.getSelectedTranslatedValue((JList)listSelectionEvent.getSource());
                int n = ConversionPanel.this.getGenerationAge((JList)listSelectionEvent.getSource());
                if (n >= 2) {
                    ConversionPanel.this.labelToUnit.setText(string + " (" + Messages.getResource("generatedConversion") + "(" + n + "))");
                } else {
                    ConversionPanel.this.labelToUnit.setText(string);
                }
                ConversionPanel.this.convert();
            }
        });
        this.setLayout(new BoxLayout(this, 1));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(jScrollPane);
        jPanel.add(Box.createHorizontalStrut(5));
        jPanel.add(jScrollPane2);
        Component component = this.getTopComponent();
        if (component != null) {
            this.add(component);
        }
        this.add(jPanel);
        JPanel jPanel2 = new JPanel();
        Dimension dimension2 = new Dimension(580, 70);
        jPanel2.setSize(dimension2);
        jPanel2.setPreferredSize(dimension2);
        JLabel jLabel = new JLabel(Messages.getResource("conversionFromLabel"));
        jLabel.setBounds(5, 5, 100, 22);
        JLabel jLabel2 = new JLabel(Messages.getResource("conversionToLabel"));
        jLabel2.setBounds(5, 30, 100, 22);
        JLabel jLabel3 = new JLabel(Messages.getResource("conversionToFractLabel"));
        jLabel3.setBounds(5, 55, 100, 22);
        this.labelFromUnit = new JLabel("xxx");
        this.labelFromUnit.setBounds(330, 5, 400, 22);
        this.labelToUnit = new JLabel("yyy");
        this.labelToUnit.setBounds(330, 30, 400, 22);
        this.txtFrom = new NumericalTextField();
        this.txtFrom.setText("1");
        this.txtFrom.setBounds(110, 5, 200, 22);
        this.txtFrom.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                ConversionPanel.this.convert();
            }
        });
        this.txtTo = new JTextField();
        this.txtTo.setBounds(110, 30, 200, 22);
        this.txtTo.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                ConversionPanel.this.convert(true);
            }
        });
        this.txtToFract = new JTextField();
        this.txtToFract.setBounds(110, 55, 200, 22);
        this.txtToFract.setEditable(false);
        jPanel2.setLayout(null);
        jPanel2.add(jLabel);
        jPanel2.add(jLabel2);
        jPanel2.add(jLabel3);
        jPanel2.add(this.labelFromUnit);
        jPanel2.add(this.labelToUnit);
        jPanel2.add(this.txtFrom);
        jPanel2.add(this.txtTo);
        jPanel2.add(this.txtToFract);
        Dimension dimension3 = new Dimension(600, 80);
        jPanel2.setPreferredSize(dimension3);
        jPanel2.setMinimumSize(dimension3);
        jPanel2.setMaximumSize(new Dimension(1200, 80));
        this.setDefaultSelections();
        this.add(jPanel2);
    }

    protected Component getTopComponent() {
        return null;
    }

    private void setDefaultSelections() {
        if (this.list.getModel().getSize() > 0) {
            this.list.setSelectedIndex(0);
        }
        if (this.list2.getModel().getSize() > 0) {
            this.list2.setSelectedIndex(0);
        }
    }
}

