/*
 * Decompiled with CFR 0.152.
 */
package mmguiclient;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import mmguiclient.IParameters;
import mmguiclient.MMFrame;

public class MMini
implements IParameters,
ItemListener {
    static final String[] ENTRIES = new String[]{"macros=", "browser=", "host=", "precision=", "mode=", "page=", "system=", "hints=", "save=", "frequency=", "expression1=", "expression2=", "expression3=", "expression4=", "expression5=", "expression6=", "expression7=", "expression8=", "expression9=", "expressionA=", "expressionB=", "expressionC=", "expressionD=", "expressionE=", "expressionF="};
    static final String INIFILE = "mathmate.ini";
    static final String DEFAULT_MACRO = "default.mac";
    static final String DEFAULT_BROWSER = "netscape";
    MMFrame m_frame;
    String[] m_ini;
    boolean m_saveFlag;
    int m_delay;

    public MMini(MMFrame mMFrame) {
        this.m_frame = mMFrame;
        int n = 0;
        int n2 = ENTRIES.length;
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(INIFILE));
            this.m_ini = new String[n2];
            while ((string = bufferedReader.readLine()) != null && n < n2) {
                this.m_ini[n++] = string;
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            return;
        }
        this.m_saveFlag = this.getSaveFlag();
    }

    public String getMacroFile() {
        String string = this.getEntry(ENTRIES[0]);
        if (string == null) {
            string = DEFAULT_MACRO;
        }
        return string;
    }

    public String getBrowser() {
        String string = this.getEntry(ENTRIES[1]);
        if (string == null) {
            string = DEFAULT_BROWSER;
        }
        return string;
    }

    public String getHost() {
        String string = this.getEntry(ENTRIES[2]);
        return string;
    }

    public int getPrecision() {
        String string = this.getEntry(ENTRIES[3]);
        if (string == null) {
            return 6;
        }
        try {
            int n = Integer.parseInt(string);
            if (n < 1 || n > 15) {
                return 6;
            }
            return n;
        }
        catch (Exception exception) {
            return 6;
        }
    }

    public int getMode() {
        String string = this.getEntry(ENTRIES[4]);
        if (string == null) {
            return 0;
        }
        try {
            int n = Integer.parseInt(string) % 6;
            return n;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int getPage() {
        String string = this.getEntry(ENTRIES[5]);
        if (string == null) {
            return 0;
        }
        try {
            int n = Integer.parseInt(string) % 3;
            return n;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int getSystem() {
        String string = this.getEntry(ENTRIES[6]);
        if (string == null) {
            return 0;
        }
        try {
            int n = Integer.parseInt(string) % 2;
            return n;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public boolean getHintFlag() {
        String string = this.getEntry(ENTRIES[7]);
        if (string == null) {
            return false;
        }
        return string.equals("true");
    }

    public boolean getSaveFlag() {
        String string = this.getEntry(ENTRIES[8]);
        if (string == null) {
            return false;
        }
        return string.equals("true");
    }

    public int getFrequency() {
        int n;
        String string = this.getEntry(ENTRIES[9]);
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            return 2000;
        }
        return n;
    }

    public String[] getExpressions() {
        String[] stringArray = new String[15];
        int n = 0;
        while (n < 15) {
            stringArray[n] = this.getEntry(ENTRIES[10 + n]);
            ++n;
        }
        return stringArray;
    }

    public void setSaveFlag(boolean bl) {
        this.m_saveFlag = bl;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.setSaveFlag(itemEvent.getStateChange() == 1);
    }

    String getEntry(String string) {
        int n = this.lookup(string);
        if (n < 0) {
            return null;
        }
        String string2 = this.m_ini[n].substring(string.length()).trim();
        if (string2.equals("null")) {
            return null;
        }
        return string2;
    }

    int lookup(String string) {
        if (string == null || this.m_ini == null) {
            return -1;
        }
        int n = 0;
        while (n < this.m_ini.length) {
            if (this.m_ini[n] != null && this.m_ini[n].startsWith(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void load() {
        this.m_frame.m_macroManager.loadMacros(this.getMacroFile());
        try {
            this.m_frame.resetMacros();
        }
        catch (Exception exception) {}
        this.m_frame.m_browser = this.getBrowser();
        int n = this.getPrecision();
        this.m_frame.m_precisionBox.setPrecision(n);
        this.m_frame.m_precisionBox.m_slider.setValue(n);
        this.m_frame.m_toolbar.setMode(this.getMode());
        this.m_frame.m_funcpad.changeFunctions(this.getPage());
        this.m_frame.m_menu.setSystem(this.getSystem());
        this.m_frame.m_hintFlag = this.getHintFlag();
        this.m_frame.m_menu.m_hint.setState(this.m_frame.m_hintFlag);
        this.m_saveFlag = this.getSaveFlag();
        this.m_frame.m_menu.m_autoSave.setState(this.m_saveFlag);
        this.m_delay = this.getFrequency();
        String[] stringArray = this.getExpressions();
        n = 0;
        while (n < 15) {
            if (stringArray[n] != null) {
                this.m_frame.m_menu.updateList(stringArray[n]);
            }
            ++n;
        }
    }

    public void save() {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(INIFILE));
            String string = String.valueOf(ENTRIES[0]) + this.m_frame.m_macroManager.getMacroFile();
            bufferedWriter.write(string, 0, string.length());
            bufferedWriter.newLine();
            string = String.valueOf(ENTRIES[1]) + this.m_frame.m_browser;
            bufferedWriter.write(string, 0, string.length());
            bufferedWriter.newLine();
            string = String.valueOf(ENTRIES[2]) + this.m_frame.m_host;
            bufferedWriter.write(string, 0, string.length());
            bufferedWriter.newLine();
            string = String.valueOf(ENTRIES[3]) + this.m_frame.getPrecision();
            bufferedWriter.write(string, 0, string.length());
            bufferedWriter.newLine();
            string = String.valueOf(ENTRIES[4]) + this.m_frame.getMode();
            bufferedWriter.write(string, 0, string.length());
            bufferedWriter.newLine();
            string = String.valueOf(ENTRIES[5]) + this.m_frame.m_funcpad.getShift();
            bufferedWriter.write(string, 0, string.length());
            bufferedWriter.newLine();
            string = String.valueOf(ENTRIES[6]) + this.m_frame.getSystem();
            bufferedWriter.write(string, 0, string.length());
            bufferedWriter.newLine();
            string = String.valueOf(ENTRIES[7]) + this.m_frame.m_hintFlag;
            bufferedWriter.write(string, 0, string.length());
            bufferedWriter.newLine();
            string = String.valueOf(ENTRIES[8]) + this.m_saveFlag;
            bufferedWriter.write(string, 0, string.length());
            bufferedWriter.newLine();
            string = String.valueOf(ENTRIES[9]) + this.m_delay;
            bufferedWriter.write(string, 0, string.length());
            bufferedWriter.newLine();
            int n = 0;
            while (n < 15) {
                string = n < this.m_frame.m_menu.m_length ? String.valueOf(ENTRIES[10 + n]) + this.m_frame.m_menu.m_list[n] : String.valueOf(ENTRIES[10 + n]) + "null";
                bufferedWriter.write(string, 0, string.length());
                bufferedWriter.newLine();
                ++n;
            }
            bufferedWriter.flush();
            bufferedWriter.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void saveAll() {
        if (!this.m_saveFlag) {
            return;
        }
        this.save();
    }
}

