/*
 * Decompiled with CFR 0.152.
 */
package tokens;

import eserver.IEngineServer;
import java.util.Locale;
import java.util.ResourceBundle;

public final class Macro {
    static final String EQ = ":=";
    public String m_name;
    public String m_definition;

    public Macro(String string, String string2) {
        string = string.trim();
        if (string.length() > 5) {
            string = string.substring(0, 5);
        }
        this.m_name = string;
        this.m_definition = string2;
    }

    public Macro(String string) {
        if (string == null) {
            this.empty();
            return;
        }
        int n = string.indexOf(EQ);
        if (n < 0) {
            this.empty();
            return;
        }
        this.m_name = string.substring(0, n).trim();
        if (this.m_name.length() > 5) {
            this.m_name = this.m_name.substring(0, 5);
        }
        this.m_definition = string.substring(n + EQ.length());
    }

    public String toString() {
        return String.valueOf(this.m_name) + EQ + this.m_definition;
    }

    void empty() {
        this.m_name = "";
        this.m_definition = "";
    }

    public boolean isEmpty() {
        return this.m_name.equals("");
    }

    public boolean verify(IEngineServer iEngineServer) {
        if (!this.checkName(iEngineServer)) {
            return false;
        }
        return this.checkDefinition(iEngineServer);
    }

    public boolean checkName(IEngineServer iEngineServer) {
        if (this.m_name == null) {
            return false;
        }
        if (this.isEmpty()) {
            return false;
        }
        String[] stringArray = iEngineServer.compile(this.m_name);
        if (stringArray == null) {
            return false;
        }
        if (stringArray.length > 1) {
            return false;
        }
        return stringArray[0].equals(this.m_name);
    }

    public boolean checkDefinition(IEngineServer iEngineServer) {
        if (this.m_definition == null) {
            return false;
        }
        String[] stringArray = iEngineServer.compile(this.m_definition);
        if (stringArray != null) {
            if (stringArray.length > 0) {
                return true;
            }
            ResourceBundle resourceBundle = ResourceBundle.getBundle("mmguiclient.Resource", Locale.getDefault());
            this.m_definition = resourceBundle.getString("no_params");
            return false;
        }
        this.m_definition = iEngineServer.calculate(this.m_definition, 1);
        return false;
    }

    public int params(IEngineServer iEngineServer) {
        if (this.m_definition == null) {
            return 0;
        }
        String[] stringArray = iEngineServer.compile(this.m_definition);
        if (stringArray == null) {
            return 0;
        }
        return stringArray.length;
    }
}

