/*
 * Decompiled with CFR 0.152.
 */
package fi.joensuu.joyds1.calendar;

import fi.joensuu.joyds1.calendar.Calendar;
import fi.joensuu.joyds1.calendar.JulianGregorianCalendar;
import java.util.GregorianCalendar;

public class FinnishCalendar
extends JulianGregorianCalendar {
    private static final int J_1753_02_17 = FinnishCalendar.date2jdn_julian(1753, 2, 17);
    private static final int J_1711_12_31 = FinnishCalendar.date2jdn_julian(1711, 12, 31) - 1;
    private static final int J_1712_12_31 = FinnishCalendar.date2jdn_julian(1712, 12, 31);
    private static final int J_1700_02_28 = FinnishCalendar.date2jdn_julian(1700, 2, 28);
    private static final int[] cumulative_days_in_1712 = new int[]{0, 31, 61, 92, 122, 153, 183, 214, 245, 275, 306, 336, 367};
    private static final int[] cumulative_days_in_1753 = new int[]{0, 31, 48, 79, 109, 140, 170, 201, 232, 262, 293, 323, 354};
    private static final int CUMULATIVE_DAYS_IN_FEBRUARY_1712 = cumulative_days_in_1712[2];
    private static final int CUMULATIVE_DAYS_IN_FEBRUARY_1753 = cumulative_days_in_1753[2];
    private static final long serialVersionUID = 1L;

    public FinnishCalendar() {
        this(FinnishCalendar.getToday());
    }

    public FinnishCalendar(int n, int n2, int n3) {
        this.set(n, n2, n3);
    }

    public FinnishCalendar(int n, int n2) {
        this.set(n, n2);
    }

    public FinnishCalendar(int n) {
        this.set(n);
    }

    public FinnishCalendar(Calendar calendar) {
        this.set(calendar);
    }

    public FinnishCalendar(GregorianCalendar gregorianCalendar) {
        this.set(gregorianCalendar);
    }

    @Override
    public final int getISOWeekNumber() {
        return FinnishCalendar.getISOWeekNumber(this.getJulianDayNumber(), this.getYear(), 1754);
    }

    @Override
    public boolean isDate(int n, int n2, int n3) {
        return this.ok_date(n, n2, n3);
    }

    @Override
    protected void jdn2date(int n) {
        if (n > J_1753_02_17) {
            this.jdn2date_gregorian(n);
        } else if (n > J_1712_12_31) {
            this.jdn2date_julian(n);
        } else if (n > J_1711_12_31) {
            this.year = 1712;
            this.doy2date(this.year, n - J_1711_12_31);
        } else if (n > J_1700_02_28) {
            this.jdn2date_julian(n + 1);
        } else {
            this.jdn2date_julian(n);
        }
    }

    @Override
    protected int date2jdn(int n, int n2, int n3) {
        if (FinnishCalendar.compare(n, n2, n3, 1753, 2, 17) > 0) {
            return FinnishCalendar.date2jdn_gregorian(n, n2, n3);
        }
        if (FinnishCalendar.compare(n, n2, n3, 1712, 2, 30) > 0) {
            return FinnishCalendar.date2jdn_julian(n, n2, n3);
        }
        if (FinnishCalendar.compare(n, n2, n3, 1700, 2, 28) > 0) {
            return FinnishCalendar.date2jdn_julian(n, n2, n3) - 1;
        }
        return FinnishCalendar.date2jdn_julian(n, n2, n3);
    }

    @Override
    protected void doy2date(int n, int n2) {
        switch (n) {
            case 1712: {
                if (n2 < CUMULATIVE_DAYS_IN_FEBRUARY_1712) {
                    this.doy2date(this.isLeapYear(n), n, n2);
                    break;
                }
                if (n2 == CUMULATIVE_DAYS_IN_FEBRUARY_1712) {
                    this.month = 2;
                    this.day = 30;
                    break;
                }
                this.doy2date(this.isLeapYear(n), n, n2 - 1);
                break;
            }
            case 1753: {
                if (n2 <= CUMULATIVE_DAYS_IN_FEBRUARY_1753) {
                    this.doy2date(this.isLeapYear(n), n, n2);
                    break;
                }
                this.doy2date(this.isLeapYear(n), n, n2 + 11);
                break;
            }
            default: {
                this.doy2date(this.isLeapYear(n), n, n2);
            }
        }
    }

    @Override
    protected int getCumulativeDays(int n, int n2) {
        if (n == 1712) {
            return cumulative_days_in_1712[n2];
        }
        if (n == 1753) {
            return cumulative_days_in_1753[n2];
        }
        if (this.isLeapYear(n)) {
            return cumulative_days_in_leap_year[n2];
        }
        return cumulative_days_in_ordinary_year[n2];
    }

    @Override
    public boolean isLeapYear(int n) {
        if (n >= 1753) {
            return FinnishCalendar.is_leap_year_gregorian(n);
        }
        if (n == 1700) {
            return false;
        }
        return FinnishCalendar.is_leap_year_julian(n);
    }

    @Override
    public int getLengthOfMonth(int n, int n2) {
        if (n2 == 2) {
            switch (n) {
                case 1712: {
                    return 30;
                }
                case 1753: {
                    return 17;
                }
            }
            return this.isLeapYear(n) ? 29 : 28;
        }
        return days_in_month_in_ordinary_year[n2];
    }
}

