/*
 * Decompiled with CFR 0.152.
 */
package fi.joensuu.joyds1.calendar;

import fi.joensuu.joyds1.calendar.Calendar;
import fi.joensuu.joyds1.calendar.OldWorldCalendar;
import java.util.GregorianCalendar;

public class FrenchRevolutionaryCalendar
extends OldWorldCalendar {
    private static final int[] cumulative_days_in_ordinary_year = new int[]{0, 30, 60, 90, 120, 150, 180, 210, 240, 270, 300, 330, 360, 365};
    private static final int[] cumulative_days_in_leap_year = new int[]{0, 30, 60, 90, 120, 150, 180, 210, 240, 270, 300, 330, 360, 366};
    public static final int FIRST_JULIAN_DAY = FrenchRevolutionaryCalendar.date2jdn_gregorian(1792, 9, 22);
    private static final int J0 = FIRST_JULIAN_DAY - 365;
    private static final int D4000 = 1460969;
    private static final int D16 = 5844;
    private static final long serialVersionUID = 1L;

    public FrenchRevolutionaryCalendar() {
        this(FrenchRevolutionaryCalendar.getToday());
    }

    public FrenchRevolutionaryCalendar(int n, int n2, int n3) {
        this.set(n, n2, n3);
    }

    public FrenchRevolutionaryCalendar(int n, int n2) {
        this.set(n, n2);
    }

    public FrenchRevolutionaryCalendar(int n) {
        this.set(n);
    }

    public FrenchRevolutionaryCalendar(Calendar calendar) {
        this.set(calendar);
    }

    public FrenchRevolutionaryCalendar(GregorianCalendar gregorianCalendar) {
        this.set(gregorianCalendar);
    }

    @Override
    protected void jdn2date(int n) {
        if (n < FIRST_JULIAN_DAY) {
            throw new IllegalArgumentException("jdn2date n=" + n);
        }
        int n2 = n - FIRST_JULIAN_DAY;
        if (n2 < 5844) {
            this.jdn2ymd(-1, n - J0);
        } else {
            int n3 = n2 / 1460969;
            int n4 = n2 % 1460969;
            this.jdn2ymd(4000 * n3, n4);
        }
    }

    @Override
    protected int date2jdn(int n, int n2, int n3) {
        return FIRST_JULIAN_DAY - 1 + 365 * (n - 1) + (n < 20 ? n / 4 : (n - 1) / 4 - (n - 1) / 100 + (n - 1) / 400 - (n - 1) / 4000) + this.getCumulativeDays(n, n2 - 1) + n3;
    }

    @Override
    protected void doy2date(int n, int n2) {
        this.year = n;
        this.month = (n2 - 1) / 30 + 1;
        this.day = n2 - this.getCumulativeDays(n, this.month - 1);
        if (!this.isDate(n, this.month, this.day)) {
            throw new IllegalArgumentException("FrenchRevolutionaryCalendar doy2date year=" + n + " month=" + this.month + " day=" + this.day + " doy=" + n2);
        }
    }

    @Override
    protected int getCumulativeDays(int n, int n2) {
        return this.isLeapYear(n) ? cumulative_days_in_leap_year[n2] : cumulative_days_in_ordinary_year[n2];
    }

    @Override
    public boolean isLeapYear(int n) {
        if (n <= 20) {
            switch (n) {
                case 3: 
                case 7: 
                case 11: 
                case 15: 
                case 20: {
                    return true;
                }
            }
            return false;
        }
        if (n % 4000 == 0) {
            return false;
        }
        return n % 4 == 0 && n % 100 != 0 || n % 400 == 0;
    }

    @Override
    public int getLengthOfMonth(int n, int n2) {
        return n2 < 13 ? 30 : (this.isLeapYear(n) ? 6 : 5);
    }

    @Override
    public int getLastMonthOfYear(int n) {
        return 13;
    }

    @Override
    public int getDayOfWeek() {
        return FrenchRevolutionaryCalendar.amod(this.getDay(), 10);
    }

    @Override
    public int getFirstJulianDay() {
        return FIRST_JULIAN_DAY;
    }
}

