/*
 * Decompiled with CFR 0.152.
 */
package fi.joensuu.joyds1.calendar;

import fi.joensuu.joyds1.calendar.Calendar;
import fi.joensuu.joyds1.calendar.OldWorldCalendar;
import java.util.GregorianCalendar;

public class HinduSolarCalendar
extends OldWorldCalendar {
    public static final int FIRST_JULIAN_DAY = HinduSolarCalendar.date2jdn_julian(-3101, 2, 18);
    protected static final double SOLAR_SIDEREAL_YEAR = 365.2587564814815;
    protected static final double MEAN_SUNRISE = 0.25;
    private static final double SOLAR_MONTH = 30.438229706790125;
    private static final long serialVersionUID = 1L;

    public HinduSolarCalendar() {
        this(HinduSolarCalendar.getToday());
    }

    public HinduSolarCalendar(int n, int n2, int n3) {
        this.set(n, n2, n3);
    }

    public HinduSolarCalendar(int n, int n2) {
        this.set(n, n2);
    }

    public HinduSolarCalendar(int n) {
        this.set(n);
    }

    public HinduSolarCalendar(Calendar calendar) {
        this.set(calendar);
    }

    public HinduSolarCalendar(GregorianCalendar gregorianCalendar) {
        this.set(gregorianCalendar);
    }

    @Override
    protected void jdn2date(int n) {
        if (n < FIRST_JULIAN_DAY) {
            throw new IllegalArgumentException("HinduSolarCalendar jdn2date (int n)");
        }
        double d = (double)(n - FIRST_JULIAN_DAY) + 0.25;
        this.year = (int)(d / 365.2587564814815);
        this.month = HinduSolarCalendar.zodiac(d);
        this.day = 1 + (int)Math.floor(HinduSolarCalendar.mod(d, 30.438229706790125));
    }

    @Override
    protected int date2jdn(int n, int n2, int n3) {
        return (int)Math.floor((double)FIRST_JULIAN_DAY + (double)n * 365.2587564814815 + (double)(n2 - 1) * 30.438229706790125 + ((double)n3 - 0.25));
    }

    @Override
    protected void doy2date(int n, int n2) {
        if (!this.isDate(n, n2)) {
            throw new IllegalArgumentException("HinduSolarCalendar doy2date year=" + n + " doy=" + n2);
        }
        this.year = n;
        this.month = 1;
        while (n2 > this.getCumulativeDays(n, this.month)) {
            ++this.month;
        }
        this.day = n2 - this.getCumulativeDays(n, this.month - 1);
        if (!this.isDate(this.year, this.month, this.day)) {
            throw new IllegalArgumentException("HinduSolarCalendar doy2date this.year=" + this.year + " this.month=" + this.month + " this.day=" + this.day + " doy=" + n2);
        }
    }

    @Override
    public boolean isDate(int n, int n2, int n3) {
        return n >= 0 && 1 <= n2 && n2 <= this.getLastMonthOfYear(n) && 1 <= n3 && n3 <= this.getLengthOfMonth(n, n2);
    }

    @Override
    protected int getCumulativeDays(int n, int n2) {
        return n2 == 0 ? 0 : this.startOfNextMonth(n, n2) - this.date2jdn(n, 1, 1);
    }

    @Override
    public int getLengthOfMonth(int n, int n2) {
        return this.startOfNextMonth(n, n2) - this.date2jdn(n, n2, 1);
    }

    @Override
    public boolean isLeapYear(int n) {
        return false;
    }

    @Override
    public int getFirstJulianDay() {
        return FIRST_JULIAN_DAY;
    }

    private final int startOfNextMonth(int n, int n2) {
        return n2 == 12 ? this.date2jdn(n + 1, 1, 1) : this.date2jdn(n, n2 + 1, 1);
    }

    protected static final double solarLongitude(double d) {
        return HinduSolarCalendar.mod(d / 365.2587564814815, 1.0) * 360.0;
    }

    protected static final int zodiac(double d) {
        return 1 + (int)HinduSolarCalendar.solarLongitude(d) / 30;
    }
}

