/*
 * Decompiled with CFR 0.152.
 */
package fi.joensuu.joyds1.calendar.util;

import fi.joensuu.joyds1.calendar.Resources;
import fi.joensuu.joyds1.calendar.util.MyTableModel;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class ConversionApplet
extends JApplet
implements ActionListener {
    private JTable table;
    private static final long serialVersionUID = 1L;

    @Override
    public void init() {
        this.setContentPane(this.makeContentPane());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Print")) {
            try {
                this.table.print();
            }
            catch (Throwable throwable) {
                JOptionPane.showMessageDialog(null, throwable.getMessage());
            }
        } else if (actionEvent.getActionCommand().equals("Help")) {
            JOptionPane.showMessageDialog(null, Resources.getString("HelpText"));
        }
    }

    private Container makeContentPane() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(this.makeButtons());
        this.table = new JTable(new MyTableModel());
        TableColumn tableColumn = null;
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            tableColumn = this.table.getColumnModel().getColumn(i);
            if (i == 0) {
                tableColumn.setPreferredWidth(200);
                continue;
            }
            tableColumn.setPreferredWidth(55);
        }
        JScrollPane jScrollPane = new JScrollPane(this.table);
        this.table.setPreferredScrollableViewportSize(new Dimension(550, 470));
        jPanel.add(jScrollPane);
        return jPanel;
    }

    private Container makeButtons() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this.makeButton("Print"));
        jPanel.add(this.makeButton("Help"));
        return jPanel;
    }

    private JButton makeButton(String string) {
        JButton jButton = new JButton(Resources.getString(string));
        jButton.setActionCommand(string);
        jButton.addActionListener(this);
        return jButton;
    }

    public ConversionApplet() {
    }

    private ConversionApplet(JFrame jFrame) {
        jFrame.getContentPane().add(this.makeContentPane());
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Calendar Conversions");
        jFrame.setDefaultCloseOperation(3);
        ConversionApplet conversionApplet = new ConversionApplet(jFrame);
    }
}

