/*
 * Decompiled with CFR 0.152.
 */
package jonelo.sugar.gui;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GUIHelper {
    private static final String browser = System.getProperty("browser");
    private static final String calculator = System.getProperty("calculator");

    public static void openLocalFileInBrowser(String filename) throws IOException, URISyntaxException {
        String address = GUIHelper.makeLocalAddressOfLocalFilename(filename);
        GUIHelper.openInBrowser(address);
    }

    public static void openLocalFileInBrowser(String filename, String browserAbsolutePath) throws IOException, URISyntaxException {
        String address = GUIHelper.makeLocalAddressOfLocalFilename(filename);
        GUIHelper.openInBrowser(address, browserAbsolutePath);
    }

    private static String makeLocalAddressOfLocalFilename(String filename) throws IOException, URISyntaxException {
        File file = new File(filename);
        String address = "file:///" + file.getCanonicalPath().replace('\\', '/').replaceAll(" ", "%20");
        return address;
    }

    public static void openInBrowser(String address) throws IOException, URISyntaxException {
        Desktop desktop = null;
        if (browser == null) {
            if (Desktop.isDesktopSupported()) {
                desktop = Desktop.getDesktop();
                if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
                    URI uri = new URI(address);
                    desktop.browse(uri);
                } else {
                    GUIHelper.openInBrowserFallback(address);
                }
            } else {
                GUIHelper.openInBrowserFallback(address);
            }
        } else {
            GUIHelper.openInBrowserFallback(address);
        }
    }

    private static void openInBrowserFallback(String address) {
        Logger logger = Logger.getLogger("jonelo.sugar.gui.GUIHelper");
        if (browser != null) {
            logger.log(Level.CONFIG, "System property browser has been set, using {0}", browser);
            GUIHelper.openInBrowser(address, browser);
        } else {
            logger.config("System property browser not set.");
            String os = System.getProperty("os.name").toLowerCase(Locale.US);
            if (os.equalsIgnoreCase("Mac OS X")) {
                logger.log(Level.INFO, "Launching {0} using the open command.", address);
                GUIHelper.openInBrowser(address, "open");
            }
            if (os.startsWith("linux") || os.startsWith("freebsd")) {
                logger.log(Level.INFO, "Launching {0} using the xdg-open command.", address);
                GUIHelper.openInBrowser(address, "xdg-open");
            }
        }
    }

    public static void openInBrowser(String address, String browserAbsolutePath) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(browserAbsolutePath);
        command.add(address);
        try {
            Process process = new ProcessBuilder(command).start();
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public static void openMail(String email, String subject, String body) throws IOException, URISyntaxException {
        Desktop desktop = null;
        if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()) != null && desktop.isSupported(Desktop.Action.MAIL)) {
            String mailTo = email + "?SUBJECT=" + subject + "&BODY=" + body;
            URI uri = new URI("mailto", mailTo, null);
            desktop.mail(uri);
        }
    }

    public static void openNativeCalculator() {
        block22: {
            block23: {
                String exec = null;
                String exec_alt = null;
                if (calculator != null) {
                    exec = calculator;
                } else {
                    String os = System.getProperty("os.name").toLowerCase(Locale.US);
                    if (os.startsWith("windows")) {
                        exec = "calc.exe";
                    } else if (os.startsWith("linux") || os.startsWith("freebsd") || os.startsWith("hp-ux")) {
                        String kde = System.getProperty("user.home") + "/.kde";
                        if (new File(kde).exists()) {
                            exec = "kcalc";
                            exec_alt = "gnome-calculator";
                            String kde4 = System.getProperty("user.home") + "/.kde4";
                            if (new File(kde4).exists()) {
                                exec = "kcalc";
                                exec_alt = "gnome-calculator";
                            }
                        } else {
                            exec = "gnome-calculator";
                            exec_alt = "galculator";
                        }
                    } else if (os.equalsIgnoreCase("Mac OS X")) {
                        exec = "/Applications/Calculator.app/Contents/MacOS/Calculator";
                    } else if (os.startsWith("sunos")) {
                        exec = "gnome-calculator";
                        exec_alt = "dtcalc";
                    } else if (os.equalsIgnoreCase("OS/2")) {
                        exec = "ecscalc";
                    } else if (os.equalsIgnoreCase("AIX")) {
                        exec = "dtcalc";
                        exec_alt = "gnome-calculator";
                    } else if (os.equalsIgnoreCase("BeOS")) {
                        exec = "/boot/apps/calc/calc";
                    }
                }
                if (exec == null) break block23;
                try {
                    Process process = new ProcessBuilder(exec).start();
                }
                catch (IOException e) {
                    System.err.println(e.toString());
                    if (exec_alt == null) break block22;
                    try {
                        System.out.println("Trying " + exec_alt + " ...");
                        Process process = new ProcessBuilder(exec_alt).start();
                        break block22;
                    }
                    catch (IOException e2) {
                        System.err.println(e2.toString());
                    }
                }
                break block22;
            }
            System.err.println("No calculator has been found. Specify one with the JVM option -Dcalculator=<yourcalculator>.");
        }
    }
}

