/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.data.i18n;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import net.numericalchameleon.data.i18n.ResBundleRecord;

public class ResBundles {
    private final List<ResBundleRecord> myList = new ArrayList<ResBundleRecord>();

    public ResBundles() {
        this._read();
    }

    private void _read() {
        this.read();
    }

    public void read() {
        this.myList.clear();
        try {
            String thisLine;
            InputStream is = ResBundles.class.getResourceAsStream("/data/lists/language.txt");
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            while ((thisLine = br.readLine()) != null) {
                if (thisLine.length() == 0 || thisLine.startsWith("#")) continue;
                this.myList.add(new ResBundleRecord(thisLine));
            }
            br.close();
            is.close();
        }
        catch (IOException e) {
            System.out.println(e);
            this.myList.clear();
            this.myList.add(new ResBundleRecord("2.0.0;US:nobody;en;GB;en;English (US)"));
        }
    }

    public boolean isLanguageSupported(String language) {
        for (ResBundleRecord resBundleRecord : this.myList) {
            if (!resBundleRecord.getLanguage().equals(language)) continue;
            return true;
        }
        return false;
    }

    public boolean isHelpSupported(String help) {
        for (ResBundleRecord resBundleRecord : this.myList) {
            if (!resBundleRecord.getHelp().equals(help)) continue;
            return true;
        }
        return false;
    }

    public ResBundleRecord getSupportedResBundleByLanguageID(String language) throws Exception {
        for (ResBundleRecord record : this.myList) {
            if (!record.getLanguage().equals(language)) continue;
            return record;
        }
        throw new Exception("Language is not supported.");
    }

    public List<ResBundleRecord> getList() {
        return this.myList;
    }

    public Vector getVector() {
        Vector v = new Vector();
        Collections.copy(v, this.myList);
        return v;
    }
}

