/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.gui.dialogs.editunits;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import net.numericalchameleon.data.Bookmark;
import net.numericalchameleon.gui.dialogs.editunits.EditUnitsInterface;

public class EditUnits
extends JDialog {
    private ResourceBundle resourceBundle;
    private String filename;
    private static final String ENCODING = "UTF-8";
    private Bookmark bookmark;
    private EditUnitsInterface editUnitsInterface;
    private JButton cancelButton;
    private JLabel headerLabel;
    private JButton saveButton;
    private JScrollPane scrollPane;
    private JTextArea textArea;

    public EditUnits(EditUnitsInterface editUnitsInterface, boolean modal) {
        super(editUnitsInterface.getFrame(), modal);
        this.editUnitsInterface = editUnitsInterface;
        this.resourceBundle = editUnitsInterface.getResourceBundle();
        if (editUnitsInterface.getFrame().isUndecorated()) {
            this.setUndecorated(true);
            this.getRootPane().setWindowDecorationStyle(1);
        }
        this.setLocationRelativeTo(editUnitsInterface.getFrame());
        this.initComponents();
        this.textArea.setFont(new Font("Courier", 0, 13));
    }

    private void initComponents() {
        this.cancelButton = new JButton();
        this.saveButton = new JButton();
        this.scrollPane = new JScrollPane();
        this.textArea = new JTextArea();
        this.headerLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle(this.resourceBundle.getString("GUI.Config.Units.Edit"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                EditUnits.this.closeDialog(evt);
            }
        });
        this.cancelButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/close.png")));
        this.cancelButton.setText(this.resourceBundle.getString("GUI.General.Close"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditUnits.this.cancelButtonActionPerformed(evt);
            }
        });
        this.saveButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/save.png")));
        this.saveButton.setText(this.resourceBundle.getString("GUI.General.Save"));
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditUnits.this.saveButtonActionPerformed(evt);
            }
        });
        this.scrollPane.setViewportView(this.textArea);
        this.headerLabel.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix48x48/dontpanic.png")));
        this.headerLabel.setText("Category");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, -1, 380, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.saveButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addComponent(this.headerLabel)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.headerLabel).addGap(8, 8, 8).addComponent(this.scrollPane, -1, 157, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.saveButton)).addContainerGap()));
        this.pack();
    }

    public void setDescription(String string) {
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        try {
            FileOutputStream fos = new FileOutputStream("../data/units/" + this.filename + ".list");
            System.out.println(this.filename);
            BufferedWriter myOutput = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, ENCODING));
            myOutput.write(this.textArea.getText());
            myOutput.close();
            fos.close();
            try {
                this.editUnitsInterface.visitBookmark(this.bookmark, true);
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.closeDialog(null);
    }

    public void fill() {
        String string = this.read();
        this.textArea.setText(string);
        this.textArea.setCaretPosition(0);
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setBookmark(Bookmark bookmark) {
        this.bookmark = bookmark;
        this.headerLabel.setIcon(new ImageIcon(this.getClass().getResource("/data/icons/categories/" + bookmark.getCategory() + ".png")));
    }

    public void setHeader(String header) {
        this.headerLabel.setText(header);
    }

    public String read() {
        StringBuilder sb = new StringBuilder();
        try {
            String thisLine;
            InputStream is = this.getClass().getResourceAsStream("/data/units/" + this.filename + ".list");
            BufferedReader br = new BufferedReader(new InputStreamReader(is, ENCODING));
            while ((thisLine = br.readLine()) != null) {
                sb.append(thisLine).append("\n");
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }
}

