/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.util.calendarlistformats;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import net.numericalchameleon.util.calendarlistformats.ListFormat;

public class VCalendarListFormat
extends ListFormat {
    private DateFormat formatter = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");

    public VCalendarListFormat() {
        this.formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    @Override
    public String getFooter() {
        return "END:VCALENDAR";
    }

    @Override
    public String getFormat() {
        return "BEGIN:VEVENT\n$TVALUE\nCLASS:PUBLIC\nSUMMARY;ENCODING=QUOTED-PRINTABLE:$TUNIT\nEND:VEVENT";
    }

    @Override
    public String getHeader() {
        return "BEGIN:VCALENDAR\nVERSION:1.0\n";
    }

    @Override
    public String reformatDate(int dateformat, String date) throws ParseException {
        Date newdate = DateFormat.getDateInstance(dateformat).parse(date);
        GregorianCalendar local = new GregorianCalendar();
        local.setTime(newdate);
        ((Calendar)local).add(10, 24);
        String zulubegin = this.formatter.format(newdate);
        String zuluend = this.formatter.format(local.getTime());
        return "DTSTART:" + zulubegin + "\nDTEND:" + zuluend;
    }

    @Override
    public String reformatUnit(String unit) {
        return VCalendarListFormat.unicode2quotedPrintable(unit, "ISO8859_1");
    }

    public static String unicode2quotedPrintable(String s, String encoding) {
        StringBuilder output = new StringBuilder(80);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, encoding);
            osw.write(s, 0, s.length());
            osw.close();
        }
        catch (Exception e) {
            if (e.toString().indexOf("UnsupportedEncoding") != 0) {
                return VCalendarListFormat.unicode2quotedPrintable(s, "US-ASCII");
            }
            e.printStackTrace();
        }
        byte[] input = baos.toByteArray();
        output.append("=\n");
        int k = 65;
        int o = 1;
        for (int i = 0; i < input.length; ++i) {
            if (input[i] < 0 || input[i] == 61) {
                int ch = input[i];
                if (input[i] < 0) {
                    ch += 256;
                }
                output.append("=" + Integer.toHexString(ch).toUpperCase());
                o += 3;
            } else if (input[i] == 13 || input[i] == 10) {
                output.append("=0D=0A");
                int ch2 = i + 1 < input.length ? input[i + 1] : 32;
                if (ch2 == 13 | ch2 == 10) {
                    ++i;
                }
                o += 6;
            } else {
                output.append((char)input[i]);
                ++o;
            }
            if (o <= k - 1) continue;
            output.append("=\n");
            k += 65;
        }
        return output.toString();
    }
}

