/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.util.datediff;

import java.util.Calendar;
import net.numericalchameleon.util.datediff.DurationControl;
import net.numericalchameleon.util.datediff.LeapSeconds;

public class Duration {
    private long seconds;
    private double minutes;
    private double hours;
    private double days;
    private double weeks;

    public Duration() {
        this._clear();
    }

    public String toString() {
        return this.days + " d, " + this.minutes + " m, " + this.hours + " h, " + this.seconds + " s";
    }

    private void _clear() {
        this.seconds = 0L;
        this.minutes = 0.0;
        this.hours = 0.0;
        this.days = 0.0;
        this.weeks = 0.0;
    }

    public void clear() {
        this._clear();
    }

    public void setSeconds(long seconds) {
        this.seconds = seconds;
    }

    public void rearrange(DurationControl control) {
        long t = (long)this.getAsSecondsOnly();
        if (t > 0L) {
            this.seconds = t % 60L;
            t /= 60L;
        }
        if (t > 0L) {
            this.minutes = t % 60L;
            t /= 60L;
        }
        if (t > 0L) {
            this.hours = t % 24L;
            t /= 24L;
        }
        if (t > 0L) {
            this.days = t % 7L;
            t /= 7L;
        }
        this.weeks = t;
        if (!control.isWeeksWanted()) {
            this.days += this.weeks * 7.0;
            this.weeks = 0.0;
        }
        if (!control.isDaysWanted()) {
            this.hours += this.days * 24.0;
            this.days = 0.0;
        }
        if (!control.isHoursWanted()) {
            this.minutes += this.hours * 60.0;
            this.hours = 0.0;
        }
        if (!control.isMinutesWanted()) {
            this.seconds = (long)((double)this.seconds + this.minutes * 60.0);
            this.minutes = 0.0;
        }
        if (!control.isSecondsWanted()) {
            if (control.isMinutesWanted()) {
                this.minutes += (double)this.seconds / 60.0;
            } else if (control.isHoursWanted()) {
                this.hours += (double)this.seconds / 3600.0;
            } else if (control.isDaysWanted()) {
                this.days += (double)this.seconds / 86400.0;
            } else if (control.isWeeksWanted()) {
                this.weeks += (double)this.seconds / 604800.0;
            }
            this.seconds = 0L;
        }
    }

    public long getSeconds() {
        return this.seconds;
    }

    public double getAsSecondsOnly() {
        return this.days * 86400.0 + this.hours * 3600.0 + this.minutes * 60.0 + (double)this.seconds;
    }

    public void setHours(long hours) {
        this.hours = hours;
    }

    public double getHours() {
        return this.hours;
    }

    public void setMinutes(long minutes) {
        this.minutes = minutes;
    }

    public double getMinutes() {
        return this.minutes;
    }

    public void setDays(long days) {
        this.days = days;
    }

    public double getDays() {
        return this.days;
    }

    public static Duration getDiff(Calendar start, Calendar end) {
        return Duration.getDiff(start, end, false);
    }

    public static Duration getDiff(Calendar start, Calendar end, boolean includingLeapSeconds) {
        Duration d = new Duration();
        d.setSeconds(Math.abs(Duration.calcSecs(end) - Duration.calcSecs(start)));
        if (includingLeapSeconds) {
            d.setSeconds(d.getSeconds() + (long)LeapSeconds.getLeapSeconds(start, end));
        }
        return d;
    }

    private static long calcSecs(Calendar c) {
        long secsInCurrentYear = (long)c.get(6) * 86400L + (long)c.get(11) * 3600L + (long)c.get(12) * 60L + (long)c.get(13);
        int fullyears = c.get(1) - 1;
        long secsInPastYears = (365L * (long)fullyears + (long)Duration.countLeapYears(fullyears)) * 86400L;
        return secsInCurrentYear + secsInPastYears;
    }

    private static int countLeapYears(int year) {
        int count4 = year / 4;
        int count100 = year / 100;
        int count400 = year / 400;
        int countLeaps = count4 - count100 + count400;
        return countLeaps;
    }

    public double getWeeks() {
        return this.weeks;
    }

    public void setWeeks(long weeks) {
        this.weeks = weeks;
    }
}

