/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.util.misc;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class GUIHelper {
    public static void setUndoRedoFor(JTextArea textArea, final UndoManager manager) {
        Document doc = textArea.getDocument();
        doc.addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent evt) {
                manager.addEdit(evt.getEdit());
            }
        });
        textArea.getActionMap().put("Undo", new AbstractAction("Undo"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GUIHelper.undo(manager);
            }
        });
        textArea.getInputMap().put(KeyStroke.getKeyStroke("control Z"), "Undo");
        textArea.getActionMap().put("Redo", new AbstractAction("Redo"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GUIHelper.redo(manager);
            }
        });
        textArea.getInputMap().put(KeyStroke.getKeyStroke("control Y"), "Redo");
    }

    public static void undo(UndoManager manager) {
        try {
            if (manager.canUndo()) {
                manager.undo();
            }
        }
        catch (CannotUndoException cannotUndoException) {
            // empty catch block
        }
    }

    public static void redo(UndoManager manager) {
        try {
            if (manager.canRedo()) {
                manager.redo();
            }
        }
        catch (CannotRedoException cannotRedoException) {
            // empty catch block
        }
    }

    public static boolean showQuestion(Component parentComponent, String title, String message) {
        boolean temp = false;
        int result = JOptionPane.showConfirmDialog(parentComponent, message, title, 1, 3);
        switch (result) {
            case -1: {
                temp = false;
                break;
            }
            case 0: {
                temp = true;
                break;
            }
            case 1: {
                temp = false;
                break;
            }
            case 2: {
                temp = false;
            }
        }
        return temp;
    }
}

