/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.util.spokennumbers;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

public class AudioThread
extends Thread {
    private ArrayList<String> syllables = null;
    private String dir = null;
    private Properties props = null;
    int waitAfterASyllable = 0;

    public AudioThread(ArrayList<String> syllables, String dir) {
        this.syllables = syllables;
        this.dir = dir;
        this.loadProperties();
    }

    public void setWaitAfterASyllable(int wait) {
        this.waitAfterASyllable = wait;
    }

    @Override
    public void run() {
        for (String syllable : this.syllables) {
            if (syllable.equals("-") || syllable.equals(" ") || syllable.length() == 0) continue;
            if (this.isInterrupted()) break;
            String filename = syllable.trim();
            if (this.props.getProperty("allfilenamesarelowercase", "false").equals("true")) {
                filename = filename.toLowerCase(Locale.US);
            }
            this.playAndWait("/data/sounds/" + this.dir + "/" + filename + this.props.get("format"));
        }
    }

    private void loadProperties() {
        this.props = new Properties();
        this.props.setProperty("format", ".wav");
        try {
            InputStream is = this.getClass().getResourceAsStream("/data/sounds/" + this.dir + "/info");
            if (is != null) {
                this.props.load(is);
            } else {
                this.props.setProperty("allfilenamesarelowercase", "true");
            }
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    private void playAndWait(String sound) {
        try {
            AudioInputStream stream = AudioSystem.getAudioInputStream(this.getClass().getResource(sound));
            AudioFormat format = stream.getFormat();
            if (format.getEncoding() != AudioFormat.Encoding.PCM_SIGNED) {
                format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, format.getSampleRate(), format.getSampleSizeInBits() * 2, format.getChannels(), format.getFrameSize() * 2, format.getFrameRate(), true);
                stream = AudioSystem.getAudioInputStream(format, stream);
            }
            Line.Info info = new Line.Info(Clip.class);
            Clip clip = (Clip)AudioSystem.getLine(info);
            clip.open(stream);
            stream.close();
            clip.addLineListener(new LineListener(){

                @Override
                public void update(LineEvent event) {
                    if (event.getType() == LineEvent.Type.STOP) {
                        event.getLine().close();
                    }
                }
            });
            FloatControl gainControl = (FloatControl)clip.getControl(FloatControl.Type.MASTER_GAIN);
            double gain = 1.0;
            float dB = (float)(Math.log(gain) / Math.log(10.0) * 20.0);
            gainControl.setValue(dB);
            double durationInSecs = (float)clip.getBufferSize() / ((float)clip.getFormat().getFrameSize() * clip.getFormat().getFrameRate());
            clip.start();
            try {
                Thread.sleep((int)(durationInSecs * 1000.0 + (double)this.waitAfterASyllable));
            }
            catch (InterruptedException e) {
                this.interrupt();
            }
        }
        catch (IOException e) {
            System.out.println(e);
        }
        catch (LineUnavailableException e) {
            System.out.println(e);
        }
        catch (UnsupportedAudioFileException e) {
            System.out.println(e);
        }
    }
}

