/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.util.spokennumbers;

import net.numericalchameleon.util.spokennumbers.SpokenNumber;

public class SwedishNumber
extends SpokenNumber {
    private static final String[][] field = new String[][]{{"ett", "tv\u00e5", "tre", "fyra", "fem", "sex", "sju", "\u00e5tta", "nio"}, {"elva", "tolv", "tretton", "fjorton", "femton", "sexton", "sjutton", "arton", "nitton"}, {"tio", "tjugo", "trettio", "fyrtio", "femtio", "sextio", "sjuttio", "\u00e5ttio", "nittio"}};
    private static final String[] amount = new String[]{"tusen", " miljon", " miljard"};
    private static final String NULL = "noll";
    private static final String MINUS = "minus";
    private static final String HUNDRED = "hundra";

    public SwedishNumber() {
    }

    public SwedishNumber(long number) throws Exception {
        super(number);
    }

    public SwedishNumber(String number) throws Exception {
        super(number);
    }

    @Override
    protected int getSupportedDigits() {
        return 12;
    }

    @Override
    public String getSoundDir() {
        return "swedish";
    }

    @Override
    protected void convert2Syllables() throws Exception {
        if (this.number.charAt(0) == '-') {
            this.number = this.number.substring(1);
            this.syllables.add("minus ");
        }
        if (this.numberType == 1) {
            this.fillSyllables(NULL, field[0]);
            return;
        }
        this.number2digits();
        if (this.number.equals("0")) {
            this.syllables.add(NULL);
        } else {
            int counter = amount.length - 1;
            for (int i = this.MAX_DIGITS - 3; i > 0; i -= 3) {
                this.xtriple(i, amount[counter--]);
            }
            this.triple(0);
        }
    }

    private void triple(int index) {
        if (this.digits[index + 2] > 0) {
            if (this.digits[index + 2] > 1) {
                this.syllables.add(field[0][this.digits[index + 2] - 1]);
            }
            this.syllables.add(HUNDRED);
        }
        if (this.digits[index + 1] == 1 && this.digits[index] > 0) {
            this.syllables.add(field[1][this.digits[index] - 1]);
        } else if (this.digits[index + 1] >= 1 && this.digits[index] == 0) {
            this.syllables.add(field[2][this.digits[index + 1] - 1]);
        } else {
            if (this.digits[index + 1] > 0) {
                this.syllables.add(field[2][this.digits[index + 1] - 1]);
            }
            if (this.digits[index] > 0) {
                this.syllables.add(field[0][this.digits[index] - 1]);
            }
        }
    }

    private void xtriple(int index, String singular) {
        if (this.digits[index] + this.digits[index + 1] + this.digits[index + 2] > 0) {
            if (index != 3 || this.digits[3] != 1 || this.digits[4] != 0 || this.digits[5] != 0) {
                this.triple(index);
            }
            this.syllables.add(singular);
        }
    }

    public static String toString(long number) throws Exception {
        return new SwedishNumber(number).toString();
    }

    public static String toString(String number) throws Exception {
        return new SwedishNumber(number).toString();
    }
}

